/* regexp routine definitions
 *
 * Copyright 2001, KUN.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: pattern.h,v 1.3 2001/10/17 09:30:15 ejv Exp $ */

#ifndef PATTERN_H
#define PATTERN_H

#include <sys/types.h>

typedef long	RegExp;

/*
//------------------------------------------------------------------------------
// Function:
//	RegExp*
//	new_regexp(const char* regexp_txt, int* result_p)
//
// Description:
//	Compile regular expression regexp_txt. A buffer holding the
//	compiled expression is allocated, even if compilation fails.
//	The location pointed to by result_p is set to indicate the
//	compilation result: code < 0 means regular expressions not
//	supported, code 0 means success, and code > 0 indicates an
//	error value.
//
// Return value:
//	Pointer to compiled expression, even in case of failure.
//------------------------------------------------------------------------------
*/

RegExp*
new_regexp(const char* regexp_txt, int* result_p);

/*
//------------------------------------------------------------------------------
// Function:
//	void
//	delete_regexp(RegExp* regexp)
//
// Description:
//	Delete compiled regular expression regexp.
//------------------------------------------------------------------------------
*/

void
delete_regexp(RegExp* regexp);

/*
//------------------------------------------------------------------------------
// Function:
//	size_t regexp_error(int error, RegExp* regexp, char* buf, size_t sz)
//
// Description:
//	Convert error code associated with regexp to string,
//	and copy at most sz bytes of this string to buf.
//
// Return value:
//	Length of error message.
//------------------------------------------------------------------------------
*/

size_t
regexp_error(int, RegExp*, char*, size_t);

/*
//------------------------------------------------------------------------------
// Function:
//	const char*
//	match_regexp(const char* str, RegExp* regexp)
//
// Description:
//	Match string str with compiled regular expression regexp.
//	This function will try to match the longest prefix of str.
//
// Return value:
//	A pointer to the first character in str not matched by regexp,
//	or NULL if regexp does not match str.
//------------------------------------------------------------------------------
*/

const char*
match_regexp(const char* str, RegExp* regexp);

#endif /* PATTERN_H */
