#ifndef BUFFER_H
#define BUFFER_H

/*
 * $Id: rtsbuffer.h,v 1.2 1999/07/04 12:48:36 everbrug Exp $
 */

typedef struct BUFFER
{
  struct
  {
    char *pos;
    int free;
  } commit;
  struct
  {
    char *pos;
    int free;
  } current;
  int size;
  char *space;
  struct BUFFER *next;
} Buffer;

void InitBuffer(void);
void EndBuffer(void);

Buffer *NewBuffer(void);
void FreeBuffer(Buffer *buffer);
void ResizBuffer(Buffer *, int);

void CommitBuffer(Buffer *);
void TruncBuffer(Buffer *);
void ResetBuffer(Buffer *);

void PutStrBuffer(const char *, Buffer *);
void PutBlBuffer(const int, Buffer *);
void PutChBuffer(const int, Buffer *);
void PutIntBuffer(const int, Buffer *);

void FlushBuffer(Buffer *, FILE *);
int BufferUsed(Buffer *);

#endif /* BUFFER_H */
