/* routine definitions for positive memoisation
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: posmemo.h,v 1.5 2003/07/17 18:10:55 paulj Exp $ */

#ifndef POSMEMO_H
#define POSMEMO_H

#include <assert.h>

#include <lexicon.h>


void posmemo_init();
void posmemo_done();
void posmemo_free_vec(PosMemo* entry);
void posmemo_dump_table(Trellis* trellis);

void posmemo_init_table_entry(PosMemo* entry);
int posmemo_is_unknown(StateIndicator input_state, unsigned nont_nr);
int posmemo_is_known(StateIndicator input_state, unsigned nont_nr);
int posmemo_is_blocked(StateIndicator input_state, unsigned nont_nr);
int posmemo_is_blocked_for_penlevel(StateIndicator input_state, unsigned nont_nr, long penlevel);
int posmemo_is_unblocked(StateIndicator input_state, unsigned nont_nr);
int posmemo_next_equal_formals(PosMemo p1);
void posmemo_set_unknown(StateIndicator input_state, unsigned nont_nr);
void posmemo_set_blocked(StateIndicator input_state, unsigned nont_nr);

void posmemo_add_production(StateIndicator input_state, unsigned nont_nr,
                            long penalty, unsigned nr_formals, 
			    unsigned nr_variables,unsigned nr_sons,
                            VALUE* variables, StateIndicator target_state,
			    void *pass2);
void posmemo_set_failcont(PosMemo prod, void* pc);
void* posmemo_get_failcont(PosMemo prod);
void* posmemo_get_pass2(PosMemo prod);
void* posmemo_get_formal_ptr(PosMemo state);
VALUE posmemo_get_variable(PosMemo state,int nr);
VALUE posmemo_get_local(PosMemo state,int nr);
PosMemo posmemo_get_son(PosMemo state,int nr);
void posmemo_set_next_son(PosMemo p,int nr);
void posmemo_reset_son(PosMemo p,int nr);
long posmemo_get_penalty(PosMemo state);
PosMemo posmemo_get_next_prod(PosMemo curr);
StateIndicator posmemo_get_input_state(PosMemo curr);
PosMemo posmemo_get_prod_ptr(StateIndicator input_state, unsigned nont_nr);
int posmemo_count_prod(StateIndicator input_state, unsigned nont_nr);

#endif /* POSMEMO_H */
