/* lexicon utility functions
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: lexiconutil.c,v 1.4 2001/10/17 10:39:31 ejv Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */

#include <stdio.h>
#include <stdlib.h>
#include "lexiconutil.h"

void*
GetMem(size_t size, char* place)
{
    void* result;
#ifdef DEBUG
    fprintf(stderr, "GetMem: allocating %Zu bytes, %s\n", size, place);
#endif
    result = malloc(size);

    if (!result) {
        fprintf(stderr, "Failed to allocate %Zu bytes of memory.\n", size);
        exit(1);
    }

    return result;
}

void
FreeMem(void* data, char* place)
{
#ifdef DEBUG
    fprintf(stderr, "FreeMem: freeing %p, %s\n", data, place);
#endif
    free(data);
}
