/* Interfacing definitions for the lexicon library.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: lexicon.h,v 1.10 2001/10/17 10:39:31 ejv Exp $ */

#ifndef lexicon_h
#define lexicon_h

#include <stdio.h>
#include <glib.h>
#include <sys/types.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*----  define Param type for trellis nodes  -----------------------------*/

enum
{
  KindAnyBit = 1,
  SetKind = 0,
  IntKind = 2,
  TextKind = 4,
  KindTypeMask = 0x0e
};

#define KIND_IS_ANY(kind)	(kind & KindAnyBit)
#define GET_KIND_TYPE(kind)	(kind & KindTypeMask)

#define SPECIAL_MARK 0xfffffff

typedef union {
    unsigned long set_par;
    int int_par;
    char *text_par;
} VALUE;


typedef struct {
  int kind;
  VALUE value;
} PARAM;

/*------------------------------------------------------------------------*/

typedef unsigned long SET;

typedef void    Trie;

typedef struct LEXICON LEXICON;
typedef long PENALTY;

/*
** Defined in reading.c
*/
void
get_params_from_entry_in_list(const LEXICON* lex, off_t entry_list,
                              off_t *nontnr, unsigned *arity,
                              PENALTY *penalty, const PARAM **params);

int try_advance_to_next_entry_in_list(const LEXICON* the_lex, off_t* lst);

off_t
 find_lex_nonterminal_with_arity(LEXICON* lex, char const *nname, int arity);

Trie* get_lexicon_trie(const LEXICON* lex);
LEXICON* lexicon_new(FILE* lex_file);
void lexicon_free(LEXICON* lex);

size_t lexicon_get_nr_nonterminals(LEXICON* lex);
char* lexicon_get_nont_name(LEXICON* lex, off_t nont_nr);
size_t lexicon_get_nont_arity(LEXICON* lex, off_t nont_nr);
char* lexicon_get_nont_param_name(LEXICON* lex, off_t nont_nr, off_t param_nr);
off_t lexicon_get_nont_param_nr(LEXICON* lex, off_t nont_nr, off_t param_nr);
gboolean lexicon_nont_exists(LEXICON* lex, off_t nont_nr);

size_t lexicon_get_nr_setaffixes(LEXICON* lex);
char* lexicon_get_setaffix_name(LEXICON* lex, off_t aff_nr);
SET lexicon_get_setaffix_bitset(LEXICON* lex, off_t aff_nr);
gboolean lexicon_get_setaffix_nont_flag(LEXICON* lex, off_t aff_nr);
size_t lexicon_get_setaffix_nr_lhsses(LEXICON* lex, off_t aff_nr);
char* lexicon_get_setaffix_lhs_name(LEXICON* lex, off_t aff_nr, off_t lhs_nr);
gboolean lexicon_affix_belongs_to_lhs(LEXICON* lex, off_t aff_nr, off_t lhs_nr);

#ifdef  __cplusplus
}
#endif

#endif /* lexicon_h */
