// Lexicon file writing routines.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexfileio.cc,v 1.3 2003/11/26 22:15:14 pspiertz Exp $

using namespace std;
#include <sys/types.h>
#include <time.h>
#include <iostream>
#include "options.h"
#include "lexfileio.h"

void
may_log_timestamp(char const *const txt)
{
    if (options->log_with_timestamp()) {
	time_t ct = time(NULL);
	cerr << ctime(&ct);
	if (*txt) {
	    cerr << txt << endl;
	}
    }
}

void
may_log_writing_size(size_t size, char const *const txt)
{
    if (options->log_sizes()) {
	may_log_timestamp("");
	cerr << "writing " << size << txt << endl;
    }
}

void
write_lex_size_and_log(ostream &os, size_t size, char const *const txt)
{
    may_log_writing_size(size, txt);
    write_lex_size(os, size);
}
