/* rtscode.h - Interface to code generated by code.k3
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtscode.h,v 1.32 2003/08/12 19:30:09 pspiertz Exp $ */

#ifndef rtscode_h
#define rtscode_h

#include <glib.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
** BITS_PER_WORD is the number of bits per machine word,
** as assumed by the agfl compiler.
*/

#define BITS_PER_WORD	32

/* Code */

typedef void (*func)(void);

/* definition of data/code/cel/union Cel: moved to rtsagfl.c 19990126 FN */

/* Constants */

extern long segment_mode;
extern long generate_option;

extern long nr_lexicon_nonterminals;
extern long nr_terminals;
extern long nr_match_regexps;
extern long nr_skip_regexps;
extern long nr_memos;
extern long nr_choices;
extern long nr_positions;
extern long nr_syntax_nonterminals;
extern long eos_terminal;
extern long max_parses;
extern long max_penalty;
extern long rel_penallowance;
extern long max_parsetime;
extern long no_translate;

extern const char agfl_version[];
extern long gra_version;

#ifdef PROFILING
extern const char fingerprint[];
#endif /* PROFILING */

extern unsigned char const * invisible_chars;
extern unsigned char const * word_terminator_chars;
extern unsigned char const * list_delimiter_chars;

/* Options */

#define allow_multiple_single_token_parts 0
/* TODO should become:
extern int allow_multiple_single_token_parts;
*/
extern int left_recursion;
extern int use_lexicon;
extern int neg_memo_option;
extern int pos_memo_option;
extern int directors_option;
extern int log_option;
extern int counters_option;
extern int trace_option;
extern int profile_option;
#define WORD_LEXING	'w'
#define PREFIX_LEXING	'p'
#define TRELLIS_LEXING	't'
extern int lexing_method; /* for now defined in rtsopt.c, see also option -m */
#define G_OUT_FORMAT_STANDARD	   's'
#define G_OUT_FORMAT_TRELLIS_INPUT 't'
extern int lex_out_format; /* for now defined in rtsopt.c, see also option -m */
extern int transduce_option;
extern int echo_unparsed_option;

extern int verbose;
extern int no_output;
extern int graph_option;
extern int label_bracket;

extern int list_option;
extern int client_option;

#ifdef PROFILING
extern long prof_count;
extern int profiles;
extern int reset_profile;
extern int update_profile;
extern int new_profile;
#endif /* PROFILING */

extern const char* alphabet_file;

/*
 * XXX
 * FIXME
 * ALERT
 *
 * TESTING OPTION:
 */
extern int text_tracing_option;

/* Tables */

extern void* match_comp_regexps[];
extern void* skip_comp_regexps[];

/*
// nont_domains[] is an array of pointers to nonterminal domains,
// indexed by nonterminal numbers. Each domain pointer points to
// an array of domains. Each domain is either INT_TYPE, TEXT_TYPE
// or an affix number >= 0 in case of a set domain.
// affix_domains[] is an array of affix domains, indexed by affix
// numbers, containing a set value, or a respesentation of TEXT or INT.
//
// NOTE: if TOP_{INT,TEXT} get changed, changes to lexgen are needed
// too.
*/

#define INT_TYPE	-1
#define TEXT_TYPE	-2
#define TOP_INT		-1
#define TOP_TEXT	NULL

extern long affix_domains[];
extern long* affix_weights[];
extern long* nont_domains[];

extern long lrec_table[];

extern const char* affix_names[];
extern const char* term_names[];
extern const char* nonterm_names[];

extern const char* alternatives_profile_table[];

extern const char *match_regexp_names[];
extern const char *skip_regexp_names[];

#if 0
extern long term_length[];
#endif

extern unsigned long *term_memo_dir[];
extern unsigned long *skip_memo_dir[];
extern unsigned long *match_memo_dir[];
extern unsigned long *lex_memo_dir[];
extern unsigned long memo_enable_table[];

#ifdef PROFILING
extern struct
{
  char *id;
  int arity;
  int altno;
} prof_table[];
#endif /* PROFILING */

void print_set_affix(unsigned long val, long domain, gboolean in_tranduction);
void print_text_affix(const char* val, gboolean in_tranduction);
void print_integer_affix(int val, gboolean in_tranduction);
/* void output_terminal(long termnr); */
/* void output_match_regexp(long termnr); */
/* void output_skip_regexp(long termnr); */
void current_parse_add_match_regexp(long termnr);
void current_parse_add_skip_regexp(long termnr);
inline long affix_get_top(unsigned nont_nr, unsigned affix_nr);

extern long get_nr_choices();

#ifdef  __cplusplus
}
#endif

#endif /* rtscode_h */
