      subroutine inisw
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw


      cutof2 = cutoff*cutoff
      cuton  = cutoff - 1.0d0

      cuton2 = cuton*cuton
      tmp    = cutof2 - cuton2
      conof3 = tmp*tmp*tmp
      isw = 1


      return
      end

      double precision function swvdw(rij2)
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw

      if (rij2.ge.cutof2) then
          swvdw = 0.0d0
      elseif (rij2.le.cuton2) then
          swvdw = 1.0d0
      else
          rd1 = cutof2 - rij2
          rd2 = cutof2 + 2.0d0*rij2 - 3.0d0*cuton2
          swvdw = (rd1*rd1*rd2)/conof3
      endif

      return
      end

      double precision function swdvdw(rij2)
c 
c derivative of VDW switch function
c
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw

      if (rij2.ge.cutof2) then
          swdvdw = 0.0d0
      elseif (rij2.le.cuton2) then
          swdvdw = 1.0d0
      else
          rd1 = cutof2 - rij2
c          rd2 = rij2 - cuton2
c          swdvdw = 12.0d0*rd1*rd2/conof3
          rd2 = cutof2 + 2.0d0*rij2 - 3.0d0*cuton2
          rij = dsqrt(rij2)
          swdvdw = 4.0d0*rij*rd1*(rd1-rd2)/conof3
      endif

      return
      end

c swchg not used, instead same function as swvdw used for charge cutoff

      subroutine swchg(rij2,s,ds)
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw


      if (rij2.ge.cutof2) then
         s = 0.0d0
         ds = 0.0d0
      else
         frac = rij2/cutof2
         frac2 = frac*frac
         s = 1.0d0 - frac
         s = s*s
         ds = (frac2 - frac)*4.0d0
c        ds = ds/rij
c        we put the rij of de = de / r also in here
c           de = e*ds - e*s/r , de = de / r => 
c                de = e*ds/rij - e*s/rij2
c now       de = e*ds - e*s
         s = s/rij2
         ds = ds/rij2
      endif
          
      return
      end

      subroutine bldlsd(coo,iresid,nlst,lst,istat)
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxneib=200)
      parameter (numres=10000)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw
      common /athlp/  iatoms, mxnat
      common /residu/  ihsres,ires(numres),ibeg(numres),iend(numres)
      logical box
      common /pbc/ abc(3),abc2(3),box
      logical doit
      dimension coo(3,*),iresid(*),nlst(*),lst(*),vr(3),loclst(mxneib)

      if (istat.eq.0) then
         usesw = .false.
         print*,'Not enough memory to use cutoff/switch'
         return
      endif

      cutf1 = cutoff + 1.0d0
      cutf2 = cutf1*cutf1

c Build nonbonded interaction list, iatoms*mxneib
c each atom can have a max of mxneib neighbours within cutoff of 8 angs
c now not an atom is stored, but a residue

      do i=1,iatoms
         nlst(i) = 0
         do j=i+1,iatoms

            if (box) then
               do k=1,3
                  vr(k) = coo(k,i) - coo(k,j)
               end do
               call reddis(vr)
               r2 = vr(1)*vr(1) + vr(2)*vr(2) + vr(3)*vr(3)
               doit = (r2.lt.cutf2)
            else
               doit = (dist2(coo(1,i),coo(1,j)).lt.cutf2)
            endif

            if (doit) then
               if (nlst(i).lt.mxneib) then
                  ido = 1
                  do k=1,nlst(i)
                     if (iresid(j).eq.lst((i-1)*mxneib+k)) ido = 0
                  end do
                  if (ido.eq.1) then
                     nlst(i) = nlst(i) + 1
                     lst((i-1)*mxneib+nlst(i)) = iresid(j)
                  endif
               else
                  print*,"neighbour list full for atom ",i
                  print*,"increase mxneib "
               endif
            endif
         end do
      end do

      do i=1,ihsres
         if (ires(i).gt.0) then
            nloc = nlst(ibeg(i))
            do j=1,nloc
               loclst(j) = lst((ibeg(i)-1)*mxneib+j)
            end do
            do j=ibeg(i)+1,iend(i)
               do k=1,nlst(j)
                  ir = lst((j-1)*mxneib+k)
                  ido = 1
                  do l=1,nloc
                     if (ir.eq.loclst(l)) ido = 0
                  end do
                  if (ido.eq.1) then
                     if (nloc.lt.mxneib) then
                        nloc = nloc + 1
                        loclst(nloc) = ir
                     else
                        print*,"neighbour list full for atom ",ibeg(i)
                        print*,"increase mxneib "
                     endif
                  endif
               end do
            end do
            do j=ibeg(i),iend(i)
               nlst(j) = nloc
               do l=1,nloc
                  lst((j-1)*mxneib+l) = loclst(l)
               end do
            end do
         endif
      end do

      return
      end

      logical function resinc(iatom,nlst,lst,ires)
      implicit double precision (a-h,o-z)
      parameter (mxneib=200)
      dimension lst(*)


      resinc = .false.
      do i=1,nlst
         if (lst((iatom-1)*mxneib + i).eq.ires) then
             resinc = .true.
             return
         endif
      end do

      return
      end

      double precision function dist2(a,b)
c
c     determine distances between neighboring atoms
c
      implicit double precision (a-h,o-z)
      dimension a(3)
      dimension b(3)

      d1 = a(1)-b(1)
      d2 = a(2)-b(2)
      d3 = a(3)-b(3)

      dist2 = d1*d1 + d2*d2 + d3*d3

      return
      end

      subroutine premul
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxcls=50)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      common /prem/ rs(mxcls,mxcls),es(mxcls,mxcls),iprem

      do i=1,mxcls
         do j=1,mxcls
            rst = ambvdwr(i) + ambvdwr(j)
            rs(i,j) = rst*rst*rst*rst*rst*rst
            es(i,j) = dsqrt(ambvdwe(i)*ambvdwe(j))
         end do
      end do

      iprem = 1

      return
      end

      subroutine prmulr
      implicit real(a-h,o-z), integer (i-n)
      parameter (mxcls=50)
      double precision ambvdwr,ambvdwe
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      common /premr/ rs(mxcls,mxcls),es(mxcls,mxcls),iprem

      do i=1,mxcls
         do j=1,mxcls
            rst = real(ambvdwr(i) + ambvdwr(j))
            rs(i,j) = rst*rst*rst*rst*rst*rst
            es(i,j) = sqrt(real(ambvdwe(i)*ambvdwe(j)))
         end do
      end do

      iprem = 1

      return
      end

      subroutine rddisr(vr)
      implicit real (a-h,o-z), integer (i-n)
      logical box
      double precision abc,abc2
      common /pbc/ abc(3),abc2(3),box
      dimension vr(3)
      
      do i=1,3
         do while (vr(i).gt.real(abc2(i)))
            vr(i) = vr(i) - real(abc(i))
         end do
         do while (vr(i).lt.real(-abc2(i)))
            vr(i) = vr(i) + real(abc(i))
         end do
      end do

      return
      end
