      subroutine reddis(vr)
      implicit double precision (a-h,o-z), integer (i-n)
      logical box
      common /pbc/ abc(3),abc2(3),box
      dimension vr(3)
      
      do i=1,3
         do while (vr(i).gt.abc2(i))
            vr(i) = vr(i) - abc(i)
         end do
         do while (vr(i).lt.-abc2(i))
            vr(i) = vr(i) + abc(i)
         end do
      end do

      return
      end

      subroutine appbnd(coo,ityp)
      implicit double precision (a-h,o-z), integer (i-n)
      integer*2 ityp
      logical box,outbox
      common /pbc/ abc(3),abc2(3),box
      common /athlp/  iatoms, mxnat
      dimension coo(3,*),cw(3,3),vec(3),ityp(*)
      
c put water molecules which are entirely out of the box
c back in the box

      do i=1,iatoms

         if (ityp(i)  .eq.649.and.
     &       ityp(i+1).eq.650.and.
     &       ityp(i+2).eq.650) then

            outbox = .true.

            do j=1,3
               vec(j) = 0.0d0
            end do

            do k=1,3

               l = 0

               do j=1,3
                  cw(j,k) = coo(j,i+k-1)
                  if (cw(j,k).gt.abc2(j)) then
                     l = l + 1
                     if (k.eq.1) vec(j) = -abc(j)
                  endif
                  if (cw(j,k).lt.-abc2(j)) then
                     l = l + 1
                     if (k.eq.1) vec(j) = abc(j)
                  endif
               end do

               if (l.eq.0) outbox = .false.

            end do

c water out of the box, put it back

            if (outbox) then
               do k=1,3
                  do j=1,3
                     coo(j,i+k-1) = cw(j,k) + vec(j)
                  end do
               end do
            endif

         endif
      end do

      return
      end

      subroutine makbod(coo)
      implicit double precision (a-h,o-z), integer (i-n)
      logical box
      common /pbc/ abc(3),abc2(3),box
      dimension coo(3,*),vec(3)

c     get largest diameter protein and add a default
c     set abc and abc2
c     set protein in center of the box

      offs = 14.0d0 

      call docnt(vec,coo)

      do i=1,3
         abc(i) = 2.0d0*vec(i) + offs
         abc2(i) = 0.5d0*abc(i)
      end do

      return
      end

      subroutine allbox
      implicit double precision (a-h,o-z), integer (i-n)
      logical box
      common /pbc/ abc(3),abc2(3),box
      common /athlp/  iatoms, mxnat
      dimension nbox(3)

      watd = 18.620d0
      nwater = 648/3

      do i=1,3
         t = abc(i)/watd
         nbox(i) = dint(t) + 1
      end do

      newat = nbox(1)*nbox(2)*nbox(3)*nwater*3

      call allcoo(newat)

      return
      end

      subroutine filbod(water,coo,iconn,iresid,ityp,
     &                  nac,iac,nad,
     &                  nbnd,ibnd,bl,bk,
     &                  nang,iang,ango,ak,q,iopt)
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxcon=10)
      parameter (mxac=3*mxcon)
      parameter (numres=10000)
      logical box,chkwat,chkbox
      common /pbc/ abc(3),abc2(3),box
      common /athlp/  iatoms, mxnat
      common /residu/ ihsres,ires(numres),ibeg(numres),iend(numres)
      integer*2 ityp
      dimension water(3,*), coo(3,*), nbox(3), doff(3)
      dimension ityp(*),iconn(mxcon+1,*),iresid(*)
      dimension nac(*),nad(*),iac(mxac,*)
      dimension ibnd(2,*), bl(*), bk(*)
      dimension iang(3,*),ango(*),ak(*)
      dimension q(*),iopt(*),cwat(3,3),ibox(3)

      watd = 18.620d0
      nwater = 648/3

c 18.620 ang box
c     take prefilled water box and tile the real box with this
c     sub box
c     remove water that overlap with protein

      do i=1,3
         t = abc(i)/watd
         nbox(i) = dint(t) + 1
      end do

      ishoh = ires(ihsres)
      if (ishoh.gt.0) then
          ishoh = -4
      else
          ishoh = ishoh - 1
      endif

      ioff = iatoms

      ibox(1) = 0

      do i=1,nbox(1)
         if (i.eq.nbox(1)) ibox(1) = 1
         ibox(2) = 0

         do j=1,nbox(2)
            if (j.eq.nbox(2)) ibox(2) = 1
            ibox(3) = 0

            do k=1,nbox(3)
               if (k.eq.nbox(3)) ibox(3) = 1

               doff(1) = -abc2(1) + 0.5d0*watd + watd*dble(i-1)
               doff(2) = -abc2(2) + 0.5d0*watd + watd*dble(j-1)
               doff(3) = -abc2(3) + 0.5d0*watd + watd*dble(k-1)

               chkbox = .false.
               if (i.eq.nbox(1).or.j.eq.nbox(2).or.k.eq.nbox(3))
     &             chkbox = .true.

               do n=1,nwater

                  in = (n-1)*3

                  do m=1,3
                     cwat(m,1) = water(m,in+1) + doff(m)
                     cwat(m,2) = water(m,in+2) + doff(m)
                     cwat(m,3) = water(m,in+3) + doff(m)
                  end do

                  if (chkwat(cwat,coo,ityp,iopt,ioff,ibox,chkbox)) then

                     if (ihsres.lt.numres) then
                        ihsres = ihsres + 1
                        ires(ihsres) = ishoh
                        ibeg(ihsres) = ioff+1
                        iend(ihsres) = ioff+3
                     endif
                     iresid(ioff+1) = ishoh
                     iresid(ioff+2) = ishoh
                     iresid(ioff+3) = ishoh
                     ishoh = ishoh - 1

                     do m=1,3
                        coo(m,ioff+1) = cwat(m,1)
                        coo(m,ioff+2) = cwat(m,2)
                        coo(m,ioff+3) = cwat(m,3)
                     end do
   
                     ityp(ioff+1) = 649
                     ityp(ioff+2) = 650
                     ityp(ioff+3) = 650
   
                     iconn(1,ioff+1) = 2
                     iconn(2,ioff+1) = ioff+2
                     iconn(3,ioff+1) = ioff+3
   
                     iconn(1,ioff+2) = 1
                     iconn(2,ioff+2) = ioff+1
   
                     iconn(1,ioff+3) = 1
                     iconn(2,ioff+3) = ioff+1

                     ibnd(1,nbnd+1) = ioff+1
                     ibnd(2,nbnd+1) = ioff+2
                     bl(nbnd+1)     = 0.9572d0
                     bk(nbnd+1)     = 553.0d0

                     ibnd(1,nbnd+2) = ioff+1
                     ibnd(2,nbnd+2) = ioff+3
                     bl(nbnd+2)     = 0.9572d0
                     bk(nbnd+2)     = 553.0d0
                     nbnd = nbnd + 2

                     nang = nang + 1
                     iang(1,nang) = ioff+2
                     iang(2,nang) = ioff+1
                     iang(3,nang) = ioff+3
                     ango(nang)   = 104.52d0
                     ak(nang)     = 100.00d0

                     q(ioff+1)    = -0.8340d0
                     q(ioff+2)    = 0.4710d0
                     q(ioff+3)    = 0.4710d0

                     if (i.eq.1.or.j.eq.1.or.k.eq.1) then
                        iopt(ioff+1) = 1
                        iopt(ioff+2) = 1
                        iopt(ioff+3) = 1
                     else
                        iopt(ioff+1) = 0
                        iopt(ioff+2) = 0
                        iopt(ioff+3) = 0
                     endif

                     nac(ioff+1) = 0
                     nac(ioff+2) = 1
                     nac(ioff+3) = 1
                     iac(1,ioff+2) = ioff+3
                     iac(1,ioff+3) = ioff+2
                     nad(ioff+1) = 0
                     nad(ioff+2) = 0
                     nad(ioff+3) = 0

                     ioff = ioff + 3

                  endif

               end do
               
            end do
         end do
      end do

      do i=iatoms,ioff
         iopt(i) = 1
      end do

      iatoms = ioff

      return
      end

      logical function chkvec(vec,cwat,coo,iopt,ityp,ioff)
      implicit double precision (a-h,p-w),integer (i-n),logical (o)
      parameter (mxamb=1590)
      parameter (mxgff=71)
      integer ambcls
      common /typpar/ ambchg(mxamb),ambcls(mxamb)
      parameter (mxcls=49)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      integer amb2gf
      common /gftyp/  gfvdw(2,mxgff),amb2gf(mxamb)
      common /athlp/  iatoms, mxnat
      integer*2 ityp
      dimension v(3),vec(3),cwat(3,3),coo(3,*),vdwat(3),ityp(*)
      dimension iopt(*)

      chkvec = .true.

      vdwat(1) = 1.7683d0
      vdwat(2) = 1.00d0
      vdwat(3) = 1.00d0

      do i=iatoms,ioff
            
         if (iopt(i).eq.1) then

            i1 = int(ityp(i))
            if (i1.gt.0) then
               il = ambcls(i1)
               vdwr = ambvdwr(il)
            else
               il = iabs(i1)
               vdwr = gfvdw(1,il)
            endif

            do j=1,3

               do k=1,3
                  v(k) = coo(k,i) + vec(k) - cwat(k,j)
               end do

               rab2 = v(1)*v(1) + v(2)*v(2) + v(3)*v(3)
               dmaxsq = vdwr + vdwat(j)
               dmaxsq = dmaxsq * dmaxsq

               if (rab2.lt.dmaxsq) then
                  chkvec = .false.
                  return
               endif

            end do

         endif

      end do

      return
      end

      logical function chkwat(cwat,coo,ityp,iopt,ioff,ibox,chkbox)
      implicit double precision (a-h,p-w),integer (i-n),logical (o)
      parameter (mxamb=1590)
      integer ambcls
      common /typpar/ ambchg(mxamb),ambcls(mxamb)
      parameter (mxcls=49)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      parameter (mxgff=71)
      integer amb2gf
      common /gftyp/  gfvdw(2,mxgff),amb2gf(mxamb)
      integer*2 ityp
      logical chkbox,chkvec
      common /athlp/  iatoms, mxnat
      logical box
      common /pbc/ abc(3),abc2(3),box
      dimension coo(3,*),ityp(*),cwat(3,3),v(3),vdwat(3),ibox(3),owat(3)
      dimension vec(3),iopt(*)

      chkwat = .false.


      do i=1,3
         owat(i) = .true.
      end do

      if (chkbox) then

         do i=1,3
            do j=1,3
               if (cwat(j,i).gt.abc2(j)) owat(i) = .false.
            end do
         end do

         if (.not.(owat(1).and.owat(2).and.owat(3))) return

         do i=1,3

            do j=1,3
               vec(j) = 0.0d0
            end do

            if (ibox(i).eq.1) then
               vec(i) = abc(i)
               if (.not.chkvec(vec,cwat,coo,iopt,ityp,ioff)) return
            endif

         end do

c         chkwat = .true.
c         return

      endif

c check overlap with protein atoms 

      do i=1,3
         owat(i) = .true.
      end do

      vdwat(1) = 1.7683d0
c vdwr H not conform to rest of parameters !
      vdwat(2) = 1.00d0
      vdwat(3) = 1.00d0

      do i=1,iatoms
         
         i1 = int(ityp(i))
         if (i1.gt.0) then
            il = ambcls(i1)
            vdwr = ambvdwr(il)
         elseif (i1.le.0) then
            i1 = iabs(i1)
            vdwr = gfvdw(1,i1)
         endif

         do j=1,3
            do k=1,3
               v(k) = coo(k,i) - cwat(k,j)
            end do
            rab2 = v(1)*v(1) + v(2)*v(2) + v(3)*v(3)
            dmaxsq = vdwr + vdwat(j)
            dmaxsq = dmaxsq * dmaxsq
            if (rab2.lt.dmaxsq) owat(j) = .false.
         end do

      end do

      if (owat(1).and.owat(2).and.owat(3)) chkwat = .true.

      return
      end

      subroutine docnt(vecm,coo)
      implicit double precision (a-h,p-w),integer (i-n),logical (o)
      common /athlp/ iatoms, mxnat
      dimension vec(3),vecm(3)
      dimension coo(3,*)

      do i=1,3
         vecm(i) = 0.0d0
      end do

      call cntvec(vec,coo,iatoms)

      do i=1,iatoms
         do j=1,3
            coo(j,i) = coo(j,i) - vec(j)
            da = dabs(coo(j,i))
            if (da.gt.vecm(j)) vecm(j) = da
         end do
      end do

      return
      end

      subroutine cntvec(vec,coo,iatoms)
      implicit double precision (a-h,p-w),integer (i-n),logical (o)
      dimension vec(3), coo(3,*)

      do i=1,3
         vec(i) = 0.0d0
      end do

      if (iatoms.le.0) return

      do i=1,iatoms
         do j=1,3
            vec(j) = vec(j) + coo(j,i)
         end do
      end do
 
      do j=1,3
         vec(j) = vec(j) / dble(iatoms)
      end do

      return
      end

