      subroutine inisw
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw


      cutof2 = cutoff*cutoff
      cuton  = cutoff - 1.0d0

      cuton2 = cuton*cuton
      tmp    = cutof2 - cuton2
      conof3 = tmp*tmp*tmp
      isw = 1


      return
      end

      double precision function swvdw(rij2)
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw

      if (rij2.ge.cutof2) then
          swvdw = 0.0d0
      elseif (rij2.le.cuton2) then
          swvdw = 1.0d0
      else
          rd1 = cutof2 - rij2
          rd2 = cutof2 + 2.0d0*rij2 - 3.0d0*cuton2
          swvdw = (rd1*rd1*rd2)/conof3
      endif

      return
      end

      double precision function swdvdw(rij2)
c 
c derivative of VDW switch function
c
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw

      if (rij2.ge.cutof2) then
          swdvdw = 0.0d0
      elseif (rij2.le.cuton2) then
          swdvdw = 1.0d0
      else
          rd1 = cutof2 - rij2
c          rd2 = rij2 - cuton2
c          swdvdw = 12.0d0*rd1*rd2/conof3
          rd2 = cutof2 + 2.0d0*rij2 - 3.0d0*cuton2
          rij = dsqrt(rij2)
          swdvdw = 4.0d0*rij*rd1*(rd1-rd2)/conof3
      endif

      return
      end

c swchg not used, instead same function as swvdw used for charge cutoff

      subroutine swchg(rij2,s,ds)
      implicit double precision (a-h,o-z)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw


      if (rij2.ge.cutof2) then
         s = 0.0d0
         ds = 0.0d0
      else
         frac = rij2/cutof2
         frac2 = frac*frac
         s = 1.0d0 - frac
         s = s*s
         ds = (frac2 - frac)*4.0d0
c        ds = ds/rij
c        we put the rij of de = de / r also in here
c           de = e*ds - e*s/r , de = de / r => 
c                de = e*ds/rij - e*s/rij2
c now       de = e*ds - e*s
         s = s/rij2
         ds = ds/rij2
      endif
          
      return
      end

      subroutine bldlsd(coo,iresid,nlst,lst,istat)
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxneib=200)
      parameter (numres=5000)
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw
      common /athlp/  iatoms, mxnat
      common /residu/  ihsres,ires(numres),ibeg(numres),iend(numres)
      logical box
      common /pbc/ abc(3),abc2(3),box
      logical doit
      dimension coo(3,*),iresid(*),nlst(*),lst(*),vr(3),loclst(mxneib)

      if (istat.eq.0) then
         usesw = .false.
         print*,'Not enough memory to use cutoff/switch'
         return
      endif

      cutf1 = cutoff + 1.0d0
      cutf2 = cutf1*cutf1

c Build nonbonded interaction list, iatoms*mxneib
c each atom can have a max of mxneib neighbours within cutoff of 8 angs
c now not an atom is stored, but a residue

      do i=1,iatoms
         nlst(i) = 0
         do j=i+1,iatoms

            if (box) then
               do k=1,3
                  vr(k) = coo(k,i) - coo(k,j)
               end do
               call reddis(vr)
               r2 = vr(1)*vr(1) + vr(2)*vr(2) + vr(3)*vr(3)
               doit = (r2.lt.cutf2)
            else
               doit = (dist2(coo(1,i),coo(1,j)).lt.cutf2)
            endif

            if (doit) then
               if (nlst(i).lt.mxneib) then
                  ido = 1
                  do k=1,nlst(i)
                     if (iresid(j).eq.lst((i-1)*mxneib+k)) ido = 0
                  end do
                  if (ido.eq.1) then
                     nlst(i) = nlst(i) + 1
                     lst((i-1)*mxneib+nlst(i)) = iresid(j)
                  endif
               else
                  print*,"neighbour list full for atom ",i
                  print*,"increase mxneib "
               endif
            endif
         end do
      end do

      do i=1,ihsres
         if (ires(i).gt.0) then
            nloc = nlst(ibeg(i))
            do j=1,nloc
               loclst(j) = lst((ibeg(i)-1)*mxneib+j)
            end do
            do j=ibeg(i)+1,iend(i)
               do k=1,nlst(j)
                  ir = lst((j-1)*mxneib+k)
                  ido = 1
                  do l=1,nloc
                     if (ir.eq.loclst(l)) ido = 0
                  end do
                  if (ido.eq.1) then
                     if (nloc.lt.mxneib) then
                        nloc = nloc + 1
                        loclst(nloc) = ir
                     else
                        print*,"neighbour list full for atom ",ibeg(i)
                        print*,"increase mxneib "
                     endif
                  endif
               end do
            end do
            do j=ibeg(i),iend(i)
               nlst(j) = nloc
               do l=1,nloc
                  lst((j-1)*mxneib+l) = loclst(l)
               end do
            end do
         endif
      end do

      return
      end

      logical function resinc(iatom,nlst,lst,ires)
      implicit double precision (a-h,o-z)
      parameter (mxneib=200)
      dimension lst(*)


      resinc = .false.
      do i=1,nlst
         if (lst((iatom-1)*mxneib + i).eq.ires) then
             resinc = .true.
             return
         endif
      end do

      return
      end

      double precision function dist2(a,b)
c
c     determine distances between neighboring atoms
c
      implicit double precision (a-h,o-z)
      dimension a(3)
      dimension b(3)

      d1 = a(1)-b(1)
      d2 = a(2)-b(2)
      d3 = a(3)-b(3)

      dist2 = d1*d1 + d2*d2 + d3*d3

      return
      end

      subroutine qenvdw(ec,ev,nac,iac,nad,iad,iresid,
     &                  coo,iconn,q,forces,potscl,iopt,nlst,lst,ityp)
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxcon=10)
      parameter (mxac=3*mxcon)
      parameter (mxad=9*mxcon)
      parameter (mxneib=200)
      common /athlp/  iatoms, mxnat
      logical usesw
      common /limits/ cutoff, cutof2,cuton, cuton2,conof3,usesw
      integer ambcls
      parameter (mxamb=701)
      common /typpar/ ambchg(mxamb),ambcls(mxamb)
      parameter (mxcls=49)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      common /prem/ rs(mxcls,mxcls),es(mxcls,mxcls),iprem
      parameter (mxgff=71)
      common /gftyp/  gfvdw(2,mxgff)
      logical box,resinc,doit
      common /pbc/ abc(3),abc2(3),box
      integer*2 ityp
      dimension vr(3),ded(3)
      dimension coo(3,*),q(*),ityp(*),iconn(mxcon+1,*),iresid(*),
     &          nac(*),nad(*),iac(mxac,*),iad(mxad,*),
     &          forces(3,*),potscl(*),iopt(*),nlst(*),lst(*)

      if (iprem.ne.1) call premul

      econv = 332.05382d0
      v14scq = 1.0d0 / 1.2d0
      v14scv = 0.5d0

      ec = 0.0d0
      ev = 0.0d0

      do i=1,iatoms

         i1 = int(ityp(i))
         if (i1.gt.0) then
            il = ambcls(i1)
            vdwr1 = ambvdwr(il)
            vdwe1 = ambvdwe(il)
         elseif (i1.le.0) then
            i1 = iabs(i1)
            vdwr1 = gfvdw(1,i1)
            vdwe1 = gfvdw(2,i1)
         endif

         do j=1,iatoms
            potscl(j) = 1.0d0
         end do

         do j=1,iconn(1,i)
            jj = iconn(1+j,i)
            if (jj.gt.0) then
               potscl(jj) = 0.0d0
            endif
         end do

         do j=1,nac(i)
            potscl(iac(j,i)) = 0.0d0
         end do

         do j=1,nad(i)
            potscl(iad(j,i)) = v14scq
         end do

         do k=i+1,iatoms

           doit = resinc(i,nlst(i),lst,iresid(k))

           if (doit) then

            if (potscl(k).ne.0.0d0.and.
     &          (iopt(i).eq.1.or.iopt(k).eq.1) ) then

               do j=1,3
                  vr(j) = coo(j,i) - coo(j,k)
               end do

               if (box) call reddis(vr)

               r2 = vr(1)*vr(1) + vr(2)*vr(2) + vr(3)*vr(3)

               if (r2.le.cutof2) then
                  r = dsqrt(r2)

                  e = econv * q(i) * q(k) * potscl(k) / r

c since we do: de = de / r, and de*vr(j), we might aswell
c put 1/r in the dw

                  call swchg(r2,s,ds)

                  de = e*(ds - s)
                  e = e * s * r2

                  do j=1,3
                     ded(j) = de * vr(j)
                  end do

                  ec = ec + e

                  do j=1,3
                     forces(j,i) = forces(j,i) + ded(j)
                     forces(j,k) = forces(j,k) - ded(j)
                  end do

                  if (vdwe1.ne.0.0d0) then

                     i2 = int(ityp(k))
                     if (i2.gt.0) then
                        kl = ambcls(i2)
                        vdwr2 = ambvdwr(kl)
                        vdwe2 = ambvdwe(kl)
                     elseif (i2.le.0) then
                        it = iabs(i2)
                        vdwr2 = gfvdw(1,it)
                        vdwe2 = gfvdw(2,it)
                     endif

                     if (vdwe2.ne.0.0d0) then

                        if (i1.gt.0.and.i2.gt.0) then
                           p6 = rs(il,kl) / (r2*r2*r2)
                           epsm = es(il,kl)
                        else
                           rsum = vdwr1 + vdwr2
                           epsm = dsqrt(vdwe1 * vdwe2)
                           p6   = rsum**6 / (r2*r2*r2)
                        endif

                        ps = potscl(k)
                        if (ps.eq.v14scq) ps = v14scv

                        epsm = epsm * ps
                        p12  = p6 * p6

                        e    = epsm * (p12 - 2.0d0*p6)
                        de   = epsm * (p12 - p6) * (-12.0d0/r)

                        if (r2.gt.cuton2) then
                           sw = swvdw(r2)
                           dsw = swdvdw(r2)
                           desw = de*sw
                           edsw = e*dsw
                           de = e*dsw + de*sw
                           e = e * sw
                        endif

                        de   = de / r

                        do j=1,3
                           ded(j) = de * vr(j)
                        end do

                        ev   = ev + e
   
                        do j=1,3
                           forces(j,i) = forces(j,i) + ded(j)
                           forces(j,k) = forces(j,k) - ded(j)
                        end do

                     endif

                  endif

               end if
            end if

           end if
         end do
      end do

      return
      end

      subroutine premul
      implicit double precision (a-h,o-z), integer (i-n)
      parameter (mxcls=49)
      common /clspar/ ambvdwr(mxcls),ambvdwe(mxcls),mapagf(mxcls)
      common /prem/ rs(mxcls,mxcls),es(mxcls,mxcls),iprem

      do i=1,mxcls
         do j=1,mxcls
            rst = ambvdwr(i) + ambvdwr(j)
            rs(i,j) = rst*rst*rst*rst*rst*rst
            es(i,j) = dsqrt(ambvdwe(i)*ambvdwe(j))
         end do
      end do

      iprem = 1

      return
      end

