      subroutine rdcor(idebug,isymm,istat)
      implicit double precision (a-h,o-z)
      parameter (numatm=2000)
      character*137 line
      common /coord / xyz(3,numatm)
      common /moldat/ natoms, norbs, nelecs,nat(numatm)
      common /rdwr/   iun1,iun2,iun3,iun4,iun5

      ig98 = 0

      if (isymm.eq.0) goto 1000

      if (idebug.eq.1)
     &   call inferr('looking for Standard orientation',0)

      call search(line,'Standard orientation:',istat)
      if (istat.eq.0) then
          if (idebug.eq.1)
     &      call inferr('Standard orientation not found!',0)
          return
      else
          call readel(line,2)
          read(iun2,'(a)',err=20) line
          if (icdex(line,'Type').ne.0) ig98 = 1
          call readel(line,1)
      endif

      natoms = 0
10    read(iun2,'(a)',err=20) line
      if (line(2:5).eq.'----') goto 200
      read(line,'(1x,i4)',err=20) natoms
      if ( natoms .gt. numatm ) then
          call inferr('Exceeding Max Atoms!',0)
          goto 20
      endif
      if (ig98.eq.1) then
          read(line,'(12x,i4,18x,3f12.6)',err=20)
     &      nat(natoms),xyz(1,natoms),xyz(2,natoms),xyz(3,natoms)
      else
          read(line,'(12x,i4,7x,3f12.6)',err=20)
     &      nat(natoms),xyz(1,natoms),xyz(2,natoms),xyz(3,natoms)
      endif
      goto 10

c
c===== Z-Matrix/ Input orientation
c
1000  if (idebug.eq.1) call inferr(
     &    'looking for Z-Matrix/Input orientation',0)

      call searchd(line,'Z-Matrix orientation:',
     &             'Input orientation:',istat)
      if (istat.eq.0) then
          if (idebug.eq.1) call inferr(
     &    'Z-Matrix/Input orientation not found!',0)
          return
      else
          call readel(line,2)
          read(iun2,'(a)',err=20) line
          if (icdex(line,'Type').ne.0) ig98 = 1
          call readel(line,1)
      endif

      natoms = 0
      do while ( .true. )
         read(iun2,'(a)',err=20) line
         if (line(2:4).eq.'---') goto 100
         natoms = natoms + 1
         if (ig98.eq.1) then
            read(line,'(12x,i4,18x,3(f12.6))',err=20)
     &      nat(natoms),(xyz(j,natoms),j=1,3)
         else
            read(line,'(12x,i4,7x,3(f12.6))',err=20) nat(natoms),
     &       (xyz(j,natoms),j=1,3)
         endif
      end do

100   continue
c
c get rid off dummy atoms
c
200   continue
      do i=1,natoms
         if (nat(i).lt.0) then
            do j=i+1,natoms
               nat(j-1) = nat(j)
               do k=1,3
                  xyz(k,j-1) = xyz(k,j)
               end do
            end do
            natoms = natoms - 1
            goto 200
         endif
      end do

      toang = 0.52917706d0
c
c convert to atomic units
c
      do i=1,natoms
         do j=1,3
            xyz(j,i) = xyz(j,i) / toang
         end do
      end do

      istat = 1
      return

20    call inferr('Error reading Standard orientation!',1)
      istat = 0
      return
      end
