
static int sym[] = {
         7,6,6,8,6,6,6,6,6,6,
         6,6,6,6,6,6,6,6,6,7,
         7,7,7,7,7,7,7,8,8,8,
         8,8,8,8,8,16,16,8,7,7,
         7,7,15,8,8,8,6,6,8,6,
         8,6,8,6,6,6,6,6,6,7,
         7,7,7,7,7,7,8,8,8,6,
         6,6,6,6,6,8,8,8,6,6,
         6,6,6,6,6,6,6,6,6,6,
         6,6,6,6,6,8,8,6,7,6,
         8,8,6};

typedef struct {double coo[3];} ROTCOOSTRU;

static int GLY_PDB[4] = { 0, 1, 2, 3 };
static short int GLY_PMF[4] = { 10, 2, 4, 6 }; 
static int GLYH_PDB[3] = { 0, 3, 4 };
static short int GLYH_PMF[3] = { 1, 1, 1 };
static int GLY_NUMC[2] = {4,3};

static ROTCOOSTRU GLY_rot0[4] = {
  {66.212,-17.017,54.606},
  {65.300,-19.013,52.958},
  {62.431,-19.011,52.997},
  {61.203,-19.341,51.051}
};

static ROTCOOSTRU GLYH_rot0[3] = {
  {67.051,-17.560,56.210},
  {65.877,-18.631,51.244},
  {65.909,-20.621,53.634}
};

static ROTCOOSTRU *GLY_rotarr[1] = {GLY_rot0};
static ROTCOOSTRU *GLYH_rotarr[1] = {GLYH_rot0};

static int ALA_PDB[5] = { 0, 1, 2, 3, 4 }; 
static short int ALA_PMF[5] = { 10, 2, 4, 6, 2 };
static int ALAH_PDB[5] = { 0, 3, 6, 7, 8 };
static short int ALAH_PMF[5] = { 1, 1, 1, 1, 1 };
static int ALA_NUMC[2] = {5,5};

static ROTCOOSTRU ALA_rot0[5] = {
  {11.652,11.773,32.254},
  {13.404,10.505,30.551},
  {15.796,9.732,31.978},
  {16.630,7.566,31.815},
  {14.088,12.238,28.353}
};

static ROTCOOSTRU ALAH_rot0[5] = {
  {11.175,13.551,31.828},
  {12.574,8.974,29.932},
  {12.537,12.736,27.433},
  {15.240,11.347,27.179},
  {14.938,13.774,28.999}
};

static ROTCOOSTRU *ALA_rotarr[1] = {ALA_rot0};
static ROTCOOSTRU *ALAH_rotarr[1] = {ALAH_rot0};

static int SER_PDB[6] = { 0, 1, 2, 3, 4, 30 };
static short int SER_PMF[6] = { 10, 2, 4, 6, 2, 7 };
static int SERH_PDB[5] = { 0, 3, 6, 7, 9 }; 
static short int SERH_PMF[5] = { 1, 1, 1, 1, 1 };
static int SER_NUMC[2] = {6,5};

static ROTCOOSTRU SER_rot0[6] = {
  {11.803,26.849,14.258},
  {9.124,27.482,14.470},
  {8.050,26.636,17.011},
  {5.981,27.412,17.758},
  {7.625,26.260,12.308},
  {7.659,23.583,12.473}
};

static ROTCOOSTRU SER_rot1[6] = {
  {11.803,26.849,14.258},
  {9.124,27.482,14.470},
  {8.050,26.636,17.011},
  {5.981,27.412,17.758},
  {7.625,26.260,12.308},
  {5.005,26.807,12.489}
 };

static ROTCOOSTRU SER_rot2[6] = {
  {11.803,26.849,14.258},
  {9.124,27.482,14.470},
  {8.050,26.636,17.011},
  {5.981,27.412,17.758},
  {7.625,26.260,12.308},
  {8.371,27.225,9.919}
};

static ROTCOOSTRU SERH_rot0[5] = {
  {12.195,25.041,13.874},
  {8.974,29.322,14.373},
  {8.306,26.705,10.623},
  {5.827,26.777,12.301},
  {6.787,23.012,11.209}
 };

static ROTCOOSTRU SERH_rot1[5] = {
  {12.195,25.041,13.874},
  {8.974,29.322,14.373},
  {7.787,24.396,12.289},
  {8.185,26.852,10.624},
  {4.272,26.068,11.224}
 };

static ROTCOOSTRU SERH_rot2[5] = {
  {12.195,25.041,13.874},
  {8.974,29.322,14.373},
  {5.783,26.553,12.458},
  {7.856,24.405,12.236},
  {7.462,26.465,8.788}
};

static ROTCOOSTRU *SER_rotarr[3] = {SER_rot0,SER_rot1,SER_rot2};
static ROTCOOSTRU *SERH_rotarr[3] = {SERH_rot0,SERH_rot1,SERH_rot2};

static int CYS_PDB[6] = { 0, 1, 2, 3, 4, 36 };
static short int CYS_PMF[6] = { 10, 2, 4, 6, 2, 13 };
static int CYSH_PDB[5] = { 0, 3, 6, 7, 9 }; 
static short int CYSH_PMF[5] = { 1, 1, 1, 1, 1 };
static int CYS_NUMC[2] = {6,5};

static ROTCOOSTRU CYS_rot0[6] = {
  {56.004,11.979,26.390},
  {56.631,14.109,28.015},
  {55.248,14.027,30.540},
  {56.337,14.609,32.513},
  {55.976,16.596,26.687},
  {52.655,17.023,26.042}
 };

static ROTCOOSTRU CYS_rot1[6] = {
  {56.004,11.979,26.390},
  {56.631,14.109,28.015},
  {55.248,14.027,30.540},
  {56.337,14.609,32.513},
  {55.976,16.596,26.687},
  {56.797,19.399,28.446}
 };

static ROTCOOSTRU CYS_rot2[6] = {
  {56.004,11.979,26.390},
  {56.631,14.109,28.015},
  {55.248,14.027,30.540},
  {56.337,14.609,32.513},
  {55.976,16.596,26.687},
  {57.784,17.211,23.862}
};

static ROTCOOSTRU CYSH_rot0[5] = {
  {54.716,12.319,25.049},
  {58.441,14.020,28.380},
  {56.477,18.095,27.687},
  {56.822,16.765,25.027},
  {51.881,15.693,26.607}
 };

static ROTCOOSTRU CYSH_rot1[5] = {
  {54.716,12.319,25.049},
  {58.441,14.020,28.380},
  {56.845,16.779,25.040},
  {54.145,16.758,26.334},
  {57.475,18.902,29.852}
 };

static ROTCOOSTRU CYSH_rot2[5] = {
  {54.716,12.319,25.049},
  {58.441,14.020,28.380},
  {54.186,16.669,26.147},
  {56.255,18.087,27.781},
  {58.808,15.947,23.663}
};

static ROTCOOSTRU *CYS_rotarr[3] = {CYS_rot0,CYS_rot1,CYS_rot2};
static ROTCOOSTRU *CYSH_rotarr[3] = {CYSH_rot0,CYSH_rot1,CYSH_rot2};

static int THR_PDB[7] = { 0, 1, 2, 3, 4, 7, 31 };
static short int THR_PMF[7] = { 10, 2, 4, 6, 2, 2, 7 }; 
static int THRH_PDB[7] = { 0, 3, 6, 12, 15, 16, 17 };
static short int THRH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 };
static int THR_NUMC[2] = {7,7};

static ROTCOOSTRU THR_rot0[7] = {
  {6.336,25.778,24.328},
  {5.703,27.598,26.290},
  {7.209,26.834,28.622},
  {8.258,24.761,28.718},
  {2.886,27.503,26.974},
  {1.262,28.092,24.674},
  {2.279,25.037,27.919}
 };

static ROTCOOSTRU THR_rot1[7] = {
  {6.336,25.778,24.328},
  {5.703,27.598,26.290},
  {7.209,26.834,28.622},
  {8.258,24.761,28.718},
  {2.886,27.503,26.974},
  {2.218,24.980,28.184},
  {2.316,29.523,28.688}
 };

static ROTCOOSTRU THR_rot2[7] = {
  {6.336,25.778,24.328},
  {5.703,27.598,26.290},
  {7.209,26.834,28.622},
  {8.258,24.761,28.718},
  {2.886,27.503,26.974},
  {2.287,29.376,29.073},
  {1.414,28.087,24.775}
};

static ROTCOOSTRU THRH_rot0[7] = {
  {5.320,24.185,24.357},
  {6.243,29.264,25.702},
  {2.553,28.779,28.301},
  {3.263,24.594,29.448},
  {-0.528,28.027,25.131},
  {1.585,26.856,23.339},
  {1.657,29.781,24.037}
 };

static ROTCOOSTRU THRH_rot1[7] = {
  {5.320,24.185,24.357},
  {6.243,29.264,25.702},
  {1.886,27.713,25.407},
  {2.679,31.206,27.957},
  {0.420,24.940,28.611},
  {3.207,24.737,29.726},
  {2.586,23.600,27.011}
 };

static ROTCOOSTRU THRH_rot2[7] = {
  {5.320,24.185,24.357},
  {6.243,29.264,25.702},
  {2.474,25.775,27.560},
  {1.712,26.883,23.374},
  {0.488,29.300,29.494},
  {2.703,31.092,28.527},
  {3.273,28.971,30.582}
};

static ROTCOOSTRU *THR_rotarr[3] = {THR_rot0,THR_rot1,THR_rot2};
static ROTCOOSTRU *THRH_rotarr[3] = {THRH_rot0,THRH_rot1,THRH_rot2};

static int ILE_PDB[8] = { 0, 1, 2, 3, 4, 6, 7, 9 };
static short int ILE_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 2 };
static int ILEH_PDB[11] = { 0, 3, 6, 12, 13, 15, 16, 17, 21, 22, 23 };
static short int ILEH_PMF[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int ILE_NUMC[2] = {8,11};

static ROTCOOSTRU ILE_rot0[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {29.199,-11.245,54.693},
  {29.901,-6.627,53.733},
  {30.377,-13.528,55.954}
 };

static ROTCOOSTRU ILE_rot1[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {29.217,-11.258,54.703},
  {29.880,-6.637,53.727},
  {28.418,-11.006,57.439}
 };

static ROTCOOSTRU ILE_rot2[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {29.239,-11.272,54.715},
  {29.855,-6.649,53.721},
  {26.599,-11.031,53.637}
 };

static ROTCOOSTRU ILE_rot3[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {33.353,-8.601,55.519},
  {29.557,-11.418,54.890},
  {34.773,-6.231,54.776}
 };

static ROTCOOSTRU ILE_rot4[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {33.358,-8.762,55.565},
  {29.422,-11.350,54.822},
  {32.686,-7.508,58.047}
 };

static ROTCOOSTRU ILE_rot5[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {33.344,-8.491,55.487},
  {29.652,-11.460,54.936},
  {34.856,-10.696,56.506}
 };

static ROTCOOSTRU ILE_rot6[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {30.134,-6.509,53.769},
  {33.205,-9.576,55.744},
  {27.458,-6.209,52.801}
 };

static ROTCOOSTRU ILE_rot7[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {29.991,-6.564,53.731},
  {33.246,-9.427,55.719},
  {28.565,-5.801,56.091}
 };

static ROTCOOSTRU ILE_rot8[8] = {
  {30.045,-10.057,49.333},
  {32.078,-9.951,51.164},
  {33.199,-12.603,51.217},
  {31.891,-14.426,51.830},
  {31.101,-9.243,53.808},
  {29.797,-6.655,53.684},
  {33.289,-9.218,55.679},
  {31.496,-4.507,52.857}
};

static ROTCOOSTRU ILEH_rot0[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {32.547,-9.218,54.995},
  {28.031,-10.508,55.921},
  {28.232,-11.880,53.252},
  {31.140,-5.379,53.165},
  {29.304,-6.157,55.417},
  {28.468,-6.623,52.566},
  {29.038,-14.728,56.470},
  {31.336,-12.991,57.469},
  {31.540,-14.380,54.763}
 };

static ROTCOOSTRU ILEH_rot1[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {32.549,-9.203,54.992},
  {27.672,-11.172,53.692},
  {29.959,-12.941,54.523},
  {31.108,-5.381,53.154},
  {29.283,-6.166,55.412},
  {28.444,-6.647,52.564},
  {27.208,-12.365,57.874},
  {27.599,-9.346,57.710},
  {29.916,-11.139,58.552}
 };

static ROTCOOSTRU ILEH_rot2[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {32.552,-9.185,54.988},
  {29.851,-12.950,54.240},
  {29.066,-11.196,56.554},
  {31.070,-5.383,53.140},
  {29.258,-6.178,55.406},
  {28.416,-6.677,52.561},
  {25.513,-12.399,54.306},
  {26.663,-11.155,51.771},
  {25.868,-9.377,54.116}
 };

static ROTCOOSTRU ILEH_rot3[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {30.008,-7.732,53.659},
  {32.775,-8.346,57.256},
  {34.581,-9.982,55.493},
  {28.133,-11.799,53.775},
  {28.907,-10.963,56.559},
  {30.614,-12.926,55.048},
  {36.191,-5.944,55.962},
  {33.621,-4.758,54.829},
  {35.452,-6.417,53.042}
 };

static ROTCOOSTRU ILEH_rot4[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {30.096,-7.671,53.675},
  {34.182,-10.361,55.988},
  {34.584,-7.658,54.731},
  {27.997,-11.628,53.679},
  {28.773,-10.894,56.491},
  {30.392,-12.917,54.964},
  {34.232,-7.261,59.071},
  {31.486,-8.584,58.996},
  {31.894,-5.844,57.722}
 };

static ROTCOOSTRU ILEH_rot5[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {29.950,-7.777,53.649},
  {34.524,-7.439,54.531},
  {32.745,-7.540,56.954},
  {28.233,-11.910,53.841},
  {29.002,-11.006,56.605},
  {30.767,-12.924,55.105},
  {36.263,-10.064,57.565},
  {35.558,-11.693,55.087},
  {33.754,-11.796,57.542}
 };

static ROTCOOSTRU ILEH_rot6[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {29.681,-10.378,54.247},
  {30.159,-5.805,55.478},
  {31.208,-5.474,52.678},
  {33.796,-11.327,55.741},
  {32.583,-9.156,57.433},
  {34.624,-8.464,55.334},
  {26.972,-4.402,52.833},
  {26.280,-7.180,53.883},
  {27.344,-6.844,51.045}
 };

static ROTCOOSTRU ILEH_rot7[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {29.748,-10.442,54.289},
  {31.345,-5.325,53.509},
  {28.802,-6.413,52.324},
  {33.928,-11.145,55.741},
  {32.625,-9.007,57.409},
  {34.598,-8.251,55.268},
  {27.909,-4.059,55.900},
  {29.707,-5.867,57.571},
  {27.131,-6.969,56.371}
 };

static ROTCOOSTRU ILEH_rot8[11] = {
  {28.351,-10.582,49.986},
  {33.324,-8.733,50.548},
  {29.849,-10.523,54.348},
  {28.394,-6.711,52.481},
  {29.141,-6.197,55.350},
  {34.095,-10.880,55.732},
  {32.671,-8.798,57.369},
  {34.543,-7.960,55.169},
  {30.525,-2.908,52.823},
  {32.168,-4.853,51.145},
  {32.924,-4.332,54.053}
};

static ROTCOOSTRU *ILE_rotarr[9] = {ILE_rot0,ILE_rot1,ILE_rot2,ILE_rot3,ILE_rot4,ILE_rot5,ILE_rot6,ILE_rot7,ILE_rot8};
static ROTCOOSTRU *ILEH_rotarr[9] = {ILEH_rot0,ILEH_rot1,ILEH_rot2,ILEH_rot3,ILEH_rot4,ILEH_rot5,ILEH_rot6,ILEH_rot7,ILEH_rot8};

static int VAL_PDB[7] = { 0, 1, 2, 3, 4, 6, 7 };
static short int VAL_PMF[7] = { 10, 2, 4, 6, 2, 2, 2 };
static int VALH_PDB[9] = { 0, 3, 6, 12, 13, 14, 15, 16, 17 };
static short int VALH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 }; 
static int VAL_NUMC[2] = {7,9};

static ROTCOOSTRU VAL_rot0[7] = {
  {12.470,19.209,34.943},
  {12.884,17.905,37.332},
  {12.100,15.137,37.165},
  {13.500,13.449,37.934},
  {11.382,19.152,39.490},
  {8.566,18.853,39.021},
  {12.104,17.977,42.001}
 };

static ROTCOOSTRU VAL_rot1[7] = {
  {12.470,19.209,34.943},
  {12.884,17.905,37.332},
  {12.100,15.137,37.165},
  {13.500,13.449,37.934},
  {11.382,19.152,39.490},
  {11.703,17.638,41.906},
  {12.269,21.849,39.879}
 };

static ROTCOOSTRU VAL_rot2[7] = {
  {12.470,19.209,34.943},
  {12.884,17.905,37.332},
  {12.100,15.137,37.165},
  {13.500,13.449,37.934},
  {11.382,19.152,39.490},
  {12.257,21.861,39.852},
  {8.577,19.082,38.908}
};

static ROTCOOSTRU VALH_rot0[9] = {
  {11.270,20.667,35.009},
  {14.696,17.960,37.693},
  {11.811,20.973,39.520},
  {8.111,19.625,37.379},
  {7.604,19.699,40.384},
  {8.119,17.037,38.991},
  {13.918,18.175,42.293},
  {11.690,16.176,41.999},
  {11.182,18.803,43.374}
 };

static ROTCOOSTRU VALH_rot1[9] = {
  {11.270,20.667,35.009},
  {14.696,17.960,37.693},
  {9.574,19.167,39.007},
  {11.119,15.882,41.636},
  {10.695,18.415,43.279},
  {13.505,17.616,42.406},
  {12.058,22.815,38.318},
  {14.054,21.864,40.358},
  {11.282,22.652,41.219}
 };

static ROTCOOSTRU VALH_rot2[9] = {
  {11.270,20.667,35.009},
  {14.696,17.960,37.693},
  {11.706,18.185,41.058},
  {14.089,21.890,40.231},
  {11.325,22.644,41.273},
  {11.938,22.845,38.293},
  {8.023,17.334,38.676},
  {8.228,20.031,37.361},
  {7.623,19.833,40.301}
};

static ROTCOOSTRU *VAL_rotarr[3] = {VAL_rot0,VAL_rot1,VAL_rot2};
static ROTCOOSTRU *VALH_rotarr[3] = {VALH_rot0,VALH_rot1,VALH_rot2};

static int MET_PDB[8] = { 0, 1, 2, 3, 4, 5, 11, 35 };
static short int MET_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 13 }; 
static int METH_PDB[9] = { 0, 3, 6, 7, 9, 10, 27, 28, 29 };
static short int METH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int MET_NUMC[2] = {8,9};

static ROTCOOSTRU MET_rot0[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.420,24.228,32.896},
  {17.971,24.508,35.411},
  {14.867,23.304,35.865}
 };

static ROTCOOSTRU MET_rot1[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.315,24.285,32.810},
  {13.158,25.765,37.800},
  {14.599,23.422,35.871}
 };

static ROTCOOSTRU MET_rot2[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.373,24.253,32.859},
  {12.265,21.400,37.072},
  {14.732,23.341,35.873}
 };

static ROTCOOSTRU MET_rot3[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.543,24.163,32.984},
  {13.093,28.886,30.838},
  {14.978,27.276,33.106}
 };

static ROTCOOSTRU MET_rot4[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.561,24.154,32.996},
  {13.885,28.323,36.099},
  {14.894,27.313,33.057}
 };

static ROTCOOSTRU MET_rot5[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.508,24.182,32.961},
  {18.167,26.276,33.971},
  {15.053,27.238,33.156}
 };

static ROTCOOSTRU MET_rot6[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.838,24.010,33.149},
  {9.411,22.630,35.518},
  {10.601,25.075,33.545}
 };

static ROTCOOSTRU MET_rot7[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.826,24.016,33.144},
  {10.713,26.254,36.668},
  {10.593,25.097,33.515}
 };

static ROTCOOSTRU MET_rot8[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.841,24.008,33.151},
  {10.661,27.688,31.292},
  {10.632,25.163,33.508}
 };

static ROTCOOSTRU MET_rot9[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.169,22.566,30.773},
  {18.092,23.828,25.806},
  {18.611,21.283,27.938}
 };

static ROTCOOSTRU MET_rot10[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.171,22.570,30.705},
  {21.707,20.968,28.711},
  {18.557,21.595,27.723}
 };

static ROTCOOSTRU MET_rot11[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.171,22.576,30.609},
  {18.988,18.726,27.610},
  {18.469,22.043,27.479}
 };

static ROTCOOSTRU MET_rot12[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.165,22.563,30.856},
  {17.724,26.574,34.129},
  {18.612,25.668,31.018}
 };

static ROTCOOSTRU MET_rot13[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.166,22.564,30.837},
  {21.853,24.810,31.150},
  {18.629,25.664,30.747}
 };

static ROTCOOSTRU MET_rot14[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.171,22.570,30.709},
  {17.980,26.816,27.806},
  {18.616,25.674,30.901}
 };

static ROTCOOSTRU MET_rot15[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.161,22.562,30.897},
  {18.940,18.333,33.360},
  {18.240,21.557,33.994}
 };

static ROTCOOSTRU MET_rot16[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.163,22.562,30.874},
  {21.562,21.482,33.442},
  {18.269,21.795,34.029}
 };

static ROTCOOSTRU MET_rot17[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {17.161,22.562,30.901},
  {17.579,25.018,35.473},
  {18.239,22.018,34.111}
 };

static ROTCOOSTRU MET_rot18[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.610,23.977,28.125},
  {10.787,27.469,28.676},
  {11.633,24.895,26.689}
 };

static ROTCOOSTRU MET_rot19[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.622,23.971,28.123},
  {12.769,26.166,23.780},
  {11.660,24.984,26.723}
 };

static ROTCOOSTRU MET_rot20[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.573,23.995,28.130},
  {10.965,22.606,24.641},
  {11.590,25.078,26.829}
 };

static ROTCOOSTRU MET_rot21[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.156,24.189,28.231},
  {18.805,26.480,28.730},
  {15.556,27.307,28.514}
 };

static ROTCOOSTRU MET_rot22[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.152,24.191,28.233},
  {14.952,28.511,25.439},
  {15.610,27.284,28.497}
 };

static ROTCOOSTRU MET_rot23[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.168,24.183,28.227},
  {13.717,28.914,30.356},
  {15.837,27.174,28.415}
 };

static ROTCOOSTRU MET_rot24[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.092,24.218,28.254},
  {13.216,21.396,23.967},
  {15.770,22.855,25.591}
 };

static ROTCOOSTRU MET_rot25[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {13.971,24.273,28.305},
  {14.322,25.057,23.169},
  {15.479,22.955,25.520}
 };

static ROTCOOSTRU MET_rot26[8] = {
  {10.314,20.328,30.200},
  {13.041,20.042,30.481},
  {13.642,18.504,32.842},
  {15.122,16.707,32.760},
  {14.296,22.648,30.657},
  {14.092,24.218,28.254},
  {18.846,23.068,26.466},
  {15.627,22.772,25.549}
};

static ROTCOOSTRU METH_rot0[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.146,22.426,30.823},
  {13.909,23.619,29.106},
  {13.837,26.007,32.616},
  {11.591,24.067,33.107},
  {19.019,24.140,36.916},
  {17.900,26.359,35.150},
  {18.748,23.706,33.911}
 };

static ROTCOOSTRU METH_rot1[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.134,22.425,30.921},
  {13.991,23.583,29.065},
  {13.758,26.054,32.512},
  {11.476,24.138,32.929},
  {13.691,25.538,39.579},
  {11.296,25.617,37.694},
  {13.672,27.468,37.219}
 };

static ROTCOOSTRU METH_rot2[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.142,22.426,30.866},
  {13.944,23.603,29.087},
  {13.812,26.026,32.577},
  {11.538,24.108,33.022},
  {12.740,20.741,38.757},
  {11.969,19.963,35.912},
  {10.691,22.399,37.226}
 };

static ROTCOOSTRU METH_rot3[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.153,22.430,30.712},
  {13.819,23.659,29.157},
  {11.711,24.405,33.016},
  {14.056,23.265,34.516},
  {13.663,30.662,30.687},
  {11.300,28.860,31.371},
  {13.251,28.047,29.173}
 };

static ROTCOOSTRU METH_rot4[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.154,22.431,30.697},
  {13.806,23.665,29.165},
  {11.723,24.336,33.079},
  {14.147,23.284,34.517},
  {14.484,30.066,36.419},
  {14.582,27.184,37.408},
  {12.016,28.291,36.189}
 };

static ROTCOOSTRU METH_rot5[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.152,22.429,30.743},
  {13.843,23.648,29.142},
  {11.687,24.492,32.921},
  {13.926,23.259,34.507},
  {19.268,27.778,34.150},
  {18.858,25.166,32.633},
  {18.138,25.340,35.590}
 };

static ROTCOOSTRU METH_rot6[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.146,22.451,30.463},
  {13.627,23.742,29.294},
  {14.219,22.884,34.564},
  {14.921,25.503,33.263},
  {7.611,22.953,35.912},
  {10.386,22.571,37.114},
  {9.562,20.982,34.646}
 };

static ROTCOOSTRU METH_rot7[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.147,22.450,30.472},
  {13.634,23.739,29.289},
  {14.192,22.890,34.564},
  {14.916,25.504,33.263},
  {9.038,26.927,37.160},
  {11.985,27.621,36.793},
  {11.184,24.869,37.833}
 };

static ROTCOOSTRU METH_rot8[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {16.146,22.451,30.460},
  {13.625,23.743,29.296},
  {14.170,22.864,34.564},
  {14.965,25.469,33.289},
  {8.990,28.529,31.268},
  {11.039,27.027,29.583},
  {11.969,28.936,31.770}
 };

static ROTCOOSTRU METH_rot9[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.829,23.655,29.151},
  {13.701,23.510,32.207},
  {17.842,24.272,31.003},
  {17.715,21.511,32.189},
  {18.795,23.400,24.126},
  {18.931,25.372,26.447},
  {16.257,24.150,25.640}
 };

static ROTCOOSTRU METH_rot10[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.792,23.671,29.174},
  {13.736,23.492,32.230},
  {17.843,24.247,31.096},
  {17.750,21.376,31.992},
  {22.728,20.400,27.250},
  {21.707,19.629,30.017},
  {22.468,22.521,29.425}
 };

static ROTCOOSTRU METH_rot11[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.741,23.693,29.208},
  {13.787,23.465,32.261},
  {17.854,24.183,31.216},
  {17.788,21.214,31.695},
  {19.713,18.133,25.991},
  {17.367,17.842,27.916},
  {20.177,18.325,28.998}
 };

static ROTCOOSTRU METH_rot12[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.873,23.635,29.125},
  {13.659,23.532,32.178},
  {17.666,21.647,32.381},
  {17.875,21.706,29.380},
  {18.395,28.279,34.508},
  {18.416,25.353,35.366},
  {15.859,26.602,34.273}
 };

static ROTCOOSTRU METH_rot13[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.863,23.640,29.130},
  {13.668,23.528,32.185},
  {17.676,21.765,32.424},
  {17.859,21.592,29.426},
  {22.922,26.345,31.142},
  {22.389,23.682,29.757},
  {22.074,23.918,32.780}
 };

static ROTCOOSTRU METH_rot14[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.794,23.670,29.172},
  {13.734,23.493,32.229},
  {17.751,21.606,32.176},
  {17.810,21.765,29.173},
  {18.673,28.543,27.612},
  {16.133,26.860,27.513},
  {18.775,25.690,26.540}
 };

static ROTCOOSTRU METH_rot15[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.896,23.625,29.112},
  {13.638,23.543,32.163},
  {17.863,21.377,29.664},
  {17.873,24.240,30.589},
  {19.568,17.503,34.915},
  {20.251,18.218,32.030},
  {17.396,17.452,32.776}
 };

static ROTCOOSTRU METH_rot16[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.883,23.631,29.119},
  {13.650,23.537,32.171},
  {17.846,21.281,29.730},
  {17.880,24.207,30.429},
  {22.451,21.052,35.031},
  {22.243,23.091,32.774},
  {21.856,20.124,32.189}
 };

static ROTCOOSTRU METH_rot17[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.899,23.624,29.111},
  {13.636,23.545,32.161},
  {17.843,21.197,29.858},
  {17.892,24.165,30.344},
  {18.079,25.019,37.276},
  {15.749,25.384,35.344},
  {18.537,26.348,34.571}
 };

static ROTCOOSTRU METH_rot18[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.251,23.758,31.742},
  {16.002,22.457,31.400},
  {15.610,25.516,28.338},
  {15.472,22.863,26.929},
  {9.154,28.192,28.116},
  {12.105,28.794,28.593},
  {10.622,26.878,30.443}
 };

static ROTCOOSTRU METH_rot19[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.246,23.761,31.734},
  {15.998,22.458,31.409},
  {15.672,25.478,28.328},
  {15.436,22.833,26.916},
  {11.329,26.806,22.771},
  {13.625,24.801,22.830},
  {13.980,27.561,24.074}
 };

static ROTCOOSTRU METH_rot20[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.266,23.750,31.764},
  {16.012,22.453,31.375},
  {15.657,25.480,28.320},
  {15.329,22.856,26.886},
  {9.351,22.936,23.755},
  {10.845,20.973,25.547},
  {12.347,22.509,23.383}
 };

static ROTCOOSTRU METH_rot21[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.452,23.644,31.998},
  {16.107,22.428,31.073},
  {15.049,23.311,26.872},
  {12.391,24.426,27.734},
  {19.843,28.027,28.898},
  {19.327,25.555,27.190},
  {19.084,25.389,30.224}
 };

static ROTCOOSTRU METH_rot22[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.454,23.643,32.000},
  {16.107,22.428,31.069},
  {15.012,23.297,26.863},
  {12.386,24.458,27.758},
  {15.650,30.241,25.287},
  {13.102,28.570,25.164},
  {15.732,27.418,24.136}
 };

static ROTCOOSTRU METH_rot23[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.447,23.647,31.992},
  {16.105,22.429,31.082},
  {14.917,23.226,26.835},
  {12.407,24.566,27.813},
  {14.387,30.638,30.638},
  {13.519,28.055,32.006},
  {12.047,29.033,29.522}
 };

static ROTCOOSTRU METH_rot24[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.485,23.626,32.030},
  {16.117,22.427,31.024},
  {12.320,24.384,27.756},
  {14.796,25.903,28.538},
  {13.848,20.548,22.424},
  {11.952,22.688,23.482},
  {12.402,20.128,25.075}
 };

static ROTCOOSTRU METH_rot25[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.550,23.591,32.091},
  {16.133,22.425,30.930},
  {12.176,24.466,27.913},
  {14.708,25.944,28.584},
  {14.998,24.569,21.494},
  {14.859,26.805,23.562},
  {12.453,24.986,23.120}
 };

static ROTCOOSTRU METH_rot26[9] = {
  {9.657,22.085,30.432},
  {13.662,19.116,29.008},
  {13.485,23.626,32.030},
  {16.117,22.427,31.024},
  {12.316,24.462,27.808},
  {14.880,25.870,28.510},
  {19.951,22.342,25.143},
  {19.133,22.154,28.074},
  {19.275,24.873,26.702}
};

static ROTCOOSTRU *MET_rotarr[27] = {MET_rot0,MET_rot1,MET_rot2,MET_rot3,MET_rot4,MET_rot5,MET_rot6,MET_rot7,MET_rot8,MET_rot9,MET_rot10,MET_rot11,MET_rot12,MET_rot13,MET_rot14,MET_rot15,MET_rot16,MET_rot17,MET_rot18,MET_rot19,MET_rot20,MET_rot21,MET_rot22,MET_rot23,MET_rot24,MET_rot25,MET_rot26};

static ROTCOOSTRU *METH_rotarr[27] = {METH_rot0,METH_rot1,METH_rot2,METH_rot3,METH_rot4,METH_rot5,METH_rot6,METH_rot7,METH_rot8,METH_rot9,METH_rot10,METH_rot11,METH_rot12,METH_rot13,METH_rot14,METH_rot15,METH_rot16,METH_rot17,METH_rot18,METH_rot19,METH_rot20,METH_rot21,METH_rot22,METH_rot23,METH_rot24,METH_rot25,METH_rot26};

static int ASP_PDB[8] = { 0, 1, 2, 3, 4, 5, 28, 29 };
static short int ASP_PMF[8] = { 10, 2, 4, 6, 2, 4, 8, 8 }; 
static int ASPH_PDB[4] = { 0, 3, 6, 7 };
static short int ASPH_PMF[4] = { 1, 1, 1, 1 };
static int ASP_NUMC[2] = {8,4};

static ROTCOOSTRU ASP_rot0[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.249,23.411,33.202},
  {0.672,22.011,31.342},
  {-1.242,25.242,33.124}
 };

static ROTCOOSTRU ASP_rot1[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.234,23.164,33.169},
  {1.511,23.226,31.177},
  {-2.122,23.333,33.194}
 };

static ROTCOOSTRU ASP_rot2[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.235,23.168,33.169},
  {0.809,24.991,31.773},
  {-1.415,21.577,32.597}
 };

static ROTCOOSTRU ASP_rot3[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.544,20.585,37.064},
  {1.330,20.116,39.247},
  {-1.079,19.263,35.967}
 };

static ROTCOOSTRU ASP_rot4[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.551,20.614,37.116},
  {2.047,18.934,37.851},
  {-1.777,20.530,37.514}
 };

static ROTCOOSTRU ASP_rot5[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.574,20.722,37.287},
  {1.056,18.492,36.656},
  {-0.715,21.272,39.189}
 };

static ROTCOOSTRU ASP_rot6[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.797,24.721,37.715},
  {1.241,27.024,37.397},
  {-0.284,23.870,39.636}
 };

static ROTCOOSTRU ASP_rot7[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.802,24.617,37.807},
  {2.445,25.378,39.332},
  {-1.474,25.233,37.953}
 };

static ROTCOOSTRU ASP_rot8[8] = {
  {5.420,25.086,34.285},
  {4.473,22.739,35.364},
  {5.187,20.496,33.705},
  {5.590,18.408,34.642},
  {1.602,22.866,35.676},
  {0.789,24.842,37.595},
  {1.828,24.858,39.721},
  {-0.890,26.382,36.969}
};

static ROTCOOSTRU ASPH_rot0[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {1.070,24.204,36.870},
  {0.882,21.266,36.326}
 };

static ROTCOOSTRU ASPH_rot1[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {1.061,24.304,36.742},
  {0.901,21.327,36.476}
 };

static ROTCOOSTRU ASPH_rot2[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {1.061,24.303,36.745},
  {0.900,21.326,36.473}
 };

static ROTCOOSTRU ASPH_rot3[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.707,22.943,34.035},
  {1.053,24.369,36.644}
 };

static ROTCOOSTRU ASPH_rot4[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.705,22.903,34.035},
  {1.050,24.389,36.611}
 };

static ROTCOOSTRU ASPH_rot5[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.700,22.771,34.040},
  {1.040,24.452,36.494}
 };

static ROTCOOSTRU ASPH_rot6[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.860,21.214,36.148},
  {0.735,23.402,34.108}
 };

static ROTCOOSTRU ASPH_rot7[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.850,21.196,36.060},
  {0.742,23.488,34.136}
 };

static ROTCOOSTRU ASPH_rot8[4] = {
  {4.132,26.392,33.828},
  {5.278,22.516,37.013},
  {0.873,21.243,36.255},
  {0.727,23.295,34.079}
};

static ROTCOOSTRU *ASP_rotarr[9] = {ASP_rot0,ASP_rot1,ASP_rot2,ASP_rot3,ASP_rot4,ASP_rot5,ASP_rot6,ASP_rot7,ASP_rot8};
static ROTCOOSTRU *ASPH_rotarr[9] = {ASPH_rot0,ASPH_rot1,ASPH_rot2,ASPH_rot3,ASPH_rot4,ASPH_rot5,ASPH_rot6,ASPH_rot7,ASPH_rot8};

static int ASN_PDB[8] = { 0, 1, 2, 3, 4, 5, 20, 28 };
static short int ASN_PMF[8] = { 10, 2, 4, 6, 2, 4, 10, 6 };
static int ASNH_PDB[6] = { 0, 3, 6, 7, 24, 25 }; 
static short int ASNH_PMF[6] = { 1, 1, 1, 1, 1, 1 };
static int ASN_NUMC[2] = {8,6};

static ROTCOOSTRU ASN_rot0[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {56.055,-20.609,50.204},
  {53.920,-19.561,50.998},
  {57.795,-21.155,51.649}
 };

static ROTCOOSTRU ASN_rot1[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.409,-20.683,50.090},
  {53.512,-22.113,50.891},
  {56.428,-19.084,51.438}
 };

static ROTCOOSTRU ASN_rot2[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.405,-20.684,50.089},
  {55.387,-22.702,51.576},
  {54.743,-18.578,50.826}
 };

static ROTCOOSTRU ASN_rot3[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.610,-20.650,50.141},
  {57.283,-21.439,51.833},
  {53.608,-19.627,50.741}
 };

static ROTCOOSTRU ASN_rot4[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.218,-20.723,50.028},
  {56.760,-19.681,51.708},
  {53.051,-21.382,50.557}
 };

static ROTCOOSTRU ASN_rot5[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.201,-20.727,50.021},
  {54.632,-18.375,50.681},
  {54.910,-22.535,51.456}
 };

static ROTCOOSTRU ASN_rot6[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {54.506,-23.097,46.265},
  {55.098,-23.989,43.998},
  {52.627,-23.808,47.439}
 };

static ROTCOOSTRU ASN_rot7[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {54.595,-23.137,46.201},
  {55.760,-25.169,45.305},
  {52.286,-22.870,46.098}
 };

static ROTCOOSTRU ASN_rot8[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {54.694,-23.178,46.136},
  {55.200,-25.531,46.840},
  {53.058,-22.666,44.563}
 };

static ROTCOOSTRU ASN_rot9[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {54.751,-23.200,46.102},
  {53.870,-25.002,47.605},
  {54.395,-23.201,43.803}
 };

static ROTCOOSTRU ASN_rot10[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {54.653,-23.162,46.162},
  {52.743,-24.028,47.536},
  {55.134,-23.971,44.034}
 };

static ROTCOOSTRU ASN_rot11[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {55.113,-23.312,45.922},
  {52.737,-23.035,45.170},
  {56.339,-25.246,45.513}
 };

static ROTCOOSTRU ASN_rot12[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.519,-22.797,46.726},
  {60.734,-21.660,46.425},
  {58.249,-25.096,46.491}
 };

static ROTCOOSTRU ASN_rot13[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.765,-22.540,47.133},
  {60.121,-22.778,49.228},
  {59.457,-23.408,45.088}
 };

static ROTCOOSTRU ASN_rot14[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.677,-22.647,46.963},
  {59.303,-24.239,48.797},
  {59.953,-22.395,45.034}
 };

static ROTCOOSTRU ASN_rot15[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.462,-22.842,46.655},
  {58.015,-25.306,46.782},
  {60.525,-21.975,46.019}
 };

static ROTCOOSTRU ASN_rot16[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.519,-22.797,46.726},
  {58.253,-24.301,44.738},
  {60.452,-22.762,48.021}
 };

static ROTCOOSTRU ASN_rot17[8] = {
  {58.109,-16.866,46.835},
  {56.269,-18.646,45.820},
  {53.629,-17.484,45.841},
  {52.128,-17.901,44.108},
  {56.274,-21.097,47.366},
  {58.781,-22.517,47.170},
  {59.851,-22.590,44.903},
  {59.722,-23.545,49.033}
};

static ROTCOOSTRU ASNH_rot0[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.839,-22.093,47.123},
  {54.856,-22.230,46.916},
  {52.622,-19.168,49.822},
  {53.690,-19.203,52.742}
 };

static ROTCOOSTRU ASNH_rot1[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.972,-21.876,47.466},
  {55.141,-22.400,46.646},
  {52.776,-23.326,49.792},
  {52.889,-21.923,52.564}
 };

static ROTCOOSTRU ASNH_rot2[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.973,-21.875,47.469},
  {55.143,-22.401,46.645},
  {55.912,-24.294,50.935},
  {54.849,-22.555,53.283}
 };

static ROTCOOSTRU ASNH_rot3[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.941,-21.947,47.354},
  {55.042,-22.350,46.725},
  {58.807,-22.220,51.293},
  {56.959,-21.222,53.585}
 };

static ROTCOOSTRU ASNH_rot4[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.992,-21.806,47.577},
  {55.244,-22.444,46.576},
  {58.420,-19.198,51.224},
  {56.205,-19.419,53.394}
 };

static ROTCOOSTRU ASNH_rot5[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {57.994,-21.800,47.587},
  {55.254,-22.448,46.570},
  {54.885,-17.031,49.518},
  {53.973,-18.036,52.316}
 };

static ROTCOOSTRU ASNH_rot6[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.728,-20.829,49.135},
  {57.969,-21.884,47.454},
  {56.565,-23.391,43.153},
  {54.055,-25.225,43.219}
 };

static ROTCOOSTRU ASNH_rot7[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.657,-20.842,49.114},
  {57.983,-21.845,47.516},
  {57.546,-25.303,45.421},
  {54.807,-26.489,44.548}
 };

static ROTCOOSTRU ASNH_rot8[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.582,-20.859,49.088},
  {57.993,-21.801,47.585},
  {56.478,-25.848,48.061},
  {54.284,-26.899,46.124}
 };

static ROTCOOSTRU ASNH_rot9[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.541,-20.869,49.072},
  {57.998,-21.777,47.623},
  {54.186,-24.932,49.371},
  {52.923,-26.363,46.916}
 };

static ROTCOOSTRU ASNH_rot10[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.613,-20.852,49.099},
  {57.989,-21.819,47.557},
  {52.435,-23.354,49.171},
  {51.684,-25.323,46.885}
 };

static ROTCOOSTRU ASNH_rot11[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {55.305,-20.941,48.959},
  {57.999,-21.633,47.852},
  {51.855,-21.512,45.524},
  {51.918,-24.360,44.278}
 };

static ROTCOOSTRU ASNH_rot12[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.738,-22.126,47.082},
  {56.361,-20.781,49.208},
  {60.864,-19.881,46.623},
  {62.189,-22.626,46.011}
 };

static ROTCOOSTRU ASNH_rot13[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.928,-22.282,46.834},
  {56.012,-20.792,49.193},
  {59.520,-22.081,50.770},
  {61.692,-23.645,49.187}
 };

static ROTCOOSTRU ASNH_rot14[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.844,-22.221,46.931},
  {56.153,-20.783,49.206},
  {58.267,-24.378,50.256},
  {60.787,-25.238,48.650}
 };

static ROTCOOSTRU ASNH_rot15[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.709,-22.094,47.133},
  {56.427,-20.784,49.204},
  {56.396,-25.900,47.281},
  {59.314,-26.477,46.375}
 };

static ROTCOOSTRU ASNH_rot16[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.738,-22.126,47.082},
  {56.361,-20.781,49.208},
  {56.731,-24.272,43.788},
  {59.586,-25.408,44.266}
 };

static ROTCOOSTRU ASNH_rot17[6] = {
  {58.894,-17.360,48.482},
  {56.735,-18.994,44.066},
  {54.947,-22.294,46.814},
  {55.983,-20.794,49.189},
  {59.064,-21.772,43.512},
  {61.404,-23.461,44.672}
};

static ROTCOOSTRU *ASN_rotarr[18] = {ASN_rot0,ASN_rot1,ASN_rot2,ASN_rot3,ASN_rot4,ASN_rot5,ASN_rot6,ASN_rot7,ASN_rot8,ASN_rot9,ASN_rot10,ASN_rot11,ASN_rot12,ASN_rot13,ASN_rot14,ASN_rot15,ASN_rot16,ASN_rot17};

static ROTCOOSTRU *ASNH_rotarr[18] = {ASNH_rot0,ASNH_rot1,ASNH_rot2,ASNH_rot3,ASNH_rot4,ASNH_rot5,ASNH_rot6,ASNH_rot7,ASNH_rot8,ASNH_rot9,ASNH_rot10,ASNH_rot11,ASNH_rot12,ASNH_rot13,ASNH_rot14,ASNH_rot15,ASNH_rot16,ASNH_rot17};

static int LEU_PDB[8] = { 0, 1, 2, 3, 4, 5, 9, 10 };
static short int LEU_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 2 };
static int LEUH_PDB[11] = { 0, 3, 6, 7, 9, 21, 22, 23, 24, 25, 26 };
static short int LEUH_PMF[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int LEU_NUMC[2] = {8,11};

static ROTCOOSTRU LEU_rot0[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {16.533,28.438,9.492},
  {14.093,29.901,9.019},
  {18.514,29.025,7.482}
 };

static ROTCOOSTRU LEU_rot1[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {16.173,28.906,9.583},
  {17.171,30.909,7.764},
  {16.498,26.253,8.504}
 };

static ROTCOOSTRU LEU_rot2[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {16.548,28.421,9.490},
  {17.487,25.799,8.744},
  {13.668,28.537,9.514}
 };

static ROTCOOSTRU LEU_rot3[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {17.435,31.992,12.240},
  {18.870,32.918,14.564},
  {18.512,33.128,9.820}
 };

static ROTCOOSTRU LEU_rot4[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {18.015,31.932,12.531},
  {19.645,32.985,10.397},
  {15.482,33.299,12.689}
 };

static ROTCOOSTRU LEU_rot5[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {17.814,31.969,12.440},
  {15.221,33.198,12.150},
  {18.968,32.549,15.018}
 };

static ROTCOOSTRU LEU_rot6[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {20.399,29.618,12.421},
  {21.771,27.141,12.970},
  {21.427,30.883,10.044}
 };

static ROTCOOSTRU LEU_rot7[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {20.438,28.786,11.919},
  {21.395,30.045,9.508},
  {21.693,29.908,14.259}
 };

static ROTCOOSTRU LEU_rot8[8] = {
  {16.609,24.997,13.984},
  {16.323,27.719,14.311},
  {13.587,28.592,14.570},
  {13.105,30.816,15.042},
  {17.571,29.107,12.106},
  {20.435,29.434,12.326},
  {21.068,30.737,14.819},
  {21.722,26.862,12.129}
};

static ROTCOOSTRU LEUH_rot0[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {19.407,28.769,11.993},
  {17.386,30.965,12.233},
  {16.131,26.636,9.402},
  {13.415,29.473,7.329},
  {14.431,31.739,9.097},
  {12.824,29.455,10.320},
  {17.847,28.593,5.789},
  {20.061,28.023,7.805},
  {18.943,30.845,7.527}
 };

static ROTCOOSTRU LEUH_rot1[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {19.297,28.480,11.749},
  {17.735,30.945,12.417},
  {14.367,29.218,9.823},
  {16.271,30.785,6.129},
  {19.002,30.649,7.478},
  {16.899,32.613,8.487},
  {15.595,26.118,6.871},
  {15.799,24.993,9.697},
  {18.314,25.898,8.231}
 };

static ROTCOOSTRU LEUH_rot2[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {19.410,28.781,12.002},
  {17.374,30.964,12.225},
  {17.166,29.618,8.224},
  {16.830,25.347,7.052},
  {16.894,24.535,9.990},
  {19.358,25.785,8.699},
  {13.001,28.093,7.823},
  {13.106,30.264,9.961},
  {12.996,27.328,10.774}
 };

static ROTCOOSTRU LEUH_rot3[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {16.803,28.668,10.457},
  {19.395,28.720,11.955},
  {15.680,32.545,12.410},
  {18.787,34.785,14.658},
  {20.662,32.389,14.455},
  {18.109,32.191,16.111},
  {18.426,34.995,9.903},
  {17.525,32.533,8.346},
  {20.297,32.604,9.614}
 };

static ROTCOOSTRU LEUH_rot4[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {16.558,29.013,10.535},
  {19.257,28.415,11.685},
  {18.923,32.208,14.117},
  {19.937,34.813,10.665},
  {18.779,32.736,8.757},
  {21.292,32.099,10.362},
  {15.765,35.128,12.965},
  {14.479,32.613,14.112},
  {14.532,33.059,11.096}
 };

static ROTCOOSTRU LEUH_rot5[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {16.634,28.890,10.501},
  {19.314,28.513,11.779},
  {18.918,32.676,11.138},
  {15.371,35.050,12.365},
  {14.051,32.522,13.444},
  {14.533,32.832,10.449},
  {19.127,34.400,15.238},
  {20.663,31.768,15.143},
  {17.874,31.862,16.371}
 };

static ROTCOOSTRU LEUH_rot6[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {16.812,30.789,11.798},
  {17.430,28.166,10.495},
  {20.692,30.749,13.853},
  {23.602,27.463,13.175},
  {21.513,25.947,11.553},
  {21.101,26.381,14.543},
  {23.257,31.215,10.243},
  {20.538,32.503,9.752},
  {21.164,29.765,8.567}
 };

static ROTCOOSTRU LEUH_rot7[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {17.300,30.957,12.179},
  {16.916,28.547,10.445},
  {20.878,26.993,11.828},
  {23.250,29.841,9.380},
  {20.979,31.869,9.538},
  {20.587,29.256,8.017},
  {23.549,29.702,14.143},
  {21.074,29.032,15.792},
  {21.285,31.729,14.386}
 };

static ROTCOOSTRU LEUH_rot8[11] = {
  {16.981,24.418,12.224},
  {17.176,28.186,15.882},
  {16.906,30.842,11.884},
  {17.312,28.234,10.471},
  {21.066,30.504,10.958},
  {22.921,30.952,14.969},
  {20.453,29.701,16.250},
  {20.249,32.418,14.882},
  {23.576,27.068,12.271},
  {21.317,26.075,10.481},
  {21.121,25.746,13.506}
};

static ROTCOOSTRU *LEU_rotarr[9] = {LEU_rot0,LEU_rot1,LEU_rot2,LEU_rot3,LEU_rot4,LEU_rot5,LEU_rot6,LEU_rot7,LEU_rot8};

static ROTCOOSTRU *LEUH_rotarr[9] = {LEUH_rot0,LEUH_rot1,LEUH_rot2,LEUH_rot3,LEUH_rot4,LEUH_rot5,LEUH_rot6,LEUH_rot7,LEUH_rot8};

static int LYS_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 11, 26 };
static short int LYS_PMF[9] = { 10, 2, 4, 6, 2, 2, 2, 2, 11 }; 
static int LYSH_PDB[13] = { 0, 3, 6, 7, 9, 10, 18, 19, 27, 28, 39, 40, 41 };
static short int LYSH_PMF[13] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int LYS_NUMC[2] = {9,13};

static ROTCOOSTRU LYS_rot0[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.589,6.740,6.473},
  {6.055,7.535,9.194},
  {8.837,8.076,9.662},
  {9.672,10.448,8.396}
 };

static ROTCOOSTRU LYS_rot1[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.592,6.740,6.477},
  {6.077,7.541,9.193},
  {8.859,8.103,9.633},
  {9.337,9.068,12.235}
 };

static ROTCOOSTRU LYS_rot2[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.389,6.691,6.102},
  {5.363,7.665,8.804},
  {7.721,9.201,9.382},
  {9.897,7.560,10.088}
 };

static ROTCOOSTRU LYS_rot3[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.563,6.737,6.431},
  {6.056,7.602,9.125},
  {5.016,10.240,9.580},
  {2.218,10.334,9.274}
 };

static ROTCOOSTRU LYS_rot4[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.641,6.745,6.554},
  {6.211,7.492,9.268},
  {5.146,10.088,9.882},
  {5.504,10.756,12.594}
 };

static ROTCOOSTRU LYS_rot5[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.641,6.745,6.554},
  {6.254,7.516,9.252},
  {4.983,9.998,9.943},
  {6.080,12.169,8.526}
 };

static ROTCOOSTRU LYS_rot6[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.589,6.740,6.473},
  {6.284,7.667,9.102},
  {4.512,6.591,11.090},
  {5.050,3.878,11.619}
 };

static ROTCOOSTRU LYS_rot7[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.657,6.746,6.577},
  {6.570,7.662,9.142},
  {4.755,6.892,11.231},
  {5.560,7.885,13.740}
 };

static ROTCOOSTRU LYS_rot8[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.589,6.740,6.473},
  {6.284,7.667,9.102},
  {4.582,6.504,11.102},
  {1.922,7.399,10.867}
 };

static ROTCOOSTRU LYS_rot9[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.565,6.737,6.435},
  {7.182,8.919,5.499},
  {7.308,8.970,2.630},
  {4.831,9.661,1.483}
 };

static ROTCOOSTRU LYS_rot10[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.540,6.733,6.392},
  {7.163,8.919,5.477},
  {7.251,9.023,2.608},
  {8.645,11.288,1.682}
 };

static ROTCOOSTRU LYS_rot11[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.629,6.744,6.535},
  {7.124,8.913,5.388},
  {6.256,9.476,2.709},
  {7.526,7.816,0.822}
 };

static ROTCOOSTRU LYS_rot12[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.568,6.737,6.439},
  {7.037,8.900,5.249},
  {5.628,11.389,5.515},
  {5.459,12.219,8.201}
 };

static ROTCOOSTRU LYS_rot13[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.570,6.738,6.442},
  {7.072,8.906,5.304},
  {5.837,11.438,5.865},
  {7.291,13.582,4.764}
 };

static ROTCOOSTRU LYS_rot14[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.561,6.736,6.427},
  {7.030,8.899,5.238},
  {5.881,11.441,5.921},
  {3.367,11.817,4.711}
 };

static ROTCOOSTRU LYS_rot15[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.599,6.741,6.489},
  {6.987,8.893,5.188},
  {9.544,9.373,6.405},
  {11.419,7.385,5.729}
 };

static ROTCOOSTRU LYS_rot16[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.531,6.731,6.376},
  {6.855,8.858,4.971},
  {9.464,9.362,6.060},
  {10.728,11.537,4.796}
 };

static ROTCOOSTRU LYS_rot17[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.599,6.741,6.489},
  {6.945,8.886,5.132},
  {9.549,9.356,6.249},
  {9.399,10.393,8.863}
 };

static ROTCOOSTRU LYS_rot18[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.599,6.741,6.489},
  {3.505,7.351,4.619},
  {1.067,5.997,5.306},
  {-0.094,7.046,7.646}
 };

static ROTCOOSTRU LYS_rot19[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.526,6.730,6.368},
  {3.519,7.258,4.382},
  {0.978,6.158,5.149},
  {-1.034,6.754,3.271}
 };

static ROTCOOSTRU LYS_rot20[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.592,6.740,6.477},
  {3.447,7.301,4.651},
  {0.959,6.226,5.603},
  {0.734,3.470,5.073}
 };

static ROTCOOSTRU LYS_rot21[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.717,6.749,6.663},
  {3.430,7.418,5.060},
  {2.368,9.989,5.778},
  {4.175,12.070,5.200}
 };

static ROTCOOSTRU LYS_rot22[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.654,6.746,6.573},
  {3.423,7.355,4.870},
  {2.308,9.929,5.490},
  {0.205,10.610,3.747}
 };

static ROTCOOSTRU LYS_rot23[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.528,6.731,6.372},
  {3.462,7.223,4.438},
  {2.002,9.618,5.059},
  {0.563,9.376,7.467}
 };

static ROTCOOSTRU LYS_rot24[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.592,6.740,6.477},
  {3.314,7.205,4.790},
  {4.115,8.047,2.164},
  {5.136,5.909,0.641}
 };

static ROTCOOSTRU LYS_rot25[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.517,6.728,6.352},
  {3.339,7.121,4.521},
  {4.285,7.444,1.828},
  {2.168,7.817,0.010}
 };

static ROTCOOSTRU LYS_rot26[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {5.606,6.742,6.501},
  {3.339,7.241,4.810},
  {4.157,7.981,2.158},
  {5.453,10.480,2.118}
 };

static ROTCOOSTRU LYS_rot27[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.410,4.618,7.068},
  {11.227,2.517,6.339},
  {11.761,2.530,3.517},
  {13.164,4.839,2.724}
 };

static ROTCOOSTRU LYS_rot28[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.508,4.466,6.874},
  {11.153,2.286,5.984},
  {11.692,2.467,3.169},
  {13.315,0.349,2.271}
 };

static ROTCOOSTRU LYS_rot29[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.402,4.629,7.081},
  {11.237,2.544,6.347},
  {12.342,2.998,3.735},
  {10.593,2.159,1.694}
 };

static ROTCOOSTRU LYS_rot30[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.416,4.610,7.058},
  {11.222,2.500,6.328},
  {13.915,3.111,7.117},
  {14.203,3.164,9.917}
 };

static ROTCOOSTRU LYS_rot31[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.428,4.592,7.036},
  {11.249,2.540,6.182},
  {13.905,3.031,7.158},
  {15.705,1.017,6.363}
 };

static ROTCOOSTRU LYS_rot32[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.488,4.499,6.919},
  {11.176,2.343,6.052},
  {13.825,2.593,7.134},
  {15.156,4.866,6.139}
 };

static ROTCOOSTRU LYS_rot33[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.545,4.399,6.783},
  {11.299,2.887,5.084},
  {11.615,0.197,6.041},
  {9.375,-1.400,5.444}
 };

static ROTCOOSTRU LYS_rot34[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.512,4.458,6.864},
  {11.348,2.977,5.224},
  {11.714,0.307,6.219},
  {13.595,-1.132,4.696}
 };

static ROTCOOSTRU LYS_rot35[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.494,4.489,6.905},
  {11.356,2.943,5.359},
  {11.519,0.240,6.320},
  {12.757,0.096,8.845}
 };

static ROTCOOSTRU LYS_rot36[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.486,4.502,6.922},
  {10.882,6.633,5.595},
  {9.896,9.201,6.422},
  {10.621,9.798,9.077}
 };

static ROTCOOSTRU LYS_rot37[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.432,4.586,7.029},
  {10.854,6.688,5.683},
  {9.754,9.265,6.317},
  {11.192,11.351,5.090}
 };

static ROTCOOSTRU LYS_rot38[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.518,4.448,6.850},
  {10.981,6.411,5.347},
  {10.630,9.041,6.447},
  {8.155,10.165,5.711}
 };

static ROTCOOSTRU LYS_rot39[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.446,4.565,7.003},
  {10.825,6.738,5.727},
  {13.367,7.234,6.970},
  {15.136,5.068,6.641}
 };

static ROTCOOSTRU LYS_rot40[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.437,4.578,7.019},
  {10.798,6.783,5.779},
  {13.409,7.168,6.913},
  {14.768,9.322,5.711}
 };

static ROTCOOSTRU LYS_rot41[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.439,4.576,7.016},
  {10.802,6.777,5.772},
  {13.480,7.048,6.776},
  {13.514,7.831,9.480}
 };

static ROTCOOSTRU LYS_rot42[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.377,4.664,7.122},
  {10.649,6.999,6.035},
  {11.726,6.481,3.423},
  {9.698,6.164,1.496}
 };

static ROTCOOSTRU LYS_rot43[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.475,4.520,6.946},
  {10.736,6.879,5.899},
  {11.364,6.577,3.113},
  {12.732,8.818,2.095}
 };

static ROTCOOSTRU LYS_rot44[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.468,4.531,6.960},
  {10.754,6.853,5.862},
  {11.435,6.461,3.100},
  {13.369,4.441,2.772}
 };

static ROTCOOSTRU LYS_rot45[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.629,4.208,6.488},
  {10.145,5.228,9.123},
  {9.770,3.198,11.120},
  {11.875,1.329,11.126}
 };

static ROTCOOSTRU LYS_rot46[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.624,4.222,6.511},
  {10.119,5.309,9.123},
  {10.342,3.231,11.094},
  {10.778,4.272,13.673}
 };

static ROTCOOSTRU LYS_rot47[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.611,4.257,6.569},
  {10.040,5.370,9.182},
  {9.904,3.345,11.214},
  {7.245,2.708,11.886}
 };

static ROTCOOSTRU LYS_rot48[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.639,4.180,6.442},
  {10.191,4.989,9.142},
  {13.018,5.073,9.648},
  {14.293,7.089,8.152}
 };

static ROTCOOSTRU LYS_rot49[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.604,4.274,6.595},
  {10.021,5.588,9.115},
  {12.817,5.770,9.747},
  {13.252,7.010,12.237}
 };

static ROTCOOSTRU LYS_rot50[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.595,4.296,6.629},
  {9.955,5.457,9.231},
  {12.739,5.639,9.916},
  {13.900,3.099,10.273}
 };

static ROTCOOSTRU LYS_rot51[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.646,4.155,6.399},
  {10.296,5.476,8.865},
  {10.393,8.327,8.527},
  {7.845,9.411,8.015}
 };

static ROTCOOSTRU LYS_rot52[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.587,4.313,6.655},
  {9.987,6.028,8.924},
  {9.552,8.784,8.238},
  {9.867,10.482,10.461}
 };

static ROTCOOSTRU LYS_rot53[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {9.574,4.342,6.699},
  {9.905,5.981,9.035},
  {9.723,8.773,8.384},
  {11.847,9.608,6.735}
 };

static ROTCOOSTRU LYS_rot54[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.442,3.600,3.612},
  {6.871,3.522,1.208},
  {5.892,6.132,0.517},
  {7.966,7.843,-0.321}
 };

static ROTCOOSTRU LYS_rot55[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.184,3.677,3.431},
  {6.389,3.823,1.193},
  {5.441,6.505,0.790},
  {3.664,6.674,-1.388}
 };

static ROTCOOSTRU LYS_rot56[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.400,3.611,3.579},
  {6.835,3.788,1.177},
  {6.692,6.494,0.222},
  {4.679,7.964,1.531}
 };

static ROTCOOSTRU LYS_rot57[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.177,3.679,3.426},
  {6.334,3.576,1.226},
  {7.709,3.223,-1.271},
  {9.119,0.787,-1.359}
 };

static ROTCOOSTRU LYS_rot58[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.188,3.676,3.433},
  {6.346,3.485,1.238},
  {7.708,2.875,-1.217},
  {5.916,2.589,-3.369}
 };

static ROTCOOSTRU LYS_rot59[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.428,3.603,3.601},
  {6.806,3.232,1.260},
  {8.422,2.720,-1.059},
  {10.134,4.877,-1.644}
 };

static ROTCOOSTRU LYS_rot60[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.393,3.613,3.574},
  {6.793,3.670,1.189},
  {5.508,1.141,0.734},
  {3.538,0.600,2.672}
 };

static ROTCOOSTRU LYS_rot61[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.247,3.656,3.472},
  {6.448,3.288,1.263},
  {5.911,0.503,0.808},
  {4.447,0.090,-1.562}
 };

static ROTCOOSTRU LYS_rot62[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {8.364,3.621,3.553},
  {6.697,3.465,1.218},
  {5.597,0.832,0.895},
  {7.590,-1.077,0.335}
 };

static ROTCOOSTRU LYS_rot63[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.769,3.837,3.217},
  {9.123,6.181,2.256},
  {11.695,6.484,3.500},
  {13.548,4.586,2.556}
 };

static ROTCOOSTRU LYS_rot64[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.706,3.864,3.191},
  {8.953,6.251,2.192},
  {11.472,6.733,3.485},
  {12.773,9.000,2.439}
 };

static ROTCOOSTRU LYS_rot65[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.777,3.833,3.220},
  {8.967,6.237,2.192},
  {11.712,6.473,3.006},
  {11.945,7.282,5.692}
 };

static ROTCOOSTRU LYS_rot66[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.651,3.889,3.171},
  {9.120,6.181,2.255},
  {10.044,5.819,-0.441},
  {7.913,5.713,-2.277}
 };

static ROTCOOSTRU LYS_rot67[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.651,3.889,3.171},
  {9.080,6.201,2.240},
  {9.889,5.894,-0.499},
  {11.273,8.157,-1.444}
 };

static ROTCOOSTRU LYS_rot68[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.639,3.895,3.167},
  {9.124,6.178,2.256},
  {9.847,5.917,-0.512},
  {11.658,3.802,-0.930}
 };

static ROTCOOSTRU LYS_rot69[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.639,3.895,3.167},
  {9.250,6.110,2.301},
  {7.637,8.426,1.765},
  {6.880,9.750,4.133}
 };

static ROTCOOSTRU LYS_rot70[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.671,3.880,3.178},
  {9.271,6.103,2.312},
  {7.667,8.452,1.914},
  {9.184,10.602,0.914}
 };

static ROTCOOSTRU LYS_rot71[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.572,3.926,3.144},
  {9.186,6.137,2.273},
  {7.619,8.528,1.996},
  {5.714,8.302,-0.065}
 };

static ROTCOOSTRU LYS_rot72[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.560,3.932,3.140},
  {9.799,2.160,2.834},
  {8.950,-0.580,2.692},
  {7.864,-1.214,0.173}
 };

static ROTCOOSTRU LYS_rot73[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.461,3.981,3.111},
  {9.683,2.209,2.693},
  {8.799,-0.492,2.274},
  {10.959,-2.254,1.879}
 };

static ROTCOOSTRU LYS_rot74[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.461,3.981,3.111},
  {9.863,2.458,2.714},
  {9.295,-0.350,2.497},
  {9.100,-1.580,5.023}
 };

static ROTCOOSTRU LYS_rot75[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.508,3.957,3.124},
  {9.461,1.891,2.717},
  {10.224,1.706,-0.046},
  {11.519,4.042,-0.937}
 };

static ROTCOOSTRU LYS_rot76[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.457,3.983,3.110},
  {9.336,1.862,2.637},
  {10.070,1.718,-0.136},
  {11.839,-0.413,-0.645}
 };

static ROTCOOSTRU LYS_rot77[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.373,4.025,3.089},
  {9.240,1.916,2.529},
  {9.998,1.902,-0.242},
  {7.871,1.109,-1.908}
 };

static ROTCOOSTRU LYS_rot78[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.576,3.925,3.145},
  {9.607,1.919,2.822},
  {12.183,2.905,3.624},
  {12.479,2.915,6.424}
 };

static ROTCOOSTRU LYS_rot79[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.504,3.959,3.123},
  {9.421,1.861,2.706},
  {11.999,2.580,3.748},
  {13.901,0.544,3.343}
 };

static ROTCOOSTRU LYS_rot80[9] = {
  {2.954,1.652,5.705},
  {5.388,1.933,6.972},
  {5.078,2.211,9.795},
  {3.495,3.598,10.736},
  {6.818,4.207,5.901},
  {7.389,4.017,3.093},
  {9.317,1.957,2.557},
  {11.949,2.748,3.393},
  {13.050,4.698,1.687}
}; 

static ROTCOOSTRU LYSH_rot0[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.751,4.208,6.665},
  {6.983,3.989,3.841},
  {6.343,8.187,5.186},
  {3.544,6.618,6.123},
  {4.932,9.230,9.628},
  {5.411,6.033,10.479},
  {9.181,8.225,11.706},
  {9.980,6.484,8.969},
  {11.506,10.738,8.747},
  {9.405,10.297,6.532},
  {8.667,11.905,9.060}
 };

static ROTCOOSTRU LYSH_rot1[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.752,4.206,6.663},
  {6.980,3.991,3.840},
  {6.335,8.185,5.181},
  {3.544,6.616,6.142},
  {4.946,9.228,9.635},
  {5.457,6.036,10.485},
  {9.974,6.376,9.321},
  {9.512,9.506,8.246},
  {11.182,9.414,12.451},
  {8.361,10.663,12.505},
  {8.788,7.774,13.498}
 };

static ROTCOOSTRU LYSH_rot2[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.633,4.392,6.898},
  {7.260,3.844,3.903},
  {6.271,8.105,4.859},
  {3.437,6.428,5.437},
  {3.675,8.839,9.106},
  {5.235,6.062,10.122},
  {8.228,10.345,7.721},
  {7.322,10.527,10.933},
  {11.406,8.637,10.453},
  {9.455,6.555,11.626},
  {10.291,6.387,8.661}
 };

static ROTCOOSTRU LYSH_rot3[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.739,4.229,6.694},
  {7.016,3.971,3.846},
  {6.279,8.162,5.098},
  {3.515,6.579,6.112},
  {5.180,6.268,10.457},
  {8.100,7.584,9.500},
  {5.523,10.865,11.497},
  {5.901,11.574,8.253},
  {1.608,12.095,9.587},
  {1.758,9.812,7.517},
  {1.409,9.158,10.512}
 };

static ROTCOOSTRU LYSH_rot4[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.772,4.168,6.609},
  {6.921,4.025,3.833},
  {6.368,8.203,5.263},
  {3.584,6.653,6.274},
  {5.403,6.082,10.564},
  {8.268,7.492,9.575},
  {6.071,11.518,8.690},
  {3.119,10.133,9.421},
  {4.781,12.471,12.922},
  {4.623,9.484,13.679},
  {7.349,10.762,13.004}
 };

static ROTCOOSTRU LYSH_rot5[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.772,4.168,6.609},
  {6.921,4.025,3.833},
  {6.339,8.196,5.239},
  {3.580,6.642,6.309},
  {5.632,6.026,10.562},
  {8.313,7.702,9.474},
  {2.947,9.869,9.543},
  {5.181,10.334,11.985},
  {5.197,13.762,9.030},
  {7.921,12.317,8.925},
  {5.859,11.888,6.670}
 };

static ROTCOOSTRU LYSH_rot6[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.751,4.208,6.665},
  {6.983,3.989,3.841},
  {6.189,8.141,5.059},
  {3.524,6.564,6.320},
  {8.240,7.117,9.541},
  {6.209,9.743,9.152},
  {4.693,7.686,12.847},
  {2.545,6.793,10.448},
  {3.849,3.241,12.932},
  {4.840,2.872,10.033},
  {6.823,3.697,12.248}
 };

static ROTCOOSTRU LYSH_rot7[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.777,4.157,6.593},
  {6.903,4.035,3.832},
  {6.148,8.147,5.121},
  {3.584,6.584,6.592},
  {8.455,6.877,9.531},
  {6.765,9.731,9.115},
  {2.850,7.595,10.789},
  {4.633,4.819,11.315},
  {4.323,7.340,15.060},
  {7.273,7.209,14.166},
  {5.626,9.772,13.680}
 };

static ROTCOOSTRU LYSH_rot8[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.751,4.208,6.665},
  {6.983,3.989,3.841},
  {6.189,8.141,5.059},
  {3.524,6.564,6.320},
  {8.266,7.188,9.509},
  {6.131,9.738,9.174},
  {4.631,4.432,10.936},
  {5.306,6.979,12.992},
  {0.865,6.595,12.211},
  {1.869,9.277,11.065},
  {1.246,6.926,9.167}
 };

static ROTCOOSTRU LYSH_rot9[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.740,4.227,6.692},
  {7.013,3.973,3.845},
  {3.704,6.802,5.511},
  {5.239,6.936,8.478},
  {6.399,10.715,6.195},
  {9.102,8.749,6.278},
  {8.755,10.332,2.023},
  {7.898,7.104,1.928},
  {4.990,9.674,-0.400},
  {3.524,8.397,1.995},
  {4.315,11.378,2.082}
 };

static ROTCOOSTRU LYSH_rot10[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.728,4.249,6.720},
  {7.046,3.955,3.851},
  {3.698,6.781,5.428},
  {5.169,6.943,8.426},
  {6.406,10.707,6.217},
  {9.091,8.717,6.227},
  {8.165,7.304,1.878},
  {5.314,9.048,1.854},
  {8.661,11.290,-0.208},
  {7.788,12.854,2.304},
  {10.420,11.244,2.326}
 };

static ROTCOOSTRU LYSH_rot11[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.767,4.178,6.623},
  {6.936,4.016,3.835},
  {3.674,6.794,5.829},
  {5.537,6.975,8.599},
  {6.902,10.612,6.565},
  {9.147,8.437,5.380},
  {4.197,9.221,2.579},
  {6.651,11.466,2.256},
  {6.907,8.243,-0.911},
  {9.395,8.081,0.906},
  {7.129,6.008,1.204}
 };

static ROTCOOSTRU LYSH_rot12[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.741,4.225,6.689},
  {7.010,3.974,3.845},
  {3.624,6.726,5.701},
  {5.438,7.029,8.493},
  {8.903,9.055,6.152},
  {7.366,8.496,3.237},
  {6.591,12.854,4.398},
  {3.713,11.189,4.732},
  {4.522,13.857,8.297},
  {4.542,10.910,9.209},
  {7.199,12.447,8.901}
 };

static ROTCOOSTRU LYSH_rot13[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.742,4.223,6.686},
  {7.007,3.976,3.844},
  {3.641,6.743,5.669},
  {5.404,7.008,8.497},
  {9.006,8.890,6.065},
  {7.224,8.644,3.248},
  {3.903,11.450,5.103},
  {5.680,11.693,7.922},
  {6.421,15.210,5.172},
  {9.035,13.601,5.491},
  {7.394,13.378,2.888}
 };

static ROTCOOSTRU LYSH_rot14[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.738,4.231,6.697},
  {7.019,3.969,3.846},
  {3.620,6.719,5.681},
  {5.422,7.033,8.480},
  {9.007,8.833,5.877},
  {7.050,8.675,3.172},
  {5.682,11.580,7.986},
  {7.167,12.965,5.332},
  {2.675,13.505,5.204},
  {3.554,11.738,2.832},
  {2.183,10.460,5.282}
 };

static ROTCOOSTRU LYSH_rot15[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.755,4.201,6.655},
  {6.971,3.996,3.839},
  {3.614,6.719,5.874},
  {5.597,7.054,8.544},
  {7.247,8.440,3.176},
  {5.836,10.622,5.279},
  {10.260,11.231,5.807},
  {9.326,9.444,8.472},
  {13.071,7.766,6.563},
  {10.792,5.701,6.315},
  {11.654,7.351,3.854}
 };

static ROTCOOSTRU LYSH_rot16[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.723,4.256,6.731},
  {7.058,3.948,3.853},
  {3.545,6.626,5.770},
  {5.525,7.139,8.414},
  {7.022,8.366,2.958},
  {5.707,10.588,5.082},
  {9.304,9.744,8.097},
  {10.643,7.662,5.852},
  {12.434,11.808,5.562},
  {10.918,11.172,2.952},
  {9.682,13.094,5.025}
 };

static ROTCOOSTRU LYSH_rot17[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.755,4.201,6.655},
  {6.971,3.996,3.839},
  {3.600,6.702,5.921},
  {5.643,7.077,8.540},
  {7.125,8.429,3.112},
  {5.806,10.619,5.266},
  {10.626,7.578,6.272},
  {10.595,10.683,5.038},
  {11.144,10.676,9.531},
  {8.462,12.034,8.838},
  {8.491,9.166,9.977}
 };

static ROTCOOSTRU LYSH_rot18[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.755,4.201,6.655},
  {6.971,3.996,3.839},
  {4.825,6.712,8.418},
  {7.041,8.238,6.434},
  {3.177,9.403,4.585},
  {4.096,6.796,2.705},
  {-0.283,6.158,3.733},
  {1.449,3.971,5.572},
  {-1.689,6.109,8.034},
  {1.113,6.857,9.088},
  {-0.486,8.877,7.390}
 };

static ROTCOOSTRU LYSH_rot19[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.721,4.260,6.736},
  {7.064,3.945,3.854},
  {4.656,6.730,8.256},
  {6.942,8.252,6.350},
  {3.335,9.310,4.104},
  {4.109,6.447,2.561},
  {1.147,4.096,5.350},
  {0.431,6.906,7.009},
  {-2.671,6.001,3.840},
  {-1.222,8.628,3.122},
  {-0.560,6.033,1.589}
 };

static ROTCOOSTRU LYSH_rot20[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.752,4.206,6.663},
  {6.980,3.991,3.840},
  {4.866,6.737,8.425},
  {7.018,8.248,6.361},
  {3.267,9.356,4.397},
  {3.888,6.492,2.788},
  {0.800,6.552,7.650},
  {-0.622,7.234,4.704},
  {-0.922,2.835,5.725},
  {0.830,3.176,3.209},
  {2.143,2.546,5.929}
 };

static ROTCOOSTRU LYSH_rot21[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.797,4.115,6.529},
  {6.836,4.075,3.827},
  {5.173,6.700,8.669},
  {7.167,8.225,6.461},
  {3.963,7.420,3.051},
  {1.962,5.966,5.299},
  {0.589,10.315,4.755},
  {1.915,10.011,7.806},
  {3.411,13.725,5.698},
  {5.777,11.801,6.166},
  {4.552,12.082,3.349}
 };

static ROTCOOSTRU LYSH_rot22[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.776,4.159,6.595},
  {6.906,4.033,3.832},
  {5.032,6.725,8.556},
  {7.091,8.239,6.400},
  {4.032,7.319,2.883},
  {1.962,5.892,5.086},
  {1.611,9.929,7.448},
  {3.797,11.375,5.375},
  {-0.476,12.309,4.214},
  {0.847,10.656,1.970},
  {-1.171,9.321,3.884}
 };

static ROTCOOSTRU LYSH_rot23[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.722,4.258,6.733},
  {7.061,3.947,3.853},
  {4.713,6.751,8.284},
  {6.936,8.258,6.293},
  {4.304,7.391,2.545},
  {2.158,5.605,4.384},
  {3.321,11.218,5.199},
  {0.686,10.049,3.508},
  {-0.369,10.984,7.809},
  {-0.670,7.951,7.325},
  {1.762,9.031,8.886}
 };

static ROTCOOSTRU LYSH_rot24[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.752,4.206,6.663},
  {6.980,3.991,3.840},
  {5.005,6.794,8.471},
  {6.980,8.264,6.209},
  {2.183,5.466,4.651},
  {2.097,8.656,5.646},
  {2.489,8.883,1.176},
  {5.560,9.533,2.322},
  {5.640,6.536,-1.068},
  {6.644,5.177,1.513},
  {3.808,4.577,0.456}
 };

static ROTCOOSTRU LYSH_rot25[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.716,4.268,6.746},
  {7.076,3.939,3.856},
  {4.809,6.809,8.305},
  {6.894,8.271,6.139},
  {2.047,5.495,4.616},
  {2.249,8.799,5.084},
  {5.571,9.074,1.736},
  {5.385,5.770,1.274},
  {2.864,8.022,-1.735},
  {1.023,6.315,0.057},
  {1.194,9.366,0.484}
 };

static ROTCOOSTRU LYSH_rot26[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {8.758,4.195,6.647},
  {6.963,4.001,3.838},
  {5.012,6.778,8.492},
  {7.006,8.259,6.255},
  {2.147,5.540,4.722},
  {2.178,8.757,5.630},
  {5.434,6.528,1.395},
  {2.495,8.044,0.911},
  {5.961,10.899,0.346},
  {4.278,11.810,2.766},
  {6.991,10.411,3.213}
 };

static ROTCOOSTRU LYSH_rot27[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {7.034,3.961,3.849},
  {5.672,5.918,6.186},
  {10.174,6.448,6.443},
  {9.238,4.705,9.138},
  {13.009,2.741,7.387},
  {10.424,0.679,6.889},
  {12.864,0.843,3.012},
  {9.967,2.418,2.471},
  {13.478,4.778,0.862},
  {12.141,6.372,3.140},
  {14.816,4.918,3.639}
 };

static ROTCOOSTRU LYSH_rot28[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.862,4.060,3.828},
  {5.766,5.941,6.360},
  {10.317,6.264,6.217},
  {9.495,4.527,8.952},
  {12.945,2.289,7.038},
  {10.205,0.483,6.398},
  {9.899,2.457,2.117},
  {12.627,4.277,2.756},
  {13.626,0.534,0.417},
  {14.965,0.384,3.192},
  {12.445,-1.296,2.602}
 };

static ROTCOOSTRU LYSH_rot29[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {7.046,3.955,3.851},
  {5.666,5.916,6.174},
  {10.156,6.468,6.470},
  {9.221,4.702,9.150},
  {12.772,2.442,7.745},
  {10.258,0.711,6.381},
  {12.759,5.021,3.500},
  {14.147,1.982,3.559},
  {11.385,2.488,0.010},
  {10.251,0.310,1.878},
  {8.969,3.116,1.823}
 };

static ROTCOOSTRU LYSH_rot30[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {7.025,3.966,3.847},
  {5.676,5.920,6.195},
  {10.185,6.436,6.427},
  {9.250,4.702,9.128},
  {10.619,0.724,7.226},
  {11.148,2.199,4.273},
  {15.211,1.698,6.316},
  {14.467,4.955,6.330},
  {15.994,3.572,10.360},
  {13.060,4.482,10.644},
  {13.748,1.475,10.630}
 };

static ROTCOOSTRU LYSH_rot31[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {7.004,3.978,3.844},
  {5.687,5.923,6.217},
  {10.164,6.454,6.477},
  {9.295,4.587,9.110},
  {10.586,0.692,6.864},
  {11.275,2.450,4.106},
  {14.573,4.871,6.458},
  {13.872,3.147,9.234},
  {17.426,1.406,7.039},
  {15.126,-0.650,7.038},
  {15.773,0.942,4.476}
 };

static ROTCOOSTRU LYSH_rot32[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.900,4.037,3.831},
  {5.743,5.937,6.322},
  {10.284,6.309,6.278},
  {9.440,4.556,8.996},
  {10.350,0.530,6.644},
  {11.270,2.322,3.976},
  {13.721,2.706,9.207},
  {14.926,0.891,6.674},
  {16.886,4.965,6.892},
  {15.294,4.743,4.258},
  {14.181,6.419,6.597}
 };

static ROTCOOSTRU LYSH_rot33[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.786,4.106,3.825},
  {5.813,5.947,6.436},
  {10.134,6.393,6.796},
  {9.697,3.706,8.736},
  {10.539,2.854,3.149},
  {13.156,3.818,4.994},
  {13.313,-0.647,5.189},
  {11.917,0.223,8.097},
  {9.654,-3.149,6.102},
  {7.838,-0.660,6.257},
  {9.126,-1.464,3.572}
 };

static ROTCOOSTRU LYSH_rot34[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.853,4.065,3.828},
  {5.771,5.941,6.369},
  {10.061,6.463,6.888},
  {9.619,3.774,8.824},
  {10.636,2.902,3.273},
  {13.180,3.957,5.168},
  {12.342,0.385,8.199},
  {9.895,-0.697,6.198},
  {13.784,-2.873,5.407},
  {13.003,-1.245,2.905},
  {15.263,-0.246,4.753}
 };

static ROTCOOSTRU LYSH_rot35[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.889,4.044,3.830},
  {5.750,5.938,6.334},
  {10.047,6.492,6.863},
  {9.562,3.880,8.891},
  {10.773,2.939,3.364},
  {13.236,3.827,5.443},
  {9.609,-0.570,6.439},
  {12.585,-0.916,4.960},
  {12.828,-1.705,9.410},
  {14.511,0.789,8.728},
  {11.763,1.108,10.093}
 };

static ROTCOOSTRU LYSH_rot36[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.903,4.035,3.832},
  {5.742,5.936,6.319},
  {9.413,4.882,8.965},
  {10.530,2.722,6.671},
  {12.914,6.500,6.009},
  {10.665,6.433,3.537},
  {10.640,10.671,5.155},
  {7.825,9.239,6.246},
  {9.940,11.497,9.549},
  {9.906,8.489,10.236},
  {12.505,9.812,9.228}
 };

static ROTCOOSTRU LYSH_rot37[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.998,3.981,3.843},
  {5.690,5.924,6.223},
  {9.260,5.044,9.050},
  {10.513,2.816,6.895},
  {12.860,6.633,6.228},
  {10.772,6.381,3.629},
  {7.769,9.341,5.707},
  {9.767,9.536,8.378},
  {10.413,13.010,5.551},
  {12.987,11.313,5.680},
  {11.142,11.133,3.213}
 };

static ROTCOOSTRU LYSH_rot38[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.841,4.072,3.827},
  {5.778,5.943,6.381},
  {9.507,4.975,8.860},
  {10.473,2.607,6.708},
  {13.001,5.921,5.342},
  {10.344,6.391,3.369},
  {10.759,8.950,8.519},
  {12.170,10.276,5.796},
  {7.995,11.889,6.469},
  {8.054,10.293,3.829},
  {6.751,9.068,6.343}
 };

static ROTCOOSTRU LYSH_rot39[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.974,3.994,3.840},
  {5.702,5.927,6.247},
  {9.303,4.932,9.044},
  {10.542,2.814,6.774},
  {11.106,6.301,3.715},
  {9.657,8.456,5.820},
  {14.215,8.948,6.156},
  {13.089,7.597,8.997},
  {16.782,5.464,7.481},
  {14.388,3.518,7.422},
  {15.428,4.765,4.798}
 };

static ROTCOOSTRU LYSH_rot40[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.989,3.986,3.842},
  {5.695,5.925,6.232},
  {9.281,4.917,9.064},
  {10.553,2.842,6.772},
  {10.969,6.437,3.736},
  {9.674,8.516,6.011},
  {13.235,7.514,8.955},
  {14.528,5.431,6.685},
  {16.472,9.514,6.506},
  {14.970,8.988,3.862},
  {13.776,10.911,5.959}
 };

static ROTCOOSTRU LYSH_rot41[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.986,3.988,3.841},
  {5.696,5.925,6.235},
  {9.286,4.916,9.061},
  {10.552,2.838,6.769},
  {10.854,6.492,3.714},
  {9.747,8.535,6.118},
  {14.485,5.240,6.567},
  {14.509,8.450,5.637},
  {15.303,7.988,10.068},
  {12.642,9.498,9.665},
  {12.620,6.534,10.524}
 };

static ROTCOOSTRU LYSH_rot42[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {7.084,3.934,3.858},
  {5.647,5.909,6.134},
  {9.141,4.890,9.174},
  {10.596,3.006,6.827},
  {9.275,8.555,5.927},
  {12.172,7.619,7.307},
  {12.972,8.048,2.863},
  {12.897,4.765,3.483},
  {10.479,5.827,-0.192},
  {8.592,4.710,1.978},
  {8.661,7.741,1.405}
 };

static ROTCOOSTRU LYSH_rot43[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.924,4.023,3.834},
  {5.730,5.934,6.298},
  {9.400,4.632,9.020},
  {10.614,2.849,6.466},
  {9.480,8.515,6.158},
  {12.476,7.272,6.967},
  {12.529,4.876,2.844},
  {9.611,6.289,2.034},
  {13.110,8.549,0.264},
  {11.655,10.359,2.295},
  {14.349,9.054,3.044}
 };

static ROTCOOSTRU LYSH_rot44[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.936,4.016,3.835},
  {5.723,5.932,6.286},
  {9.377,4.697,9.030},
  {10.600,2.841,6.533},
  {9.495,8.498,6.043},
  {12.472,7.279,6.951},
  {9.726,5.963,2.027},
  {12.154,8.242,2.303},
  {13.766,4.240,0.935},
  {14.941,4.915,3.707},
  {12.699,2.810,3.452}
 };

static ROTCOOSTRU LYSH_rot45[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.560,4.255,3.839},
  {5.972,5.950,6.655},
  {10.375,2.274,6.331},
  {10.635,5.364,5.084},
  {12.091,5.952,9.222},
  {8.878,6.830,9.511},
  {9.629,4.086,12.995},
  {7.972,2.213,10.779},
  {11.561,0.028,12.461},
  {11.975,0.486,9.438},
  {13.505,2.215,11.483}
 };

static ROTCOOSTRU LYSH_rot46[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.577,4.243,3.837},
  {5.959,5.951,6.639},
  {10.370,2.284,6.410},
  {10.642,5.341,5.086},
  {11.868,6.431,9.092},
  {8.576,6.601,9.645},
  {8.608,2.086,11.095},
  {11.908,1.961,10.588},
  {10.914,2.852,14.912},
  {12.380,5.275,13.687},
  {9.333,5.390,14.155}
 };

static ROTCOOSTRU LYSH_rot47[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.619,4.214,3.832},
  {5.927,5.951,6.599},
  {10.379,2.327,6.498},
  {10.646,5.377,5.155},
  {11.898,6.300,9.247},
  {8.612,6.833,9.559},
  {10.879,1.632,10.553},
  {10.909,3.998,12.912},
  {7.235,1.373,13.223},
  {6.370,4.253,12.532},
  {6.343,2.069,10.353}
 };

static ROTCOOSTRU LYSH_rot48[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.526,4.278,3.844},
  {5.998,5.949,6.687},
  {10.392,2.270,6.118},
  {10.614,5.452,5.119},
  {9.364,6.864,9.491},
  {9.285,3.667,10.465},
  {13.351,5.401,11.673},
  {13.861,3.231,9.184},
  {16.143,7.084,8.535},
  {14.032,6.767,6.308},
  {13.561,8.771,8.607}
 };

static ROTCOOSTRU LYSH_rot49[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.639,4.201,3.830},
  {5.913,5.952,6.579},
  {10.346,2.334,6.689},
  {10.669,5.262,5.109},
  {9.195,7.495,9.052},
  {9.033,4.546,10.617},
  {13.648,3.865,9.769},
  {13.796,6.842,8.260},
  {15.108,7.094,12.584},
  {12.539,8.760,12.203},
  {12.402,6.011,13.597}
 };

static ROTCOOSTRU LYSH_rot50[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.665,4.184,3.828},
  {5.894,5.951,6.555},
  {10.382,2.372,6.609},
  {10.650,5.401,5.220},
  {9.102,7.352,9.273},
  {8.961,4.310,10.651},
  {13.757,6.660,8.419},
  {12.953,6.748,11.661},
  {15.726,3.297,10.720},
  {13.007,2.187,11.667},
  {13.749,2.105,8.673}
 };

static ROTCOOSTRU LYSH_rot51[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.496,4.300,3.850},
  {6.022,5.947,6.716},
  {10.306,2.185,6.468},
  {10.647,5.078,4.828},
  {8.882,4.993,10.309},
  {12.133,4.794,9.558},
  {11.185,9.202,10.239},
  {11.672,8.797,6.958},
  {7.987,11.284,7.805},
  {7.143,8.652,6.433},
  {6.693,9.026,9.462}
 };

static ROTCOOSTRU LYSH_rot52[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.685,4.171,3.827},
  {5.880,5.951,6.535},
  {10.262,2.398,7.101},
  {10.720,4.999,5.053},
  {8.690,5.477,10.452},
  {11.920,5.787,9.649},
  {10.885,9.345,6.745},
  {7.638,9.011,7.459},
  {9.567,12.272,9.935},
  {8.624,10.003,11.802},
  {11.622,10.312,11.142}
 };

static ROTCOOSTRU LYSH_rot53[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {6.719,4.148,3.826},
  {5.857,5.950,6.501},
  {10.282,2.426,7.086},
  {10.714,5.111,5.140},
  {8.451,5.496,10.439},
  {11.750,5.587,9.907},
  {7.916,9.146,7.427},
  {9.725,9.895,10.134},
  {11.661,11.448,6.350},
  {13.489,9.313,7.623},
  {11.818,8.622,5.123}
 };

static ROTCOOSTRU LYSH_rot54[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.446,5.681,5.382},
  {8.026,5.006,7.392},
  {9.940,5.029,3.420},
  {9.382,1.766,3.890},
  {8.022,2.773,-0.352},
  {5.270,2.222,1.464},
  {4.480,5.965,-0.998},
  {4.927,6.968,2.157},
  {7.249,9.536,-0.758},
  {9.227,8.035,1.073},
  {8.814,7.109,-1.841}
 };

static ROTCOOSTRU LYSH_rot55[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.476,5.768,5.608},
  {8.201,4.857,7.310},
  {9.726,5.048,3.179},
  {9.052,1.790,3.506},
  {7.358,3.161,-0.522},
  {4.774,2.553,1.510},
  {4.488,7.170,2.513},
  {7.058,7.770,0.463},
  {3.085,8.461,-1.591},
  {4.544,6.114,-2.964},
  {2.171,5.560,-1.071}
 };

static ROTCOOSTRU LYSH_rot56[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.450,5.697,5.420},
  {8.057,4.981,7.380},
  {10.000,4.932,3.468},
  {9.198,1.700,3.752},
  {7.669,2.574,-0.290},
  {4.917,3.075,1.540},
  {8.527,7.428,0.508},
  {6.326,6.489,-1.824},
  {4.644,9.728,0.853},
  {3.003,7.143,1.233},
  {5.036,8.010,3.386}
 };

static ROTCOOSTRU LYSH_rot57[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.478,5.770,5.614},
  {8.206,4.853,7.308},
  {9.594,5.159,3.080},
  {9.200,1.875,3.564},
  {4.994,2.012,1.511},
  {5.219,5.330,1.166},
  {6.339,3.285,-2.833},
  {9.033,4.799,-1.563},
  {9.996,0.625,-3.025},
  {10.398,0.749,0.031},
  {7.911,-0.649,-1.141}
 };

static ROTCOOSTRU LYSH_rot58[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.476,5.767,5.604},
  {8.198,4.860,7.312},
  {9.564,5.188,3.060},
  {9.261,1.903,3.599},
  {4.935,2.011,1.637},
  {5.314,5.278,1.035},
  {9.070,4.385,-1.648},
  {8.799,1.121,-0.988},
  {6.880,2.190,-4.945},
  {4.706,1.185,-3.000},
  {4.956,4.199,-3.610}
 };

static ROTCOOSTRU LYSH_rot59[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.447,5.686,5.395},
  {8.036,4.998,7.388},
  {9.783,5.146,3.273},
  {9.539,1.883,3.960},
  {5.497,1.646,1.562},
  {5.645,4.927,0.940},
  {9.554,1.003,-0.750},
  {7.193,2.350,-2.694},
  {11.162,4.469,-3.176},
  {9.105,6.428,-1.972},
  {11.285,5.185,-0.177}
 };

static ROTCOOSTRU LYSH_rot60[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.450,5.699,5.426},
  {8.062,4.977,7.378},
  {9.940,4.991,3.408},
  {9.266,1.738,3.783},
  {5.356,5.163,1.349},
  {7.989,4.147,-0.442},
  {4.640,1.134,-1.155},
  {6.932,-0.374,0.754},
  {2.740,-1.074,2.309},
  {4.334,0.559,4.385},
  {2.218,1.951,2.623}
 };

static ROTCOOSTRU LYSH_rot61[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.467,5.749,5.553},
  {8.160,4.893,7.332},
  {9.548,5.224,3.057},
  {9.408,1.949,3.717},
  {4.666,4.289,1.641},
  {7.267,4.130,-0.452},
  {7.706,-0.541,0.702},
  {4.852,-0.272,2.419},
  {4.133,-1.759,-1.794},
  {2.795,0.999,-1.449},
  {5.430,0.751,-3.034}
 };

static ROTCOOSTRU LYSH_rot62[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.453,5.710,5.452},
  {8.082,4.960,7.370},
  {9.807,5.093,3.282},
  {9.371,1.821,3.812},
  {5.156,4.851,1.369},
  {7.807,3.969,-0.466},
  {4.585,0.286,2.627},
  {4.202,0.847,-0.645},
  {6.794,-2.780,0.136},
  {8.480,-0.609,-1.265},
  {8.834,-1.127,1.756}
 };

static ROTCOOSTRU LYSH_rot63[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.571,5.870,5.951},
  {8.435,4.629,7.137},
  {9.062,2.210,3.153},
  {6.170,3.393,1.965},
  {9.357,6.056,0.195},
  {7.962,7.862,2.638},
  {12.419,8.398,3.138},
  {11.496,6.289,5.561},
  {15.211,4.846,3.416},
  {12.914,2.845,2.926},
  {13.766,4.792,0.690}
 };

static ROTCOOSTRU LYSH_rot64[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.590,5.882,6.001},
  {8.466,4.595,7.107},
  {9.051,2.282,3.094},
  {6.089,3.365,1.985},
  {9.244,6.080,0.141},
  {7.692,7.876,2.495},
  {11.166,6.991,5.525},
  {12.696,5.068,3.261},
  {14.418,9.253,3.335},
  {13.095,8.747,0.594},
  {11.682,10.523,2.684}
 };

static ROTCOOSTRU LYSH_rot65[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.569,5.869,5.944},
  {8.431,4.633,7.141},
  {9.174,2.295,3.188},
  {6.204,3.253,1.991},
  {8.852,6.240,0.117},
  {7.896,7.887,2.864},
  {12.671,4.647,2.748},
  {12.682,7.846,1.783},
  {13.773,7.415,6.154},
  {11.115,8.965,5.919},
  {11.105,6.011,6.810}
 };

static ROTCOOSTRU LYSH_rot66[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.608,5.892,6.045},
  {8.492,4.566,7.080},
  {8.833,2.188,2.996},
  {5.985,3.600,1.962},
  {7.912,7.870,2.356},
  {10.743,6.517,3.509},
  {11.320,7.378,-0.952},
  {11.151,4.064,-0.564},
  {8.595,5.474,-4.023},
  {6.777,4.266,-1.842},
  {6.933,7.327,-2.200}
 };

static ROTCOOSTRU LYSH_rot67[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.608,5.892,6.045},
  {8.492,4.566,7.080},
  {8.861,2.207,3.003},
  {5.987,3.566,1.967},
  {7.877,7.886,2.427},
  {10.755,6.512,3.431},
  {11.102,4.216,-0.680},
  {8.214,5.563,-1.684},
  {11.772,7.883,-3.246},
  {10.155,9.675,-1.325},
  {12.822,8.432,-0.398}
 };

static ROTCOOSTRU LYSH_rot68[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.611,5.893,6.054},
  {8.498,4.559,7.074},
  {8.806,2.185,2.980},
  {5.966,3.626,1.962},
  {7.989,7.900,2.521},
  {10.842,6.398,3.407},
  {8.136,5.597,-1.648},
  {10.694,7.695,-1.179},
  {12.086,3.692,-2.767},
  {13.234,4.115,0.065},
  {10.872,2.178,-0.368}
 };

static ROTCOOSTRU LYSH_rot69[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.611,5.893,6.054},
  {8.498,4.559,7.074},
  {8.715,2.128,2.959},
  {5.962,3.734,1.949},
  {10.656,6.563,3.763},
  {10.301,5.581,0.588},
  {8.691,9.739,0.546},
  {5.934,7.858,0.717},
  {5.825,11.257,3.703},
  {5.881,8.573,5.222},
  {8.426,10.309,5.064}
 };

static ROTCOOSTRU LYSH_rot70[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.601,5.888,6.029},
  {8.483,4.576,7.089},
  {8.763,2.121,2.996},
  {6.008,3.696,1.944},
  {10.743,6.495,3.727},
  {10.243,5.614,0.541},
  {6.123,8.021,0.591},
  {6.788,9.005,3.715},
  {8.066,12.107,0.678},
  {10.560,11.027,2.137},
  {9.946,10.119,-0.747}
 };

static ROTCOOSTRU LYSH_rot71[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.634,5.904,6.107},
  {8.528,4.524,7.039},
  {8.622,2.151,2.886},
  {5.865,3.802,1.964},
  {10.718,6.462,3.640},
  {10.080,5.674,0.455},
  {6.651,8.935,3.790},
  {8.874,10.138,1.604},
  {4.724,9.907,-0.188},
  {6.595,7.979,-1.705},
  {4.543,6.868,0.313}
 };

static ROTCOOSTRU LYSH_rot72[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.638,5.906,6.116},
  {8.534,4.518,7.033},
  {5.943,3.208,2.052},
  {8.035,5.798,2.356},
  {10.849,2.654,1.109},
  {11.105,2.403,4.432},
  {10.565,-1.829,3.082},
  {7.532,-0.944,4.168},
  {7.329,-3.027,0.155},
  {6.365,-0.113,-0.164},
  {9.167,-0.930,-1.166}
 };

static ROTCOOSTRU LYSH_rot73[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.675,5.919,6.192},
  {8.576,4.466,6.979},
  {5.804,3.280,2.068},
  {7.913,5.859,2.345},
  {10.782,2.846,1.048},
  {10.951,2.280,4.338},
  {7.685,-1.120,3.913},
  {7.539,-0.561,0.621},
  {10.303,-4.006,1.610},
  {11.946,-1.712,0.361},
  {12.080,-2.228,3.400}
 };

static ROTCOOSTRU LYSH_rot74[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.675,5.919,6.192},
  {8.576,4.466,6.979},
  {5.885,3.073,2.104},
  {7.694,5.877,2.293},
  {10.826,3.110,0.991},
  {11.166,2.785,4.301},
  {7.516,-0.619,1.457},
  {10.791,-1.277,1.391},
  {8.726,-3.419,4.801},
  {10.733,-1.377,5.951},
  {7.708,-0.770,6.013}
 };

static ROTCOOSTRU LYSH_rot75[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.657,5.913,6.156},
  {8.556,4.490,7.005},
  {5.801,3.531,2.017},
  {8.253,5.768,2.425},
  {11.140,2.279,3.879},
  {8.690,0.068,3.351},
  {11.484,0.074,-0.310},
  {8.536,1.364,-1.210},
  {11.989,3.848,-2.757},
  {10.358,5.520,-0.742},
  {13.080,4.329,0.089}
 };

static ROTCOOSTRU LYSH_rot76[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.676,5.920,6.195},
  {8.578,4.464,6.977},
  {5.720,3.631,2.023},
  {8.248,5.780,2.429},
  {11.036,2.166,3.794},
  {8.508,0.051,3.234},
  {8.360,1.489,-1.296},
  {10.959,3.507,-0.712},
  {12.276,-0.444,-2.483},
  {13.414,-0.181,0.373},
  {11.015,-2.044,-0.166}
 };

static ROTCOOSTRU LYSH_rot77[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.709,5.929,6.259},
  {8.611,4.420,6.930},
  {5.605,3.686,2.050},
  {8.141,5.834,2.411},
  {10.932,2.150,3.713},
  {8.394,0.084,3.029},
  {10.639,3.800,-0.796},
  {11.607,0.614,-0.515},
  {8.442,1.124,-3.710},
  {7.318,-0.636,-1.438},
  {6.424,2.306,-1.697}
 };

static ROTCOOSTRU LYSH_rot78[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.633,5.903,6.103},
  {8.527,4.526,7.041},
  {5.909,3.417,2.012},
  {8.272,5.745,2.423},
  {9.119,0.244,3.952},
  {9.679,1.314,0.835},
  {13.671,1.728,2.776},
  {12.446,4.834,2.894},
  {14.192,3.573,6.875},
  {11.156,4.023,7.194},
  {12.288,1.155,7.085}
 };

static ROTCOOSTRU LYSH_rot79[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.658,5.913,6.159},
  {8.558,4.488,7.003},
  {5.790,3.569,2.014},
  {8.280,5.760,2.433},
  {8.759,0.118,3.626},
  {9.579,1.455,0.673},
  {12.654,4.329,2.833},
  {11.839,2.983,5.781},
  {15.567,1.086,4.052},
  {13.331,-1.033,4.214},
  {14.084,0.210,1.492}
 };

static ROTCOOSTRU LYSH_rot80[13] = {
  {1.430,2.707,6.236},
  {6.490,0.209,6.606},
  {5.702,5.927,6.247},
  {8.605,4.429,6.939},
  {5.635,3.619,2.050},
  {8.108,5.841,2.402},
  {8.767,0.213,3.546},
  {9.331,1.526,0.524},
  {11.867,3.492,5.332},
  {13.194,1.083,3.434},
  {14.776,5.168,2.297},
  {13.170,4.007,-0.067},
  {11.945,6.231,1.685}
};

static ROTCOOSTRU *LYS_rotarr[81] = {LYS_rot0,LYS_rot1,LYS_rot2,LYS_rot3,LYS_rot4,LYS_rot5,LYS_rot6,LYS_rot7,LYS_rot8,LYS_rot9,LYS_rot10,LYS_rot11,LYS_rot12,LYS_rot13,LYS_rot14,LYS_rot15,LYS_rot16,LYS_rot17,LYS_rot18,LYS_rot19,LYS_rot20,LYS_rot21,LYS_rot22,LYS_rot23,LYS_rot24,LYS_rot25,LYS_rot26,LYS_rot27,LYS_rot28,LYS_rot29,LYS_rot30,LYS_rot31,LYS_rot32,LYS_rot33,LYS_rot34,LYS_rot35,LYS_rot36,LYS_rot37,LYS_rot38,LYS_rot39,LYS_rot40,LYS_rot41,LYS_rot42,LYS_rot43,LYS_rot44,LYS_rot45,LYS_rot46,LYS_rot47,LYS_rot48,LYS_rot49,LYS_rot50,LYS_rot51,LYS_rot52,LYS_rot53,LYS_rot54,LYS_rot55,LYS_rot56,LYS_rot57,LYS_rot58,LYS_rot59,LYS_rot60,LYS_rot61,LYS_rot62,LYS_rot63,LYS_rot64,LYS_rot65,LYS_rot66,LYS_rot67,LYS_rot68,LYS_rot69,LYS_rot70,LYS_rot71,LYS_rot72,LYS_rot73,LYS_rot74,LYS_rot75,LYS_rot76,LYS_rot77,LYS_rot78,LYS_rot79,LYS_rot80};


static ROTCOOSTRU *LYSH_rotarr[81] = {LYSH_rot0,LYSH_rot1,LYSH_rot2,LYSH_rot3,LYSH_rot4,LYSH_rot5,LYSH_rot6,LYSH_rot7,LYSH_rot8,LYSH_rot9,LYSH_rot10,LYSH_rot11,LYSH_rot12,LYSH_rot13,LYSH_rot14,LYSH_rot15,LYSH_rot16,LYSH_rot17,LYSH_rot18,LYSH_rot19,LYSH_rot20,LYSH_rot21,LYSH_rot22,LYSH_rot23,LYSH_rot24,LYSH_rot25,LYSH_rot26,LYSH_rot27,LYSH_rot28,LYSH_rot29,LYSH_rot30,LYSH_rot31,LYSH_rot32,LYSH_rot33,LYSH_rot34,LYSH_rot35,LYSH_rot36,LYSH_rot37,LYSH_rot38,LYSH_rot39,LYSH_rot40,LYSH_rot41,LYSH_rot42,LYSH_rot43,LYSH_rot44,LYSH_rot45,LYSH_rot46,LYSH_rot47,LYSH_rot48,LYSH_rot49,LYSH_rot50,LYSH_rot51,LYSH_rot52,LYSH_rot53,LYSH_rot54,LYSH_rot55,LYSH_rot56,LYSH_rot57,LYSH_rot58,LYSH_rot59,LYSH_rot60,LYSH_rot61,LYSH_rot62,LYSH_rot63,LYSH_rot64,LYSH_rot65,LYSH_rot66,LYSH_rot67,LYSH_rot68,LYSH_rot69,LYSH_rot70,LYSH_rot71,LYSH_rot72,LYSH_rot73,LYSH_rot74,LYSH_rot75,LYSH_rot76,LYSH_rot77,LYSH_rot78,LYSH_rot79,LYSH_rot80};

static int GLU_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 33, 34 };
static short int GLU_PMF[9] = { 10, 2, 4, 6, 2, 2, 4, 8, 8 };
static int GLUH_PDB[6] = { 0, 3, 6, 7, 9, 10 }; 
static short int GLUH_PMF[6] = { 1, 1, 1, 1, 1, 1 };
static int GLU_NUMC[2] = {9,6};

static ROTCOOSTRU GLU_rot0[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.225,0.142,42.784},
  {20.490,-2.570,43.704},
  {21.892,-3.002,45.555},
  {19.293,-4.261,42.575}
 };

static ROTCOOSTRU GLU_rot1[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.229,0.135,42.788},
  {20.489,-2.489,43.936},
  {22.620,-3.192,44.674},
  {18.561,-3.840,44.099}
 };

static ROTCOOSTRU GLU_rot2[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.154,0.271,42.719},
  {20.265,-2.528,43.368},
  {21.298,-4.001,41.838},
  {19.321,-3.247,45.408}
 };

static ROTCOOSTRU GLU_rot3[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.464,-0.191,42.979},
  {19.192,0.457,45.475},
  {18.391,2.655,45.796},
  {18.996,-1.235,47.108}
 };

static ROTCOOSTRU GLU_rot4[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.475,-0.204,42.987},
  {19.175,0.474,45.461},
  {20.024,2.282,46.723},
  {17.308,-0.801,46.135}
 };

static ROTCOOSTRU GLU_rot5[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.494,-0.225,43.001},
  {19.171,0.475,45.457},
  {20.417,0.429,47.462},
  {16.890,1.073,45.373}
 };

static ROTCOOSTRU GLU_rot6[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.322,-0.009,42.866},
  {17.988,1.456,42.044},
  {17.951,2.396,39.877},
  {16.196,1.662,43.566}
 };

static ROTCOOSTRU GLU_rot7[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.580,-0.314,43.064},
  {18.126,0.446,41.769},
  {18.149,2.301,40.308},
  {16.183,-0.817,42.214}
 };

static ROTCOOSTRU GLU_rot8[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {20.489,-0.219,42.997},
  {18.174,0.494,41.446},
  {17.478,2.751,41.432},
  {17.061,-1.203,40.243}
 };

static ROTCOOSTRU GLU_rot9[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.537,1.205,44.675},
  {26.739,3.050,44.548},
  {26.272,5.343,44.222},
  {28.929,2.203,44.776}
 };

static ROTCOOSTRU GLU_rot10[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.461,0.960,44.693},
  {26.678,2.787,44.827},
  {26.696,4.647,43.372},
  {28.394,2.360,46.390}
 };

static ROTCOOSTRU GLU_rot11[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.520,1.143,44.680},
  {26.493,3.230,44.835},
  {28.103,3.390,43.114},
  {26.426,4.705,46.675}
 };

static ROTCOOSTRU GLU_rot12[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.473,0.994,44.691},
  {23.266,1.761,47.187},
  {21.210,0.771,47.796},
  {24.378,3.348,48.532}
 };

static ROTCOOSTRU GLU_rot13[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.478,1.007,44.691},
  {23.235,1.683,47.194},
  {21.022,2.507,47.169},
  {24.475,1.387,49.180}
 };

static ROTCOOSTRU GLU_rot14[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.507,1.099,44.684},
  {23.242,1.718,47.192},
  {22.320,3.872,47.489},
  {23.173,0.048,48.857}
 };

static ROTCOOSTRU GLU_rot15[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.631,1.967,44.547},
  {25.855,-0.430,45.560},
  {27.201,-1.712,44.104},
  {25.469,-1.024,47.811}
 };

static ROTCOOSTRU GLU_rot16[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.576,1.374,44.655},
  {24.897,-1.269,45.742},
  {23.340,-2.937,45.132},
  {26.708,-1.672,47.200}
 };

static ROTCOOSTRU GLU_rot17[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {24.599,1.508,44.636},
  {25.272,-1.118,45.595},
  {23.521,-2.634,46.055},
  {27.551,-1.659,45.883}
 };

static ROTCOOSTRU GLU_rot18[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.249,4.243,42.849},
  {20.134,5.246,41.177},
  {18.060,4.117,41.183},
  {20.552,7.162,39.865}
 };

static ROTCOOSTRU GLU_rot19[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.245,4.242,42.847},
  {19.823,5.128,41.572},
  {18.505,3.538,40.427},
  {19.244,7.410,41.723}
 };

static ROTCOOSTRU GLU_rot20[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.269,4.245,42.858},
  {19.675,5.074,41.936},
  {19.065,4.598,39.704},
  {18.251,6.197,43.446}
 };

static ROTCOOSTRU GLU_rot21[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.332,4.251,42.888},
  {21.052,4.795,45.405},
  {22.059,3.984,47.381},
  {19.045,6.036,45.400}
 };

static ROTCOOSTRU GLU_rot22[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.307,4.249,42.876},
  {20.966,4.788,45.362},
  {20.315,2.963,46.712},
  {20.569,7.036,45.960}
 };

static ROTCOOSTRU GLU_rot23[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.207,4.238,42.829},
  {21.034,4.795,45.395},
  {19.072,3.636,46.014},
  {22.079,6.389,46.786}
 };

static ROTCOOSTRU GLU_rot24[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.158,4.231,42.806},
  {24.463,5.772,43.568},
  {26.260,5.943,42.045},
  {24.470,6.811,45.687}
 };

static ROTCOOSTRU GLU_rot25[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.162,4.231,42.808},
  {24.520,5.826,43.220},
  {26.580,4.725,43.568},
  {24.306,8.176,43.190}
 };

static ROTCOOSTRU GLU_rot26[9] = {
  {22.301,1.446,37.823},
  {24.011,0.869,39.902},
  {24.954,-1.848,39.892},
  {23.478,-3.647,39.680},
  {22.754,1.449,42.441},
  {22.307,4.249,42.876},
  {24.743,5.778,42.878},
  {26.505,5.091,44.292},
  {24.888,7.660,41.462}
};

static ROTCOOSTRU GLUH_rot0[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.419,3.275,42.674},
  {23.803,0.919,43.897},
  {19.241,0.058,41.195},
  {19.133,1.010,44.031}
 };

static ROTCOOSTRU GLUH_rot1[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.414,3.275,42.671},
  {23.806,0.924,43.897},
  {19.313,-0.093,41.172},
  {19.076,1.084,43.915}
 };

static ROTCOOSTRU GLUH_rot2[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.515,3.284,42.719},
  {23.754,0.825,43.894},
  {19.138,0.403,41.154},
  {19.143,1.079,44.071}
 };

static ROTCOOSTRU GLUH_rot3[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.152,3.217,42.555},
  {23.913,1.196,43.888},
  {20.892,-2.010,43.070},
  {19.143,-0.029,41.664}
 };

static ROTCOOSTRU GLUH_rot4[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.142,3.214,42.551},
  {23.917,1.207,43.887},
  {20.919,-2.017,43.112},
  {19.164,-0.076,41.659}
 };

static ROTCOOSTRU GLUH_rot5[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.123,3.208,42.543},
  {23.923,1.228,43.886},
  {20.962,-2.030,43.159},
  {19.189,-0.137,41.664}
 };

static ROTCOOSTRU GLUH_rot6[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.303,3.256,42.621},
  {23.856,1.037,43.896},
  {20.054,-0.446,44.666},
  {20.281,-1.624,41.923}
 };

static ROTCOOSTRU GLUH_rot7[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.044,3.179,42.510},
  {23.946,1.315,43.877},
  {20.205,-0.370,44.896},
  {20.918,-2.079,42.543}
 };

static ROTCOOSTRU GLUH_rot8[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {22.128,3.209,42.545},
  {23.921,1.222,43.886},
  {19.960,-0.134,44.789},
  {20.822,-2.024,42.633}
 };

static ROTCOOSTRU GLUH_rot9[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.319,0.307,42.808},
  {22.073,3.190,42.522},
  {25.295,-0.501,44.802},
  {23.685,1.524,46.309}
 };

static ROTCOOSTRU GLUH_rot10[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.219,0.420,42.732},
  {22.222,3.237,42.585},
  {25.204,-0.757,44.669},
  {23.558,1.117,46.324}
 };

static ROTCOOSTRU GLUH_rot11[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.293,0.334,42.789},
  {22.110,3.203,42.537},
  {25.470,-0.468,44.628},
  {23.612,1.164,46.316}
 };

static ROTCOOSTRU GLUH_rot12[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.233,0.403,42.743},
  {22.200,3.231,42.576},
  {26.076,1.952,44.573},
  {24.950,-0.805,44.875}
 };

static ROTCOOSTRU GLUH_rot13[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.238,0.397,42.747},
  {22.192,3.229,42.572},
  {26.048,2.020,44.599},
  {25.014,-0.779,44.842}
 };

static ROTCOOSTRU GLUH_rot14[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.275,0.354,42.775},
  {22.136,3.212,42.548},
  {26.024,2.189,44.584},
  {25.132,-0.658,44.837}
 };

static ROTCOOSTRU GLUH_rot15[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.683,0.041,43.048},
  {21.647,2.955,42.365},
  {23.841,2.810,46.019},
  {26.035,3.076,43.999}
 };

static ROTCOOSTRU GLUH_rot16[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.393,0.236,42.860},
  {21.973,3.149,42.482},
  {24.020,2.456,46.077},
  {26.291,1.958,44.191}
 };

static ROTCOOSTRU GLUH_rot17[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {21.454,0.185,42.902},
  {21.896,3.112,42.452},
  {23.928,2.444,46.111},
  {26.220,2.329,44.188}
 };

static ROTCOOSTRU GLUH_rot18[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.795,0.903,43.897},
  {21.099,0.599,42.632},
  {23.747,5.302,42.483},
  {21.749,4.631,44.609}
 };

static ROTCOOSTRU GLUH_rot19[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.796,0.905,43.897},
  {21.100,0.597,42.633},
  {23.613,5.325,42.172},
  {22.071,4.683,44.656}
 };

static ROTCOOSTRU GLUH_rot20[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.788,0.889,43.896},
  {21.092,0.611,42.626},
  {23.508,5.327,41.967},
  {22.357,4.725,44.664}
 };

static ROTCOOSTRU GLUH_rot21[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.767,0.849,43.895},
  {21.072,0.648,42.608},
  {21.249,5.029,41.575},
  {23.929,5.224,42.895}
 };

static ROTCOOSTRU GLUH_rot22[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.776,0.865,43.896},
  {21.080,0.633,42.615},
  {21.252,5.021,41.538},
  {23.899,5.230,42.920}
 };

static ROTCOOSTRU GLUH_rot23[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.808,0.930,43.897},
  {21.113,0.575,42.644},
  {21.018,4.918,41.555},
  {23.750,5.291,42.723}
 };

static ROTCOOSTRU GLUH_rot24[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.824,0.963,43.897},
  {21.130,0.547,42.659},
  {20.876,4.519,44.138},
  {21.489,5.029,41.252}
 };

static ROTCOOSTRU GLUH_rot25[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.822,0.960,43.897},
  {21.128,0.550,42.658},
  {21.061,4.540,44.289},
  {21.281,4.976,41.335}
 };

static ROTCOOSTRU GLUH_rot26[6] = {
  {20.647,2.233,38.290},
  {25.497,1.952,39.720},
  {23.776,0.865,43.896},
  {21.080,0.633,42.615},
  {21.475,4.595,44.515},
  {21.215,5.012,41.562}
};

static ROTCOOSTRU *GLU_rotarr[27] = {GLU_rot0,GLU_rot1,GLU_rot2,GLU_rot3,GLU_rot4,GLU_rot5,GLU_rot6,GLU_rot7,GLU_rot8,GLU_rot9,GLU_rot10,GLU_rot11,GLU_rot12,GLU_rot13,GLU_rot14,GLU_rot15,GLU_rot16,GLU_rot17,GLU_rot18,GLU_rot19,GLU_rot20,GLU_rot21,GLU_rot22,GLU_rot23,GLU_rot24,GLU_rot25,GLU_rot26};

static ROTCOOSTRU *GLUH_rotarr[27] = {GLUH_rot0,GLUH_rot1,GLUH_rot2,GLUH_rot3,GLUH_rot4,GLUH_rot5,GLUH_rot6,GLUH_rot7,GLUH_rot8,GLUH_rot9,GLUH_rot10,GLUH_rot11,GLUH_rot12,GLUH_rot13,GLUH_rot14,GLUH_rot15,GLUH_rot16,GLUH_rot17,GLUH_rot18,GLUH_rot19,GLUH_rot20,GLUH_rot21,GLUH_rot22,GLUH_rot23,GLUH_rot24,GLUH_rot25,GLUH_rot26};

static int GLN_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 23, 33 };
static short int GLN_PMF[9] = { 10, 2, 4, 6, 2, 2, 4, 10, 6 };
static int GLNH_PDB[8] = { 0, 3, 6, 7, 9, 10, 33, 34 }; 
static short int GLNH_PMF[8] = { 1, 1, 1, 1, 1, 1, 1, 1 };
static int GLN_NUMC[2] = {9,8};

static ROTCOOSTRU GLN_rot0[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.918,22.054,25.840},
  {9.644,21.404,25.193},
  {9.973,19.584,23.491},
  {11.429,22.515,26.205}
 };

static ROTCOOSTRU GLN_rot1[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.944,22.031,25.827},
  {9.461,21.271,24.661},
  {10.291,22.718,22.781},
  {10.644,19.414,25.432}
 };

static ROTCOOSTRU GLN_rot2[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.865,22.099,25.866},
  {9.466,21.458,24.820},
  {11.315,23.063,25.390},
  {9.815,19.552,23.519}
 };

static ROTCOOSTRU GLN_rot3[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {7.032,21.948,25.781},
  {9.537,21.068,24.676},
  {11.103,19.911,26.266},
  {10.063,21.421,22.430}
 };

static ROTCOOSTRU GLN_rot4[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.831,22.126,25.882},
  {6.023,23.062,23.286},
  {4.206,21.747,22.151},
  {7.012,24.937,22.310}
 };

static ROTCOOSTRU GLN_rot5[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.914,22.057,25.842},
  {6.196,22.925,23.195},
  {4.689,24.932,23.060},
  {6.980,21.813,21.300}
 };

static ROTCOOSTRU GLN_rot6[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.950,22.025,25.824},
  {6.230,22.898,23.180},
  {7.412,24.947,22.330},
  {4.637,21.753,21.916}
 };

static ROTCOOSTRU GLN_rot7[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.960,22.016,25.819},
  {6.228,22.901,23.182},
  {7.712,22.131,21.305},
  {4.360,24.256,22.832}
 };

static ROTCOOSTRU GLN_rot8[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.918,22.054,25.840},
  {5.836,24.572,26.711},
  {5.968,25.040,29.178},
  {4.893,26.077,25.197}
 };

static ROTCOOSTRU GLN_rot9[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.988,21.990,25.804},
  {6.183,24.525,26.900},
  {8.026,26.180,27.330},
  {3.943,24.993,27.356}
 };

static ROTCOOSTRU GLN_rot10[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.940,22.034,25.829},
  {5.717,24.570,26.414},
  {5.941,26.342,24.644},
  {4.588,24.938,28.422}
 };

static ROTCOOSTRU GLN_rot11[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {6.694,22.226,25.945},
  {5.394,24.590,26.940},
  {2.963,24.847,26.352},
  {6.549,26.164,28.218}
 };

static ROTCOOSTRU GLN_rot12[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.774,17.692,24.778},
  {4.135,15.373,25.235},
  {1.659,15.779,25.382},
  {5.074,13.248,25.454}
 };

static ROTCOOSTRU GLN_rot13[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.835,17.712,24.770},
  {3.847,15.635,24.820},
  {3.159,14.707,22.587},
  {2.939,14.872,26.829}
 };

static ROTCOOSTRU GLN_rot14[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.865,17.723,24.766},
  {4.138,15.440,25.049},
  {5.238,13.189,24.852},
  {1.851,15.691,25.438}
 };

static ROTCOOSTRU GLN_rot15[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.951,17.755,24.756},
  {4.157,15.510,24.869},
  {4.426,13.976,26.842},
  {2.553,15.155,23.212}
 };

static ROTCOOSTRU GLN_rot16[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.839,17.714,24.770},
  {5.148,18.532,22.100},
  {4.294,20.883,21.849},
  {5.375,17.078,20.289}
 };

static ROTCOOSTRU GLN_rot17[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.947,17.753,24.757},
  {5.151,18.524,22.102},
  {6.993,19.285,20.571},
  {2.917,18.438,21.433}
 };

static ROTCOOSTRU GLN_rot18[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.904,17.737,24.762},
  {5.158,18.531,22.100},
  {5.528,16.826,20.291},
  {4.262,20.643,21.670}
 };

static ROTCOOSTRU GLN_rot19[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.887,17.730,24.764},
  {5.281,18.579,22.083},
  {3.174,17.648,21.077},
  {6.682,20.047,20.930}
 };

static ROTCOOSTRU GLN_rot20[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.383,17.599,24.841},
  {8.024,16.788,24.042},
  {9.427,15.685,25.812},
  {8.798,17.145,21.869}
 };

static ROTCOOSTRU GLN_rot21[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.571,17.636,24.808},
  {8.263,17.134,23.927},
  {8.837,14.737,23.436},
  {9.805,18.869,23.690}
 };

static ROTCOOSTRU GLN_rot22[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.406,17.603,24.837},
  {8.033,16.997,23.836},
  {8.227,16.692,21.348},
  {9.863,16.805,25.270}
 };

static ROTCOOSTRU GLN_rot23[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {5.624,17.649,24.800},
  {8.351,17.031,24.123},
  {9.757,18.957,23.328},
  {9.185,14.860,24.310}
 };

static ROTCOOSTRU GLN_rot24[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.545,19.885,26.197},
  {1.232,22.125,27.434},
  {2.160,24.395,26.881},
  {-0.586,21.827,28.866}
 };

static ROTCOOSTRU GLN_rot25[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.554,20.159,26.278},
  {1.639,22.801,26.955},
  {-0.161,23.759,25.484},
  {2.531,23.967,28.768}
 };

static ROTCOOSTRU GLN_rot26[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.545,19.991,26.229},
  {1.348,22.326,27.407},
  {-0.970,22.034,28.334},
  {2.484,24.363,27.486}
 };

static ROTCOOSTRU GLN_rot27[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.547,19.832,26.180},
  {1.269,22.270,27.014},
  {1.058,22.617,29.495},
  {0.483,23.822,25.458}
 };

static ROTCOOSTRU GLN_rot28[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.547,20.057,26.249},
  {1.948,20.920,23.571},
  {3.918,21.224,22.039},
  {-0.248,21.309,22.884}
 };

static ROTCOOSTRU GLN_rot29[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.547,20.062,26.250},
  {1.946,20.867,23.555},
  {1.105,19.061,22.022},
  {2.231,23.075,22.856}
 };

static ROTCOOSTRU GLN_rot30[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.546,20.031,26.241},
  {1.948,20.955,23.583},
  {-0.489,21.175,23.010},
  {3.646,21.463,22.065}
 };

static ROTCOOSTRU GLN_rot31[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.550,20.106,26.263},
  {1.946,20.875,23.558},
  {1.303,23.280,23.209},
  {2.052,19.337,21.807}
 };

static ROTCOOSTRU GLN_rot32[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.549,20.093,26.259},
  {1.210,17.614,25.682},
  {1.037,15.980,27.584},
  {0.344,17.168,23.561}
 };

static ROTCOOSTRU GLN_rot33[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.559,20.213,26.293},
  {0.974,17.835,26.616},
  {-1.125,18.080,27.978},
  {1.619,15.807,25.659}
 };

static ROTCOOSTRU GLN_rot34[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.547,20.053,26.247},
  {1.200,17.534,25.908},
  {-0.433,17.400,24.002},
  {1.616,15.735,27.334}
 };

static ROTCOOSTRU GLN_rot35[9] = {
  {5.340,20.940,31.239},
  {6.013,18.950,29.457},
  {8.831,18.372,29.682},
  {9.638,16.214,29.397},
  {5.384,19.774,26.751},
  {2.545,19.987,26.228},
  {1.140,17.498,26.555},
  {1.879,15.607,25.073},
  {-0.583,17.273,28.112}
};

static ROTCOOSTRU GLNH_rot0[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.589,20.263,26.550},
  {5.702,18.421,25.498},
  {7.007,23.415,27.121},
  {6.198,22.831,24.298},
  {8.550,18.774,22.756},
  {11.632,19.094,23.010}
 };

static ROTCOOSTRU GLNH_rot1[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.595,20.286,26.556},
  {5.679,18.414,25.501},
  {7.359,23.226,27.205},
  {6.054,23.028,24.518},
  {9.324,24.132,22.242},
  {11.850,22.338,21.977}
 };

static ROTCOOSTRU GLNH_rot2[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.579,20.217,26.539},
  {5.747,18.438,25.493},
  {7.157,23.329,27.245},
  {5.983,23.034,24.507},
  {10.969,24.509,26.397},
  {12.980,22.764,24.791}
 };

static ROTCOOSTRU GLNH_rot3[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.618,20.365,26.575},
  {5.599,18.389,25.512},
  {7.468,23.171,27.128},
  {6.194,22.933,24.429},
  {10.628,19.676,27.981},
  {12.696,19.320,25.686}
 };

static ROTCOOSTRU GLNH_rot4[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.573,20.189,26.532},
  {5.775,18.449,25.490},
  {8.675,21.830,25.768},
  {6.603,23.576,27.042},
  {3.493,20.314,22.965},
  {3.623,22.239,20.526}
 };

static ROTCOOSTRU GLNH_rot5[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.588,20.260,26.550},
  {5.705,18.422,25.498},
  {8.752,21.710,25.785},
  {6.696,23.551,26.947},
  {4.127,25.735,24.563},
  {4.175,25.562,21.459}
 };

static ROTCOOSTRU GLNH_rot6[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.596,20.291,26.557},
  {5.674,18.412,25.502},
  {8.780,21.644,25.756},
  {6.767,23.526,26.925},
  {8.626,25.775,23.362},
  {7.042,25.584,20.693}
 };

static ROTCOOSTRU GLNH_rot7[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.599,20.300,26.560},
  {5.665,18.409,25.503},
  {8.787,21.623,25.737},
  {6.795,23.516,26.925},
  {9.132,21.090,21.653},
  {7.351,22.623,19.616}
 };

static ROTCOOSTRU GLNH_rot8[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.589,20.263,26.550},
  {5.702,18.421,25.498},
  {7.010,22.155,23.974},
  {8.685,22.018,26.452},
  {6.708,23.833,30.282},
  {5.324,26.581,29.835}
 };

static ROTCOOSTRU GLNH_rot9[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.606,20.325,26.566},
  {5.639,18.401,25.507},
  {6.909,22.188,23.946},
  {8.799,21.798,26.235},
  {9.727,25.747,26.953},
  {7.641,27.795,28.013}
 };

static ROTCOOSTRU GLNH_rot10[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.594,20.283,26.555},
  {5.682,18.414,25.501},
  {7.209,22.011,23.978},
  {8.642,22.096,26.605},
  {6.826,25.984,23.123},
  {5.218,27.964,24.902}
 };

static ROTCOOSTRU GLNH_rot11[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {3.554,20.076,26.502},
  {5.882,18.496,25.479},
  {6.761,22.424,24.085},
  {8.463,22.324,26.546},
  {2.141,23.593,25.364},
  {2.049,26.284,26.919}
 };

static ROTCOOSTRU GLNH_rot12[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.434,21.213,26.178},
  {3.603,20.317,26.564},
  {7.538,17.071,24.732},
  {5.375,18.266,23.043},
  {1.010,17.443,25.203},
  {0.539,14.405,25.665}
 };

static ROTCOOSTRU GLNH_rot13[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.405,21.239,26.193},
  {3.593,20.277,26.554},
  {7.480,16.850,24.995},
  {5.829,18.383,23.024},
  {3.903,15.345,21.082},
  {1.925,13.407,22.496}
 };

static ROTCOOSTRU GLNH_rot14[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.390,21.252,26.200},
  {3.588,20.257,26.549},
  {7.611,17.054,24.837},
  {5.611,18.343,23.020},
  {7.004,13.076,24.552},
  {4.257,11.694,25.011}
 };

static ROTCOOSTRU GLNH_rot15[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.346,21.288,26.222},
  {3.575,20.200,26.535},
  {7.673,17.042,24.928},
  {5.831,18.419,23.011},
  {5.683,14.315,28.078},
  {3.360,12.542,27.016}
 };

static ROTCOOSTRU GLNH_rot16[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.402,21.241,26.194},
  {3.592,20.274,26.553},
  {4.843,16.166,25.104},
  {7.630,17.178,24.692},
  {4.148,21.943,23.291},
  {3.832,21.502,20.229}
 };

static ROTCOOSTRU GLNH_rot17[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.349,21.287,26.221},
  {3.576,20.203,26.535},
  {5.069,16.139,25.105},
  {7.770,17.346,24.645},
  {8.689,19.324,21.158},
  {6.613,19.791,18.891}
 };

static ROTCOOSTRU GLNH_rot18[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.370,21.269,26.210},
  {3.582,20.232,26.543},
  {4.973,16.150,25.101},
  {7.714,17.273,24.668},
  {6.222,15.221,20.699},
  {5.099,17.212,18.591}
 };

static ROTCOOSTRU GLNH_rot19[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.379,21.262,26.206},
  {3.584,20.243,26.546},
  {4.872,16.186,25.052},
  {7.676,17.185,24.735},
  {2.147,16.523,22.026},
  {2.696,18.109,19.409}
 };

static ROTCOOSTRU GLNH_rot20[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.600,21.029,26.084},
  {3.692,20.561,26.617},
  {4.482,18.035,23.260},
  {4.556,16.060,25.509},
  {8.763,15.445,27.463},
  {11.093,15.138,25.427}
 };

static ROTCOOSTRU GLNH_rot21[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.525,21.120,26.129},
  {3.645,20.446,26.593},
  {4.583,17.988,23.259},
  {4.939,16.006,25.474},
  {7.597,13.456,23.642},
  {10.489,14.306,22.880}
 };

static ROTCOOSTRU GLNH_rot22[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.592,21.040,26.089},
  {3.686,20.548,26.615},
  {4.356,17.965,23.331},
  {4.753,16.005,25.559},
  {6.773,16.856,20.308},
  {9.819,16.311,20.612}
 };

static ROTCOOSTRU GLNH_rot23[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.502,21.145,26.142},
  {3.633,20.413,26.586},
  {4.777,18.062,23.184},
  {4.868,16.044,25.393},
  {9.045,20.601,23.210},
  {11.474,18.689,22.877}
 };

static ROTCOOSTRU GLNH_rot24[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.102,18.620,25.466},
  {6.041,21.479,26.351},
  {1.638,18.364,26.800},
  {2.177,20.024,24.368},
  {3.562,24.545,25.770},
  {1.420,25.866,27.597}
 };

static ROTCOOSTRU GLNH_rot25[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {5.941,18.525,25.474},
  {6.196,21.395,26.289},
  {1.495,18.981,27.273},
  {2.086,19.900,24.486},
  {-0.798,22.801,24.106},
  {-0.808,25.401,25.812}
 };

static ROTCOOSTRU GLNH_rot26[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.041,18.581,25.468},
  {6.102,21.449,26.327},
  {1.581,18.532,26.894},
  {2.158,20.086,24.401},
  {-1.781,20.435,28.237},
  {-1.816,23.424,29.093}
 };

static ROTCOOSTRU GLNH_rot27[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.132,18.640,25.465},
  {6.010,21.494,26.362},
  {1.617,18.450,27.033},
  {2.180,19.662,24.353},
  {1.687,21.377,30.631},
  {0.277,24.103,30.130}
 };

static ROTCOOSTRU GLNH_rot28[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.002,18.558,25.470},
  {6.140,21.428,26.312},
  {1.741,21.310,27.381},
  {1.614,18.454,26.490},
  {5.580,20.905,22.640},
  {3.664,21.760,20.345}
 };

static ROTCOOSTRU GLNH_rot29[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.000,18.557,25.471},
  {6.142,21.427,26.311},
  {1.751,21.344,27.356},
  {1.606,18.470,26.530},
  {0.911,17.383,22.633},
  {0.698,19.448,20.317}
 };

static ROTCOOSTRU GLNH_rot30[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.018,18.568,25.469},
  {6.125,21.436,26.318},
  {1.717,21.241,27.401},
  {1.634,18.409,26.435},
  {-1.739,20.764,24.232},
  {-0.980,21.742,21.379}
 };

static ROTCOOSTRU GLNH_rot31[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {5.973,18.542,25.472},
  {6.167,21.412,26.301},
  {1.785,21.422,27.351},
  {1.581,18.537,26.577},
  {1.243,24.405,24.606},
  {0.904,23.872,21.561}
 };

static ROTCOOSTRU GLNH_rot32[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {5.981,18.547,25.472},
  {6.160,21.417,26.304},
  {2.197,21.215,24.804},
  {1.647,20.832,27.722},
  {1.728,16.394,29.189},
  {0.222,14.399,27.339}
 };

static ROTCOOSTRU GLNH_rot33[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {5.909,18.509,25.477},
  {6.225,21.377,26.277},
  {2.202,20.834,24.565},
  {1.832,21.476,27.466},
  {-1.556,19.674,28.683},
  {-2.192,16.662,28.246}
 };

static ROTCOOSTRU GLNH_rot34[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.005,18.560,25.470},
  {6.137,21.430,26.313},
  {2.188,21.037,24.697},
  {1.655,20.926,27.641},
  {-0.700,18.828,22.947},
  {-1.332,15.877,23.696}
 };

static ROTCOOSTRU GLNH_rot35[8] = {
  {5.013,22.638,30.477},
  {5.058,17.438,29.920},
  {6.044,18.583,25.468},
  {6.100,21.450,26.328},
  {2.179,20.555,24.483},
  {1.696,21.206,27.365},
  {3.213,15.856,23.898},
  {1.073,14.007,25.189}
};

static ROTCOOSTRU *GLN_rotarr[36] = {GLN_rot0,GLN_rot1,GLN_rot2,GLN_rot3,GLN_rot4,GLN_rot5,GLN_rot6,GLN_rot7,GLN_rot8,GLN_rot9,GLN_rot10,GLN_rot11,GLN_rot12,GLN_rot13,GLN_rot14,GLN_rot15,GLN_rot16,GLN_rot17,GLN_rot18,GLN_rot19,GLN_rot20,GLN_rot21,GLN_rot22,GLN_rot23,GLN_rot24,GLN_rot25,GLN_rot26,GLN_rot27,GLN_rot28,GLN_rot29,GLN_rot30,GLN_rot31,GLN_rot32,GLN_rot33,GLN_rot34,GLN_rot35};

static ROTCOOSTRU *GLNH_rotarr[36] = {GLNH_rot0,GLNH_rot1,GLNH_rot2,GLNH_rot3,GLNH_rot4,GLNH_rot5,GLNH_rot6,GLNH_rot7,GLNH_rot8,GLNH_rot9,GLNH_rot10,GLNH_rot11,GLNH_rot12,GLNH_rot13,GLNH_rot14,GLNH_rot15,GLNH_rot16,GLNH_rot17,GLNH_rot18,GLNH_rot19,GLNH_rot20,GLNH_rot21,GLNH_rot22,GLNH_rot23,GLNH_rot24,GLNH_rot25,GLNH_rot26,GLNH_rot27,GLNH_rot28,GLNH_rot29,GLNH_rot30,GLNH_rot31,GLNH_rot32,GLNH_rot33,GLNH_rot34,GLNH_rot35};

static int PRO_PDB[7] = { 0, 1, 2, 3, 4, 5, 8 };
static short int PRO_PMF[7] = { 10, 2, 4, 6, 2, 2, 2 };
static int PROH_PDB[7] = { 3, 6, 7, 9, 10, 18, 19 };
static short int PROH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 };
static int PRO_NUMC[2] = {7,7};

static ROTCOOSTRU PRO_rot0[7] = {
  {27.452,-2.175,40.108},
  {28.644,-4.675,40.138},
  {28.233,-5.975,42.676},
  {27.622,-4.755,44.558},
  {31.432,-4.095,39.690},
  {31.734,-1.465,40.702},
  {29.281,-0.130,40.129}
 };

static ROTCOOSTRU PRO_rot1[7] = {
  {27.452,-2.175,40.108},
  {28.644,-4.675,40.138},
  {28.233,-5.975,42.676},
  {27.622,-4.755,44.558},
  {31.432,-4.095,39.690},
  {31.382,-1.618,38.313},
  {29.222,-0.145,39.450}
};

static ROTCOOSTRU PROH_rot0[7] = {
  {27.833,-5.698,38.830},
  {31.802,-4.200,37.859},
  {32.481,-5.338,40.613},
  {33.177,-0.633,39.850},
  {32.054,-1.541,42.544},
  {29.414,0.733,38.475},
  {28.933,1.132,41.466}
 };

static ROTCOOSTRU PROH_rot1[7] = {
  {27.833,-5.698,38.830},
  {32.195,-5.463,38.667},
  {32.314,-3.977,41.335},
  {31.109,-1.927,36.488},
  {33.013,-0.736,38.561},
  {28.543,1.045,38.176},
  {29.837,0.812,40.935}
};

static ROTCOOSTRU *PRO_rotarr[2] = {PRO_rot0,PRO_rot1};
static ROTCOOSTRU *PROH_rotarr[2] = {PROH_rot0,PROH_rot1};

static int ARG_PDB[11] = { 0, 1, 2, 3, 4, 5, 8, 16, 21, 24, 25 };
static short int ARG_PMF[11] = { 10, 2, 4, 6, 2, 2, 2, 5, 9, 9, 9 };
static int ARGH_PDB[13] = { 0, 3, 6, 7, 9, 10, 18, 19, 27, 54, 55, 57, 58 };
static short int ARGH_PMF[13] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int ARG_NUMC[2] = {11,13};

static ROTCOOSTRU ARG_rot0[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.170,   -4.016,   13.883},
 {    8.509,   -4.890,   15.304},
 {    6.978,   -7.387,   18.927},
 {    8.000,   -5.293,   17.983},
 {    6.354,   -9.274,   17.402},
 {    6.583,   -7.586,   21.393}
};

static ROTCOOSTRU ARG_rot1[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.277,   -4.025,   14.021},
 {    8.387,   -4.918,   15.753},
 {    8.931,   -5.911,   20.272},
 {    7.456,   -5.562,   18.267},
 {   11.416,   -5.678,   20.056},
 {    7.915,   -6.493,   22.488}
};

static ROTCOOSTRU ARG_rot2[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.144,   -4.013,   13.852},
 {    8.503,   -4.904,   15.227},
 {    8.679,   -3.884,   19.769},
 {    8.015,   -5.416,   17.891},
 {    9.865,   -1.733,   19.272},
 {    8.155,   -4.506,   22.139}
};

static ROTCOOSTRU ARG_rot3[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.144,   -4.013,   13.852},
 {    8.296,   -5.063,   15.438},
 {   10.828,   -7.861,   12.705},
 {    9.138,   -7.529,   14.535},
 {   11.863,   -5.876,   11.579},
 {   11.480,  -10.178,   12.007}
};

static ROTCOOSTRU ARG_rot4[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.126,   -4.011,   13.831},
 {    8.250,   -5.104,   15.426},
 {   11.068,   -8.815,   15.414},
 {    9.173,   -7.499,   14.418},
 {   12.247,   -7.965,   17.455},
 {   11.778,  -10.978,   14.367}
};

static ROTCOOSTRU ARG_rot5[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.115,   -4.010,   13.817},
 {    8.245,   -5.113,   15.397},
 {    8.157,   -9.704,   14.606},
 {    9.230,   -7.450,   14.314},
 {    6.056,   -9.927,   15.952},
 {    9.190,  -11.728,   13.550}
};

static ROTCOOSTRU ARG_rot6[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.144,   -4.013,   13.852},
 {    8.389,   -4.995,   15.351},
 {   11.851,   -1.941,   15.983},
 {   10.738,   -3.744,   14.630},
 {   10.823,   -1.175,   18.136},
 {   13.988,   -0.910,   15.178}
};

static ROTCOOSTRU ARG_rot7[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.008,   -3.993,   13.699},
 {    8.342,   -5.068,   14.982},
 {   12.970,   -4.647,   14.648},
 {   10.665,   -4.307,   13.707},
 {   13.261,   -5.739,   16.885},
 {   14.977,   -3.893,   13.351}
};

static ROTCOOSTRU ARG_rot8[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.144,   -4.013,   13.852},
 {    8.389,   -4.995,   15.351},
 {   12.178,   -4.340,   12.718},
 {   10.729,   -3.704,   14.671},
 {   11.524,   -6.259,   11.246},
 {   14.276,   -3.055,   12.244}
};

static ROTCOOSTRU ARG_rot9[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.350,   -4.026,   14.125},
 {    4.855,   -6.196,   15.270},
 {    1.651,   -7.461,   12.133},
 {    2.286,   -6.315,   14.278},
 {    3.407,   -8.590,   10.749},
 {   -0.739,   -7.473,   11.379}
};

static ROTCOOSTRU ARG_rot10[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.403,   -4.025,   14.206},
 {    4.747,   -6.197,   15.093},
 {    0.484,   -7.882,   14.255},
 {    2.380,   -6.333,   13.685},
 {    0.679,   -9.433,   16.213},
 {   -1.601,   -7.874,   12.865}
};

static ROTCOOSTRU ARG_rot11[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.427,   -4.023,   14.244},
 {    4.836,   -6.196,   15.242},
 {    0.231,   -5.489,   15.322},
 {    2.315,   -6.227,   14.126},
 {    0.369,   -4.659,   17.682},
 {   -1.984,   -5.584,   14.155}
};

static ROTCOOSTRU ARG_rot12[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.432,   -4.023,   14.252},
 {    4.874,   -6.194,   15.306},
 {    7.744,   -9.800,   15.984},
 {    5.949,   -8.648,   14.655},
 {    8.669,   -8.716,   18.045},
 {    8.609,  -12.034,   15.248}
};

static ROTCOOSTRU ARG_rot13[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.460,   -4.020,   14.299},
 {    4.845,   -6.196,   15.253},
 {    4.956,  -10.854,   15.317},
 {    6.018,   -8.643,   14.765},
 {    2.688,  -10.923,   16.380},
 {    6.165,  -12.987,   14.804}
};

static ROTCOOSTRU ARG_rot14[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.458,   -4.021,   14.295},
 {    4.792,   -6.199,   15.149},
 {    5.962,   -9.857,   12.512},
 {    5.986,   -8.645,   14.714},
 {    4.800,   -8.843,   10.537},
 {    7.101,  -12.078,   12.292}
};

static ROTCOOSTRU ARG_rot15[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.396,   -4.025,   14.194},
 {    4.656,   -6.192,   14.920},
 {    2.218,   -5.562,   18.840},
 {    4.285,   -6.349,   17.648},
 {    0.327,   -4.557,   17.539},
 {    2.047,   -5.781,   21.331}
};

static ROTCOOSTRU ARG_rot16[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.386,   -4.025,   14.179},
 {    4.745,   -6.197,   15.097},
 {    3.179,   -7.903,   19.140},
 {    4.664,   -6.339,   17.849},
 {    1.645,   -9.465,   17.922},
 {    3.234,   -7.900,   21.645}
};

static ROTCOOSTRU ARG_rot17[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.373,   -4.026,   14.160},
 {    4.821,   -6.196,   15.222},
 {    6.889,   -7.463,   19.200},
 {    5.002,   -6.349,   17.969},
 {    8.763,   -8.527,   17.922},
 {    6.895,   -7.510,   21.705}
};

static ROTCOOSTRU ARG_rot18[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.430,   -4.023,   14.248},
 {    5.639,   -4.940,   11.643},
 {    9.426,   -4.814,    8.932},
 {    7.212,   -3.866,    9.650},
 {   10.333,   -6.865,   10.050},
 {   10.727,   -3.708,    7.098}
};

static ROTCOOSTRU ARG_rot19[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.381,   -4.026,   14.171},
 {    5.494,   -4.895,   11.581},
 {    6.329,   -3.889,    7.109},
 {    6.909,   -3.688,    9.546},
 {    4.352,   -5.257,    6.401},
 {    7.727,   -2.723,    5.387}
};

static ROTCOOSTRU ARG_rot20[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.391,   -4.025,   14.186},
 {    5.646,   -4.832,   11.532},
 {    5.789,   -1.474,    8.305},
 {    6.902,   -3.317,    9.601},
 {    3.384,   -0.915,    8.736},
 {    7.083,   -0.195,    6.582}
};

static ROTCOOSTRU ARG_rot21[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.391,   -4.025,   14.186},
 {    5.795,   -4.747,   11.471},
 {    5.769,   -9.399,   11.214},
 {    6.883,   -7.187,   10.788},
 {    3.525,   -9.479,   12.325},
 {    6.903,  -11.526,   10.527}
};

static ROTCOOSTRU ARG_rot22[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.233,   -4.022,   13.962},
 {    5.207,   -4.677,   11.360},
 {    5.421,   -8.193,    8.310},
 {    6.008,   -7.184,   10.536},
 {    4.023,   -6.903,    6.679},
 {    6.234,  -10.489,    7.722}
};

static ROTCOOSTRU ARG_rot23[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.510,   -4.014,   14.387},
 {    6.228,   -4.819,   11.644},
 {    9.783,   -7.653,   10.626},
 {    7.357,   -7.290,   11.171},
 {   11.342,   -5.697,   10.483},
 {   10.643,   -9.972,   10.224}
};

static ROTCOOSTRU ARG_rot24[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.391,   -4.025,   14.186},
 {    5.807,   -4.741,   11.467},
 {    1.343,   -4.300,   10.205},
 {    3.224,   -5.659,   11.172},
 {    1.761,   -1.952,    9.436},
 {   -0.949,   -5.294,   10.010}
};

static ROTCOOSTRU ARG_rot25[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.393,   -4.025,   14.190},
 {    5.806,   -4.748,   11.473},
 {    2.044,   -5.404,    8.804},
 {    3.105,   -5.121,   11.065},
 {    3.462,   -5.354,    6.739},
 {   -0.433,   -5.734,    8.615}
};

static ROTCOOSTRU ARG_rot26[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    6.396,   -4.025,   14.194},
 {    5.808,   -4.753,   11.478},
 {    1.701,   -6.952,   11.541},
 {    3.095,   -4.927,   11.019},
 {    2.770,   -8.984,   12.545},
 {   -0.757,   -6.939,   11.058}
};

static ROTCOOSTRU ARG_rot27[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.996,   -1.554,   17.729},
 {    3.407,    0.634,   18.696},
 {   -1.004,   -0.861,   18.558},
 {    0.848,    0.586,   17.669},
 {   -0.580,   -2.387,   20.500},
 {   -3.275,   -0.779,   17.501}
};

static ROTCOOSTRU ARG_rot28[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.154,   -1.655,   17.734},
 {    3.679,    0.534,   18.867},
 {   -0.623,    2.308,   18.623},
 {    1.013,    0.456,   18.165},
 {    0.137,    4.391,   19.789},
 {   -3.015,    2.070,   17.915}
};

static ROTCOOSTRU ARG_rot29[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.883,   -1.486,   17.718},
 {    3.133,    0.634,   18.554},
 {   -0.492,    1.453,   15.743},
 {    0.546,    0.240,   17.685},
 {    0.843,    3.144,   14.463},
 {   -2.862,    0.972,   15.088}
};

static ROTCOOSTRU ARG_rot30[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.158,   -1.657,   17.734},
 {    3.670,    0.521,   18.870},
 {    5.431,    1.361,   23.101},
 {    3.628,    0.418,   21.625},
 {    7.427,    2.482,   22.081},
 {    5.233,    1.180,   25.592}
};

static ROTCOOSTRU ARG_rot31[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.015,   -1.566,   17.731},
 {    3.378,    0.580,   18.712},
 {    1.969,    2.264,   22.822},
 {    3.038,    0.453,   21.445},
 {    1.133,    4.351,   21.715},
 {    1.740,    1.983,   25.301}
};

static ROTCOOSTRU ARG_rot32[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.204,   -1.687,   17.733},
 {    3.723,    0.471,   18.915},
 {    2.094,   -1.023,   23.016},
 {    3.722,    0.337,   21.669},
 {    0.328,   -2.372,   21.858},
 {    2.237,   -1.031,   25.518}
};

static ROTCOOSTRU ARG_rot33[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.980,   -1.545,   17.728},
 {    2.851,    0.164,   18.621},
 {    2.998,    4.545,   17.043},
 {    3.629,    2.806,   18.744},
 {    1.574,    3.918,   15.079},
 {    3.794,    6.906,   17.310}
};

static ROTCOOSTRU ARG_rot34[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.961,   -1.533,   17.727},
 {    2.869,    0.229,   18.603},
 {    2.339,    4.737,   19.658},
 {    3.809,    2.767,   19.130},
 {   -0.150,    4.459,   19.730},
 {    3.363,    6.978,   20.112}
};

static ROTCOOSTRU ARG_rot35[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.081,   -1.608,   17.733},
 {    3.094,    0.201,   18.749},
 {    5.353,    3.793,   20.674},
 {    3.998,    2.805,   18.802},
 {    5.962,    2.387,   22.657},
 {    6.093,    6.184,   20.559}
};

static ROTCOOSTRU ARG_rot36[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.027,   -1.574,   17.731},
 {    3.489,   -3.840,   18.595},
 {    6.581,   -7.248,   19.327},
 {    4.726,   -6.225,   17.975},
 {    7.417,   -6.089,   21.386},
 {    7.594,   -9.427,   18.617}
};

static ROTCOOSTRU ARG_rot37[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.902,   -1.497,   17.721},
 {    3.300,   -3.724,   18.574},
 {    3.466,   -8.374,   18.348},
 {    4.587,   -6.131,   18.186},
 {    1.024,   -8.518,   18.893},
 {    4.789,  -10.467,   17.964}
};

static ROTCOOSTRU ARG_rot38[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.004,   -1.559,   17.730},
 {    3.474,   -3.832,   18.594},
 {    3.983,   -7.696,   16.041},
 {    4.702,   -6.212,   17.938},
 {    2.036,   -7.041,   14.606},
 {    5.215,   -9.830,   15.585}
};

static ROTCOOSTRU ARG_rot39[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.007,   -1.561,   17.730},
 {    3.431,   -3.803,   18.591},
 {    1.531,   -2.685,   22.696},
 {    3.238,   -3.935,   21.339},
 {   -0.137,   -1.203,   21.554},
 {    1.497,   -2.920,   25.190}
};

static ROTCOOSTRU ARG_rot40[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.011,   -1.564,   17.730},
 {    3.385,   -3.771,   18.589},
 {    1.903,   -5.668,   22.578},
 {    3.194,   -3.905,   21.336},
 {    0.684,   -7.454,   21.311},
 {    1.834,   -5.640,   25.082}
};

static ROTCOOSTRU ARG_rot41[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    5.035,   -1.578,   17.732},
 {    3.415,   -3.789,   18.592},
 {    4.766,   -4.919,   22.906},
 {    3.123,   -3.850,   21.333},
 {    6.827,   -6.022,   22.005},
 {    4.342,   -4.882,   25.375}
};

static ROTCOOSTRU ARG_rot42[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.914,   -1.504,   17.722},
 {    3.362,   -3.763,   18.582},
 {   -0.052,   -5.131,   15.721},
 {    0.788,   -3.683,   17.596},
 {    1.485,   -6.778,   14.624},
 {   -2.427,   -4.927,   14.949}
};

static ROTCOOSTRU ARG_rot43[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.953,   -1.528,   17.726},
 {    3.462,   -3.825,   18.592},
 {   -0.691,   -5.745,   17.712},
 {    0.856,   -3.764,   17.693},
 {    0.109,   -7.952,   18.587},
 {   -3.034,   -5.512,   16.854}
};

static ROTCOOSTRU ARG_rot44[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.961,   -1.533,   17.727},
 {    3.465,   -3.827,   18.593},
 {   -0.986,   -2.475,   18.846},
 {    0.855,   -3.753,   17.708},
 {   -0.500,   -1.159,   20.922},
 {   -3.308,   -2.517,   17.904}
};

static ROTCOOSTRU ARG_rot45[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.730,   -1.397,   17.694},
 {    6.975,   -2.387,   19.187},
 {    8.920,    1.318,   21.238},
 {    8.943,   -0.478,   19.479},
 {    7.021,    1.450,   22.868},
 {   10.794,    2.976,   21.360}
};

static ROTCOOSTRU ARG_rot46[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.584,   -1.318,   17.660},
 {    6.793,   -2.145,   19.299},
 {   10.958,   -0.507,   20.597},
 {    8.717,   -0.180,   19.507},
 {   11.560,   -2.731,   21.581},
 {   12.590,    1.392,   20.699}
};

static ROTCOOSTRU ARG_rot47[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.730,   -1.397,   17.694},
 {    6.975,   -2.387,   19.187},
 {   11.153,   -0.948,   17.710},
 {    9.104,   -0.636,   19.132},
 {   11.350,   -2.953,   16.219},
 {   12.998,    0.745,   17.783}
};

static ROTCOOSTRU ARG_rot48[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.796,   -1.435,   17.706},
 {    7.031,   -2.547,   19.128},
 {    5.326,   -4.686,   22.899},
 {    6.534,   -2.758,   21.831},
 {    4.488,   -6.577,   21.485},
 {    4.959,   -4.717,   25.378}
};

static ROTCOOSTRU ARG_rot49[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.792,   -1.433,   17.705},
 {    6.990,   -2.618,   19.127},
 {    8.260,   -3.420,   23.537},
 {    6.574,   -2.623,   21.852},
 {   10.486,   -4.279,   22.772},
 {    7.716,   -3.354,   25.982}
};

static ROTCOOSTRU ARG_rot50[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.781,   -1.426,   17.703},
 {    7.031,   -2.480,   19.143},
 {    6.805,   -0.595,   23.398},
 {    6.570,   -2.569,   21.860},
 {    7.499,    1.631,   22.482},
 {    6.344,   -0.854,   25.848}
};

static ROTCOOSTRU ARG_rot51[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.741,   -1.404,   17.696},
 {    6.794,   -2.787,   19.154},
 {    8.126,   -6.887,   17.386},
 {    6.610,   -5.522,   18.854},
 {    9.946,   -5.766,   16.079},
 {    7.817,   -9.369,   17.230}
};

static ROTCOOSTRU ARG_rot52[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.749,   -1.409,   17.698},
 {    6.847,   -2.725,   19.153},
 {    8.726,   -6.979,   19.426},
 {    6.882,   -5.441,   18.684},
 {   10.695,   -6.063,   20.676},
 {    8.597,   -9.429,   18.914}
};

static ROTCOOSTRU ARG_rot53[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    4.580,   -1.316,   17.659},
 {    6.752,   -2.236,   19.299},
 {    6.218,   -6.847,   19.702},
 {    7.421,   -4.854,   18.753},
 {    4.277,   -6.517,   21.252},
 {    6.961,   -9.163,   19.099}
};

static ROTCOOSTRU ARG_rot54[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.383,   -1.156,   14.803},
 {    1.294,   -1.985,   12.278},
 {   -0.018,   -6.431,   12.747},
 {    1.577,   -4.697,   11.871},
 {   -2.018,   -5.731,   14.085},
 {    0.392,   -8.859,   12.283}
};

static ROTCOOSTRU ARG_rot55[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.394,   -1.086,   14.977},
 {    1.177,   -1.536,   12.414},
 {    0.354,   -5.093,    9.520},
 {    1.228,   -4.198,   11.700},
 {   -0.642,   -3.531,    7.834},
 {    0.480,   -7.548,    9.033}
};

static ROTCOOSTRU ARG_rot56[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.386,   -1.124,   14.880},
 {    1.234,   -1.835,   12.346},
 {    3.142,   -5.567,   10.311},
 {    1.435,   -4.538,   11.842},
 {    4.804,   -4.111,    9.129},
 {    3.182,   -8.048,    9.966}
};

static ROTCOOSTRU ARG_rot57[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.383,   -1.163,   14.787},
 {    1.384,   -1.379,   12.102},
 {   -2.499,    1.183,   11.845},
 {   -1.350,   -1.048,   11.987},
 {   -1.142,    3.289,   11.799},
 {   -5.000,    1.301,   11.748}
};

static ROTCOOSTRU ARG_rot58[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.407,   -1.043,   15.092},
 {    1.167,   -0.884,   12.506},
 {   -3.114,   -0.501,   10.707},
 {   -1.578,   -0.700,   12.686},
 {   -2.168,   -0.461,    8.386},
 {   -5.590,   -0.343,   11.053}
};

static ROTCOOSTRU ARG_rot59[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.386,   -1.124,   14.880},
 {    1.273,   -1.526,   12.262},
 {   -3.041,   -3.152,   12.934},
 {   -1.475,   -1.304,   12.264},
 {   -2.125,   -5.369,   13.661},
 {   -5.518,   -2.778,   12.876}
};

static ROTCOOSTRU ARG_rot60[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.392,   -1.094,   14.956},
 {    1.218,   -1.378,   12.349},
 {    3.284,    1.061,    8.959},
 {    1.585,    0.874,   10.801},
 {    4.779,   -0.880,    8.432},
 {    3.482,    3.187,    7.648}
};

static ROTCOOSTRU ARG_rot61[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.403,   -1.054,   15.063},
 {    1.142,   -1.225,   12.487},
 {    0.352,    1.563,    8.839},
 {    0.987,    1.233,   11.248},
 {   -0.190,   -0.418,    7.403},
 {    0.261,    3.873,    7.872}
};

static ROTCOOSTRU ARG_rot62[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.388,   -1.111,   14.913},
 {    1.252,   -1.429,   12.295},
 {    0.045,    2.818,   10.806},
 {    1.579,    0.828,   10.745},
 {   -1.932,    2.829,   12.346},
 {    0.491,    4.790,    9.327}
};

static ROTCOOSTRU ARG_rot63[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.425,   -1.414,   14.281},
 {    1.085,   -3.736,   15.313},
 {   -0.555,   -2.613,   19.526},
 {    1.111,   -3.804,   18.069},
 {   -2.386,   -1.256,   18.486},
 {   -0.384,   -2.782,   22.021}
};

static ROTCOOSTRU ARG_rot64[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.421,   -1.403,   14.300},
 {    1.089,   -3.747,   15.291},
 {    0.447,   -5.899,   19.373},
 {    1.151,   -3.886,   18.043},
 {   -0.376,   -7.952,   18.196},
 {    0.569,   -5.853,   21.876}
};

static ROTCOOSTRU ARG_rot65[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.418,   -1.392,   14.320},
 {    1.064,   -3.669,   15.430},
 {    2.822,   -5.220,   19.457},
 {    1.243,   -3.738,   18.180},
 {    4.365,   -6.762,   18.224},
 {    2.853,   -5.155,   21.961}
};

static ROTCOOSTRU ARG_rot66[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.420,   -1.399,   14.308},
 {    1.079,   -3.717,   15.347},
 {   -2.731,   -4.465,   12.770},
 {   -1.637,   -3.636,   14.876},
 {   -1.333,   -5.441,   10.933},
 {   -5.218,   -4.315,   12.508}
};

static ROTCOOSTRU ARG_rot67[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.414,   -1.381,   14.340},
 {    1.077,   -3.713,   15.352},
 {   -3.212,   -5.534,   15.383},
 {   -1.628,   -3.664,   14.822},
 {   -2.356,   -7.609,   16.497},
 {   -5.646,   -5.322,   14.829}
};

static ROTCOOSTRU ARG_rot68[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.412,   -1.373,   14.356},
 {    1.067,   -3.679,   15.416},
 {   -3.368,   -2.421,   16.093},
 {   -1.620,   -3.681,   14.799},
 {   -2.708,   -1.051,   18.084},
 {   -5.771,   -2.535,   15.392}
};

static ROTCOOSTRU ARG_rot69[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.407,   -1.355,   14.388},
 {    1.039,   -3.566,   15.610},
 {    3.248,   -7.657,   15.310},
 {    1.643,   -5.960,   14.383},
 {    4.415,   -7.221,   17.485},
 {    3.681,   -9.786,   14.061}
};

static ROTCOOSTRU ARG_rot70[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.419,   -1.397,   14.312},
 {    1.079,   -3.719,   15.342},
 {    1.102,   -8.330,   14.669},
 {    1.804,   -6.013,   13.994},
 {   -0.350,   -8.662,   16.684},
 {    1.854,  -10.307,   13.327}
};

static ROTCOOSTRU ARG_rot71[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.410,   -1.366,   14.368},
 {    1.012,   -3.441,   15.779},
 {    0.675,   -7.106,   12.922},
 {    1.724,   -5.953,   14.893},
 {   -1.142,   -5.966,   11.625},
 {    1.445,   -9.394,   12.253}
};

static ROTCOOSTRU ARG_rot72[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.444,   -1.466,   14.191},
 {    0.989,    0.400,   15.818},
 {   -0.017,    3.957,   12.981},
 {    1.264,    2.991,   14.916},
 {   -1.670,    2.539,   11.741},
 {    0.358,    6.337,   12.293}
};

static ROTCOOSTRU ARG_rot73[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.441,   -1.457,   14.207},
 {    0.967,    0.261,   15.975},
 {    0.596,    4.832,   16.798},
 {    1.247,    2.920,   15.302},
 {   -0.376,    4.377,   19.062},
 {    0.920,    7.194,   16.025}
};

static ROTCOOSTRU ARG_rot74[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.458,   -1.499,   14.138},
 {    0.921,    0.224,   15.847},
 {    2.797,    4.369,   16.852},
 {    1.427,    2.888,   15.352},
 {    3.802,    3.439,   18.951},
 {    3.158,    6.774,   16.249}
};

static ROTCOOSTRU ARG_rot75[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.457,   -1.497,   14.142},
 {    1.021,    0.601,   15.478},
 {   -3.404,   -0.811,   15.850},
 {   -1.647,    0.633,   14.781},
 {   -2.772,   -2.409,   17.674},
 {   -5.787,   -0.653,   15.092}
};

static ROTCOOSTRU ARG_rot76[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.456,   -1.494,   14.145},
 {    0.991,    0.498,   15.607},
 {   -3.388,    2.049,   15.959},
 {   -1.698,    0.453,   15.004},
 {   -2.661,    3.826,   17.570},
 {   -5.798,    1.865,   15.301}
};

static ROTCOOSTRU ARG_rot77[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.451,   -1.483,   14.165},
 {    1.025,    0.587,   15.556},
 {   -2.815,    1.606,   13.121},
 {   -1.686,    0.482,   15.066},
 {   -1.460,    2.925,   11.478},
 {   -5.295,    1.407,   12.827}
};

static ROTCOOSTRU ARG_rot78[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.436,   -1.444,   14.230},
 {    1.026,    0.471,   15.842},
 {    1.937,   -0.084,   20.378},
 {    0.489,   -0.501,   18.366},
 {    4.019,    1.294,   20.160},
 {    1.298,   -1.045,   22.602}
};

static ROTCOOSTRU ARG_rot79[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.447,   -1.473,   14.180},
 {    1.051,    0.650,   15.519},
 {    0.275,    2.058,   19.892},
 {    1.025,    0.305,   18.254},
 {   -0.514,    4.288,   19.066},
 {    0.317,    1.575,   22.350}
};

static ROTCOOSTRU ARG_rot80[11] = {
 {    6.710,    0.784,   11.103},
 {    6.710,    0.790,   13.862},
 {    9.363,    0.783,   14.913},
 {   11.016,   -0.600,   14.094},
 {    5.236,   -1.485,   14.868},
 {    2.455,   -1.492,   14.149},
 {    1.026,    0.608,   15.490},
 {   -0.406,   -1.131,   19.568},
 {    1.130,    0.342,   18.232},
 {   -2.174,   -2.477,   18.408},
 {   -0.171,   -1.255,   22.060}
};

static ROTCOOSTRU ARGH_rot0[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.340,   -1.490,   16.944},
 {    3.231,   -1.265,   14.365},
 {    4.666,   -5.438,   14.076},
 {    6.604,   -3.859,   11.856},
 {    9.211,   -6.655,   14.460},
 {   10.015,   -3.472,   15.092},
 {    8.446,   -3.909,   19.190},
 {    6.651,   -9.124,   15.542},
 {    5.585,  -10.848,   18.111},
 {    7.054,   -6.163,   22.544},
 {    5.815,   -9.160,   22.103}
};

static ROTCOOSTRU ARGH_rot1[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.231,   -1.418,   16.945},
 {    3.256,   -1.330,   14.254},
 {    4.748,   -5.433,   14.000},
 {    6.990,   -3.872,   12.074},
 {    9.314,   -6.578,   14.912},
 {    9.828,   -3.429,   15.910},
 {    5.591,   -5.753,   18.500},
 {   12.182,   -5.239,   18.385},
 {   12.525,   -5.941,   21.563},
 {    6.041,   -6.669,   22.651},
 {    9.024,   -6.756,   23.995}
};

static ROTCOOSTRU ARGH_rot2[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.365,   -1.507,   16.942},
 {    3.226,   -1.250,   14.391},
 {    4.638,   -5.431,   14.061},
 {    6.544,   -3.845,   11.819},
 {    9.227,   -6.626,   14.313},
 {    9.986,   -3.457,   15.062},
 {    7.123,   -7.022,   18.337},
 {   10.260,   -1.263,   17.484},
 {   10.364,   -0.581,   20.684},
 {    7.261,   -6.128,   22.515},
 {    8.654,   -3.354,   23.551}
};

static ROTCOOSTRU ARGH_rot3[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.365,   -1.507,   16.942},
 {    3.226,   -1.250,   14.391},
 {    4.566,   -5.366,   13.835},
 {    6.774,   -3.788,   11.883},
 {    9.893,   -3.733,   15.403},
 {    7.680,   -5.225,   17.417},
 {    8.397,   -9.069,   15.341},
 {   11.371,   -4.129,   12.105},
 {   13.134,   -6.126,   10.203},
 {   10.700,  -11.675,   12.857},
 {   12.751,  -10.428,   10.632}
};

static ROTCOOSTRU ARGH_rot4[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.382,   -1.518,   16.941},
 {    3.223,   -1.240,   14.409},
 {    4.533,   -5.346,   13.782},
 {    6.779,   -3.770,   11.872},
 {    9.818,   -3.742,   15.515},
 {    7.577,   -5.387,   17.372},
 {    8.328,   -8.197,   12.879},
 {   11.711,   -6.334,   18.245},
 {   13.671,   -8.955,   18.205},
 {   10.889,  -11.619,   12.827},
 {   13.203,  -11.967,   15.116}
};

static ROTCOOSTRU ARGH_rot5[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.394,   -1.526,   16.940},
 {    3.222,   -1.233,   14.421},
 {    4.518,   -5.340,   13.773},
 {    6.757,   -3.763,   11.855},
 {    9.781,   -3.722,   15.552},
 {    7.557,   -5.480,   17.323},
 {   10.813,   -7.353,   13.287},
 {    5.278,   -8.400,   16.749},
 {    5.250,  -11.622,   16.171},
 {   10.774,  -11.560,   12.534},
 {    8.383,  -13.423,   13.769}
};

static ROTCOOSTRU ARGH_rot6[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.365,   -1.507,   16.942},
 {    3.226,   -1.250,   14.391},
 {    4.593,   -5.395,   13.933},
 {    6.675,   -3.811,   11.852},
 {    8.045,   -4.704,   17.380},
 {    8.577,   -7.043,   15.051},
 {   11.567,   -4.274,   13.017},
 {    9.211,   -1.953,   18.743},
 {   11.660,    0.180,   19.152},
 {   14.763,   -1.488,   13.554},
 {   14.825,    0.446,   16.195}
};

static ROTCOOSTRU ARGH_rot7[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.491,   -1.595,   16.928},
 {    3.209,   -1.178,   14.527},
 {    4.439,   -5.347,   13.856},
 {    6.385,   -3.730,   11.672},
 {    8.398,   -4.430,   16.960},
 {    8.218,   -7.143,   15.014},
 {   10.517,   -3.477,   12.015},
 {   11.748,   -6.308,   17.863},
 {   14.994,   -5.995,   17.593},
 {   14.757,   -3.069,   11.665},
 {   16.710,   -4.148,   14.060}
};

static ROTCOOSTRU ARGH_rot8[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.365,   -1.507,   16.942},
 {    3.226,   -1.250,   14.391},
 {    4.593,   -5.395,   13.933},
 {    6.675,   -3.811,   11.852},
 {    8.026,   -4.744,   17.382},
 {    8.604,   -7.035,   15.016},
 {   11.281,   -2.247,   15.740},
 {    9.941,   -7.228,   11.604},
 {   12.613,   -6.738,    9.778},
 {   14.769,   -1.608,   13.354},
 {   15.365,   -3.534,   10.776}
};

static ROTCOOSTRU ARGH_rot9[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.149,   -1.367,   16.941},
 {    3.279,   -1.379,   14.175},
 {    6.363,   -4.204,   12.054},
 {    8.328,   -4.132,   14.758},
 {    5.831,   -7.989,   14.878},
 {    4.790,   -5.975,   17.335},
 {    0.911,   -5.483,   15.273},
 {    5.209,   -8.581,   11.317},
 {    2.930,   -9.452,    9.136},
 {   -2.064,   -6.621,   12.423},
 {   -1.216,   -8.334,    9.766}
};

static ROTCOOSTRU ARGH_rot10[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.088,   -1.330,   16.935},
 {    3.299,   -1.418,   14.117},
 {    6.677,   -4.151,   12.149},
 {    8.282,   -4.178,   15.081},
 {    5.782,   -7.987,   14.878},
 {    4.334,   -5.969,   17.117},
 {    2.167,   -5.189,   12.196},
 {    2.251,   -9.439,   17.261},
 {   -0.747,  -10.597,   16.641},
 {   -1.748,   -6.704,   11.388},
 {   -3.026,   -9.038,   13.293}
};

static ROTCOOSTRU ARGH_rot11[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.059,   -1.313,   16.932},
 {    3.309,   -1.436,   14.090},
 {    6.643,   -4.205,   12.185},
 {    8.334,   -4.120,   15.068},
 {    5.793,   -7.996,   14.837},
 {    4.675,   -6.042,   17.309},
 {    2.139,   -6.842,   12.348},
 {    2.039,   -4.587,   18.563},
 {   -1.198,   -4.104,   18.582},
 {   -2.088,   -6.210,   12.375},
 {   -3.551,   -5.029,   15.054}
};

static ROTCOOSTRU ARGH_rot12[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.053,   -1.309,   16.931},
 {    3.311,   -1.440,   14.085},
 {    6.610,   -4.228,   12.191},
 {    8.354,   -4.097,   15.041},
 {    4.754,   -6.018,   17.373},
 {    2.934,   -6.072,   14.569},
 {    5.297,   -9.522,   13.112},
 {    8.017,   -7.032,   18.600},
 {   10.019,   -9.583,   19.045},
 {    7.912,  -12.852,   13.694},
 {    9.959,  -12.901,   16.247}
};

static ROTCOOSTRU ARGH_rot13[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.017,   -1.289,   16.926},
 {    3.324,   -1.462,   14.053},
 {    6.748,   -4.212,   12.250},
 {    8.337,   -4.103,   15.189},
 {    4.528,   -5.977,   17.295},
 {    2.982,   -6.127,   14.334},
 {    7.729,   -8.663,   13.964},
 {    1.776,   -9.314,   16.766},
 {    1.889,  -12.585,   16.794},
 {    7.875,  -12.935,   14.002},
 {    5.367,  -14.649,   15.218}
};

static ROTCOOSTRU ARGH_rot14[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.020,   -1.290,   16.926},
 {    3.323,   -1.461,   14.056},
 {    6.817,   -4.176,   12.254},
 {    8.301,   -4.137,   15.249},
 {    4.364,   -5.989,   17.173},
 {    2.981,   -6.123,   14.132},
 {    6.880,   -9.466,   16.162},
 {    3.942,   -7.168,   10.703},
 {    4.782,   -9.754,    8.881},
 {    7.977,  -12.842,   13.782},
 {    7.083,  -12.989,   10.637}
};

static ROTCOOSTRU ARGH_rot15[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.097,   -1.335,   16.936},
 {    3.296,   -1.412,   14.126},
 {    6.783,   -4.095,   12.153},
 {    8.220,   -4.239,   15.168},
 {    2.816,   -5.943,   13.986},
 {    5.455,   -7.981,   14.227},
 {    5.673,   -7.097,   18.690},
 {    0.455,   -4.391,   15.661},
 {   -1.228,   -3.964,   18.435},
 {    3.473,   -6.539,   22.312},
 {    0.493,   -5.189,   22.227}
};

static ROTCOOSTRU ARGH_rot16[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.108,   -1.342,   16.938},
 {    3.292,   -1.405,   14.137},
 {    6.617,   -4.150,   12.117},
 {    8.282,   -4.183,   15.015},
 {    2.815,   -5.963,   14.360},
 {    5.477,   -7.986,   14.333},
 {    5.797,   -5.188,   18.830},
 {    1.604,   -9.467,   16.032},
 {    0.528,  -10.641,   18.892},
 {    4.391,   -6.722,   22.564},
 {    2.118,   -9.076,   22.616}
};

static ROTCOOSTRU ARGH_rot17[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.123,   -1.351,   16.939},
 {    3.287,   -1.396,   14.150},
 {    6.478,   -4.190,   12.090},
 {    8.320,   -4.143,   14.879},
 {    2.830,   -5.955,   14.673},
 {    5.472,   -7.985,   14.386},
 {    3.621,   -5.566,   18.994},
 {    8.759,   -8.492,   16.033},
 {   10.182,   -9.365,   18.848},
 {    5.481,   -6.707,   22.669},
 {    8.314,   -8.348,   22.631}
};

static ROTCOOSTRU ARGH_rot18[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.056,   -1.311,   16.931},
 {    3.310,   -1.438,   14.088},
 {    8.500,   -3.859,   14.331},
 {    5.872,   -5.424,   15.679},
 {    5.759,   -7.014,   11.576},
 {    3.652,   -4.431,   11.306},
 {    6.587,   -2.317,    8.764},
 {    9.352,   -7.699,   11.433},
 {   11.998,   -7.578,    9.510},
 {   10.043,   -2.161,    6.254},
 {   12.392,   -4.421,    6.558}
};

static ROTCOOSTRU ARGH_rot19[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.114,   -1.346,   16.938},
 {    3.290,   -1.401,   14.142},
 {    8.455,   -3.884,   14.186},
 {    5.856,   -5.442,   15.599},
 {    5.700,   -6.958,   11.437},
 {    3.471,   -4.467,   11.364},
 {    8.412,   -2.641,   10.010},
 {    3.298,   -6.137,    7.699},
 {    3.916,   -5.409,    4.568},
 {    9.218,   -1.692,    5.921},
 {    7.291,   -2.875,    3.555}
};

static ROTCOOSTRU ARGH_rot20[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.103,   -1.339,   16.937},
 {    3.294,   -1.408,   14.131},
 {    8.462,   -3.909,   14.325},
 {    5.768,   -5.463,   15.552},
 {    6.126,   -6.836,   11.259},
 {    3.586,   -4.662,   11.311},
 {    8.718,   -3.685,    9.227},
 {    2.408,   -1.880,   10.035},
 {    2.547,    0.470,    7.761},
 {    8.896,   -0.616,    6.258},
 {    6.246,    1.191,    5.608}
};

static ROTCOOSTRU ARGH_rot21[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.103,   -1.339,   16.937},
 {    3.294,   -1.408,   14.131},
 {    8.451,   -3.948,   14.452},
 {    5.665,   -5.488,   15.472},
 {    3.734,   -4.812,   11.210},
 {    6.526,   -3.282,   10.190},
 {    8.575,   -7.200,    9.946},
 {    2.670,   -7.875,   12.843},
 {    2.687,  -11.142,   12.645},
 {    8.596,  -11.466,    9.689},
 {    6.066,  -13.189,   10.847}
};

static ROTCOOSTRU ARGH_rot22[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.277,   -1.448,   16.946},
 {    3.245,   -1.302,   14.300},
 {    8.310,   -3.974,   13.901},
 {    5.697,   -5.505,   15.316},
 {    3.131,   -4.591,   11.395},
 {    5.854,   -3.258,    9.986},
 {    7.065,   -8.211,   11.718},
 {    3.410,   -5.171,    7.122},
 {    3.582,   -7.661,    5.005},
 {    7.289,  -11.461,    8.952},
 {    5.793,  -11.247,    6.048}
};

static ROTCOOSTRU ARGH_rot23[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    4.953,   -1.252,   16.914},
 {    3.349,   -1.504,   13.996},
 {    8.527,   -3.882,   14.871},
 {    5.679,   -5.460,   15.627},
 {    4.211,   -4.874,   11.144},
 {    7.123,   -3.403,   10.413},
 {    6.237,   -8.809,   11.263},
 {   10.694,   -3.948,   10.786},
 {   13.166,   -5.970,   10.073},
 {    9.468,  -11.448,   10.332},
 {   12.468,  -10.246,    9.814}
};

static ROTCOOSTRU ARGH_rot24[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.103,   -1.339,   16.937},
 {    3.294,   -1.408,   14.131},
 {    8.450,   -3.951,   14.461},
 {    5.657,   -5.490,   15.466},
 {    6.097,   -3.088,   10.240},
 {    7.138,   -6.208,   10.838},
 {    2.840,   -7.422,   11.732},
 {    3.489,   -1.203,    9.583},
 {    0.347,   -0.931,    8.709},
 {   -1.263,   -7.065,   10.590},
 {   -2.363,   -4.273,    9.283}
};

static ROTCOOSTRU ARGH_rot25[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.100,   -1.337,   16.937},
 {    3.295,   -1.410,   14.128},
 {    8.453,   -3.948,   14.461},
 {    5.664,   -5.488,   15.474},
 {    6.498,   -3.260,   10.198},
 {    6.826,   -6.492,   10.986},
 {    1.977,   -5.169,   12.580},
 {    5.330,   -5.105,    6.882},
 {    2.665,   -5.567,    5.039},
 {   -1.503,   -5.771,   10.172},
 {   -1.231,   -5.947,    6.915}
};

static ROTCOOSTRU ARGH_rot26[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.097,   -1.335,   16.936},
 {    3.296,   -1.412,   14.126},
 {    8.455,   -3.945,   14.465},
 {    5.668,   -5.487,   15.480},
 {    6.638,   -3.346,   10.192},
 {    6.702,   -6.579,   11.044},
 {    2.226,   -3.429,   10.264},
 {    4.625,   -8.994,   12.909},
 {    1.722,  -10.507,   12.937},
 {   -1.563,   -5.406,   10.301},
 {   -1.805,   -8.462,   11.451}
};

static ROTCOOSTRU ARGH_rot27[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.333,   -1.478,   14.032},
 {    6.169,   -3.229,   14.228},
 {    4.134,   -3.353,   18.313},
 {    6.886,   -1.477,   18.590},
 {    3.319,    0.560,   20.772},
 {    4.322,    2.430,   18.188},
 {    0.460,    1.713,   16.202},
 {    1.133,   -2.449,   21.296},
 {   -1.973,   -3.475,   21.168},
 {   -3.594,    0.371,   16.037},
 {   -4.667,   -1.868,   18.170}
};

static ROTCOOSTRU ARGH_rot28[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.290,   -1.401,   14.142},
 {    6.087,   -3.225,   14.114},
 {    4.280,   -3.453,   18.301},
 {    7.091,   -1.654,   18.488},
 {    3.849,    0.483,   20.938},
 {    4.509,    2.330,   18.230},
 {    0.373,   -1.088,   17.282},
 {    1.941,    4.571,   20.324},
 {   -1.093,    5.784,   20.134},
 {   -3.588,    0.499,   17.036},
 {   -4.245,    3.462,   18.260}
};

static ROTCOOSTRU ARGH_rot29[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.368,   -1.533,   13.957},
 {    6.224,   -3.227,   14.311},
 {    4.101,   -3.314,   18.324},
 {    6.729,   -1.274,   18.650},
 {    3.153,    0.768,   20.628},
 {    3.842,    2.444,   17.818},
 {   -0.517,   -1.022,   18.606},
 {    2.631,    3.507,   14.958},
 {    0.063,    4.055,   13.004},
 {   -3.869,   -0.303,   16.053},
 {   -3.643,    1.883,   13.628}
};

static ROTCOOSTRU ARGH_rot30[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.289,   -1.399,   14.145},
 {    6.085,   -3.225,   14.111},
 {    4.296,   -3.462,   18.301},
 {    7.096,   -1.645,   18.486},
 {    4.507,    2.323,   18.258},
 {    1.721,    0.477,   18.148},
 {    2.151,   -0.414,   22.460},
 {    7.576,    2.619,   20.202},
 {    8.782,    3.191,   23.191},
 {    3.728,    0.334,   26.361},
 {    6.588,    1.889,   26.702}
};

static ROTCOOSTRU ARGH_rot31[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.327,   -1.468,   14.045},
 {    6.160,   -3.229,   14.214},
 {    4.202,   -3.387,   18.316},
 {    6.909,   -1.444,   18.580},
 {    4.249,    2.399,   18.208},
 {    1.521,    0.514,   17.781},
 {    3.646,   -1.094,   22.344},
 {    1.306,    4.563,   19.845},
 {    0.330,    5.713,   22.750},
 {    2.370,    0.409,   26.136},
 {    0.936,    3.345,   26.336}
};

static ROTCOOSTRU ARGH_rot32[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.278,   -1.378,   14.178},
 {    6.059,   -3.223,   14.079},
 {    4.359,   -3.502,   18.294},
 {    7.153,   -1.673,   18.455},
 {    4.544,    2.283,   18.311},
 {    1.764,    0.427,   18.220},
 {    5.028,    1.331,   22.606},
 {    0.220,   -2.366,   19.971},
 {   -0.896,   -3.395,   22.871},
 {    3.568,   -0.014,   26.391},
 {    1.013,   -2.054,   26.531}
};

static ROTCOOSTRU ARGH_rot33[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.337,   -1.485,   14.022},
 {    6.177,   -3.229,   14.239},
 {    4.621,   -3.494,   18.356},
 {    6.769,   -0.944,   18.601},
 {    1.231,   -0.021,   17.332},
 {    2.209,   -0.456,   20.499},
 {    4.705,    3.347,   20.200},
 {    0.973,    2.137,   14.877},
 {    1.100,    5.225,   13.800},
 {    4.868,    7.379,   18.791},
 {    3.320,    8.213,   16.031}
};

static ROTCOOSTRU ARGH_rot34[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.343,   -1.495,   14.009},
 {    6.187,   -3.228,   14.253},
 {    4.549,   -3.471,   18.355},
 {    6.758,   -0.975,   18.610},
 {    1.392,    0.328,   17.143},
 {    1.983,   -0.549,   20.315},
 {    5.677,    3.047,   19.092},
 {   -0.923,    2.769,   19.387},
 {   -1.255,    5.940,   20.127},
 {    5.241,    7.187,   20.058},
 {    2.258,    8.459,   20.509}
};

static ROTCOOSTRU ARGH_rot35[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.309,   -1.436,   14.090},
 {    6.126,   -3.228,   14.166},
 {    4.625,   -3.548,   18.325},
 {    6.933,   -1.140,   18.553},
 {    1.387,    0.086,   17.569},
 {    2.549,   -0.380,   20.669},
 {    3.574,    3.921,   17.337},
 {    5.403,    0.584,   22.744},
 {    6.980,    3.130,   24.065},
 {    5.634,    7.244,   19.064},
 {    7.112,    6.927,   21.967}
};

static ROTCOOSTRU ARGH_rot36[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.324,   -1.462,   14.053},
 {    6.154,   -3.228,   14.205},
 {    6.928,   -1.661,   18.567},
 {    4.139,    0.175,   18.420},
 {    3.191,   -3.730,   20.650},
 {    1.612,   -3.782,   17.703},
 {    4.143,   -7.152,   16.434},
 {    6.653,   -4.446,   21.921},
 {    8.811,   -6.858,   22.403},
 {    6.963,  -10.301,   17.065},
 {    8.988,  -10.196,   19.634}
};

static ROTCOOSTRU ARGH_rot37[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.362,   -1.524,   13.970},
 {    6.215,   -3.228,   14.296},
 {    6.764,   -1.585,   18.640},
 {    4.007,    0.278,   18.326},
 {    2.833,   -3.506,   20.588},
 {    1.504,   -3.723,   17.528},
 {    6.430,   -6.095,   17.771},
 {    0.026,   -6.940,   19.183},
 {    0.181,  -10.205,   19.015},
 {    6.630,  -10.359,   17.553},
 {    3.946,  -12.154,   18.086}
};

static ROTCOOSTRU ARGH_rot38[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.331,   -1.474,   14.037},
 {    6.165,   -3.229,   14.222},
 {    6.898,   -1.629,   18.582},
 {    4.097,    0.187,   18.401},
 {    3.202,   -3.739,   20.653},
 {    1.587,   -3.765,   17.725},
 {    6.178,   -6.766,   18.980},
 {    1.108,   -5.432,   14.951},
 {    1.496,   -8.157,   13.180},
 {    6.683,  -10.324,   16.667},
 {    4.675,  -10.946,   14.158}
};

static ROTCOOSTRU ARGH_rot39[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.329,   -1.472,   14.040},
 {    6.164,   -3.229,   14.219},
 {    6.902,   -1.674,   18.578},
 {    4.140,    0.202,   18.408},
 {    1.527,   -3.665,   17.770},
 {    4.280,   -5.560,   17.874},
 {    4.465,   -5.034,   22.263},
 {   -0.111,   -1.025,   19.673},
 {   -1.420,   -0.263,   22.575},
 {    2.755,   -4.037,   26.051},
 {    0.214,   -1.980,   26.211}
};

static ROTCOOSTRU ARGH_rot40[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.328,   -1.470,   14.043},
 {    6.162,   -3.229,   14.216},
 {    6.904,   -1.723,   18.574},
 {    4.187,    0.217,   18.414},
 {    1.483,   -3.586,   17.772},
 {    4.191,   -5.545,   17.865},
 {    4.090,   -2.588,   22.353},
 {    0.735,   -7.474,   19.422},
 {   -0.287,   -8.779,   22.244},
 {    2.754,   -4.294,   26.038},
 {    0.863,   -6.966,   26.016}
};

static ROTCOOSTRU ARGH_rot41[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.322,   -1.459,   14.058},
 {    6.150,   -3.228,   14.200},
 {    6.934,   -1.742,   18.559},
 {    4.216,    0.200,   18.431},
 {    1.542,   -3.662,   17.700},
 {    4.278,   -5.568,   17.950},
 {    1.589,   -3.036,   22.080},
 {    7.147,   -6.049,   20.143},
 {    8.063,   -6.825,   23.188},
 {    2.787,   -4.051,   26.055},
 {    5.577,   -5.686,   26.558}
};

static ROTCOOSTRU ARGH_rot42[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.358,   -1.518,   13.978},
 {    6.209,   -3.228,   14.288},
 {    6.781,   -1.554,   18.634},
 {    3.985,    0.252,   18.331},
 {    4.288,   -5.516,   17.955},
 {    3.305,   -3.812,   20.659},
 {   -0.424,   -2.463,   18.379},
 {    3.276,   -6.931,   15.206},
 {    0.853,   -7.866,   13.214},
 {   -3.587,   -3.685,   15.776},
 {   -3.059,   -6.015,   13.539}
};

static ROTCOOSTRU ARGH_rot43[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.346,   -1.499,   14.003},
 {    6.190,   -3.228,   14.259},
 {    6.833,   -1.542,   18.613},
 {    3.994,    0.205,   18.358},
 {    4.391,   -5.552,   17.902},
 {    3.475,   -3.913,   20.669},
 {    0.188,   -2.130,   17.019},
 {    1.876,   -8.127,   19.234},
 {   -1.054,   -9.441,   18.601},
 {   -3.638,   -3.848,   16.194},
 {   -4.198,   -7.001,   16.868}
};

static ROTCOOSTRU ARGH_rot44[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.343,   -1.495,   14.009},
 {    6.187,   -3.228,   14.253},
 {    6.843,   -1.554,   18.608},
 {    4.009,    0.202,   18.365},
 {    4.384,   -5.555,   17.891},
 {    3.489,   -3.923,   20.669},
 {    0.419,   -4.724,   16.147},
 {    1.251,   -1.127,   21.633},
 {   -1.885,   -0.198,   21.778},
 {   -3.674,   -3.509,   16.338},
 {   -4.692,   -1.556,   18.759}
};

static ROTCOOSTRU ARGH_rot45[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.421,   -1.610,   13.862},
 {    6.292,   -3.220,   14.426},
 {    4.317,    0.557,   18.268},
 {    3.044,   -2.531,   18.136},
 {    6.335,   -3.012,   21.064},
 {    7.764,   -4.052,   18.226},
 {   10.404,   -0.520,   18.282},
 {    5.607,    0.200,   22.776},
 {    7.004,    2.800,   24.190},
 {   12.226,    2.876,   20.131},
 {   10.777,    4.326,   22.683}
};

static ROTCOOSTRU ARGH_rot46[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.478,   -1.685,   13.776},
 {    6.350,   -3.208,   14.538},
 {    4.054,    0.635,   18.137},
 {    2.932,   -2.513,   18.063},
 {    6.100,   -2.637,   21.196},
 {    7.644,   -3.862,   18.495},
 {    8.328,    1.522,   18.785},
 {   10.329,   -4.163,   21.504},
 {   13.245,   -2.977,   22.400},
 {   12.136,    3.069,   19.956},
 {   14.275,    1.146,   21.518}
};

static ROTCOOSTRU ARGH_rot47[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.421,   -1.610,   13.862},
 {    6.292,   -3.220,   14.426},
 {    4.317,    0.557,   18.268},
 {    3.044,   -2.531,   18.136},
 {    6.402,   -2.716,   21.158},
 {    7.568,   -4.221,   18.409},
 {    9.021,    0.897,   20.233},
 {    9.958,   -4.230,   16.164},
 {   12.890,   -3.187,   15.150},
 {   12.850,    2.257,   18.907},
 {   14.539,    0.511,   16.713}
};

static ROTCOOSTRU ARGH_rot48[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.397,   -1.576,   13.903},
 {    6.263,   -3.224,   14.375},
 {    4.478,    0.522,   18.328},
 {    3.076,   -2.508,   18.164},
 {    7.474,   -4.426,   18.357},
 {    8.706,   -1.353,   18.824},
 {    7.139,   -1.365,   22.956},
 {    4.764,   -6.554,   19.616},
 {    3.579,   -8.027,   22.288},
 {    5.591,   -3.290,   26.444},
 {    4.051,   -6.166,   26.180}
};

static ROTCOOSTRU ARGH_rot49[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.399,   -1.578,   13.900},
 {    6.265,   -3.224,   14.378},
 {    4.533,    0.531,   18.335},
 {    3.039,   -2.454,   18.156},
 {    7.268,   -4.569,   18.466},
 {    8.734,   -1.573,   18.696},
 {    4.916,   -1.987,   22.498},
 {   10.897,   -4.329,   20.928},
 {   11.754,   -4.878,   24.038},
 {    6.037,   -2.706,   26.559},
 {    8.984,   -3.953,   27.249}
};

static ROTCOOSTRU ARGH_rot50[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.403,   -1.584,   13.893},
 {    6.270,   -3.223,   14.387},
 {    4.417,    0.528,   18.311},
 {    3.081,   -2.532,   18.160},
 {    7.459,   -4.394,   18.452},
 {    8.705,   -1.307,   18.765},
 {    6.042,   -4.218,   22.617},
 {    7.846,    1.826,   20.635},
 {    7.676,    3.115,   23.639},
 {    5.821,   -2.533,   26.539},
 {    6.521,    0.630,   27.004}
};

static ROTCOOSTRU ARGH_rot51[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.417,   -1.604,   13.869},
 {    6.287,   -3.221,   14.417},
 {    4.647,    0.573,   18.331},
 {    2.894,   -2.265,   18.106},
 {    8.659,   -2.144,   18.500},
 {    6.654,   -2.302,   21.171},
 {    5.258,   -6.430,   19.812},
 {   10.179,   -3.894,   16.197},
 {   11.086,   -6.793,   14.975},
 {    6.444,  -10.214,   18.216},
 {    8.957,  -10.395,   16.126}
};

static ROTCOOSTRU ARGH_rot52[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.414,   -1.600,   13.874},
 {    6.283,   -3.221,   14.411},
 {    4.598,    0.567,   18.326},
 {    2.930,   -2.322,   18.117},
 {    8.680,   -1.906,   18.614},
 {    6.599,   -2.377,   21.188},
 {    5.427,   -6.198,   17.746},
 {   10.793,   -4.216,   21.062},
 {   12.082,   -7.219,   21.234},
 {    7.112,  -10.120,   17.971},
 {    9.984,  -10.585,   19.472}
};

static ROTCOOSTRU ARGH_rot53[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    3.480,   -1.687,   13.774},
 {    6.352,   -3.208,   14.541},
 {    4.121,    0.651,   18.150},
 {    2.883,   -2.453,   18.047},
 {    8.410,   -1.021,   18.994},
 {    6.227,   -2.060,   21.303},
 {    8.876,   -5.174,   17.591},
 {    3.716,   -4.771,   21.707},
 {    3.372,   -8.015,   21.966},
 {    8.425,   -9.411,   17.931},
 {    6.057,  -10.661,   19.813}
};

static ROTCOOSTRU ARGH_rot54[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.746,   -3.164,   13.754},
 {    5.827,   -1.858,   16.826},
 {    1.519,   -2.266,   16.334},
 {    1.903,    0.837,   15.150},
 {   -0.721,   -1.480,   12.196},
 {    2.245,   -0.953,   10.744},
 {    3.064,   -5.294,   10.870},
 {   -2.327,   -3.900,   14.436},
 {   -3.217,   -7.034,   14.744},
 {    1.900,   -9.386,   11.274},
 {   -0.808,  -10.162,   12.942}
};

static ROTCOOSTRU ARGH_rot55[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.639,   -3.133,   13.667},
 {    5.926,   -1.944,   16.774},
 {    1.562,   -2.375,   16.380},
 {    1.985,    0.851,   15.612},
 {   -0.791,   -0.869,   12.457},
 {    2.170,   -0.415,   10.972},
 {    1.967,   -5.432,   12.926},
 {   -0.737,   -1.679,    8.201},
 {   -1.299,   -4.203,    6.195},
 {    1.231,   -8.727,   10.305},
 {   -0.177,   -8.221,    7.394}
};

static ROTCOOSTRU ARGH_rot56[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.700,   -3.151,   13.715},
 {    5.871,   -1.896,   16.804},
 {    1.542,   -2.289,   16.380},
 {    1.936,    0.857,   15.319},
 {   -0.767,   -1.272,   12.315},
 {    2.189,   -0.777,   10.832},
 {    0.211,   -5.694,   12.701},
 {    4.774,   -2.239,    9.389},
 {    6.088,   -4.884,    7.978},
 {    1.928,   -9.146,   10.857},
 {    4.466,   -8.822,    8.815}
};

static ROTCOOSTRU ARGH_rot57[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.756,   -3.167,   13.762},
 {    5.817,   -1.849,   16.830},
 {    1.484,   -2.606,   15.983},
 {    1.867,    0.690,   15.575},
 {    2.304,    0.050,   10.906},
 {    1.889,   -3.240,   11.326},
 {   -2.433,   -2.597,   12.018},
 {    0.744,    3.200,   11.872},
 {   -2.006,    4.967,   11.692},
 {   -6.023,   -0.288,   11.783},
 {   -5.863,    2.978,   11.641}
};

static ROTCOOSTRU ARGH_rot58[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.567,   -3.110,   13.614},
 {    5.988,   -2.001,   16.736},
 {    1.545,   -2.587,   16.185},
 {    2.057,    0.716,   16.143},
 {    1.905,    0.770,   11.487},
 {    1.675,   -2.564,   11.392},
 {   -2.358,   -0.724,   14.408},
 {   -0.300,   -0.580,    8.125},
 {   -3.322,   -0.312,    6.898},
 {   -6.304,   -0.373,   12.802},
 {   -6.745,   -0.194,    9.564}
};

static ROTCOOSTRU ARGH_rot59[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.700,   -3.151,   13.715},
 {    5.871,   -1.896,   16.804},
 {    1.520,   -2.458,   16.218},
 {    1.929,    0.791,   15.546},
 {    2.078,   -0.131,   10.948},
 {    1.814,   -3.407,   11.563},
 {   -2.233,    0.341,   11.726},
 {   -0.257,   -5.651,   13.704},
 {   -3.303,   -6.758,   14.165},
 {   -6.209,   -1.107,   12.328},
 {   -6.696,   -4.167,   13.381}
};

static ROTCOOSTRU ARGH_rot60[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.652,   -3.137,   13.677},
 {    5.914,   -1.934,   16.781},
 {    1.539,   -2.471,   16.258},
 {    1.971,    0.797,   15.708},
 {    2.057,   -3.020,   11.390},
 {   -0.816,   -1.758,   12.546},
 {    0.489,    2.375,   11.146},
 {    4.629,   -2.483,    9.421},
 {    6.057,   -0.739,    7.047},
 {    2.355,    4.651,    8.045},
 {    4.760,    3.328,    6.263}
};

static ROTCOOSTRU ARGH_rot61[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.586,   -3.116,   13.628},
 {    5.972,   -1.987,   16.746},
 {    1.569,   -2.465,   16.342},
 {    2.037,    0.815,   15.895},
 {    2.209,   -2.541,   11.282},
 {   -0.770,   -2.011,   12.705},
 {    1.383,    2.770,   12.273},
 {   -0.121,   -2.160,    8.132},
 {   -0.668,   -0.170,    5.592},
 {    0.669,    5.367,    8.955},
 {   -0.217,    4.121,    6.061}
};

static ROTCOOSTRU ARGH_rot62[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.679,   -3.145,   13.698},
 {    5.890,   -1.912,   16.794},
 {    1.526,   -2.480,   16.219},
 {    1.946,    0.786,   15.640},
 {    2.142,   -3.052,   11.348},
 {   -0.774,   -1.860,   12.469},
 {    3.051,    0.886,    9.561},
 {   -2.269,    1.341,   13.462},
 {   -3.085,    4.325,   12.392},
 {    1.982,    4.781,    8.165},
 {   -0.662,    6.286,    9.372}
};

static ROTCOOSTRU ARGH_rot63[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.048,   -3.222,   14.066},
 {    5.491,   -1.595,   16.928},
 {    1.584,    0.299,   15.103},
 {    2.145,   -1.304,   12.224},
 {   -0.881,   -3.755,   14.639},
 {    2.001,   -5.449,   14.571},
 {    2.466,   -4.809,   18.919},
 {   -2.515,   -1.128,   16.605},
 {   -3.638,   -0.360,   19.582},
 {    0.998,   -3.806,   22.806},
 {   -1.636,   -1.887,   23.117}
};

static ROTCOOSTRU ARGH_rot64[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.038,   -3.221,   14.052},
 {    5.505,   -1.605,   16.926},
 {    1.585,    0.292,   15.165},
 {    2.128,   -1.249,   12.248},
 {   -0.886,   -3.744,   14.643},
 {    1.990,   -5.442,   14.493},
 {    1.762,   -2.371,   18.994},
 {   -0.467,   -7.987,   16.309},
 {   -0.905,   -9.466,   19.196},
 {    1.190,   -4.304,   22.763},
 {    0.040,   -7.367,   22.875}
};

static ROTCOOSTRU ARGH_rot65[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.027,   -3.220,   14.039},
 {    5.519,   -1.615,   16.923},
 {    1.611,    0.353,   15.111},
 {    2.108,   -1.330,   12.266},
 {   -0.937,   -3.624,   14.869},
 {    1.880,   -5.411,   14.640},
 {    0.107,   -2.600,   19.172},
 {    4.342,   -6.812,   16.335},
 {    5.552,   -7.876,   19.184},
 {    1.689,   -3.992,   22.891},
 {    4.040,   -6.269,   22.921}
};

static ROTCOOSTRU ARGH_rot66[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.033,   -3.220,   14.047},
 {    5.511,   -1.609,   16.925},
 {    1.595,    0.317,   15.144},
 {    2.120,   -1.281,   12.255},
 {    1.881,   -5.426,   14.477},
 {    1.421,   -3.855,   17.392},
 {   -2.749,   -2.912,   16.221},
 {    0.542,   -5.554,   11.131},
 {   -2.156,   -6.064,    9.350},
 {   -6.272,   -3.579,   13.893},
 {   -6.040,   -4.938,   10.924}
};

static ROTCOOSTRU ARGH_rot67[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.016,   -3.218,   14.026},
 {    5.533,   -1.625,   16.921},
 {    1.604,    0.322,   15.214},
 {    2.093,   -1.227,   12.292},
 {    1.918,   -5.414,   14.503},
 {    1.377,   -3.845,   17.405},
 {   -2.340,   -2.128,   13.982},
 {   -0.520,   -7.768,   16.915},
 {   -3.547,   -9.014,   16.919},
 {   -6.291,   -3.757,   13.989},
 {   -6.837,   -6.728,   15.251}
};

static ROTCOOSTRU ARGH_rot68[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.007,   -3.217,   14.016},
 {    5.544,   -1.633,   16.918},
 {    1.617,    0.350,   15.206},
 {    2.079,   -1.251,   12.308},
 {    1.951,   -5.402,   14.661},
 {    1.302,   -3.727,   17.481},
 {   -2.187,   -4.695,   13.308},
 {   -0.896,   -0.965,   18.613},
 {   -4.022,   -0.104,   19.057},
 {   -6.269,   -3.568,   13.890},
 {   -7.085,   -1.587,   16.365}
};

static ROTCOOSTRU ARGH_rot69[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    5.989,   -3.215,   13.995},
 {    5.565,   -1.649,   16.914},
 {    1.654,    0.431,   15.137},
 {    2.046,   -1.358,   12.341},
 {    1.554,   -3.670,   17.621},
 {   -1.012,   -3.242,   15.522},
 {    0.797,   -6.352,   12.739},
 {    4.088,   -5.616,   18.427},
 {    5.621,   -8.497,   18.182},
 {    2.800,  -10.115,   12.421},
 {    4.887,  -11.062,   14.758}
};

static ROTCOOSTRU ARGH_rot70[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.031,   -3.220,   14.044},
 {    5.514,   -1.611,   16.924},
 {    1.595,    0.315,   15.156},
 {    2.117,   -1.270,   12.260},
 {    1.524,   -3.934,   17.361},
 {   -0.977,   -3.452,   15.195},
 {    2.900,   -5.834,   12.465},
 {   -0.917,   -7.170,   17.696},
 {   -0.878,  -10.404,   17.192},
 {    2.949,  -10.057,   11.808},
 {    1.326,  -12.050,   13.834}
};

static ROTCOOSTRU ARGH_rot71[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.000,   -3.216,   14.008},
 {    5.552,   -1.639,   16.917},
 {    1.676,    0.490,   14.950},
 {    2.054,   -1.549,   12.328},
 {    1.416,   -3.285,   17.813},
 {   -1.036,   -3.179,   15.541},
 {    3.089,   -6.869,   15.826},
 {   -1.723,   -4.240,   12.130},
 {   -1.931,   -6.833,   10.143},
 {    2.815,  -10.254,   13.230},
 {    0.656,  -10.261,   10.771}
};

static ROTCOOSTRU ARGH_rot72[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.097,   -3.226,   14.128},
 {    5.427,   -1.550,   16.937},
 {    2.216,   -0.970,   12.186},
 {    1.654,   -3.373,   14.441},
 {   -1.024,   -0.117,   15.830},
 {    1.662,    0.277,   17.781},
 {    2.495,    4.115,   15.806},
 {   -1.953,    0.744,   12.260},
 {   -2.633,    3.265,   10.286},
 {    1.605,    7.405,   13.228},
 {   -0.605,    7.063,   10.838}
};

static ROTCOOSTRU ARGH_rot73[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.089,   -3.226,   14.117},
 {    5.439,   -1.557,   16.935},
 {    2.195,   -0.815,   12.245},
 {    1.679,   -3.388,   14.316},
 {   -1.045,   -0.257,   15.924},
 {    1.623,   -0.031,   17.926},
 {    1.974,    3.335,   13.608},
 {   -0.620,    2.596,   19.645},
 {   -0.865,    5.814,   20.187},
 {    1.653,    7.537,   14.317},
 {    0.431,    8.631,   17.150}
};

static ROTCOOSTRU ARGH_rot74[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.126,   -3.228,   14.166},
 {    5.388,   -1.522,   16.941},
 {    2.253,   -0.885,   12.163},
 {    1.716,   -3.437,   14.253},
 {   -1.103,   -0.158,   15.572},
 {    1.359,   -0.206,   17.833},
 {    0.699,    3.654,   13.786},
 {    3.530,    1.625,   19.406},
 {    4.832,    4.552,   20.079},
 {    2.400,    7.475,   14.666},
 {    4.188,    7.887,   17.377}
};

static ROTCOOSTRU ARGH_rot75[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.124,   -3.228,   14.163},
 {    5.391,   -1.524,   16.940},
 {    2.273,   -1.266,   12.084},
 {    1.617,   -3.335,   14.627},
 {    1.194,    0.356,   17.535},
 {    1.880,    2.435,   15.008},
 {   -2.192,    1.816,   13.412},
 {   -0.975,   -2.528,   18.245},
 {   -4.093,   -3.495,   18.478},
 {   -6.263,    0.552,   13.717},
 {   -7.108,   -1.739,   15.896}
};

static ROTCOOSTRU ARGH_rot76[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.122,   -3.227,   14.161},
 {    5.394,   -1.526,   16.940},
 {    2.264,   -1.144,   12.105},
 {    1.644,   -3.371,   14.520},
 {    1.248,    0.187,   17.646},
 {    1.765,    2.379,   15.175},
 {   -2.314,   -0.863,   13.795},
 {   -0.843,    3.965,   18.067},
 {   -3.932,    5.027,   18.288},
 {   -6.346,    0.525,   14.086},
 {   -7.069,    3.066,   16.019}
};

static ROTCOOSTRU ARGH_rot77[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.112,   -3.227,   14.147},
 {    5.408,   -1.536,   16.939},
 {    2.250,   -1.210,   12.114},
 {    1.616,   -3.331,   14.619},
 {    1.366,    0.407,   17.598},
 {    1.761,    2.442,   14.975},
 {   -2.767,   -0.497,   16.267},
 {    0.411,    3.075,   11.700},
 {   -2.308,    3.770,   10.016},
 {   -6.317,    0.412,   14.066},
 {   -6.144,    2.252,   11.365}
};

static ROTCOOSTRU ARGH_rot78[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.076,   -3.225,   14.100},
 {    5.455,   -1.569,   16.933},
 {    2.185,   -0.981,   12.219},
 {    1.625,   -3.335,   14.525},
 {    2.156,    2.209,   15.997},
 {   -0.757,    0.984,   14.905},
 {   -1.066,   -1.547,   18.602},
 {    4.501,    2.018,   18.483},
 {    5.107,    1.607,   21.673},
 {   -0.272,   -2.083,   22.767},
 {    2.386,   -0.731,   24.115}
};

static ROTCOOSTRU ARGH_rot79[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.103,   -3.226,   14.136},
 {    5.419,   -1.544,   16.938},
 {    2.237,   -1.258,   12.123},
 {    1.595,   -3.299,   14.691},
 {    1.952,    2.466,   15.059},
 {   -0.903,    0.743,   14.815},
 {    1.608,   -1.354,   18.945},
 {   -0.546,    4.652,   17.212},
 {   -1.079,    5.606,   20.297},
 {    0.912,   -0.107,   22.973},
 {   -0.247,    2.893,   23.582}
};

static ROTCOOSTRU ARGH_rot80[13] = {
 {    7.954,   -0.307,   10.112},
 {    5.769,    2.535,   14.486},
 {    6.120,   -3.227,   14.158},
 {    5.397,   -1.528,   16.940},
 {    2.266,   -1.261,   12.092},
 {    1.613,   -3.329,   14.636},
 {    1.827,    2.447,   14.943},
 {   -0.958,    0.598,   14.870},
 {    2.441,    1.329,   19.170},
 {   -2.351,   -2.384,   16.529},
 {   -3.329,   -3.584,   19.413},
 {    1.162,   -0.240,   22.934},
 {   -1.327,   -2.362,   23.064}
};
static ROTCOOSTRU *ARG_rotarr[81] = {ARG_rot0,ARG_rot1,ARG_rot2,ARG_rot3,ARG_rot4,ARG_rot5,ARG_rot6,ARG_rot7,ARG_rot8,ARG_rot9,ARG_rot10,ARG_rot11,ARG_rot12,ARG_rot13,ARG_rot14,ARG_rot15,ARG_rot16,ARG_rot17,ARG_rot18,ARG_rot19,ARG_rot20,ARG_rot21,ARG_rot22,ARG_rot23,ARG_rot24,ARG_rot25,ARG_rot26,ARG_rot27,ARG_rot28,ARG_rot29,ARG_rot30,ARG_rot31,ARG_rot32,ARG_rot33,ARG_rot34,ARG_rot35,ARG_rot36,ARG_rot37,ARG_rot38,ARG_rot39,ARG_rot40,ARG_rot41,ARG_rot42,ARG_rot43,ARG_rot44,ARG_rot45,ARG_rot46,ARG_rot47,ARG_rot48,ARG_rot49,ARG_rot50,ARG_rot51,ARG_rot52,ARG_rot53,ARG_rot54,ARG_rot55,ARG_rot56,ARG_rot57,ARG_rot58,ARG_rot59,ARG_rot60,ARG_rot61,ARG_rot62,ARG_rot63,ARG_rot64,ARG_rot65,ARG_rot66,ARG_rot67,ARG_rot68,ARG_rot69,ARG_rot70,ARG_rot71,ARG_rot72,ARG_rot73,ARG_rot74,ARG_rot75,ARG_rot76,ARG_rot77,ARG_rot78,ARG_rot79,ARG_rot80};

static ROTCOOSTRU *ARGH_rotarr[81] = {ARGH_rot0,ARGH_rot1,ARGH_rot2,ARGH_rot3,ARGH_rot4,ARGH_rot5,ARGH_rot6,ARGH_rot7,ARGH_rot8,ARGH_rot9,ARGH_rot10,ARGH_rot11,ARGH_rot12,ARGH_rot13,ARGH_rot14,ARGH_rot15,ARGH_rot16,ARGH_rot17,ARGH_rot18,ARGH_rot19,ARGH_rot20,ARGH_rot21,ARGH_rot22,ARGH_rot23,ARGH_rot24,ARGH_rot25,ARGH_rot26,ARGH_rot27,ARGH_rot28,ARGH_rot29,ARGH_rot30,ARGH_rot31,ARGH_rot32,ARGH_rot33,ARGH_rot34,ARGH_rot35,ARGH_rot36,ARGH_rot37,ARGH_rot38,ARGH_rot39,ARGH_rot40,ARGH_rot41,ARGH_rot42,ARGH_rot43,ARGH_rot44,ARGH_rot45,ARGH_rot46,ARGH_rot47,ARGH_rot48,ARGH_rot49,ARGH_rot50,ARGH_rot51,ARGH_rot52,ARGH_rot53,ARGH_rot54,ARGH_rot55,ARGH_rot56,ARGH_rot57,ARGH_rot58,ARGH_rot59,ARGH_rot60,ARGH_rot61,ARGH_rot62,ARGH_rot63,ARGH_rot64,ARGH_rot65,ARGH_rot66,ARGH_rot67,ARGH_rot68,ARGH_rot69,ARGH_rot70,ARGH_rot71,ARGH_rot72,ARGH_rot73,ARGH_rot74,ARGH_rot75,ARGH_rot76,ARGH_rot77,ARGH_rot78,ARGH_rot79,ARGH_rot80};

static int HIS_PDB[10] = { 0, 1, 2, 3, 4, 5, 10, 12, 19, 23 };
static short int HIS_PMF[10] = { 10, 2, 4, 6, 2, 4, 4, 4, 9, 9 };
static int HISH_PDB[7] = { 0, 3, 6, 7, 21, 24, 30 };
static short int HISH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 }; 
static int HIS_NUMC[2] = {10,7};

static ROTCOOSTRU HIS_rot0[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {37.576,-8.762,37.938},
  {39.632,-9.745,39.108},
  {39.137,-5.871,40.499},
  {37.318,-6.334,38.850},
  {40.567,-7.910,40.689}
 };

static ROTCOOSTRU HIS_rot1[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {37.529,-8.696,37.941},
  {39.831,-7.608,37.661},
  {38.860,-7.452,41.688},
  {36.975,-8.566,40.485},
  {40.616,-6.852,40.017}
 };

static ROTCOOSTRU HIS_rot2[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {37.513,-8.674,37.942},
  {37.239,-6.563,39.367},
  {40.972,-8.159,40.206},
  {39.870,-9.629,38.513},
  {39.415,-6.286,40.756}
 };

static ROTCOOSTRU HIS_rot3[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {33.251,-8.906,36.849},
  {32.600,-7.012,38.446},
  {29.094,-8.714,37.032},
  {31.012,-9.933,35.995},
  {30.005,-6.933,38.527}
 };

static ROTCOOSTRU HIS_rot4[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {33.154,-9.129,36.776},
  {31.197,-8.274,35.362},
  {29.933,-8.380,39.309},
  {32.301,-9.174,39.238},
  {29.218,-7.823,36.982}
 };

static ROTCOOSTRU HIS_rot5[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {33.151,-9.137,36.773},
  {30.969,-10.477,36.821},
  {30.082,-6.605,38.009},
  {32.531,-6.720,37.528},
  {29.091,-8.859,37.595}
 };

static ROTCOOSTRU HIS_rot6[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {35.371,-12.648,36.530},
  {33.227,-14.048,36.580},
  {36.394,-16.584,37.433},
  {37.320,-14.292,37.071},
  {33.916,-16.487,37.145}
 };

static ROTCOOSTRU HIS_rot7[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {35.279,-12.636,36.510},
  {34.909,-14.577,34.881},
  {34.588,-16.096,38.724},
  {35.067,-13.651,38.902},
  {34.484,-16.706,36.305}
 };

static ROTCOOSTRU HIS_rot8[10] = {
  {38.892,-10.342,32.670},
  {36.457,-9.273,33.308},
  {36.472,-6.423,32.900},
  {34.531,-5.316,32.309},
  {35.786,-9.887,36.054},
  {35.473,-12.657,36.553},
  {36.977,-14.332,37.774},
  {33.659,-16.404,36.402},
  {33.410,-14.014,35.717},
  {35.807,-16.647,37.652}
};

static ROTCOOSTRU HISH_rot0[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {35.811,-11.966,36.329},
  {33.872,-9.145,36.486},
  {35.931,-5.105,38.319},
  {40.342,-11.518,38.851},
  {39.408,-4.088,41.533}
 };

static ROTCOOSTRU HISH_rot1[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {35.871,-11.963,36.345},
  {33.848,-9.199,36.468},
  {35.355,-9.235,41.289},
  {40.790,-7.397,36.002},
  {38.944,-7.089,43.733}
 };

static ROTCOOSTRU HISH_rot2[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {35.891,-11.961,36.350},
  {33.840,-9.218,36.462},
  {40.623,-11.224,37.736},
  {35.698,-5.405,39.392},
  {42.864,-8.453,41.015}
 };

static ROTCOOSTRU HISH_rot3[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {37.217,-9.034,37.329},
  {35.764,-11.968,36.317},
  {30.883,-11.403,34.756},
  {33.820,-5.868,39.404},
  {27.082,-9.119,36.702}
 };

static ROTCOOSTRU HISH_rot4[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {37.104,-8.877,37.336},
  {35.951,-11.955,36.366},
  {33.353,-9.736,40.752},
  {31.205,-8.019,33.451},
  {28.763,-8.214,41.019}
 };

static ROTCOOSTRU HISH_rot5[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {37.099,-8.872,37.336},
  {35.957,-11.954,36.368},
  {33.786,-5.265,37.683},
  {30.773,-12.339,36.365},
  {29.052,-4.916,38.645}
 };

static ROTCOOSTRU HISH_rot6[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {34.018,-8.887,36.580},
  {37.346,-9.261,37.309},
  {39.179,-13.793,37.170},
  {31.442,-13.398,36.256},
  {37.505,-18.279,37.894}
 };

static ROTCOOSTRU HISH_rot7[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {34.058,-8.831,36.602},
  {37.376,-9.327,37.302},
  {35.254,-12.649,40.538},
  {34.943,-14.463,32.957},
  {34.324,-17.397,40.324}
 };

static ROTCOOSTRU HISH_rot8[7] = {
  {39.869,-11.043,34.128},
  {35.204,-10.015,32.170},
  {33.977,-8.951,36.555},
  {37.310,-9.191,37.316},
  {31.935,-13.267,34.727},
  {38.662,-13.934,38.621},
  {32.303,-17.927,35.995}
};

static ROTCOOSTRU *HIS_rotarr[9] = {HIS_rot0,HIS_rot1,HIS_rot2,HIS_rot3,HIS_rot4,HIS_rot5,HIS_rot6,HIS_rot7,HIS_rot8};
static ROTCOOSTRU *HISH_rotarr[9] = {HISH_rot0,HISH_rot1,HISH_rot2,HISH_rot3,HISH_rot4,HISH_rot5,HISH_rot6,HISH_rot7,HISH_rot8};

static int PHE_PDB[11] = { 0, 1, 2, 3, 4, 5, 9, 10, 12, 13, 16 };
static short int PHE_PMF[11] = { 10, 2, 4, 6, 2, 3, 3, 3, 3, 3, 3 }; 
static int PHEH_PDB[9] = { 0, 3, 6, 7, 21, 24, 30, 33, 39 };
static short int PHEH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int PHE_NUMC[2] = {11,9};

static ROTCOOSTRU PHE_rot0[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {59.435,-24.669,78.669},
  {61.309,-22.846,78.916},
  {58.696,-26.028,80.800},
  {62.434,-22.379,81.250},
  {59.808,-25.576,83.145},
  {61.681,-23.748,83.369}
 };

static ROTCOOSTRU PHE_rot1[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {59.408,-24.701,78.688},
  {61.354,-26.228,79.570},
  {58.552,-22.730,80.209},
  {62.435,-25.803,81.932},
  {59.620,-22.286,82.576},
  {61.565,-23.826,83.438}
 };

static ROTCOOSTRU PHE_rot2[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {58.227,-22.628,74.893},
  {56.549,-22.105,72.941},
  {59.909,-20.752,75.659},
  {56.543,-19.749,71.766},
  {59.919,-18.388,74.497},
  {58.232,-17.886,72.547}
 };

static ROTCOOSTRU PHE_rot3[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {58.046,-22.681,74.805},
  {58.246,-22.549,72.189},
  {57.678,-20.455,76.163},
  {58.084,-20.238,70.940},
  {57.513,-18.132,74.934},
  {57.715,-18.023,72.317}
 };

static ROTCOOSTRU PHE_rot4[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {55.432,-25.557,76.356},
  {54.393,-26.686,78.489},
  {53.826,-24.798,74.412},
  {51.795,-27.055,78.687},
  {51.223,-25.159,74.590},
  {50.206,-26.289,76.732}
 };

static ROTCOOSTRU PHE_rot5[11] = {
  {59.451,-29.633,75.935},
  {59.581,-27.227,74.606},
  {62.333,-26.481,74.162},
  {62.996,-25.485,72.167},
  {58.238,-25.177,76.145},
  {55.421,-25.511,76.285},
  {54.185,-27.141,74.637},
  {54.000,-24.181,78.059},
  {51.573,-27.445,74.750},
  {51.386,-24.471,78.190},
  {50.171,-26.107,76.532}
};

static ROTCOOSTRU PHEH_rot0[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {56.254,-25.760,76.500},
  {58.257,-23.375,75.071},
  {61.901,-21.766,77.242},
  {57.216,-27.479,80.646},
  {63.916,-20.931,81.421},
  {59.204,-26.666,84.809},
  {62.563,-23.385,85.216}
 };

static ROTCOOSTRU PHEH_rot1[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {56.245,-25.744,76.471},
  {58.287,-23.367,75.086},
  {62.040,-27.788,78.378},
  {57.014,-21.498,79.547},
  {63.974,-27.026,82.608},
  {58.922,-20.723,83.755},
  {62.413,-23.482,85.305}
 };

static ROTCOOSTRU PHEH_rot2[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {59.194,-24.958,77.999},
  {56.238,-25.731,76.448},
  {55.216,-23.576,72.327},
  {61.252,-21.126,77.201},
  {55.206,-19.359,70.223},
  {61.258,-16.927,75.124},
  {58.233,-16.023,71.626}
 };

static ROTCOOSTRU PHEH_rot3[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {59.286,-24.847,77.932},
  {56.284,-25.802,76.582},
  {58.536,-24.298,71.104},
  {57.514,-20.517,78.235},
  {58.246,-20.159,68.870},
  {57.222,-16.392,76.034},
  {57.585,-16.194,71.339}
 };

static ROTCOOSTRU PHEH_rot4[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {58.548,-23.311,75.239},
  {59.012,-25.148,78.094},
  {55.650,-27.289,80.031},
  {54.608,-23.901,72.708},
  {50.997,-27.951,80.385},
  {49.981,-24.549,73.039},
  {48.152,-26.576,76.880}
 };

static ROTCOOSTRU PHEH_rot5[9] = {
  {58.997,-29.530,77.767},
  {58.658,-27.471,72.739},
  {58.602,-23.303,75.275},
  {58.966,-25.191,78.112},
  {55.295,-28.197,73.232},
  {54.941,-22.882,79.381},
  {50.618,-28.741,73.435},
  {50.291,-23.407,79.601},
  {48.107,-26.342,76.630}
};

static ROTCOOSTRU *PHE_rotarr[6] = {PHE_rot0,PHE_rot1,PHE_rot2,PHE_rot3,PHE_rot4,PHE_rot5};
static ROTCOOSTRU *PHEH_rotarr[6] = {PHEH_rot0,PHEH_rot1,PHEH_rot2,PHEH_rot3,PHEH_rot4,PHEH_rot5};

static int TYR_PDB[12] = { 0, 1, 2, 3, 4, 5, 9, 10, 12, 13, 16, 32 };
static short int TYR_PMF[12] = { 10, 2, 4, 6, 2, 3, 3, 3, 3, 3, 3, 7 }; 
static int TYRH_PDB[9] = { 0, 3, 6, 7, 21, 24, 30, 33, 51 };
static short int TYRH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int TYR_NUMC[2] = {12,9};

static ROTCOOSTRU TYR_rot0[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {38.828,-23.879,54.515},
  {40.861,-25.539,54.617},
  {37.083,-24.156,52.563},
  {41.163,-27.431,52.804},
  {37.365,-26.030,50.752},
  {39.408,-27.652,50.878},
  {39.698,-29.468,49.044}
 };

static ROTCOOSTRU TYR_rot1[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {39.059,-23.953,54.650},
  {40.219,-23.589,52.321},
  {38.268,-26.381,55.288},
  {40.573,-25.599,50.650},
  {38.611,-28.392,53.642},
  {39.755,-27.989,51.329},
  {40.037,-29.984,49.691}
 };

static ROTCOOSTRU TYR_rot2[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {39.727,-22.843,58.749},
  {39.194,-21.815,61.107},
  {41.445,-24.833,58.612},
  {40.358,-22.738,63.287},
  {42.610,-25.766,60.766},
  {42.066,-24.708,63.091},
  {43.272,-25.611,65.206}
 };

static ROTCOOSTRU TYR_rot3[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {39.563,-22.711,58.877},
  {40.797,-21.095,60.540},
  {39.358,-25.255,59.525},
  {41.822,-21.993,62.799},
  {40.368,-26.166,61.765},
  {41.602,-24.531,63.386},
  {42.642,-25.464,65.575}
 };

static ROTCOOSTRU TYR_rot4[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {35.891,-21.371,57.238},
  {33.878,-21.848,55.619},
  {35.370,-20.415,59.634},
  {31.393,-21.370,56.363},
  {32.908,-19.935,60.393},
  {30.933,-20.408,58.751},
  {28.505,-19.874,59.502}
 };

static ROTCOOSTRU TYR_rot5[12] = {
  {38.637,-18.378,53.256},
  {39.849,-19.328,55.524},
  {42.574,-19.878,54.929},
  {43.245,-20.303,52.740},
  {38.569,-21.770,56.393},
  {35.912,-21.361,57.297},
  {35.049,-18.958,57.914},
  {34.283,-23.401,57.634},
  {32.615,-18.591,58.863},
  {31.861,-23.057,58.574},
  {31.042,-20.654,59.191},
  {28.658,-20.342,60.171}
 };

static ROTCOOSTRU TYRH_rot0[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {36.522,-21.418,56.684},
  {39.435,-22.407,58.195},
  {42.244,-25.345,56.157},
  {35.450,-22.877,52.440},
  {42.777,-28.738,52.895},
  {35.967,-26.219,49.226},
  {41.230,-30.404,49.412}
 };

static ROTCOOSTRU TYRH_rot1[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {36.494,-21.475,56.483},
  {39.287,-22.294,58.293},
  {40.862,-21.681,51.803},
  {37.354,-26.728,57.122},
  {41.491,-25.299,48.810},
  {37.974,-30.296,54.181},
  {40.841,-29.357,48.168}
 };

static ROTCOOSTRU TYRH_rot2[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {38.731,-23.217,54.883},
  {36.544,-21.392,56.789},
  {37.832,-20.250,61.239},
  {41.896,-25.692,56.773},
  {39.928,-21.916,65.147},
  {43.960,-27.340,60.618},
  {42.689,-24.641,66.648}
 };

static ROTCOOSTRU TYRH_rot3[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {38.890,-23.271,54.964},
  {36.510,-21.437,56.612},
  {40.960,-19.081,60.053},
  {38.383,-26.576,58.251},
  {42.797,-20.704,64.106},
  {40.186,-28.181,62.244},
  {43.447,-24.074,66.457}
 };

static ROTCOOSTRU TYRH_rot4[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {39.636,-22.579,58.008},
  {38.544,-23.145,54.810},
  {34.267,-22.614,53.726},
  {36.924,-20.029,60.960},
  {29.808,-21.751,55.073},
  {32.535,-19.181,62.294},
  {27.379,-20.292,58.118}
 };

static ROTCOOSTRU TYRH_rot5[9] = {
  {38.277,-19.688,51.943},
  {39.757,-17.824,56.983},
  {39.663,-22.604,57.977},
  {38.501,-23.127,54.796},
  {36.316,-17.332,57.645},
  {34.910,-25.323,57.151},
  {31.943,-16.685,59.349},
  {30.601,-24.692,58.825},
  {28.417,-18.558,60.516}
};

static ROTCOOSTRU *TYR_rotarr[6] = {TYR_rot0,TYR_rot1,TYR_rot2,TYR_rot3,TYR_rot4,TYR_rot5};
static ROTCOOSTRU *TYRH_rotarr[6] = {TYRH_rot0,TYRH_rot1,TYRH_rot2,TYRH_rot3,TYRH_rot4,TYRH_rot5};

static int TRP_PDB[14] = { 0, 1, 2, 3, 4, 5, 9, 10, 13, 14, 15, 17, 18, 22 };
static short int TRP_PMF[14] = { 10, 2, 4, 6, 2, 4, 4, 3, 3, 3, 3, 3, 3, 9 }; 
static int TRPH_PDB[10] = { 0, 3, 6, 7, 21, 30, 36, 45, 48, 57 }; 
static short int TRPH_PMF[10] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int TRP_NUMC[2] = {14,10};

static ROTCOOSTRU TRP_rot0[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {34.346,1.120,32.516},
  {36.214,-0.645,32.723},
  {35.583,3.523,32.285},
  {38.209,3.061,32.364},
  {34.723,6.011,32.012},
  {39.106,7.429,31.926},
  {39.996,5.011,32.188},
  {36.507,7.952,31.838},
  {38.544,0.508,32.635}
 };

static ROTCOOSTRU TRP_rot1[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {34.302,1.331,32.496},
  {35.855,1.317,30.438},
  {35.829,2.092,34.604},
  {38.293,2.512,33.674},
  {35.346,2.464,37.180},
  {39.767,3.631,37.756},
  {40.286,3.283,35.242},
  {37.335,3.231,38.740},
  {38.261,2.024,31.132}
 };

static ROTCOOSTRU TRP_rot2[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {34.344,1.133,32.515},
  {35.519,3.410,32.236},
  {36.309,-0.724,32.729},
  {38.633,0.575,32.566},
  {36.325,-3.351,33.050},
  {40.931,-3.246,33.015},
  {40.967,-0.675,32.704},
  {38.652,-4.594,33.186},
  {38.101,3.090,32.263}
 };

static ROTCOOSTRU TRP_rot3[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.428,2.863,33.890},
  {31.489,5.189,34.217},
  {28.008,2.944,35.113},
  {27.732,5.391,36.138},
  {26.052,1.189,35.430},
  {23.682,4.377,37.765},
  {25.567,6.129,37.477},
  {23.896,1.928,36.765},
  {29.879,6.721,35.570}
 };

static ROTCOOSTRU TRP_rot4[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.361,2.802,33.930},
  {28.081,3.887,33.413},
  {31.393,4.155,36.043},
  {29.623,6.037,36.706},
  {33.634,3.950,37.436},
  {32.240,7.485,40.042},
  {30.032,7.722,38.710},
  {34.039,5.632,39.432},
  {27.623,5.837,35.074}
 };

static ROTCOOSTRU TRP_rot5[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.507,2.929,33.843},
  {28.352,3.046,35.254},
  {31.541,5.436,33.813},
  {29.905,6.974,35.254},
  {33.691,6.521,32.715},
  {32.465,10.578,34.522},
  {30.351,9.561,35.619},
  {34.131,9.100,33.080},
  {27.976,5.474,36.108}
 };

static ROTCOOSTRU TRP_rot6[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.791,-1.230,34.503},
  {28.784,-1.058,36.112},
  {32.034,-3.572,35.074},
  {30.665,-4.721,37.054},
  {34.162,-4.806,34.098},
  {33.457,-8.225,37.105},
  {31.366,-7.057,38.091},
  {34.859,-7.134,35.134},
  {28.696,-3.151,37.655}
 };

static ROTCOOSTRU TRP_rot7[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.844,-1.267,34.487},
  {29.214,-3.240,34.174},
  {31.707,-1.385,37.056},
  {30.517,-3.489,38.185},
  {33.373,0.078,38.501},
  {32.570,-2.700,42.088},
  {30.935,-4.164,40.713},
  {33.787,-0.597,41.021},
  {29.005,-4.585,36.391}
 };

static ROTCOOSTRU TRP_rot8[14] = {
  {31.572,-2.090,28.843},
  {30.428,0.163,29.937},
  {30.823,2.449,28.204},
  {29.024,3.783,27.554},
  {31.566,0.656,32.556},
  {30.888,-1.296,34.473},
  {32.356,-3.261,35.269},
  {28.543,-1.495,35.823},
  {28.733,-3.631,37.409},
  {26.313,-0.069,35.846},
  {24.594,-2.964,38.992},
  {26.758,-4.388,39.007},
  {24.346,-0.827,37.439},
  {31.071,-4.676,37.034}
};

static ROTCOOSTRU TRPH_rot0[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {31.228,-1.008,33.787},
  {30.661,2.349,33.401},
  {35.938,-2.695,32.931},
  {40.319,-0.372,32.752},
  {32.694,6.454,31.933},
  {42.043,4.657,32.254},
  {35.880,9.923,31.629},
  {40.484,8.979,31.782}
 };

static ROTCOOSTRU TRPH_rot1[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {31.373,-1.068,33.735},
  {30.549,2.247,33.469},
  {35.304,0.821,28.497},
  {39.848,2.181,29.952},
  {33.452,2.167,37.982},
  {42.210,3.607,34.524},
  {37.007,3.531,40.771},
  {41.309,4.238,39.010}
 };

static ROTCOOSTRU TRPH_rot2[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {31.237,-1.013,33.784},
  {30.654,2.343,33.405},
  {34.578,5.251,32.019},
  {39.483,4.503,32.084},
  {34.557,-4.436,33.194},
  {42.781,0.331,32.572},
  {38.716,-6.657,33.431},
  {42.745,-4.254,33.129}
 };

static ROTCOOSTRU TRPH_rot3[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {33.620,1.033,32.364},
  {31.273,-1.028,33.772},
  {33.352,5.790,33.519},
  {30.192,8.606,36.107},
  {26.186,-0.735,34.654},
  {25.348,8.033,38.283},
  {22.336,0.583,37.046},
  {21.970,4.927,38.807}
 };

static ROTCOOSTRU TRPH_rot4[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {33.605,1.107,32.357},
  {31.339,-1.056,33.748},
  {26.773,3.316,31.901},
  {26.024,7.010,35.128},
  {35.060,2.506,36.988},
  {28.658,9.194,39.228},
  {35.787,5.515,40.552},
  {32.588,8.791,41.622}
 };

static ROTCOOSTRU TRPH_rot5[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {33.635,0.948,32.373},
  {31.198,-0.994,33.798},
  {27.078,1.457,35.669},
  {26.476,6.128,37.231},
  {35.019,5.390,31.585},
  {29.078,10.766,36.737},
  {35.803,9.999,32.233},
  {32.843,12.604,34.794}
 };

static ROTCOOSTRU TRPH_rot6[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {30.956,2.544,33.236},
  {33.659,0.598,32.429},
  {27.416,0.506,36.195},
  {27.364,-3.534,39.075},
  {35.278,-3.981,32.550},
  {30.306,-7.956,39.637},
  {36.527,-8.138,34.405},
  {34.030,-10.060,37.895}
 };

static ROTCOOSTRU TRPH_rot7[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {30.915,2.522,33.259},
  {33.659,0.649,32.419},
  {28.198,-3.717,32.424},
  {27.888,-6.192,36.713},
  {34.347,1.727,37.694},
  {30.006,-5.799,41.600},
  {35.081,0.525,42.199},
  {32.921,-3.207,44.074}
 };

static ROTCOOSTRU TRPH_rot8[10] = {
  {33.050,-2.809,29.776},
  {28.365,-0.178,30.105},
  {30.882,2.503,33.276},
  {33.658,0.690,32.412},
  {34.284,-3.684,34.619},
  {31.725,-6.298,37.972},
  {26.090,1.613,34.647},
  {26.897,-6.054,40.241},
  {22.573,0.256,37.488},
  {23.029,-3.531,40.237}
};

static ROTCOOSTRU *TRP_rotarr[9] = {TRP_rot0,TRP_rot1,TRP_rot2,TRP_rot3,TRP_rot4,TRP_rot5,TRP_rot6,TRP_rot7,TRP_rot8};
static ROTCOOSTRU *TRPH_rotarr[9] = {TRPH_rot0,TRPH_rot1,TRPH_rot2,TRPH_rot3,TRPH_rot4,TRPH_rot5,TRPH_rot6,TRPH_rot7,TRPH_rot8};


typedef struct { ROTCOOSTRU **coo;
		 ROTCOOSTRU **cooh;
		 short int *ipdbt;
		 short int *ipdbth;
		 int *pdb;
		 int *pdbh;
		 int *numc;
		 int nrots;
		} ROTAMERSTRU;

static ROTAMERSTRU aminorots[20] = { 
	{GLY_rotarr,GLYH_rotarr,GLY_PMF,GLYH_PMF,GLY_PDB,GLYH_PDB,GLY_NUMC,1}, 
	{ALA_rotarr,ALAH_rotarr,ALA_PMF,ALAH_PMF,ALA_PDB,ALAH_PDB,ALA_NUMC,1},
	{SER_rotarr,SERH_rotarr,SER_PMF,SERH_PMF,SER_PDB,SERH_PDB,SER_NUMC,3},
	{CYS_rotarr,CYSH_rotarr,CYS_PMF,CYSH_PMF,CYS_PDB,CYSH_PDB,CYS_NUMC,3},
	{THR_rotarr,THRH_rotarr,THR_PMF,THRH_PMF,THR_PDB,THRH_PDB,THR_NUMC,3},
	{ILE_rotarr,ILEH_rotarr,ILE_PMF,ILEH_PMF,ILE_PDB,ILEH_PDB,ILE_NUMC,9},
	{VAL_rotarr,VALH_rotarr,VAL_PMF,VALH_PMF,VAL_PDB,VALH_PDB,VAL_NUMC,3},
	{MET_rotarr,METH_rotarr,MET_PMF,METH_PMF,MET_PDB,METH_PDB,MET_NUMC,27},
	{ASP_rotarr,ASPH_rotarr,ASP_PMF,ASPH_PMF,ASP_PDB,ASPH_PDB,ASP_NUMC,9},
	{ASN_rotarr,ASNH_rotarr,ASN_PMF,ASNH_PMF,ASN_PDB,ASNH_PDB,ASN_NUMC,18},
	{LEU_rotarr,LEUH_rotarr,LEU_PMF,LEUH_PMF,LEU_PDB,LEUH_PDB,LEU_NUMC,9},
	{LYS_rotarr,LYSH_rotarr,LYS_PMF,LYSH_PMF,LYS_PDB,LYSH_PDB,LYS_NUMC,81},
	{GLU_rotarr,GLUH_rotarr,GLU_PMF,GLUH_PMF,GLU_PDB,GLUH_PDB,GLU_NUMC,27},
	{GLN_rotarr,GLNH_rotarr,GLN_PMF,GLNH_PMF,GLN_PDB,GLNH_PDB,GLN_NUMC,36},
	{PRO_rotarr,PROH_rotarr,PRO_PMF,PROH_PMF,PRO_PDB,PROH_PDB,PRO_NUMC,2},
	{ARG_rotarr,ARGH_rotarr,ARG_PMF,ARGH_PMF,ARG_PDB,ARGH_PDB,ARG_NUMC,81},
	{HIS_rotarr,HISH_rotarr,HIS_PMF,HISH_PMF,HIS_PDB,HISH_PDB,HIS_NUMC,9},
	{PHE_rotarr,PHEH_rotarr,PHE_PMF,PHEH_PMF,PHE_PDB,PHEH_PDB,PHE_NUMC,6},
	{TYR_rotarr,TYRH_rotarr,TYR_PMF,TYRH_PMF,TYR_PDB,TYRH_PDB,TYR_NUMC,6},
	{TRP_rotarr,TRPH_rotarr,TRP_PMF,TRPH_PMF,TRP_PDB,TRPH_PDB,TRP_NUMC,9}
};

static int RGLY_PDB[4] = { 0, 1, 2, 3 };
static short int RGLY_PMF[4] = { 10, 2, 4, 6 }; 
static int RGLYH_PDB[3] = { 0, 3, 4 };
static short int RGLYH_PMF[3] = { 1, 1, 1 };
static int RGLY_NUMC[2] = {4,3};

static ROTCOOSTRU RGLY_rot0[4] = {
  {66.212,-17.017,54.606},
  {65.300,-19.013,52.958},
  {62.431,-19.011,52.997},
  {61.203,-19.341,51.051}
};

static ROTCOOSTRU RGLYH_rot0[3] = {
  {67.051,-17.560,56.210},
  {65.877,-18.631,51.244},
  {65.909,-20.621,53.634}
};

static ROTCOOSTRU *RGLY_rotarr[1] = {RGLY_rot0};
static ROTCOOSTRU *RGLYH_rotarr[1] = {RGLYH_rot0};

static int RALA_PDB[5] = { 0, 1, 2, 3, 4 }; 
static short int RALA_PMF[5] = { 10, 2, 4, 6, 2 };
static int RALAH_PDB[5] = { 0, 3, 6, 7, 8 };
static short int RALAH_PMF[5] = { 1, 1, 1, 1, 1 };
static int RALA_NUMC[2] = {5,5};

static ROTCOOSTRU RALA_rot0[5] = {
  {11.652,11.773,32.254},
  {13.404,10.505,30.551},
  {15.796,9.732,31.978},
  {16.630,7.566,31.815},
  {14.088,12.238,28.353}
};

static ROTCOOSTRU RALAH_rot0[5] = {
  {11.175,13.551,31.828},
  {12.574,8.974,29.932},
  {12.537,12.736,27.433},
  {15.240,11.347,27.179},
  {14.938,13.774,28.999}
};

static ROTCOOSTRU *RALA_rotarr[1] = {RALA_rot0};
static ROTCOOSTRU *RALAH_rotarr[1] = {RALAH_rot0};

static int RSER_PDB[6] = { 0, 1, 2, 3, 4, 30 };
static short int RSER_PMF[6] = { 10, 2, 4, 6, 2, 7 };
static int RSERH_PDB[5] = { 0, 3, 6, 7, 9 }; 
static short int RSERH_PMF[5] = { 1, 1, 1, 1, 1 };
static int RSER_NUMC[2] = {6,5};

static ROTCOOSTRU RSER_rot0[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.467,6.481,6.323}
};

static ROTCOOSTRU RSER_rot1[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.241,4.435,7.017}
};

static ROTCOOSTRU RSER_rot2[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.457,3.821,3.330}
};

static ROTCOOSTRU RSERH_rot0[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.122,3.910,3.867},
 {8.693,4.301,6.793},
 {6.439,7.934,5.607}
};

static ROTCOOSTRU RSERH_rot1[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.697,5.924,6.243},
 {6.984,3.984,3.841},
 {10.134,5.932,6.286}
};

static ROTCOOSTRU RSERH_rot2[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.531,4.517,7.037},
 {5.632,5.902,6.108},
 {8.387,5.331,2.677}
};

static ROTCOOSTRU *RSER_rotarr[3] = {RSER_rot0,RSER_rot1,RSER_rot2};
static ROTCOOSTRU *RSERH_rotarr[3] = {RSERH_rot0,RSERH_rot1,RSERH_rot2};

static int RCYS_PDB[6] = { 0, 1, 2, 3, 4, 36 };
static short int RCYS_PMF[6] = { 10, 2, 4, 6, 2, 13 };
static int RCYSH_PDB[5] = { 0, 3, 6, 7, 9 }; 
static short int RCYSH_PMF[5] = { 1, 1, 1, 1, 1 };
static int RCYS_NUMC[2] = {6,5};

static ROTCOOSTRU RCYS_rot0[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.227,7.228,6.352}
};

static ROTCOOSTRU RCYS_rot1[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.964,4.660,7.223}
};

static ROTCOOSTRU RCYS_rot2[6] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.725,3.889,2.595}
};

static ROTCOOSTRU RCYSH_rot0[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.122,3.910,3.867},
 {8.693,4.301,6.793},
 {3.106,6.869,7.539}
};

static ROTCOOSTRU RCYSH_rot1[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.697,5.924,6.243},
 {6.984,3.984,3.841},
 {10.417,2.906,8.883}
};

static ROTCOOSTRU RCYSH_rot2[5] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.531,4.517,7.037},
 {5.632,5.902,6.108},
 {6.960,1.716,1.741}
};

static ROTCOOSTRU *RCYS_rotarr[3] = {RCYS_rot0,RCYS_rot1,RCYS_rot2};
static ROTCOOSTRU *RCYSH_rotarr[3] = {RCYSH_rot0,RCYSH_rot1,RCYSH_rot2};

static int RTHR_PDB[7] = { 0, 1, 2, 3, 4, 7, 31 };
static short int RTHR_PMF[7] = { 10, 2, 4, 6, 2, 2, 7 }; 
static int RTHRH_PDB[7] = { 0, 3, 6, 12, 15, 16, 17 };
static short int RTHRH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 };
static int RTHR_NUMC[2] = {7,7};

static ROTCOOSTRU RTHR_rot0[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {7.267,3.974,3.112},
 {5.451,6.493,6.427}
};

static ROTCOOSTRU RTHR_rot1[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {5.466,6.668,6.560},
 {9.315,4.312,7.073}
};

static ROTCOOSTRU RTHR_rot2[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {9.275,4.628,7.443},
 {7.491,3.810,3.346}
};

static ROTCOOSTRU RTHRH_rot0[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.698,4.314,6.902},
 {5.197,6.693,8.289},
 {8.315,5.626,2.412},
 {8.356,2.247,2.721},
 {5.427,3.864,2.151}
};

static ROTCOOSTRU RTHRH_rot1[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.022,4.034,3.882},
 {10.256,2.727,6.654},
 {6.539,8.284,5.814},
 {3.578,6.630,5.691},
 {5.274,6.857,8.621}
};

static ROTCOOSTRU RTHRH_rot2[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.651,5.913,6.123},
 {5.909,3.575,2.340},
 {10.297,6.272,6.685},
 {8.808,4.965,9.440},
 {10.474,2.937,7.289}
};

static ROTCOOSTRU *RTHR_rotarr[3] = {RTHR_rot0,RTHR_rot1,RTHR_rot2};
static ROTCOOSTRU *RTHRH_rotarr[3] = {RTHRH_rot0,RTHRH_rot1,RTHRH_rot2};

static int RILE_PDB[8] = { 0, 1, 2, 3, 4, 6, 7, 9 };
static short int RILE_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 2 };
static int RILEH_PDB[11] = { 0, 3, 6, 12, 13, 15, 16, 17, 21, 22, 23 };
static short int RILEH_PMF[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RILE_NUMC[2] = {8,11};

static ROTCOOSTRU RILE_rot0[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {5.386,6.668,6.442},
 {7.267,3.974,3.112},
 {6.320,8.135,8.709}
};

static ROTCOOSTRU RILE_rot1[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {5.386,6.668,6.442},
 {7.267,3.974,3.112},
 {6.880,9.043,5.907}
};

static ROTCOOSTRU RILE_rot2[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {9.455,4.405,7.197},
 {5.420,6.661,6.478},
 {11.201,2.240,6.540}
};

static ROTCOOSTRU RILE_rot3[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {9.455,4.405,7.197},
 {5.420,6.661,6.478},
 {11.267,6.155,5.850}
};

static ROTCOOSTRU RILE_rot4[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {7.552,3.818,3.169},
 {9.275,4.628,7.443},
 {5.817,5.156,1.335}
};

static ROTCOOSTRU RILEH_rot0[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.689,4.297,6.920},
 {5.501,7.882,4.759},
 {3.378,6.205,6.719},
 {8.315,5.626,2.412},
 {8.356,2.247,2.721},
 {5.427,3.864,2.151},
 {5.176,9.855,8.942},
 {6.154,6.957,10.414},
 {8.310,8.661,8.423}
};

static ROTCOOSTRU RILEH_rot1[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.689,4.297,6.920},
 {3.668,6.674,5.272},
 {4.767,6.693,8.427},
 {8.315,5.626,2.412},
 {8.356,2.247,2.721},
 {5.427,3.864,2.151},
 {5.703,10.709,6.307},
 {8.572,9.086,7.114},
 {7.455,9.066,3.909}
};

static ROTCOOSTRU RILEH_rot2[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.075,3.975,3.894},
 {10.356,6.192,6.637},
 {9.209,4.471,9.261},
 {6.493,8.277,5.733},
 {3.557,6.583,5.558},
 {5.169,6.883,8.530},
 {13.022,2.500,7.507},
 {10.343,0.448,7.150},
 {11.508,2.196,4.485}
};

static ROTCOOSTRU RILEH_rot3[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.075,3.975,3.894},
 {9.219,5.056,9.157},
 {10.293,2.505,7.287},
 {6.493,8.277,5.733},
 {3.557,6.583,5.558},
 {5.169,6.883,8.530},
 {13.085,6.182,6.858},
 {11.564,5.484,3.905},
 {10.473,8.076,5.805}
};

static ROTCOOSTRU RILEH_rot4[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.630,5.898,6.127},
 {9.500,4.475,2.857},
 {7.526,1.781,2.759},
 {10.297,6.272,6.685},
 {8.808,4.965,9.440},
 {10.474,2.937,7.289},
 {6.437,4.773,-0.612},
 {3.873,4.466,1.590},
 {5.878,7.203,1.690}
};

static ROTCOOSTRU *RILE_rotarr[9] = {RILE_rot0,RILE_rot1,RILE_rot2,RILE_rot3,RILE_rot4};
static ROTCOOSTRU *RILEH_rotarr[9] = {RILEH_rot0,RILEH_rot1,RILEH_rot2,RILEH_rot3,RILEH_rot4};

static int RVAL_PDB[7] = { 0, 1, 2, 3, 4, 6, 7 };
static short int RVAL_PMF[7] = { 10, 2, 4, 6, 2, 2, 2 };
static int RVALH_PDB[9] = { 0, 3, 6, 12, 13, 14, 15, 16, 17 };
static short int RVALH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 }; 
static int RVAL_NUMC[2] = {7,9};

static ROTCOOSTRU RVAL_rot0[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {5.420,6.661,6.478},
 {7.226,3.996,3.104}
};

static ROTCOOSTRU RVAL_rot1[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {9.275,4.628,7.443},
 {5.261,6.611,6.142}
};

static ROTCOOSTRU RVAL_rot2[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.855,4.228,5.945},
 {7.348,3.930,3.129},
 {9.383,4.489,7.287}
};

static ROTCOOSTRU RVALH_rot0[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.702,4.275,6.897},
 {6.493,8.277,5.733},
 {3.557,6.583,5.558},
 {5.169,6.883,8.530},
 {8.262,2.245,2.681},
 {5.373,3.948,2.164},
 {8.312,5.628,2.411}
};

static ROTCOOSTRU RVALH_rot1[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.312,3.846,3.954},
 {10.297,6.272,6.685},
 {8.808,4.965,9.440},
 {10.474,2.937,7.289},
 {3.499,6.358,5.068},
 {4.809,6.981,8.137},
 {6.320,8.221,5.362}
};

static ROTCOOSTRU RVALH_rot2[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.697,5.921,6.284},
 {8.395,5.583,2.429},
 {8.468,2.210,2.799},
 {5.537,3.780,2.120},
 {9.065,4.707,9.330},
 {10.530,2.790,6.943},
 {10.385,6.159,6.561}
};

static ROTCOOSTRU *RVAL_rotarr[3] = {RVAL_rot0,RVAL_rot1,RVAL_rot2};
static ROTCOOSTRU *RVALH_rotarr[3] = {RVALH_rot0,RVALH_rot1,RVALH_rot2};

static int RMET_PDB[8] = { 0, 1, 2, 3, 4, 5, 11, 35 };
static short int RMET_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 13 }; 
static int RMETH_PDB[9] = { 0, 3, 6, 7, 9, 10, 27, 28, 29 };
static short int RMETH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RMET_NUMC[2] = {8,9};

static ROTCOOSTRU RMET_rot0[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {6.656,8.932,1.689},
 {7.218,9.349,5.000}
};

static ROTCOOSTRU RMET_rot1[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {9.672,9.681,7.307},
 {7.218,9.349,5.000}
};

static ROTCOOSTRU RMET_rot2[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {12.246,2.710,3.006},
 {11.564,2.025,6.249}
};

static ROTCOOSTRU RMET_rot3[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {14.384,3.051,7.814},
 {11.564,2.025,6.249}
};

static ROTCOOSTRU RMET_rot4[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {9.452,9.801,7.267},
 {11.063,7.265,5.707}
};

static ROTCOOSTRU RMET_rot5[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {13.994,7.126,7.393},
 {11.063,7.265,5.707}
};

static ROTCOOSTRU RMET_rot6[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.924,6.077,2.657},
 {11.063,7.265,5.707}
};

static ROTCOOSTRU RMET_rot7[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {12.319,6.227,3.504},
 {9.322,6.604,1.977}
};

static ROTCOOSTRU RMET_rot8[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.990,5.603,-1.186},
 {9.322,6.604,1.977}
};

static ROTCOOSTRU RMET_rot9[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {6.771,8.782,1.524},
 {9.322,6.604,1.977}
};

static ROTCOOSTRU RMET_rot10[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.143},
 {7.808,-0.985,1.356},
 {9.814,1.423,2.634}
};

static ROTCOOSTRU RMET_rot11[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.143},
 {10.256,1.630,-0.715},
 {9.814,1.423,2.634}
};

static ROTCOOSTRU RMET_rot12[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.143},
 {12.576,2.734,4.085},
 {9.814,1.423,2.634}
};

static ROTCOOSTRU RMETH_rot0[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.495,4.582,7.071},
 {6.752,4.149,3.824},
 {3.604,6.639,5.391},
 {5.175,7.030,8.317},
 {7.623,10.434,0.626},
 {7.387,7.081,1.089},
 {4.614,9.024,1.315}
};

static ROTCOOSTRU RMETH_rot1[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.495,4.582,7.071},
 {6.752,4.149,3.824},
 {3.604,6.639,5.391},
 {5.175,7.030,8.317},
 {10.921,11.254,6.770},
 {8.829,10.072,9.166},
 {10.776,7.923,7.404}
};

static ROTCOOSTRU RMETH_rot2[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.378,3.809,3.940},
 {5.950,5.961,6.603},
 {10.238,6.360,6.311},
 {9.290,4.741,9.079},
 {13.554,1.280,2.254},
 {10.483,2.681,1.905},
 {13.120,4.591,2.863}
};

static ROTCOOSTRU RMETH_rot3[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.378,3.809,3.940},
 {5.950,5.961,6.603},
 {10.238,6.360,6.311},
 {9.290,4.741,9.079},
 {15.893,1.653,7.512},
 {14.978,4.887,7.041},
 {14.016,3.244,9.851}
};

static ROTCOOSTRU RMETH_rot4[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.378,3.809,3.940},
 {5.950,5.961,6.603},
 {9.285,4.802,9.073},
 {10.572,2.863,6.672},
 {10.252,11.617,6.647},
 {7.430,9.737,6.788},
 {9.683,9.609,9.324}
};

static ROTCOOSTRU RMETH_rot5[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.378,3.809,3.940},
 {5.950,5.961,6.603},
 {9.285,4.802,9.073},
 {10.572,2.863,6.672},
 {15.220,8.691,6.785},
 {13.630,7.284,9.433},
 {14.937,5.316,6.996}
};

static ROTCOOSTRU RMETH_rot6[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {7.378,3.809,3.940},
 {5.950,5.961,6.603},
 {9.285,4.802,9.073},
 {10.572,2.863,6.672},
 {12.955,7.544,1.607},
 {13.137,4.404,2.882},
 {10.208,5.551,1.608}
};

static ROTCOOSTRU RMETH_rot7[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.496,5.788,5.630},
 {8.701,4.312,6.774},
 {8.865,2.214,3.015},
 {5.976,3.544,1.983},
 {13.581,7.782,2.948},
 {12.055,6.254,5.566},
 {13.163,4.414,2.937}
};

static ROTCOOSTRU RMETH_rot8[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.496,5.788,5.630},
 {8.701,4.312,6.774},
 {8.865,2.214,3.015},
 {5.976,3.544,1.983},
 {11.035,7.100,-2.181},
 {11.140,3.872,-1.138},
 {8.207,5.223,-2.185}
};

static ROTCOOSTRU RMETH_rot9[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.496,5.788,5.630},
 {8.701,4.312,6.774},
 {8.865,2.214,3.015},
 {5.976,3.544,1.983},
 {7.515,10.576,0.782},
 {5.410,7.985,0.170},
 {5.820,9.125,3.340}
};

static ROTCOOSTRU RMETH_rot10[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.510,5.810,5.694},
 {8.726,4.273,6.724},
 {5.867,3.563,2.005},
 {8.379,5.720,2.470},
 {8.937,-2.680,0.938},
 {6.330,-1.462,2.738},
 {6.923,-0.295,-0.394}
};

static ROTCOOSTRU RMETH_rot11[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.510,5.810,5.694},
 {8.726,4.273,6.724},
 {5.867,3.563,2.005},
 {8.379,5.720,2.470},
 {11.614,0.180,-1.327},
 {8.438,1.323,-1.675},
 {10.988,3.513,-1.203}
};

static ROTCOOSTRU RMETH_rot12[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.510,5.810,5.694},
 {8.726,4.273,6.724},
 {5.867,3.563,2.005},
 {8.379,5.720,2.470},
 {14.151,1.388,3.922},
 {13.083,4.511,3.132},
 {12.192,3.111,6.093}
};


static ROTCOOSTRU *RMET_rotarr[27] = {RMET_rot0,RMET_rot1,RMET_rot2,RMET_rot3,RMET_rot4,RMET_rot5,RMET_rot6,RMET_rot7,RMET_rot8,RMET_rot9,RMET_rot10,RMET_rot11,RMET_rot12};

static ROTCOOSTRU *RMETH_rotarr[27] = {RMETH_rot0,RMETH_rot1,RMETH_rot2,RMETH_rot3,RMETH_rot4,RMETH_rot5,RMETH_rot6,RMETH_rot7,RMETH_rot8,RMETH_rot9,RMETH_rot10,RMETH_rot11,RMETH_rot12};

static int RASP_PDB[8] = { 0, 1, 2, 3, 4, 5, 28, 29 };
static short int RASP_PMF[8] = { 10, 2, 4, 6, 2, 4, 8, 8 }; 
static int RASPH_PDB[4] = { 0, 3, 6, 7 };
static short int RASPH_PMF[4] = { 1, 1, 1, 1 };
static int RASP_NUMC[2] = {8,4};

static ROTCOOSTRU RASP_rot0[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.427,6.677,6.318},
 {3.204,6.595,7.111},
 {6.561,8.697,5.853}
};

static ROTCOOSTRU RASP_rot1[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.427,6.677,6.318},
 {4.043,6.880,8.221},
 {5.721,8.412,4.742}
};

static ROTCOOSTRU RASP_rot2[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.423,4.512,7.053},
 {10.119,2.953,8.685},
 {10.771,6.309,6.323}
};

static ROTCOOSTRU RASP_rot3[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.423,4.512,7.053},
 {11.032,2.830,6.652},
 {9.858,6.432,8.357}
};

static ROTCOOSTRU RASP_rot4[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.733,3.770,3.222},
 {7.745,1.561,2.385},
 {8.438,5.637,1.957}
};

static ROTCOOSTRU RASPH_rot0[4] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.319,6.789},
 {7.124,3.929,3.864}
};

static ROTCOOSTRU RASPH_rot1[4] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.319,6.789},
 {7.124,3.929,3.864}
};

static ROTCOOSTRU RASPH_rot2[4] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.999,3.997,3.841},
 {5.713,5.935,6.240}
};

static ROTCOOSTRU RASPH_rot3[4] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.999,3.997,3.841},
 {5.713,5.935,6.240}
};

static ROTCOOSTRU RASPH_rot4[4] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.579,5.877,5.939},
 {8.446,4.631,7.121}
};


static ROTCOOSTRU *RASP_rotarr[9] = {RASP_rot0,RASP_rot1,RASP_rot2,RASP_rot3,RASP_rot4};
static ROTCOOSTRU *RASPH_rotarr[9] = {RASPH_rot0,RASPH_rot1,RASPH_rot2,RASPH_rot3,RASPH_rot4};

static int RASN_PDB[8] = { 0, 1, 2, 3, 4, 5, 20, 28 };
static short int RASN_PMF[8] = { 10, 2, 4, 6, 2, 4, 10, 6 };
static int RASNH_PDB[6] = { 0, 3, 6, 7, 24, 25 }; 
static short int RASNH_PMF[6] = { 1, 1, 1, 1, 1, 1 };
static int RASN_NUMC[2] = {8,6};

static ROTCOOSTRU RASN_rot0[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.427,6.677,6.318},
 {6.701,8.775,5.800},
 {3.237,6.694,7.096}
};

static ROTCOOSTRU RASN_rot1[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.427,6.677,6.318},
 {5.793,8.467,4.600},
 {4.044,6.968,8.163}
};

static ROTCOOSTRU RASN_rot2[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.474,4.432,6.951},
 {11.087,5.812,5.617},
 {10.062,3.377,8.937}
};

static ROTCOOSTRU RASN_rot3[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.423,4.512,7.053},
 {10.310,6.853,7.202},
 {10.619,2.663,7.797}
};

static ROTCOOSTRU RASN_rot4[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.534,3.861,3.149},
 {8.057,5.949,1.862},
 {7.614,1.742,2.198}
};

static ROTCOOSTRU RASN_rot5[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.534,3.861,3.149},
 {6.183,5.150,1.475},
 {9.280,2.453,2.542}
};

static ROTCOOSTRU RASN_rot6[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.534,3.861,3.149},
 {9.014,1.908,2.619},
 {6.763,5.334,1.524}
};

static ROTCOOSTRU RASNH_rot0[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.319,6.789},
 {7.124,3.929,3.864},
 {8.480,8.669,5.172},
 {5.881,10.461,6.039}
};

static ROTCOOSTRU RASNH_rot1[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.319,6.789},
 {7.124,3.929,3.864},
 {6.936,8.145,3.129},
 {4.926,10.136,4.775}
};

static ROTCOOSTRU RASNH_rot2[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.911,4.048,3.831},
 {5.762,5.946,6.330},
 {10.524,6.636,4.012},
 {12.866,6.029,6.216}
};

static ROTCOOSTRU RASNH_rot3[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.999,3.997,3.841},
 {5.713,5.935,6.240},
 {9.270,8.299,6.571},
 {12.018,7.170,7.944}
};

static ROTCOOSTRU RASNH_rot4[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.642,5.911,6.094},
 {8.539,4.527,7.022},
 {7.967,7.633,2.716},
 {8.541,5.838,0.039}
};

static ROTCOOSTRU RASNH_rot5[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.642,5.911,6.094},
 {8.539,4.527,7.022},
 {4.779,6.273,2.057},
 {6.568,4.997,-0.369}
};

static ROTCOOSTRU RASNH_rot6[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.642,5.911,6.094},
 {8.539,4.527,7.022},
 {9.595,0.760,4.003},
 {9.549,1.584,0.836}
};


static ROTCOOSTRU *RASN_rotarr[18] = {RASN_rot0,RASN_rot1,RASN_rot2,RASN_rot3,RASN_rot4,RASN_rot5,RASN_rot6};

static ROTCOOSTRU *RASNH_rotarr[18] = {RASNH_rot0,RASNH_rot1,RASNH_rot2,RASNH_rot3,RASNH_rot4,RASNH_rot5,RASNH_rot6};

static int RLEU_PDB[8] = { 0, 1, 2, 3, 4, 5, 9, 10 };
static short int RLEU_PMF[8] = { 10, 2, 4, 6, 2, 2, 2, 2 };
static int RLEUH_PDB[11] = { 0, 3, 6, 7, 9, 21, 22, 23, 24, 25, 26 };
static short int RLEUH_PMF[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RLEU_NUMC[2] = {8,11};

static ROTCOOSTRU RLEU_rot0[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.555,6.787,6.235},
 {5.997,7.799,8.889},
 {6.621,8.690,4.363}
};

static ROTCOOSTRU RLEU_rot1[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.471,4.665,6.955},
 {11.230,2.504,6.250},
 {10.577,7.099,5.901}
};

static ROTCOOSTRU RLEU_rot2[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.550,4.536,6.787},
 {11.183,5.597,4.673},
 {9.685,6.345,9.016}
};

static ROTCOOSTRU RLEU_rot3[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {8.378,3.732,3.514},
 {6.672,3.042,1.306},
 {9.871,6.079,2.791}
};

static ROTCOOSTRU RLEU_rot4[8] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.619,4.027,3.129},
 {8.808,6.493,2.253},
 {9.546,1.926,2.763}
};

static ROTCOOSTRU RLEUH_rot0[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.278,6.793},
 {7.125,3.888,3.870},
 {3.519,6.534,5.903},
 {5.075,9.651,9.087},
 {5.197,6.475,10.278},
 {8.039,8.002,9.223},
 {5.689,10.528,4.635},
 {8.666,8.898,4.674},
 {6.280,8.021,2.424}
};

static ROTCOOSTRU RLEUH_rot1[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.964,3.975,3.841},
 {5.678,5.913,6.239},
 {9.308,4.800,9.023},
 {13.124,2.870,7.025},
 {10.494,0.725,7.034},
 {11.347,2.351,4.180},
 {12.481,7.391,6.681},
 {10.690,6.970,3.829},
 {9.360,8.700,6.429}
};

static ROTCOOSTRU RLEUH_rot2[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.815,4.062,3.828},
 {5.761,5.930,6.388},
 {10.253,2.663,7.354},
 {13.136,5.818,5.349},
 {11.154,4.294,3.053},
 {10.441,7.448,4.086},
 {11.663,6.554,9.622},
 {8.936,8.200,8.451},
 {8.555,5.592,10.590}
};

static ROTCOOSTRU RLEUH_rot3[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.441,5.711,5.494},
 {8.087,4.934,7.378},
 {9.680,2.164,3.921},
 {7.829,2.708,-0.388},
 {5.605,1.317,1.766},
 {5.345,4.599,0.941},
 {10.977,5.696,1.073},
 {8.560,7.652,2.434},
 {11.157,6.588,4.343}
};

static ROTCOOSTRU RLEUH_rot4[11] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.624,5.894,6.128},
 {8.519,4.511,7.056},
 {5.914,3.625,2.010},
 {9.369,6.323,0.259},
 {7.431,8.037,2.454},
 {10.484,6.906,3.411},
 {10.096,1.829,0.761},
 {11.226,2.315,3.924},
 {8.712,0.111,3.340}
};


static ROTCOOSTRU *RLEU_rotarr[9] = {RLEU_rot0,RLEU_rot1,RLEU_rot2,RLEU_rot3,RLEU_rot4};

static ROTCOOSTRU *RLEUH_rotarr[9] = {RLEUH_rot0,RLEUH_rot1,RLEUH_rot2,RLEUH_rot3,RLEUH_rot4};

static int RLYS_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 11, 26 };
static short int RLYS_PMF[9] = { 10, 2, 4, 6, 2, 2, 2, 2, 11 }; 
static int RLYSH_PDB[13] = { 0, 3, 6, 7, 9, 10, 18, 19, 27, 28, 39, 40, 41 };
static short int RLYSH_PMF[13] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RLYS_NUMC[2] = {9,13};

static ROTCOOSTRU RLYS_rot0[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {7.095,8.745,2.311},
 {8.581,10.862,1.200}
};

static ROTCOOSTRU RLYS_rot1[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {5.662,11.404,5.561},
 {5.458,12.080,8.287}
};

static ROTCOOSTRU RLYS_rot2[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {5.662,11.404,5.561},
 {7.132,13.551,4.486}
};

static ROTCOOSTRU RLYS_rot3[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {5.662,11.404,5.561},
 {3.233,11.527,4.143}
};

static ROTCOOSTRU RLYS_rot4[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {9.427,9.324,6.654},
 {10.938,11.448,5.590}
};

static ROTCOOSTRU RLYS_rot5[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.216,2.460,6.215},
 {13.839,2.826,7.327},
 {13.826,2.634,10.136}
};

static ROTCOOSTRU RLYS_rot6[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.216,2.460,6.215},
 {13.839,2.826,7.327},
 {15.601,0.767,6.560}
};

static ROTCOOSTRU RLYS_rot7[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.216,2.460,6.215},
 {13.839,2.826,7.327},
 {15.093,5.138,6.321}
};

static ROTCOOSTRU RLYS_rot8[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {9.465,9.303,6.661},
 {9.684,9.753,9.432}
};

static ROTCOOSTRU RLYS_rot9[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {9.465,9.303,6.661},
 {10.729,11.562,5.552}
};

static ROTCOOSTRU RLYS_rot10[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {13.373,7.225,6.979},
 {15.097,5.097,6.325}
};

static ROTCOOSTRU RLYS_rot11[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {13.373,7.225,6.979},
 {14.680,9.461,5.873}
};

static ROTCOOSTRU RLYS_rot12[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {13.373,7.225,6.979},
 {13.274,7.844,9.724}
};

static ROTCOOSTRU RLYS_rot13[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {11.376,6.425,3.098},
 {12.661,8.651,1.950}
};

static ROTCOOSTRU RLYS_rot14[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {11.376,6.425,3.098},
 {13.262,4.362,2.759}
};

static ROTCOOSTRU RLYS_rot15[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {8.512,3.582,3.668},
 {6.969,2.844,1.361},
 {8.663,2.219,-0.872},
 {7.175,1.492,-3.149}
};

static ROTCOOSTRU RLYS_rot16[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {11.587,6.505,3.550},
 {13.342,4.392,2.930}
};

static ROTCOOSTRU RLYS_rot17[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {11.587,6.505,3.550},
 {12.986,8.775,2.647}
};

static ROTCOOSTRU RLYS_rot18[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {9.881,5.898,-0.502},
 {7.684,5.718,-2.253}
};

static ROTCOOSTRU RLYS_rot19[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {9.881,5.898,-0.502},
 {11.262,8.161,-1.449}
};

static ROTCOOSTRU RLYS_rot20[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {9.881,5.898,-0.502},
 {11.775,3.834,-0.792}
};

static ROTCOOSTRU RLYS_rot21[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {7.299,8.479,2.019},
 {8.651,10.772,1.100}
};

static ROTCOOSTRU RLYS_rot22[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {7.299,8.479,2.019},
 {5.311,8.090,0.063}
};

static ROTCOOSTRU RLYS_rot23[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {10.021,1.702,-0.157},
 {11.289,4.019,-1.133}
};

static ROTCOOSTRU RLYS_rot24[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {10.021,1.702,-0.157},
 {11.923,-0.315,-0.648}
};

static ROTCOOSTRU RLYS_rot25[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {10.021,1.702,-0.157},
 {7.801,0.861,-1.672}
};

static ROTCOOSTRU RLYS_rot26[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {11.950,2.629,3.730},
 {13.874,0.622,3.282}
};

static ROTCOOSTRU RLYSH_rot0[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {6.155,10.700,5.756},
 {8.933,8.850,5.943},
 {7.938,6.933,1.737},
 {5.162,8.783,1.550},
 {8.600,10.700,-0.683},
 {7.789,12.509,1.682},
 {10.353,10.801,1.854}
};

static ROTCOOSTRU RLYSH_rot1[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.876,8.956,6.073},
 {7.305,8.566,3.148},
 {6.695,12.901,4.554},
 {3.761,11.312,4.727},
 {4.569,13.739,8.461},
 {4.478,10.744,9.196},
 {7.187,12.211,9.036}
};

static ROTCOOSTRU RLYSH_rot2[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.876,8.956,6.073},
 {7.305,8.566,3.148},
 {3.787,11.335,4.668},
 {5.356,11.725,7.592},
 {6.194,15.166,4.774},
 {8.820,13.646,5.330},
 {7.371,13.286,2.630}
};

static ROTCOOSTRU RLYSH_rot3[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.876,8.956,6.073},
 {7.305,8.566,3.148},
 {5.296,11.693,7.587},
 {6.903,12.952,4.942},
 {2.412,13.203,4.442},
 {3.569,11.312,2.296},
 {2.085,10.149,4.738}
};

static ROTCOOSTRU RLYSH_rot4[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {7.456,8.483,3.192},
 {5.855,10.626,5.197},
 {8.968,9.729,8.640},
 {10.568,7.587,6.636},
 {12.514,11.673,6.609},
 {11.397,11.061,3.798},
 {9.919,13.039,5.649}
};

static ROTCOOSTRU RLYSH_rot5[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.212,6.402,6.394},
 {9.317,4.634,9.087},
 {10.445,0.631,6.834},
 {11.340,2.399,4.141},
 {15.130,1.398,6.543},
 {14.578,4.686,6.764},
 {15.579,2.884,10.793},
 {12.689,3.963,10.853},
 {13.199,0.927,10.649}
};

static ROTCOOSTRU RLYSH_rot6[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.212,6.402,6.394},
 {9.317,4.634,9.087},
 {10.445,0.631,6.834},
 {11.340,2.399,4.141},
 {14.605,4.657,6.709},
 {13.711,2.890,9.400},
 {17.301,1.074,7.326},
 {14.930,-0.894,7.163},
 {15.755,0.738,4.677}
};

static ROTCOOSTRU RLYSH_rot7[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.212,6.402,6.394},
 {9.317,4.634,9.087},
 {10.445,0.631,6.834},
 {11.340,2.399,4.141},
 {13.703,2.958,9.397},
 {15.011,1.163,6.900},
 {16.808,5.312,7.095},
 {15.260,4.999,4.444},
 {14.052,6.656,6.749}
};

static ROTCOOSTRU RLYSH_rot8[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {12.741,6.893,6.463},
 {10.736,6.705,3.795},
 {10.314,10.898,5.633},
 {7.457,9.236,6.128},
 {8.818,11.372,9.878},
 {8.871,8.327,10.368},
 {11.508,9.861,9.911}
};

static ROTCOOSTRU RLYSH_rot9[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {12.741,6.893,6.463},
 {10.736,6.705,3.795},
 {7.473,9.264,6.067},
 {9.478,9.452,8.734},
 {9.832,13.126,6.116},
 {12.527,11.625,6.128},
 {10.676,11.451,3.666}
};

static ROTCOOSTRU RLYSH_rot10[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.892,6.622,3.807},
 {9.605,8.561,6.207},
 {14.180,9.008,6.280},
 {13.234,7.391,9.046},
 {16.798,5.406,7.087},
 {14.389,3.481,7.000},
 {15.263,4.974,4.446}
};

static ROTCOOSTRU RLYSH_rot11[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.892,6.622,3.807},
 {9.605,8.561,6.207},
 {13.227,7.459,9.039},
 {14.514,5.520,6.641},
 {16.393,9.637,6.650},
 {14.856,9.229,4.006},
 {13.668,11.018,6.221}
};

static ROTCOOSTRU RLYSH_rot12[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.892,6.622,3.807},
 {9.605,8.561,6.207},
 {14.492,5.495,6.700},
 {14.351,8.751,5.962},
 {15.030,8.069,10.384},
 {12.297,9.442,9.976},
 {12.427,6.436,10.658}
};

static ROTCOOSTRU RLYSH_rot13[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {9.525,8.529,6.052},
 {12.495,7.264,6.922},
 {12.598,4.753,2.917},
 {9.629,6.017,2.048},
 {13.040,8.294,0.134},
 {11.532,10.162,2.071},
 {14.273,8.995,2.874}
};

static ROTCOOSTRU RLYSH_rot14[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {9.525,8.529,6.052},
 {12.495,7.264,6.922},
 {9.639,5.950,2.060},
 {12.117,8.181,2.270},
 {13.623,4.134,0.918},
 {14.859,4.813,3.663},
 {12.571,2.752,3.469}
};

static ROTCOOSTRU RLYSH_rot15[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.443,5.654,5.319},
 {7.974,5.047,7.411},
 {9.703,5.225,3.215},
 {9.792,2.025,4.178},
 {5.778,1.201,1.815},
 {5.689,4.401,0.851},
 {9.855,3.862,-1.321},
 {9.943,0.664,-0.358},
 {8.353,1.096,-4.573},
 {6.127,-0.031,-2.758},
 {6.045,2.922,-3.647}
};

static ROTCOOSTRU RLYSH_rot16[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {9.347,6.067,0.178},
 {7.895,7.909,2.560},
 {12.455,8.310,2.994},
 {11.294,6.579,5.606},
 {14.983,4.650,3.831},
 {12.575,2.754,3.477},
 {13.647,4.352,1.066}
};

static ROTCOOSTRU RLYSH_rot17[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {9.347,6.067,0.178},
 {7.895,7.909,2.560},
 {11.288,6.647,5.602},
 {12.739,4.806,3.221},
 {14.638,8.901,3.556},
 {13.300,8.626,0.790},
 {11.960,10.325,2.989}
};

static ROTCOOSTRU RLYSH_rot18[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.827,7.885,2.398},
 {10.715,6.555,3.429},
 {11.076,7.506,-1.055},
 {11.048,4.186,-0.679},
 {8.305,5.512,-4.025},
 {6.621,4.228,-1.781},
 {6.648,7.294,-2.128}
};

static ROTCOOSTRU RLYSH_rot19[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.827,7.885,2.398},
 {10.715,6.555,3.429},
 {11.103,4.224,-0.667},
 {8.216,5.553,-1.697},
 {11.775,7.881,-3.246},
 {10.137,9.676,-1.344},
 {12.803,8.448,-0.393}
};

static ROTCOOSTRU RLYSH_rot20[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.827,7.885,2.398},
 {10.715,6.555,3.429},
 {8.224,5.486,-1.687},
 {10.693,7.683,-1.191},
 {12.272,3.685,-2.609},
 {13.303,4.229,0.248},
 {11.023,2.201,-0.210}
};

static ROTCOOSTRU RLYSH_rot21[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {10.612,6.658,3.530},
 {9.900,5.813,0.375},
 {5.738,8.030,0.721},
 {6.450,8.875,3.875},
 {7.438,12.216,0.987},
 {10.040,11.209,2.303},
 {9.383,10.429,-0.609}
};

static ROTCOOSTRU RLYSH_rot22[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {10.612,6.658,3.530},
 {9.900,5.813,0.375},
 {6.398,8.834,3.859},
 {8.408,10.174,1.550},
 {4.199,9.616,-0.018},
 {6.126,7.815,-1.619},
 {4.271,6.578,0.513}
};

static ROTCOOSTRU RLYSH_rot23[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.120,2.334,3.712},
 {8.658,0.106,3.332},
 {11.256,0.058,-0.462},
 {8.278,1.361,-1.237},
 {11.673,3.801,-2.971},
 {10.149,5.508,-0.901},
 {12.898,4.304,-0.185}
};

static ROTCOOSTRU RLYSH_rot24[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.120,2.334,3.712},
 {8.658,0.106,3.332},
 {8.288,1.294,-1.230},
 {10.749,3.522,-0.850},
 {12.287,-0.401,-2.500},
 {13.516,0.079,0.289},
 {11.244,-1.978,-0.062}
};

static ROTCOOSTRU RLYSH_rot25[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.120,2.334,3.712},
 {8.658,0.106,3.332},
 {10.685,3.540,-0.866},
 {11.582,0.354,-0.411},
 {8.291,0.739,-3.493},
 {7.225,-0.831,-1.061},
 {6.397,2.111,-1.480}
};

static ROTCOOSTRU RLYSH_rot26[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {8.736,0.143,3.487},
 {9.572,1.590,0.593},
 {12.600,4.411,2.879},
 {11.764,2.964,5.773},
 {15.527,1.155,4.026},
 {13.307,-0.987,4.095},
 {14.079,0.349,1.423}
};

static ROTCOOSTRU *RLYS_rotarr[81] = {RLYS_rot0,RLYS_rot1,RLYS_rot2,RLYS_rot3,RLYS_rot4,RLYS_rot5,RLYS_rot6,RLYS_rot7,RLYS_rot8,RLYS_rot9,RLYS_rot10,RLYS_rot11,RLYS_rot12,RLYS_rot13,RLYS_rot14,RLYS_rot15,RLYS_rot16,RLYS_rot17,RLYS_rot18,RLYS_rot19,RLYS_rot20,RLYS_rot21,RLYS_rot22,RLYS_rot23,RLYS_rot24,RLYS_rot25,RLYS_rot26};


static ROTCOOSTRU *RLYSH_rotarr[81] = {RLYSH_rot0,RLYSH_rot1,RLYSH_rot2,RLYSH_rot3,RLYSH_rot4,RLYSH_rot5,RLYSH_rot6,RLYSH_rot7,RLYSH_rot8,RLYSH_rot9,RLYSH_rot10,RLYSH_rot11,RLYSH_rot12,RLYSH_rot13,RLYSH_rot14,RLYSH_rot15,RLYSH_rot16,RLYSH_rot17,RLYSH_rot18,RLYSH_rot19,RLYSH_rot20,RLYSH_rot21,RLYSH_rot22,RLYSH_rot23,RLYSH_rot24,RLYSH_rot25,RLYSH_rot26};

static int RGLU_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 33, 34 };
static short int RGLU_PMF[9] = { 10, 2, 4, 6, 2, 2, 4, 8, 8 };
static int RGLUH_PDB[6] = { 0, 3, 6, 7, 9, 10 }; 
static short int RGLUH_PMF[6] = { 1, 1, 1, 1, 1, 1 };
static int RGLU_NUMC[2] = {9,6};

static ROTCOOSTRU RGLU_rot0[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.479,6.722,6.285},
 {6.953,8.925,5.199},
 {9.265,8.646,4.807},
 {5.796,10.933,4.740}
};

static ROTCOOSTRU RGLU_rot1[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.669,6.749,6.596},
 {3.422,7.423,4.952},
 {2.764,5.901,3.269},
 {2.317,9.473,5.345}
};

static ROTCOOSTRU RGLU_rot2[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {11.219,2.422,6.363},
 {10.520,0.834,4.760},
 {13.310,2.322,7.456}
};

static ROTCOOSTRU RGLU_rot3[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {10.796,6.843,5.906},
 {9.679,8.128,4.269},
 {12.974,7.337,6.674}
};

static ROTCOOSTRU RGLU_rot4[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {9.379,5.855,9.575},
 {7.532,7.231,10.097},
 {11.177,5.484,11.062}
};

static ROTCOOSTRU RGLU_rot5[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.141},
 {5.471,4.705,1.350},
 {3.431,5.461,2.270},
 {5.866,4.558,-0.974}
};

static ROTCOOSTRU RGLU_rot6[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.648,3.891,3.168},
 {9.056,6.181,2.177},
 {9.073,8.144,3.491},
 {10.143,6.014,0.087}
};

static ROTCOOSTRU RGLU_rot7[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.141},
 {9.459,1.816,2.727},
 {11.189,1.531,4.310},
 {9.212,0.444,0.820}
};

static ROTCOOSTRU RGLUH_rot0[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.303,6.791},
 {7.123,3.913,3.866},
 {3.603,6.644,5.392},
 {5.173,7.034,8.317}
};

static ROTCOOSTRU RGLUH_rot1[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.781,4.150,6.582},
 {6.886,4.046,3.830},
 {5.076,6.713,8.588},
 {7.118,8.229,6.420}
};

static ROTCOOSTRU RGLUH_rot2[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {10.242,6.360,6.313},
 {9.296,4.742,9.080}
};

static ROTCOOSTRU RGLUH_rot3[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {9.290,4.803,9.074},
 {10.577,2.865,6.675}
};

static ROTCOOSTRU RGLUH_rot4[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {10.376,2.725,7.193},
 {10.591,5.710,5.705}
};

static ROTCOOSTRU RGLUH_rot5[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {9.254,5.085,2.767},
 {8.093,1.952,2.768}
};

static ROTCOOSTRU RGLUH_rot6[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.608,5.892,6.045},
 {8.496,4.561,7.076},
 {8.866,2.214,3.009},
 {5.978,3.544,1.979}
};

static ROTCOOSTRU RGLUH_rot7[6] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {5.869,3.562,2.000},
 {8.380,5.719,2.465}
};


static ROTCOOSTRU *RGLU_rotarr[27] = {RGLU_rot0,RGLU_rot1,RGLU_rot2,RGLU_rot3,RGLU_rot4,RGLU_rot5,RGLU_rot6,RGLU_rot7};

static ROTCOOSTRU *RGLUH_rotarr[27] = {RGLUH_rot0,RGLUH_rot1,RGLUH_rot2,RGLUH_rot3,RGLUH_rot4,RGLUH_rot5,RGLUH_rot6,RGLUH_rot7};

static int RGLN_PDB[9] = { 0, 1, 2, 3, 4, 5, 8, 23, 33 };
static short int RGLN_PMF[9] = { 10, 2, 4, 6, 2, 2, 4, 10, 6 };
static int RGLNH_PDB[8] = { 0, 3, 6, 7, 9, 10, 33, 34 }; 
static short int RGLNH_PMF[8] = { 1, 1, 1, 1, 1, 1, 1, 1 };
static int RGLN_NUMC[2] = {9,8};

static ROTCOOSTRU RGLN_rot0[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.479,6.722,6.285},
 {6.953,8.925,5.199},
 {6.370,11.200,6.089},
 {8.592,8.586,3.584}
};

static ROTCOOSTRU RGLN_rot1[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.669,6.749,6.596},
 {3.288,7.319,5.109},
 {2.164,9.510,5.604},
 {2.471,5.811,3.537}
};

static ROTCOOSTRU RGLN_rot2[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {11.219,2.422,6.363},
 {12.250,2.484,4.074},
 {11.656,0.728,7.897}
};

static ROTCOOSTRU RGLN_rot3[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {11.219,2.422,6.363},
 {12.180,1.147,8.302},
 {11.719,1.913,4.149}
};

static ROTCOOSTRU RGLN_rot4[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.443,4.573,7.013},
 {10.796,6.843,5.906},
 {13.107,7.295,6.779},
 {9.778,8.169,4.288}
};

static ROTCOOSTRU RGLN_rot5[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.141},
 {5.471,4.705,1.350},
 {5.976,4.517,-1.103},
 {3.427,5.463,2.162}
};

static ROTCOOSTRU RGLN_rot6[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.648,3.891,3.168},
 {9.056,6.181,2.177},
 {10.647,5.773,0.278},
 {8.717,8.286,3.108}
};

static ROTCOOSTRU RGLN_rot7[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.141},
 {9.459,1.816,2.727},
 {9.122,0.407,0.676},
 {11.197,1.457,4.231}
};

static ROTCOOSTRU RGLN_rot8[9] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.568,3.928,3.141},
 {9.459,1.816,2.727},
 {11.855,2.348,3.258},
 {8.774,-0.264,1.942}
};

static ROTCOOSTRU RGLNH_rot0[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.303,6.791},
 {7.123,3.913,3.866},
 {3.603,6.644,5.392},
 {5.173,7.034,8.317},
 {5.023,11.385,7.402},
 {7.277,12.728,5.446}
};

static ROTCOOSTRU RGLNH_rot1[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.781,4.150,6.582},
 {6.886,4.046,3.830},
 {5.232,6.773,8.628},
 {7.066,8.250,6.258},
 {2.897,10.676,6.898},
 {0.586,9.992,4.683}
};

static ROTCOOSTRU RGLNH_rot2[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {10.242,6.360,6.313},
 {9.296,4.742,9.080},
 {11.839,3.898,2.890},
 {13.438,1.116,3.535}
};

static ROTCOOSTRU RGLNH_rot3[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {10.242,6.360,6.313},
 {9.296,4.742,9.080},
 {11.719,1.629,10.070},
 {13.364,-0.293,7.992}
};

static ROTCOOSTRU RGLNH_rot4[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {9.290,4.803,9.074},
 {10.577,2.865,6.675},
 {13.858,6.166,8.095},
 {14.094,8.766,6.121}
};

static ROTCOOSTRU RGLNH_rot5[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {9.254,5.085,2.767},
 {8.093,1.952,2.768},
 {7.665,3.891,-1.675},
 {4.667,5.002,-2.376}
};

static ROTCOOSTRU RGLNH_rot6[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.608,5.892,6.045},
 {8.496,4.561,7.076},
 {8.866,2.214,3.009},
 {5.978,3.544,1.979},
 {10.861,4.029,-0.418},
 {11.630,7.210,-0.456}
};

static ROTCOOSTRU RGLNH_rot7[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {5.869,3.562,2.000},
 {8.380,5.719,2.465},
 {7.682,0.769,-0.493},
 {10.309,-1.015,0.301}
};

static ROTCOOSTRU RGLNH_rot8[8] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {5.869,3.562,2.000},
 {8.380,5.719,2.465},
 {12.324,4.065,3.892},
 {13.190,1.031,3.023}
};

static ROTCOOSTRU *RGLN_rotarr[36] = {RGLN_rot0,RGLN_rot1,RGLN_rot2,RGLN_rot3,RGLN_rot4,RGLN_rot5,RGLN_rot6,RGLN_rot7,RGLN_rot8};

static ROTCOOSTRU *RGLNH_rotarr[36] = {RGLNH_rot0,RGLNH_rot1,RGLNH_rot2,RGLNH_rot3,RGLNH_rot4,RGLNH_rot5,RGLNH_rot6,RGLNH_rot7,RGLNH_rot8};

static int RPRO_PDB[7] = { 0, 1, 2, 3, 4, 5, 8 };
static short int RPRO_PMF[7] = { 10, 2, 4, 6, 2, 2, 2 };
static int RPROH_PDB[7] = { 3, 6, 7, 9, 10, 18, 19 };
static short int RPROH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 };
static int RPRO_NUMC[2] = {7,7};

static ROTCOOSTRU RPRO_rot0[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {6.022,-0.357,8.551},
 {4.484,-1.368,9.940},
 {5.017,4.304,8.585},
 {3.063,5.820,7.155},
 {1.253,3.808,6.205}
};

static ROTCOOSTRU RPRO_rot1[7] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {6.022,-0.357,8.551},
 {4.484,-1.368,9.940},
 {5.017,4.304,8.585},
 {2.208,4.360,9.104},
 {1.081,3.352,6.667}
};

static ROTCOOSTRU RPROH_rot0[7] = {
 {6.988,2.098,5.655},
 {4.360,3.825,10.498},
 {6.795,5.361,8.800},
 {2.108,7.197,8.385},
 {3.915,6.891,5.590},
 {-0.194,3.340,7.622},
 {0.251,4.418,4.489}
};

static ROTCOOSTRU RPROH_rot1[7] = {
 {6.988,2.098,5.655},
 {6.116,4.202,10.347},
 {5.641,6.012,7.578},
 {1.704,3.174,10.735},
 {1.543,6.284,9.524},
 {-0.716,2.362,6.999},
 {0.696,4.875,5.306}
};

static ROTCOOSTRU *RPRO_rotarr[2] = {RPRO_rot0,RPRO_rot1};
static ROTCOOSTRU *RPROH_rotarr[2] = {RPROH_rot0,RPROH_rot1};

static int RARG_PDB[11] = { 0, 1, 2, 3, 4, 5, 8, 16, 21, 24, 25 };
static short int RARG_PMF[11] = { 10, 2, 4, 6, 2, 2, 2, 5, 9, 9, 9 };
static int RARGH_PDB[13] = { 0, 3, 6, 7, 9, 10, 18, 19, 27, 54, 55, 57, 58 };
static short int RARGH_PMF[13] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RARG_NUMC[2] = {11,13};

static ROTCOOSTRU RARG_rot0[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {5.501,9.565,0.819},
 {7.222,8.706,2.436},
 {3.423,10.674,1.672},
 {5.864,9.312,-1.648}
};

static ROTCOOSTRU RARG_rot1[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {8.603,10.258,1.022},
 {7.222,8.706,2.436},
 {9.891,12.120,2.097},
 {8.692,9.944,-1.462}
};

static ROTCOOSTRU RARG_rot2[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {5.932,12.721,7.607},
 {5.742,11.319,5.530},
 {7.338,11.933,9.526},
 {4.717,14.907,7.759}
};

static ROTCOOSTRU RARG_rot3[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {6.667,13.518,4.740},
 {5.742,11.319,5.530},
 {8.869,13.594,3.548},
 {5.387,15.634,5.145}
};

static ROTCOOSTRU RARG_rot4[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {3.987,12.238,3.983},
 {5.742,11.319,5.530},
 {3.280,10.925,1.969},
 {2.944,14.467,4.455}
};

static ROTCOOSTRU RARG_rot5[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {11.162,10.894,5.790},
 {9.399,9.246,6.491},
 {10.794,12.344,3.780},
 {13.289,11.087,7.101}
};

static ROTCOOSTRU RARG_rot6[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.720,6.284},
 {7.000,8.891,5.178},
 {9.673,10.601,8.590},
 {9.399,9.246,6.491},
 {7.689,11.734,9.619},
 {11.931,10.820,9.654}
};

static ROTCOOSTRU RARG_rot7[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.177,2.389,6.330},
 {13.437,3.572,2.431},
 {11.653,2.258,3.617},
 {14.920,5.123,3.724},
 {13.733,3.330,-0.046}
};

static ROTCOOSTRU RARG_rot8[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.177,2.389,6.330},
 {12.959,0.424,2.499},
 {11.653,2.258,3.617},
 {13.923,-1.441,3.868},
 {13.297,0.460,0.017}
};

static ROTCOOSTRU RARG_rot9[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.177,2.389,6.330},
 {14.362,2.031,9.711},
 {13.705,2.711,7.383},
 {12.671,0.986,11.236},
 {16.710,2.397,10.508}
};

static ROTCOOSTRU RARG_rot10[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {11.177,2.389,6.330},
 {15.585,1.073,7.068},
 {13.705,2.711,7.383},
 {15.221,-1.010,5.725},
 {17.825,1.524,8.098}
};

static ROTCOOSTRU RARG_rot11[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {9.847,10.507,8.622},
 {9.461,9.213,6.503},
 {11.492,9.672,10.318},
 {8.587,12.632,9.039}
};

static ROTCOOSTRU RARG_rot12[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {10.108,11.466,5.596},
 {9.461,9.213,6.503},
 {12.035,11.672,4.008},
 {8.824,13.507,6.280}
};

static ROTCOOSTRU RARG_rot13[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {8.033,10.519,4.899},
 {9.461,9.213,6.503},
 {7.710,9.696,2.554},
 {6.933,12.643,5.645}
};

static ROTCOOSTRU RARG_rot14[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {15.340,6.085,6.070},
 {13.272,7.237,6.915},
 {15.183,4.474,4.158},
 {17.557,6.546,7.142}
};

static ROTCOOSTRU RARG_rot15[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {14.818,9.100,6.239},
 {13.272,7.237,6.915},
 {14.095,10.762,4.508},
 {17.082,9.296,7.295}
};

static ROTCOOSTRU RARG_rot16[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {13.745,8.487,9.044},
 {13.272,7.237,6.915},
 {11.858,9.483,10.358},
 {16.104,8.736,9.852}
};

static ROTCOOSTRU RARG_rot17[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {9.937,7.650,1.348},
 {11.245,6.525,3.176},
 {8.046,9.189,1.926},
 {10.524,7.233,-1.052}
};

static ROTCOOSTRU RARG_rot18[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {12.205,8.306,1.685},
 {11.245,6.525,3.176},
 {12.776,10.556,2.627},
 {12.592,7.831,-0.745}
};

static ROTCOOSTRU RARG_rot19[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.441,4.573,7.013},
 {10.750,6.859,5.868},
 {13.267,5.356,2.246},
 {11.245,6.525,3.176},
 {14.989,4.405,3.798},
 {13.560,5.141,-0.233}
};

static ROTCOOSTRU RARG_rot20[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {13.596,5.481,2.952},
 {11.430,6.595,3.572},
 {13.684,3.909,1.003},
 {15.668,5.943,4.284}
};

static ROTCOOSTRU RARG_rot21[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {12.934,8.583,3.245},
 {11.430,6.595,3.572},
 {12.302,10.376,1.613},
 {15.064,8.770,4.551}
};

static ROTCOOSTRU RARG_rot22[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {11.795,8.356,5.328},
 {11.430,6.595,3.572},
 {9.927,9.904,5.956},
 {14.026,8.564,6.450}
};

static ROTCOOSTRU RARG_rot23[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {8.414,6.460,-2.379},
 {9.862,5.941,-0.391},
 {6.071,7.283,-2.041},
 {9.312,6.154,-4.698}
};

static ROTCOOSTRU RARG_rot24[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {11.127,7.697,-1.669},
 {9.862,5.941,-0.391},
 {11.729,9.863,-0.561},
 {11.786,7.282,-4.051}
};

static ROTCOOSTRU RARG_rot25[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {11.992,4.812,-1.101},
 {9.862,5.941,-0.391},
 {13.533,3.846,0.623},
 {12.575,4.652,-3.533}
};

static ROTCOOSTRU RARG_rot26[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {7.522,10.324,3.802},
 {7.426,8.439,2.143},
 {9.172,10.252,5.687},
 {5.966,12.275,3.573}
};

static ROTCOOSTRU RARG_rot27[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.052,6.214,2.230},
 {8.226,10.751,1.564},
 {7.426,8.439,2.143},
 {10.640,11.142,1.020},
 {6.608,12.664,1.532}
};

static ROTCOOSTRU RARG_rot28[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.647,3.891,3.170},
 {9.544,5.912,2.414},
 {7.149,9.440,0.537},
 {8.433,8.435,2.449},
 {6.812,8.129,-1.572},
 {6.206,11.752,0.738}
};

static ROTCOOSTRU RARG_rot29[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {11.748,3.080,-1.212},
 {10.017,1.686,-0.038},
 {13.030,4.817,0.060},
 {12.192,2.731,-3.653}
};

static ROTCOOSTRU RARG_rot30[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {11.663,0.026,-0.961},
 {10.017,1.686,-0.038},
 {12.852,-1.551,0.581},
 {12.114,-0.053,-3.425}
};

static ROTCOOSTRU RARG_rot31[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {8.698,0.318,-1.683},
 {10.017,1.686,-0.038},
 {6.669,-0.941,-0.923},
 {9.411,0.214,-4.082}
};

static ROTCOOSTRU RARG_rot32[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {13.790,0.947,3.816},
 {11.824,2.512,3.789},
 {13.608,-1.313,2.747},
 {15.934,1.645,4.910}
};

static ROTCOOSTRU RARG_rot33[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.449,3.987,3.108},
 {9.390,1.923,2.636},
 {13.597,3.924,2.703},
 {11.824,2.512,3.789},
 {13.204,4.897,0.427},
 {15.757,4.360,3.896}
};

static ROTCOOSTRU RARGH_rot0[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {6.094,10.694,5.678},
 {8.898,8.907,6.026},
 {8.766,7.880,1.725},
 {3.149,10.864,3.532},
 {2.129,11.320,0.456},
 {7.432,8.476,-2.292},
 {4.570,9.958,-2.864}
};

static ROTCOOSTRU RARGH_rot1[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {6.094,10.694,5.678},
 {8.898,8.907,6.026},
 {6.276,7.323,1.561},
 {9.823,12.357,3.971},
 {10.929,13.287,1.034},
 {7.721,8.540,-2.273},
 {9.730,11.112,-2.525}
};

static ROTCOOSTRU RARGH_rot2[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.875,8.948,6.075},
 {7.304,8.558,3.149},
 {4.665,11.973,4.121},
 {8.254,10.284,9.412},
 {7.481,12.987,11.088},
 {3.658,15.502,6.312},
 {4.861,15.962,9.321}
};

static ROTCOOSTRU RARGH_rot3[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.875,8.948,6.075},
 {7.304,8.558,3.149},
 {4.076,11.333,6.423},
 {9.835,11.999,3.242},
 {9.565,15.248,2.953},
 {3.726,15.576,6.044},
 {6.083,17.287,4.551}
};

static ROTCOOSTRU RARGH_rot4[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {8.875,8.948,6.075},
 {7.304,8.558,3.149},
 {6.227,12.361,7.030},
 {4.067,9.244,1.614},
 {1.961,11.616,0.806},
 {3.476,15.457,5.974},
 {1.624,15.158,3.292}
};

static ROTCOOSTRU RARGH_rot5[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {7.362,8.525,3.164},
 {5.886,10.642,5.290},
 {9.741,8.184,8.016},
 {9.190,12.199,2.791},
 {12.120,13.583,3.253},
 {13.567,9.993,8.617},
 {14.615,12.326,6.574}
};

static ROTCOOSTRU RARGH_rot6[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.695,4.301,6.789},
 {7.126,3.912,3.867},
 {3.605,6.655,5.389},
 {5.175,7.045,8.315},
 {7.362,8.525,3.164},
 {5.886,10.642,5.290},
 {10.937,8.419,5.769},
 {5.986,11.569,8.816},
 {7.895,12.753,11.197},
 {13.428,9.966,8.878},
 {12.138,11.839,11.232}
};

static ROTCOOSTRU RARGH_rot7[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.252,6.354,6.313},
 {9.306,4.736,9.081},
 {12.982,2.600,7.339},
 {10.326,0.604,6.969},
 {10.571,1.106,2.581},
 {14.697,5.305,5.592},
 {16.261,6.111,2.832},
 {12.615,2.160,-1.021},
 {15.074,4.319,-0.938}
};

static ROTCOOSTRU RARGH_rot8[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.252,6.354,6.313},
 {9.306,4.736,9.081},
 {12.982,2.600,7.339},
 {10.326,0.604,6.969},
 {10.954,3.633,2.526},
 {13.668,-1.469,5.740},
 {14.904,-2.820,3.027},
 {12.570,1.867,-1.015},
 {14.278,-0.918,-0.824}
};

static ROTCOOSTRU RARGH_rot9[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.252,6.354,6.313},
 {9.306,4.736,9.081},
 {10.358,0.611,7.029},
 {11.305,2.230,4.261},
 {15.030,3.493,6.286},
 {10.900,0.710,10.635},
 {13.165,0.474,12.987},
 {17.986,3.185,9.358},
 {17.204,1.885,12.258}
};

static ROTCOOSTRU RARGH_rot10[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {10.252,6.354,6.313},
 {9.306,4.736,9.081},
 {10.358,0.611,7.029},
 {11.305,2.230,4.261},
 {14.048,4.262,8.407},
 {13.532,-1.350,4.949},
 {16.634,-2.242,5.489},
 {18.100,3.096,9.111},
 {19.238,0.293,7.862}
};

static ROTCOOSTRU RARGH_rot11[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {12.713,6.942,6.545},
 {10.825,6.648,3.801},
 {8.207,9.899,5.267},
 {12.443,8.070,10.003},
 {11.782,10.646,11.912},
 {7.346,13.262,7.760},
 {8.877,13.606,10.633}
};

static ROTCOOSTRU RARGH_rot12[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {12.713,6.942,6.545},
 {10.825,6.648,3.801},
 {7.998,9.129,7.696},
 {13.003,10.133,3.492},
 {12.521,13.366,3.327},
 {7.371,13.351,7.478},
 {9.310,15.201,5.599}
};

static ROTCOOSTRU RARGH_rot13[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {12.713,6.942,6.545},
 {10.825,6.648,3.801},
 {9.663,9.890,8.255},
 {8.539,8.094,1.991},
 {6.636,10.678,1.348},
 {7.177,13.263,7.413},
 {5.860,13.625,4.439}
};

static ROTCOOSTRU RARGH_rot14[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.886,6.617,3.808},
 {9.599,8.556,6.208},
 {13.461,8.440,8.360},
 {13.511,4.125,3.350},
 {16.738,3.607,3.523},
 {17.675,7.761,8.584},
 {19.112,5.679,6.507}
};

static ROTCOOSTRU RARGH_rot15[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.886,6.617,3.808},
 {9.599,8.556,6.208},
 {13.880,6.019,8.225},
 {12.388,10.615,3.712},
 {15.257,12.163,4.000},
 {17.627,8.042,8.600},
 {18.244,10.696,6.786}
};

static ROTCOOSTRU RARGH_rot16[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {10.886,6.617,3.808},
 {9.599,8.556,6.208},
 {14.741,6.512,5.974},
 {10.079,9.295,9.748},
 {12.214,10.422,11.958},
 {17.527,7.985,8.861},
 {16.459,9.676,11.453}
};

static ROTCOOSTRU RARGH_rot17[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {9.566,8.545,6.149},
 {12.542,7.199,6.863},
 {12.658,5.377,2.670},
 {7.604,9.504,3.736},
 {7.063,10.035,0.552},
 {11.951,6.072,-1.487},
 {9.541,8.079,-2.426}
};

static ROTCOOSTRU RARGH_rot18[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {9.566,8.545,6.149},
 {12.542,7.199,6.863},
 {10.838,4.851,2.400},
 {12.484,10.915,4.460},
 {13.497,11.895,1.506},
 {12.162,6.133,-1.456},
 {13.314,9.169,-1.866}
};

static ROTCOOSTRU RARGH_rot19[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.989,3.841},
 {5.698,5.926,6.238},
 {9.298,4.810,9.073},
 {10.586,2.872,6.673},
 {9.566,8.545,6.149},
 {12.542,7.199,6.863},
 {9.986,7.219,1.949},
 {14.768,4.567,5.668},
 {16.508,3.526,3.099},
 {12.261,5.858,-1.404},
 {15.079,4.262,-0.932}
};

static ROTCOOSTRU RARGH_rot20[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {9.430,6.016,0.196},
 {7.848,7.892,2.467},
 {11.435,7.769,5.053},
 {12.121,3.561,-0.001},
 {15.313,3.072,0.537},
 {15.602,7.128,5.754},
 {17.297,5.105,3.818}
};

static ROTCOOSTRU RARGH_rot21[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {9.430,6.016,0.196},
 {7.848,7.892,2.467},
 {11.967,5.280,4.818},
 {10.695,10.235,0.628},
 {13.433,11.871,1.367},
 {15.540,7.418,5.781},
 {16.194,10.265,4.305}
};

static ROTCOOSTRU RARGH_rot22[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {9.430,6.016,0.196},
 {7.848,7.892,2.467},
 {12.881,5.462,3.146},
 {8.245,9.748,5.110},
 {10.201,11.228,7.276},
 {15.434,7.396,5.976},
 {14.300,9.888,7.770}
};

static ROTCOOSTRU RARGH_rot23[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.823,7.881,2.404},
 {10.712,6.551,3.435},
 {11.618,5.324,-0.717},
 {5.393,7.513,-0.292},
 {4.982,7.673,-3.535},
 {11.079,5.534,-4.952},
 {8.223,6.545,-6.192}
};

static ROTCOOSTRU RARGH_rot24[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.823,7.881,2.404},
 {10.712,6.551,3.435},
 {9.440,4.331,-1.287},
 {11.231,10.175,1.235},
 {12.680,11.183,-1.522},
 {11.332,5.649,-4.886},
 {12.737,8.603,-5.011}
};

static ROTCOOSTRU RARGH_rot25[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {7.823,7.881,2.404},
 {10.712,6.551,3.435},
 {8.746,6.647,-1.743},
 {13.094,3.967,2.457},
 {15.135,2.997,0.089},
 {11.413,5.380,-4.833},
 {14.177,3.803,-4.067}
};

static ROTCOOSTRU RARGH_rot26[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {10.673,6.591,3.475},
 {9.814,5.839,0.333},
 {6.158,8.557,0.747},
 {10.345,8.781,5.860},
 {9.243,11.670,6.935},
 {4.722,12.329,2.152},
 {6.038,13.693,4.821}
};

static ROTCOOSTRU RARGH_rot27[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.872,2.220,3.002},
 {5.983,3.550,1.971},
 {10.673,6.591,3.475},
 {9.814,5.839,0.333},
 {5.593,8.215,2.543},
 {11.860,9.699,1.044},
 {11.241,12.880,0.585},
 {4.787,12.369,1.943},
 {7.209,14.402,1.098}
};

static ROTCOOSTRU RARGH_rot28[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.609,5.892,6.048},
 {8.494,4.564,7.078},
 {8.492,2.010,2.911},
 {5.988,3.991,1.921},
 {11.168,5.853,3.711},
 {10.268,5.501,0.510},
 {8.651,9.479,4.010},
 {7.523,6.385,-1.724},
 {5.846,8.884,-3.010},
 {6.460,12.741,2.329},
 {5.240,12.508,-0.700}
};

static ROTCOOSTRU RARGH_rot29[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.116,2.339,3.717},
 {8.654,0.109,3.337},
 {9.087,0.394,-1.056},
 {12.695,5.080,1.901},
 {14.332,5.865,-0.823},
 {11.226,1.421,-4.612},
 {13.494,3.779,-4.536}
};

static ROTCOOSTRU RARGH_rot30[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.116,2.339,3.717},
 {8.654,0.109,3.337},
 {9.156,2.845,-1.257},
 {12.511,-1.491,2.439},
 {14.089,-2.799,-0.113},
 {11.218,1.136,-4.588},
 {13.352,-1.301,-4.119}
};

static ROTCOOSTRU RARGH_rot31[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {11.116,2.339,3.717},
 {8.654,0.109,3.337},
 {11.536,2.611,-0.678},
 {6.131,-0.862,0.887},
 {5.677,-1.970,-2.159},
 {10.941,1.163,-4.656},
 {8.419,-0.815,-5.319}
};

static ROTCOOSTRU RARGH_rot32[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {8.682,0.123,3.398},
 {9.639,1.664,0.589},
 {12.031,4.200,4.613},
 {11.992,-1.840,1.922},
 {15.086,-2.490,2.767},
 {16.071,3.349,5.716},
 {17.412,0.468,4.930}
};

static ROTCOOSTRU RARGH_rot33[13] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.679,5.920,6.202},
 {8.581,4.459,6.973},
 {5.718,3.575,2.032},
 {8.180,5.804,2.413},
 {8.682,0.123,3.398},
 {9.639,1.664,0.589},
 {12.186,1.810,5.506},
 {11.575,4.568,-0.472},
 {14.537,5.959,-0.390},
 {16.053,3.627,5.612},
 {17.090,5.422,3.079}
};

static ROTCOOSTRU *RARG_rotarr[81] = {RARG_rot0,RARG_rot1,RARG_rot2,RARG_rot3,RARG_rot4,RARG_rot5,RARG_rot6,RARG_rot7,RARG_rot8,RARG_rot9,RARG_rot10,RARG_rot11,RARG_rot12,RARG_rot13,RARG_rot14,RARG_rot15,RARG_rot16,RARG_rot17,RARG_rot18,RARG_rot19,RARG_rot20,RARG_rot21,RARG_rot22,RARG_rot23,RARG_rot24,RARG_rot25,RARG_rot26,RARG_rot27,RARG_rot28,RARG_rot29,RARG_rot30,RARG_rot31,RARG_rot32,RARG_rot33};

static ROTCOOSTRU *RARGH_rotarr[81] = {RARGH_rot0,RARGH_rot1,RARGH_rot2,RARGH_rot3,RARGH_rot4,RARGH_rot5,RARGH_rot6,RARGH_rot7,RARGH_rot8,RARGH_rot9,RARGH_rot10,RARGH_rot11,RARGH_rot12,RARGH_rot13,RARGH_rot14,RARGH_rot15,RARGH_rot16,RARGH_rot17,RARGH_rot18,RARGH_rot19,RARGH_rot20,RARGH_rot21,RARGH_rot22,RARGH_rot23,RARGH_rot24,RARGH_rot25,RARGH_rot26,RARGH_rot27,RARGH_rot28,RARGH_rot29,RARGH_rot30,RARGH_rot31,RARGH_rot32,RARGH_rot33};

static int RHIS_PDB[10] = { 0, 1, 2, 3, 4, 5, 10, 12, 19, 23 };
static short int RHIS_PMF[10] = { 10, 2, 4, 6, 2, 4, 4, 4, 9, 9 };
static int RHISH_PDB[7] = { 0, 3, 6, 7, 21, 24, 30 };
static short int RHISH_PMF[7] = { 1, 1, 1, 1, 1, 1, 1 }; 
static int RHIS_NUMC[2] = {10,7};

static ROTCOOSTRU RHIS_rot0[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.489,6.675,6.285},
 {5.941,8.599,7.909},
 {2.643,9.640,5.637},
 {3.410,7.386,4.888},
 {4.145,10.418,7.466}
};

static ROTCOOSTRU RHIS_rot1[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.489,6.675,6.285},
 {4.057,8.083,4.702},
 {4.224,10.073,8.326},
 {5.557,7.973,8.542},
 {3.294,10.185,6.018}
};

static ROTCOOSTRU RHIS_rot2[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.399,4.556,7.004},
 {10.874,2.979,8.376},
 {12.953,6.524,7.901},
 {10.756,6.762,6.739},
 {13.072,4.250,8.908}
};

static ROTCOOSTRU RHIS_rot3[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.399,4.556,7.004},
 {11.713,3.934,6.110},
 {12.249,5.723,9.802},
 {9.800,5.674,9.322},
 {13.451,4.681,7.886}
};

static ROTCOOSTRU RHIS_rot4[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.399,4.556,7.004},
 {10.429,6.504,8.303},
 {13.326,3.568,7.962},
 {11.263,2.746,6.822},
 {12.871,5.841,8.876}
};

static ROTCOOSTRU RHIS_rot5[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.550,3.919,3.184},
 {6.700,5.091,1.075},
 {9.622,2.402,-0.089},
 {9.380,2.245,2.390},
 {8.020,4.112,-0.933}
};

static ROTCOOSTRU RHIS_rot6[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.550,3.919,3.184},
 {7.627,1.861,1.667},
 {8.845,5.110,-0.586},
 {8.325,5.925,1.715},
 {8.438,2.654,-0.666}
};

static ROTCOOSTRU RHIS_rot7[10] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.550,3.919,3.184},
 {9.771,3.265,2.097},
 {7.047,3.933,-0.946},
 {5.882,4.325,1.227},
 {9.406,3.288,-0.472}
};

static ROTCOOSTRU RHISH_rot0[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.303,6.791},
 {7.123,3.913,3.866},
 {2.608,6.355,3.521},
 {7.465,8.688,9.320},
 {1.025,10.690,4.864}
};

static ROTCOOSTRU RHISH_rot1[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.303,6.791},
 {7.123,3.913,3.866},
 {6.473,7.413,10.097},
 {3.590,7.628,2.728},
 {3.939,11.488,9.822}
};

static ROTCOOSTRU RHISH_rot2[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {10.169,8.301,5.813},
 {10.398,1.040,8.956},
 {14.432,7.981,8.009}
};

static ROTCOOSTRU RHISH_rot3[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {8.447,6.343,10.460},
 {12.124,3.003,4.297},
 {13.134,6.504,11.513}
};

static ROTCOOSTRU RHISH_rot4[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.986,3.988,3.841},
 {5.699,5.926,6.241},
 {11.080,1.073,5.962},
 {9.485,8.286,8.806},
 {15.120,2.530,8.121}
};

static ROTCOOSTRU RHISH_rot5[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {10.369,1.093,3.516},
 {5.227,6.554,0.987},
 {10.939,1.291,-1.252}
};

static ROTCOOSTRU RHISH_rot6[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {8.469,7.716,2.302},
 {7.131,-0.085,2.205},
 {9.507,6.285,-2.168}
};

static ROTCOOSTRU RHISH_rot7[7] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.904,6.107},
 {8.532,4.520,7.035},
 {4.073,4.837,1.422},
 {11.539,2.801,3.087},
 {6.192,4.114,-2.832}
};

static ROTCOOSTRU *RHIS_rotarr[9] = {RHIS_rot0,RHIS_rot1,RHIS_rot2,RHIS_rot3,RHIS_rot4,RHIS_rot5,RHIS_rot6,RHIS_rot7};
static ROTCOOSTRU *RHISH_rotarr[9] = {RHISH_rot0,RHISH_rot1,RHISH_rot2,RHISH_rot3,RHISH_rot4,RHISH_rot5,RHISH_rot6,RHISH_rot7};

static int RPHE_PDB[11] = { 0, 1, 2, 3, 4, 5, 9, 10, 12, 13, 16 };
static short int RPHE_PMF[11] = { 10, 2, 4, 6, 2, 3, 3, 3, 3, 3, 3 }; 
static int RPHEH_PDB[9] = { 0, 3, 6, 7, 21, 24, 30, 33, 39 };
static short int RPHEH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RPHE_NUMC[2] = {11,9};

static ROTCOOSTRU RPHE_rot0[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {5.485,6.678,6.261},
 {5.917,8.117,8.402},
 {3.802,7.570,4.474},
 {4.691,10.397,8.746},
 {2.572,9.847,4.810},
 {3.017,11.264,6.949}
};

static ROTCOOSTRU RPHE_rot1[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {9.406,4.556,6.988},
 {11.423,3.117,6.150},
 {9.828,6.327,8.861},
 {13.807,3.443,7.163},
 {12.208,6.660,9.879},
 {14.201,5.216,9.030}
};

static ROTCOOSTRU RPHE_rot2[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {7.548,3.898,3.164},
 {9.751,2.653,2.503},
 {6.035,4.855,1.262},
 {10.424,2.373,-0.004},
 {6.700,4.581,-1.246},
 {8.898,3.337,-1.882}
};

static ROTCOOSTRU RPHE_rot3[11] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {7.548,3.898,3.164},
 {8.037,1.529,2.168},
 {7.747,5.978,1.597},
 {8.710,1.250,-0.339},
 {8.419,5.707,-0.910},
 {8.901,3.339,-1.881}
};

static ROTCOOSTRU RPHEH_rot0[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.302,6.775},
 {7.120,3.896,3.854},
 {7.251,7.436,9.844},
 {3.435,6.451,2.761},
 {5.053,11.520,10.457},
 {1.238,10.530,3.370},
 {2.041,13.078,7.223}
};

static ROTCOOSTRU RPHEH_rot1[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.971,3.828},
 {5.699,5.922,6.219},
 {11.122,1.698,4.660},
 {8.248,7.488,9.551},
 {15.392,2.286,6.478},
 {12.512,8.077,11.369},
 {16.099,5.476,9.837}
};

static ROTCOOSTRU RPHEH_rot2[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.899,6.085},
 {8.532,4.519,7.017},
 {10.978,1.878,3.992},
 {4.277,5.851,1.752},
 {12.181,1.379,-0.501},
 {5.475,5.354,-2.737},
 {9.434,3.115,-3.878}
};

static ROTCOOSTRU RPHEH_rot3[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.899,6.085},
 {8.532,4.519,7.017},
 {7.888,-0.148,3.388},
 {7.365,7.875,2.355},
 {9.093,-0.645,-1.104},
 {8.569,7.382,-2.133},
 {9.437,3.117,-3.877}
};

static ROTCOOSTRU *RPHE_rotarr[6] = {RPHE_rot0,RPHE_rot1,RPHE_rot2,RPHE_rot3};
static ROTCOOSTRU *RPHEH_rotarr[6] = {RPHEH_rot0,RPHEH_rot1,RPHEH_rot2,RPHEH_rot3};

static int RTYR_PDB[12] = { 0, 1, 2, 3, 4, 5, 9, 10, 12, 13, 16, 32 };
static short int RTYR_PMF[12] = { 10, 2, 4, 6, 2, 3, 3, 3, 3, 3, 3, 7 }; 
static int RTYRH_PDB[9] = { 0, 3, 6, 7, 21, 24, 30, 33, 51 };
static short int RTYRH_PMF[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RTYR_NUMC[2] = {12,9};

static ROTCOOSTRU RTYR_rot0[12] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {5.485,6.678,6.261},
 {5.916,8.125,8.408},
 {3.790,7.583,4.469},
 {4.699,10.406,8.768},
 {2.555,9.861,4.797},
 {3.013,11.269,6.948},
 {1.795,13.540,7.295}
};

static ROTCOOSTRU RTYR_rot1[12] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {9.406,4.556,6.988},
 {11.433,3.114,6.149},
 {9.840,6.335,8.873},
 {13.822,3.427,7.151},
 {12.218,6.675,9.898},
 {14.206,5.218,9.034},
 {16.582,5.540,10.040}
};

static ROTCOOSTRU RTYR_rot2[12] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {7.548,3.898,3.164},
 {9.758,2.649,2.497},
 {6.032,4.858,1.244},
 {10.446,2.361,-0.004},
 {6.690,4.587,-1.269},
 {8.898,3.338,-1.888},
 {9.572,3.057,-4.384}
};

static ROTCOOSTRU RTYR_rot3[12] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {7.548,3.898,3.164},
 {8.039,1.522,2.161},
 {7.750,5.985,1.580},
 {8.713,1.225,-0.343},
 {8.422,5.723,-0.930},
 {8.903,3.341,-1.887},
 {9.573,3.058,-4.384}
};

static ROTCOOSTRU RTYR_rot4[12] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.817,4.201,5.887},
 {7.548,3.898,3.164},
 {6.084,2.453,1.532},
 {9.705,5.054,2.208},
 {6.742,2.163,-0.976},
 {10.393,4.785,-0.297},
 {8.909,3.339,-1.885},
 {9.575,3.058,-4.383}
};

static ROTCOOSTRU RTYRH_rot0[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.302,6.775},
 {7.120,3.896,3.854},
 {7.250,7.442,9.848},
 {3.425,6.462,2.756},
 {5.061,11.529,10.479},
 {1.220,10.547,3.359},
 {2.339,14.304,8.935}
};

static ROTCOOSTRU RTYRH_rot1[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.983,3.971,3.828},
 {5.699,5.922,6.219},
 {11.129,1.696,4.660},
 {8.257,7.495,9.560},
 {15.407,2.269,6.466},
 {12.525,8.092,11.387},
 {17.787,4.346,9.208}
};

static ROTCOOSTRU RTYRH_rot2[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.899,6.085},
 {8.532,4.519,7.017},
 {10.983,1.876,3.987},
 {4.274,5.853,1.737},
 {12.202,1.367,-0.501},
 {5.467,5.360,-2.762},
 {11.207,2.117,-4.494}
};

static ROTCOOSTRU RTYRH_rot3[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.899,6.085},
 {8.532,4.519,7.017},
 {7.889,-0.152,3.383},
 {7.368,7.881,2.342},
 {9.097,-0.669,-1.108},
 {8.573,7.396,-2.155},
 {9.850,1.227,-4.759}
};

static ROTCOOSTRU RTYRH_rot4[9] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.634,5.899,6.085},
 {8.532,4.519,7.017},
 {4.370,1.523,2.252},
 {10.887,6.205,3.473},
 {5.563,1.013,-2.244},
 {12.107,5.714,-1.019},
 {8.306,1.962,-5.255}
};

static ROTCOOSTRU *RTYR_rotarr[6] = {RTYR_rot0,RTYR_rot1,RTYR_rot2,RTYR_rot3,RTYR_rot4};
static ROTCOOSTRU *RTYRH_rotarr[6] = {RTYRH_rot0,RTYRH_rot1,RTYRH_rot2,RTYRH_rot3,RTYRH_rot4};

static int RTRP_PDB[14] = { 0, 1, 2, 3, 4, 5, 9, 10, 13, 14, 15, 17, 18, 22 };
static short int RTRP_PMF[14] = { 10, 2, 4, 6, 2, 4, 4, 3, 3, 3, 3, 3, 3, 9 }; 
static int RTRPH_PDB[10] = { 0, 3, 6, 7, 21, 30, 36, 45, 48, 57 }; 
static short int RTRPH_PMF[10] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
static int RTRP_NUMC[2] = {14,10};

static ROTCOOSTRU RTRP_rot0[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.672,6.290},
 {3.780,7.780,4.698},
 {5.737,8.334,8.414},
 {4.133,10.414,7.978},
 {7.162,8.267,10.636},
 {5.326,12.301,11.838},
 {3.909,12.411,9.674},
 {6.943,10.249,12.323},
 {2.956,10.032,5.693}
};

static ROTCOOSTRU RTRP_rot1[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {5.480,6.672,6.290},
 {5.718,8.261,8.308},
 {3.695,7.827,4.611},
 {2.930,10.115,5.737},
 {2.673,7.152,2.273},
 {0.216,11.031,2.319},
 {1.191,11.735,4.611},
 {0.946,8.758,1.152},
 {4.193,10.339,7.997}
};

static ROTCOOSTRU RTRP_rot2[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.400,4.548,7.011},
 {10.120,6.320,8.741},
 {11.604,3.072,6.462},
 {13.593,4.060,7.931},
 {12.089,1.018,4.876},
 {16.456,1.056,6.297},
 {16.028,3.070,7.867},
 {14.507,0.032,4.810},
 {12.639,6.046,9.310}
};

static ROTCOOSTRU RTRP_rot3[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {9.400,4.548,7.011},
 {11.606,3.538,6.137},
 {10.039,6.003,9.205},
 {12.670,5.787,9.547},
 {8.646,7.463,10.908},
 {12.537,8.393,13.164},
 {13.944,6.972,11.519},
 {9.908,8.641,12.868},
 {13.587,4.270,7.647}
};

static ROTCOOSTRU RTRP_rot4[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.546,3.910,3.182},
 {9.733,2.893,2.267},
 {6.079,4.640,1.024},
 {7.499,4.007,-1.137},
 {3.711,5.764,0.711},
 {4.308,5.560,-3.838},
 {6.636,4.456,-3.580},
 {2.851,6.212,-1.714},
 {9.727,2.941,-0.329}
};

static ROTCOOSTRU RTRP_rot5[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.546,3.910,3.182},
 {7.224,1.815,1.712},
 {8.723,5.776,1.609},
 {9.057,4.676,-0.793},
 {9.525,8.261,1.996},
 {10.926,8.403,-2.375},
 {10.156,5.968,-2.802},
 {10.616,9.548,0.003},
 {8.125,2.253,-0.683}
};

static ROTCOOSTRU RTRP_rot6[14] = {
 {2.954,1.652,5.705},
 {5.388,1.933,6.972},
 {5.078,2.211,9.795},
 {3.495,3.598,10.736},
 {6.818,4.207,5.901},
 {7.546,3.910,3.182},
 {6.241,4.761,1.127},
 {9.759,2.672,2.226},
 {9.667,2.848,-0.429},
 {11.802,1.437,3.353},
 {13.518,0.635,-0.831},
 {11.534,1.837,-1.980},
 {13.658,0.432,1.815},
 {7.498,4.133,-1.057}
};

static ROTCOOSTRU RTRPH_rot0[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.306,6.790},
 {7.125,3.916,3.866},
 {3.159,6.984,2.881},
 {1.707,11.201,4.890},
 {8.433,6.671,11.033},
 {2.645,14.016,9.295},
 {8.054,10.221,14.079},
 {5.197,13.847,13.222}
};

static ROTCOOSTRU RTRPH_rot1[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {8.694,4.306,6.790},
 {7.125,3.916,3.866},
 {6.952,7.926,9.947},
 {4.027,11.777,9.212},
 {3.231,5.378,1.343},
 {0.620,13.513,5.524},
 {0.125,8.251,-0.689},
 {-1.163,12.266,1.374}
};

static ROTCOOSTRU RTRPH_rot2[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.988,3.991,3.841},
 {5.702,5.928,6.239},
 {8.866,7.760,9.562},
 {13.618,7.112,10.524},
 {10.578,0.202,3.704},
 {17.553,3.871,9.031},
 {14.916,-1.585,3.570},
 {18.358,0.226,6.199}
};

static ROTCOOSTRU RTRPH_rot3[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {6.988,3.991,3.841},
 {5.702,5.928,6.239},
 {11.774,2.314,4.465},
 {15.397,3.781,7.407},
 {6.589,7.670,10.694},
 {16.000,6.778,11.751},
 {8.837,9.797,14.223},
 {13.481,9.357,14.745}
};

static ROTCOOSTRU RTRPH_rot4[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.637,5.906,6.105},
 {8.533,4.522,7.033},
 {11.278,2.143,3.439},
 {11.112,2.306,-1.447},
 {2.555,6.281,2.359},
 {7.776,3.947,-5.241},
 {0.990,7.095,-1.990},
 {3.566,5.943,-5.741}
};

static ROTCOOSTRU RTRPH_rot5[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.637,5.906,6.105},
 {8.533,4.522,7.033},
 {6.366,0.033,2.353},
 {8.107,1.015,-2.111},
 {9.292,9.175,3.849},
 {10.398,5.073,-4.662},
 {11.256,11.506,0.280},
 {11.803,9.482,-3.920}
};

static ROTCOOSTRU RTRPH_rot6[10] = {
 {1.430,2.707,6.236},
 {6.490,0.209,6.606},
 {5.637,5.906,6.105},
 {8.533,4.522,7.033},
 {4.442,5.799,1.207},
 {6.930,4.542,-2.812},
 {11.930,1.267,5.421},
 {11.425,1.995,-4.050},
 {15.278,-0.546,2.676},
 {15.029,-0.187,-1.998}
};


static ROTCOOSTRU *RTRP_rotarr[9] = {RTRP_rot0,RTRP_rot1,RTRP_rot2,RTRP_rot3,RTRP_rot4,RTRP_rot5,RTRP_rot6};
static ROTCOOSTRU *RTRPH_rotarr[9] = {RTRPH_rot0,RTRPH_rot1,RTRPH_rot2,RTRPH_rot3,RTRPH_rot4,RTRPH_rot5,RTRPH_rot6};


static ROTAMERSTRU raminorots[20] = { 
	{RGLY_rotarr,RGLYH_rotarr,RGLY_PMF,RGLYH_PMF,RGLY_PDB,RGLYH_PDB,RGLY_NUMC,1}, 
	{RALA_rotarr,RALAH_rotarr,RALA_PMF,RALAH_PMF,RALA_PDB,RALAH_PDB,RALA_NUMC,1},
	{RSER_rotarr,RSERH_rotarr,RSER_PMF,RSERH_PMF,RSER_PDB,RSERH_PDB,RSER_NUMC,3},
	{RCYS_rotarr,RCYSH_rotarr,RCYS_PMF,RCYSH_PMF,RCYS_PDB,RCYSH_PDB,RCYS_NUMC,3},
	{RTHR_rotarr,RTHRH_rotarr,RTHR_PMF,RTHRH_PMF,RTHR_PDB,RTHRH_PDB,RTHR_NUMC,3},
	{RILE_rotarr,RILEH_rotarr,RILE_PMF,RILEH_PMF,RILE_PDB,RILEH_PDB,RILE_NUMC,5},
	{RVAL_rotarr,RVALH_rotarr,RVAL_PMF,RVALH_PMF,RVAL_PDB,RVALH_PDB,RVAL_NUMC,3},
	{RMET_rotarr,RMETH_rotarr,RMET_PMF,RMETH_PMF,RMET_PDB,RMETH_PDB,RMET_NUMC,13},
	{RASP_rotarr,RASPH_rotarr,RASP_PMF,RASPH_PMF,RASP_PDB,RASPH_PDB,RASP_NUMC,5},
	{RASN_rotarr,RASNH_rotarr,RASN_PMF,RASNH_PMF,RASN_PDB,RASNH_PDB,RASN_NUMC,7},
	{RLEU_rotarr,RLEUH_rotarr,RLEU_PMF,RLEUH_PMF,RLEU_PDB,RLEUH_PDB,RLEU_NUMC,5},
	{RLYS_rotarr,RLYSH_rotarr,RLYS_PMF,RLYSH_PMF,RLYS_PDB,RLYSH_PDB,RLYS_NUMC,27},
	{RGLU_rotarr,RGLUH_rotarr,RGLU_PMF,RGLUH_PMF,RGLU_PDB,RGLUH_PDB,RGLU_NUMC,8},
	{RGLN_rotarr,RGLNH_rotarr,RGLN_PMF,RGLNH_PMF,RGLN_PDB,RGLNH_PDB,RGLN_NUMC,9},
	{RPRO_rotarr,RPROH_rotarr,RPRO_PMF,RPROH_PMF,RPRO_PDB,RPROH_PDB,RPRO_NUMC,2},
	{RARG_rotarr,RARGH_rotarr,RARG_PMF,RARGH_PMF,RARG_PDB,RARGH_PDB,RARG_NUMC,34},
	{RHIS_rotarr,RHISH_rotarr,RHIS_PMF,RHISH_PMF,RHIS_PDB,RHISH_PDB,RHIS_NUMC,8},
	{RPHE_rotarr,RPHEH_rotarr,RPHE_PMF,RPHEH_PMF,RPHE_PDB,RPHEH_PDB,RPHE_NUMC,4},
	{RTYR_rotarr,RTYRH_rotarr,RTYR_PMF,RTYRH_PMF,RTYR_PDB,RTYRH_PDB,RTYR_NUMC,5},
	{RTRP_rotarr,RTRPH_rotarr,RTRP_PMF,RTRPH_PMF,RTRP_PDB,RTRPH_PDB,RTRP_NUMC,7}
};

static ROTAMERSTRU *RDrots = raminorots;

static ROTAMERSTRU flxrots[6] = { 
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0}, 
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0},
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0},
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0},
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0},
	{NULL,NULL,NULL,NULL,NULL,NULL,NULL,0}
};

static ROTCOOSTRU **rotarr[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
static ROTCOOSTRU **rotarh[6] = {NULL,NULL,NULL,NULL,NULL,NULL};

void vscal(a,scale,tol)
double *a;
double scale;
double tol;
{
   double rl;
   int i;

   rl = vln(a);

   if (rl > tol) {
      for (i=0; i<3; i++) {
	a[i] = a[i]*scale/rl;
      }
   }

}

void scimprd(a,b,c)
double *a;
double *b;
double *c;
{
  double rtmp,al,bl;
  int i;

  rtmp = 0.0;

  for (i=0; i<3; i++) {
     rtmp = rtmp + a[i]*b[i];
  }

  al = vln(a);
  bl = vln(b);

  if (al > 0.0 && bl > 0.0) {
     *c = rtmp/(al*bl);
  } else {
     *c = 0.0;
  }
}

void imprd(a,b,c)
double *a;
double *b;
double *c;
{
  int i;

  *c = 0.0;

  for (i=0; i<3; i++) {
     *c = *c + a[i]*b[i];
  }

}

void crossd(double *a,double *b, double *c)
{
      c[0] = a[1]*b[2] - a[2]*b[1];
      c[1] = a[2]*b[0] - a[0]*b[2];
      c[2] = a[0]*b[1] - a[1]*b[0];

}

void vecadd(double *a,double *b)
{
  int i;
   
  for (i=0; i<3; i++) {
	b[i] = b[i] + a[i];
  }
}


void DeAllocRot()
{
   int i,j,k,l;
   ROTCOOSTRU **rtrr;

   for (l=0; l<pmfrot->ndrs; l++) {
     if (rotarr[l] != NULL) {
	rtrr = rotarr[l];
	for (i=0; i<81; i++) {
	    if (rtrr[i] != NULL) {
		free(rtrr[i]);
		rtrr[i] = NULL;
	    }
	}
	free(rotarr[l]);
	rotarr[l] = NULL;
     }
     if (rotarh[l] != NULL) {
	rtrr = rotarh[l];
	for (i=0; i<81; i++) {
	    if (rtrr[i] != NULL) {
		free(rtrr[i]);
		rtrr[i] = NULL;
	    }
	}
	free(rotarh[l]);
	rotarh[l] = NULL;
     }
   }

}

void AllocRot()
{
   int i,j,k,l,irs,ic,aminotyp;
   ROTCOOSTRU **rtrr;
   double d;
   int i3[3],j3[3],idum,ica,in,ico,icb,rtyp;
   double tol;
   double v1[3],v2[3],v3[3],vct0[3],vct1[3],vct2[3],cosa,sina,vctb[3];
   double v1b[3],v2b[3],v3b[3],vctb0[3],vctb1[3],vctb2[3],cosba,sinba;

   tol = 1.0e-6;

   for (l=0; l<pmfrot->ndrs; l++) {
	irs = pmfrot->idrs[l];
	aminotyp = calfptr->iamino[irs-1]-1;
	rtyp = 0;
	if (aminotyp == 14) rtyp = 1;

	rotarr[l] = (ROTCOOSTRU **) malloc((sizeof rtrr)*81);
	rtrr = rotarr[l];
	for (i=0; i<81; i++) rtrr[i] = NULL;
	for (i=0; i< RDrots[aminotyp].nrots; i++) {
	   rtrr[i] = (ROTCOOSTRU *) malloc((sizeof d)*3
			*RDrots[aminotyp].numc[0]); 
	}
	flxrots[l].coo = rtrr;

	rotarh[l] = (ROTCOOSTRU **) malloc((sizeof rtrr)*81);
	rtrr = rotarh[l];
	for (i=0; i<81; i++) rtrr[i] = NULL;
	for (i=0; i<RDrots[aminotyp].nrots; i++) {
	   rtrr[i] = (ROTCOOSTRU *) malloc((sizeof d)*3
			*RDrots[aminotyp].numc[1]); 
	}
	flxrots[l].cooh = rtrr;

	flxrots[l].ipdbt = RDrots[aminotyp].ipdbt;
	flxrots[l].ipdbth = RDrots[aminotyp].ipdbth;
	flxrots[l].pdb = RDrots[aminotyp].pdb;
	flxrots[l].pdbh = RDrots[aminotyp].pdbh;
	flxrots[l].numc = RDrots[aminotyp].numc;
	flxrots[l].nrots = RDrots[aminotyp].nrots;

	ica = calfptr->icalf[irs-1][0]-1;
	in  = calfptr->icalf[irs-1][1]-1;
	ico = calfptr->icalf[irs-1][2]-1;

	icb = -1;
	for (k=0; k < xyzp->iconn[(ica)*(MXCON+1)]; k++) {
		ic = abs(xyzp->iconn[(ica)*(MXCON+1)+1+k]);
		if (xyzp->ianz[ic-1] == 6) {
		   if (ic != ico+1) {
			icb = ic - 1;
		   }
		}
	}

	for (i=0; i<3; i++) {
	   vct0[i] = xyzp->coo[ica*3+i] - (RDrots[aminotyp].coo[0])[1].coo[i];
	}

	for (j=0; j<3; j++) {
	   if (icb == -1) {
		v1[j] = (xyzp->coo[in*3+j] - xyzp->coo[ica*3+j]);
		vct1[j] = (RDrots[aminotyp].coo[0])[0].coo[j] - 
			(RDrots[aminotyp].coo[0])[1].coo[j];
	   } else {
		v1[j] = (xyzp->coo[icb*3+j] - xyzp->coo[ica*3+j]);
		vct1[j] = (RDrots[aminotyp].coo[0])[4].coo[j] - 
			(RDrots[aminotyp].coo[0])[1].coo[j];
	   }
	}

	vscal(v1,1.0,tol);
	vscal(vct1,1.0,tol);
	crossd(v1,vct1,v2);

	if (vln(v2) > tol) {

	   vscal(v2,1.0,tol);
	   crossd(v1,v2,v3);
	   vscal(v3,1.0,tol);
	   scimprd(v1,vct1,&cosa);
	   scimprd(v3,vct1,&sina);
	}

	if (icb == -1) {
	   for (j=0; j<3; j++) {
		v1b[j] = xyzp->coo[in*3+j] - xyzp->coo[ica*3+j];
		v2b[j] = xyzp->coo[ico*3+j] - xyzp->coo[ica*3+j];
	   }
	} else {
	   if (rtyp == 0) {
		for (j=0; j<3; j++) {
		   v1b[j] = xyzp->coo[icb*3+j] - xyzp->coo[ica*3+j];
		   v2b[j] = (xyzp->coo[ico*3+j] - xyzp->coo[ica*3+j]) +
		      	(xyzp->coo[in*3+j] - xyzp->coo[ica*3+j]);
		}
	   } else {
		for (j=0; j<3; j++) {
		   v1b[j] = xyzp->coo[icb*3+j] - xyzp->coo[ica*3+j];
		   v2b[j] = xyzp->coo[in*3+j] - xyzp->coo[ica*3+j];
		}
	   }
	}

	vscal(v1b,1.0,tol);
	vscal(v2b,1.0,tol);
	crossd(v1b,v2b,vctb);

	for (j = 0; j < RDrots[aminotyp].nrots; j++) {       

	   for (i = 0; i < RDrots[aminotyp].numc[0]; i++) {       

		for (k = 0; k < 3; k++) (flxrots[l].coo[j])[i].coo[k] = 
			(RDrots[aminotyp].coo[j])[i].coo[k];

		vecadd(vct0,(flxrots[l].coo[j])[i].coo);
	   }

	   for (i = 0; i < RDrots[aminotyp].numc[1]; i++) {       

		for (k = 0; k < 3; k++) (flxrots[l].cooh[j])[i].coo[k] = 
			(RDrots[aminotyp].cooh[j])[i].coo[k];

		vecadd(vct0,(flxrots[l].cooh[j])[i].coo);
	   }

	   for (i = 0; i < RDrots[aminotyp].numc[0]; i++) {       
		if (vln(v2) > tol) {

		   if (i != 1) {

			for (k=0; k<3; k++) {
			   vct1[k] = (flxrots[l].coo[j])[i].coo[k] - 
				(flxrots[l].coo[0])[1].coo[k];
			}

			imprd(vct1,v1,&vct2[0]);
			imprd(vct1,v2,&vct2[1]);
			imprd(vct1,v3,&vct2[2]);

			for (k=0; k<3; k++) {
			   (flxrots[l].coo[j])[i].coo[k] = 
			     ( cosa*vct2[0] + sina*vct2[2])*v1[k] +
			     (-sina*vct2[0] + cosa*vct2[2])*v3[k] +
			     v2[k]*vct2[1] + (flxrots[l].coo[0])[1].coo[k];
			}

		   }


		}
 
	   }

	   if (icb == -1) {
		for (k=0; k<3; k++) {
		   v1b[k] = (flxrots[l].coo[j])[0].coo[k] - 
		  	    (flxrots[l].coo[j])[1].coo[k];
		   v3b[k] = (flxrots[l].coo[j])[2].coo[k] - 
			    (flxrots[l].coo[j])[1].coo[k];
		}
	   } else {
	      if (rtyp == 0) {
		   for (k=0; k<3; k++) {
			v1b[k] = (flxrots[l].coo[j])[4].coo[k] - 
				(flxrots[l].coo[j])[1].coo[k];
			v3b[k] = ((flxrots[l].coo[j])[0].coo[k] - 
				(flxrots[l].coo[j])[1].coo[k]) +
				((flxrots[l].coo[j])[2].coo[k] -
				(flxrots[l].coo[j])[1].coo[k]);
		   }
	      } else {
		   for (k=0; k<3; k++) {
			v1b[k] = (flxrots[l].coo[j])[4].coo[k] - 
				(flxrots[l].coo[j])[1].coo[k];
			v3b[k] = (flxrots[l].coo[j])[0].coo[k] - 
				(flxrots[l].coo[j])[1].coo[k];
		   }
	      }
	   }

	   vscal(v1b,1.0,tol);
	   vscal(v3b,1.0,tol);
	   crossd(v1b,v3b,v2b);

	   if (vln(vctb) > tol && vln(v2b) > tol) {

         	   vscal(vctb,1.0,tol);
         	   vscal(v1b,1.0,tol);
         	   vscal(v2b,1.0,tol);
         	   crossd(v1b,v2b,v3b);

         	   if (vln(v3b) > tol) {

            		vscal(v3b,1.0,tol);
            		scimprd(vctb,v2b,&cosba);
            		scimprd(vctb,v3b,&sinba);
	 	   }

	   }

	   sinba = -sinba;


	   for (i = 0; i < RDrots[aminotyp].numc[0]; i++) {       
		if (vln(vctb) > tol && vln(v2b) > tol && 
			vln(v3b) > tol) {


		  for (k=0; k<3; k++) {
                     vctb1[k] = (flxrots[l].coo[j])[i].coo[k] - 
			(flxrots[l].coo[0])[1].coo[k];
		  }

                  imprd(vctb1,v1b,&vctb2[0]);
                  imprd(vctb1,v2b,&vctb2[1]);
                  imprd(vctb1,v3b,&vctb2[2]);

		  for (k=0; k<3; k++) {
			(flxrots[l].coo[j])[i].coo[k] = 
			   ( cosba*vctb2[1] + sinba*vctb2[2])*v2b[k] +
			   (-sinba*vctb2[1] + cosba*vctb2[2])*v3b[k] +
			   v1b[k]*vctb2[0] + (flxrots[l].coo[0])[1].coo[k];
		  }


	    }

	   }

	   for (i = 0; i < RDrots[aminotyp].numc[1]; i++) {       

		if (vln(v2) > tol) {

			for (k=0; k<3; k++) {
			   vct1[k] = (flxrots[l].cooh[j])[i].coo[k] - 
				(flxrots[l].coo[0])[1].coo[k];
			}

			imprd(vct1,v1,&vct2[0]);
			imprd(vct1,v2,&vct2[1]);
			imprd(vct1,v3,&vct2[2]);

			for (k=0; k<3; k++) {
			   (flxrots[l].cooh[j])[i].coo[k] = 
			     ( cosa*vct2[0] + sina*vct2[2])*v1[k] +
			     (-sina*vct2[0] + cosa*vct2[2])*v3[k] +
			     v2[k]*vct2[1] + (flxrots[l].coo[0])[1].coo[k];
			}



		}
 
	   }

	   for (i = 0; i < RDrots[aminotyp].numc[1]; i++) {       
		if (vln(vctb) > tol && vln(v2b) > tol && 
			vln(v3b) > tol) {


		  for (k=0; k<3; k++) {
                     vctb1[k] = (flxrots[l].cooh[j])[i].coo[k] - 
			(flxrots[l].coo[0])[1].coo[k];
		  }

                  imprd(vctb1,v1b,&vctb2[0]);
                  imprd(vctb1,v2b,&vctb2[1]);
                  imprd(vctb1,v3b,&vctb2[2]);

		  for (k=0; k<3; k++) {
			(flxrots[l].cooh[j])[i].coo[k] = 
			   ( cosba*vctb2[1] + sinba*vctb2[2])*v2b[k] +
			   (-sinba*vctb2[1] + cosba*vctb2[2])*v3b[k] +
			   v1b[k]*vctb2[0] + (flxrots[l].coo[0])[1].coo[k];
		  }


		}

	   }
	}
   }
}

#define HISD 1.02/0.52917706e0

void rotset(irs,irot)
int irs;
int irot;
{
	int i,j,k,l,ls,aminotyp,recon,frst;
	double D[3],E[3];

	recon = 0;

	aminotyp = calfptr->iamino[irs-1]-1;
	for (l=0; l<pmfrot->ndrs; l++) {
	   if (pmfrot->idrs[l] == irs) {
		ls = l; 
		break;
	   }
	}

	frst = 0;
	for (l=0; l<incompl->nincmp; l++) {
	   if (incompl->incomp[l] == irs) {
		frst = l; 
		incompl->incomp[l] = -irs;
		break;
	   }
	}

#if defined(VMS) || defined(UNDERSC)
	getpdb(&irs,ipdb,ihpdb);
#else
#ifdef CRAY
	GETPDB(&irs,ipdb,ihpdb);
#else
	getpdb_(&irs,ipdb,ihpdb);
#endif
#endif


	for (i = 0; i < flxrots[ls].numc[0]; i++) {       
	   j = flxrots[ls].pdb[i];
		if (ipdb[j] > 0) {
		   if (j != 0 && j != 1 && j != 2 && j != 3) {
		      for (k = 0; k < 3; k++) 
			xyzp->coo[3*(ipdb[j]-1)+k] = 
			(flxrots[ls].coo[irot])[i].coo[k];
		   }
		} else {
		   recon = 1;
		   for (k = 0; k < 3; k++) 
		   xyzp->coo[3*(*xyzp->iatoms)+k] = 
			(flxrots[ls].coo[irot])[i].coo[k];
		   xyzp->iresid[*xyzp->iatoms] = irs;
		   xyzp->ipdbt[*xyzp->iatoms] = flxrots[ls].pdb[i] + 1;
		   xyzp->iaton[*xyzp->iatoms] = 1;
		   xyzp->ianz[*xyzp->iatoms] = sym[flxrots[ls].pdb[i]];
		   xyzp->iatclr[*xyzp->iatoms] = 1;
		   xyzp->ityp[*xyzp->iatoms] = flxrots[ls].ipdbt[i];
		   (*xyzp->iatoms)++;
		   ipdb[j] = *xyzp->iatoms;
		}
	}

	if (aminotyp == 16) {
		for (k = 0; k < 3; k++) {
		   D[k] = 
			xyzp->coo[3*(ipdb[5]-1)+k] + 
			xyzp->coo[3*(ipdb[12]-1)+k] - 
			2.0*xyzp->coo[3*(ipdb[19]-1)+k];
		   D[k] =  -D[k];
		   E[k] = 
			xyzp->coo[3*(ipdb[10]-1)+k] + 
			xyzp->coo[3*(ipdb[12]-1)+k] - 
			2.0*xyzp->coo[3*(ipdb[23]-1)+k];
		   E[k] =  -E[k];
		}
		vscal(D,HISD,1.0e-6);
		vscal(E,HISD,1.0e-6);
	}

	for (i = 0; i < flxrots[ls].numc[1]; i++) {       
	   j = flxrots[ls].pdbh[i];
	   if (j != 0 && j != 3 && j != 4) {
		if (ihpdb[j] > 0) {
		   for (k = 0; k < 3; k++) 
		   xyzp->coo[3*(ihpdb[j]-1)+k] = 
			(flxrots[ls].cooh[irot])[i].coo[k];
		} else {
		   if (frst) {
		 	recon = 1;
			for (k = 0; k < 3; k++) 
			xyzp->coo[3*(*xyzp->iatoms)+k] = 
			(flxrots[ls].cooh[irot])[i].coo[k];
			xyzp->iresid[*xyzp->iatoms] = irs;
			xyzp->ipdbt[*xyzp->iatoms] = flxrots[ls].pdbh[i] + 1;
			xyzp->iaton[*xyzp->iatoms] = 1;
			xyzp->ianz[*xyzp->iatoms] = 1;
			xyzp->iatclr[*xyzp->iatoms] = 1;
			xyzp->ityp[*xyzp->iatoms] = flxrots[ls].ipdbth[i];
			(*xyzp->iatoms)++;
			ihpdb[j] = *xyzp->iatoms;
		   }
		}
	   }
	}

	if (aminotyp == 16) {
	    if (ihpdb[21] > 0 && ihpdb[33] > 0) {
		for (k = 0; k < 3; k++) {
		   xyzp->coo[3*(ihpdb[21]-1)+k] = 
			xyzp->coo[3*(ipdb[19]-1)+k] + D[k];
		   xyzp->coo[3*(ihpdb[33]-1)+k] = 
			xyzp->coo[3*(ipdb[23]-1)+k] + E[k];
		}
	    } else if (ihpdb[21] > 0 ) {
		for (k = 0; k < 3; k++) 
		   xyzp->coo[3*(ihpdb[21]-1)+k] = 
			xyzp->coo[3*(ipdb[19]-1)+k] + D[k];
	    } else if (ihpdb[33] > 0 ) {
		for (k = 0; k < 3; k++) 
		   xyzp->coo[3*(ihpdb[33]-1)+k] = 
			xyzp->coo[3*(ipdb[23]-1)+k] + E[k];
	    }
	}


	if (recon) {
	   aminotyp++;

	   NW_MKBACK = 1;

#if defined(VMS) || defined(UNDERSC)
	   mkcon(ipdb,&aminotyp,&irs,ihpdb,&ONE,&ONE);
#else
#ifdef CRAY
	   MKCON(ipdb,&aminotyp,&irs,ihpdb,&ONE,&ONE);
#else
	   mkcon_(ipdb,&aminotyp,&irs,ihpdb,&ONE,&ONE);
#endif
#endif

	   NW_MKBACK = 0;

#if defined(VMS) || defined(UNDERSC)
	   dfires();
#else
#ifdef CRAY
	   DFIRES();
#else
	   dfires_();
#endif
#endif
	}
#ifdef DOGL
	if (vis) ogres(irs,1,1);
#endif
}

