c
c     Reading Symmetry and MO Sections
c
c     *********************************
c     read all symmetry data
c     *********************************
c
      subroutine rwsym(iu,jout)
c
      include 'tape21.fh'
      include 'general.fh'
      include 'symmetry.fh'
      integer iu,jout
c
      integer nsym,npeq
      integer ispin,isym
      integer ndxorb, ndxvec
      integer nbas,nsos,isos
      integer norb(nrepmx,2)
      Integer indx(norbmx,2)
c      integer jasym(npmx),jjsym(npmx)
c
c     String defining ADF KF Section%SubSection
      integer ls,k,i,ind
      integer is1,is2,no,io,k1,k2
      character key*(lchars)
      character cdummy*(lchars)
      Character namorb*(lchars)  
      Character*5 spin(2)
      dimension namorb(norbmx,2)
      double precision  rwk1(ndim), rwk2(naomx)
      double precision hartreev
      Data hartreev/27.2107D00/
      Data spin/'Alpha','Beta '/
c
c ----------------------------------------------------------------------
c     Section ADF Symmetry
c ----------------------------------------------------------------------
c
      key = 'Symmetry%nsym'
      call kfrdi(iu,key,nsym)
      key = 'Symmetry%npeq'
      call kfrdi(iu,key,npeq)
      key = 'Symmetry%symlab'
      call kfrdns(iu,key,rep,nsym,1)
      key = 'Symmetry%nfcn'
      call kfrdni(iu,key,nbs,nsym,1)
c
c  check dimensions
c
      if (nsym.gt.nrepmx) then
         write(*,*) ' No. of irreps ',nsym,
     &        ' exceed the maximum allowed:', nrepmx
         stop
      end if
c
      if (npeq.gt.npmx) then
         write(*,*)' No. of symmetry unique pair atoms ',npeq,' is too',
     +        ' large.'
         stop
      end if
c      key = 'Symmetry%jjsym'
c      call kfrdni(iu,key,jjsym,npeq,1)
c      key = 'Symmetry%jasym'
c      call kfrdni(iu,key,jasym,npeq,1)
c
c
c
      do ispin = 1,nspin
c  ndxorb counts the total ispin orbitals
         ndxorb=0
         ndxvec=0
         do isym=1,nsym
            call csend(rep(isym),ls)
            nbas = nbs(isym)
            if (ispin.eq.1) then
               if(nbas.gt.naomx)then
                  write(*,*) ' too many basis functions:',
     &                 nbas,' increase naomx'
                  stop
               end if
               key = rep(isym)(1:ls)//'%npart'
               call kfrdni(iu,key,npart(1,isym),nbas,1)
            end if
            if (ispin.eq.1) key = rep(isym)(1:ls)//'%nmo_A'
            if (ispin.eq.2) key = rep(isym)(1:ls)//'%nmo_B'
            call kfrdi(iu,key,norb(isym,ispin))
            nsos=norb(isym,ispin)
            if (ispin.eq.1) key = rep(isym)(1:ls)//'%froc_A'
            if (ispin.eq.2) key = rep(isym)(1:ls)//'%froc_B'
            call kfrdnr(iu,key,rwk1,nsos,1)
            if (ispin.eq.1) key = rep(isym)(1:ls)//'%eps_A'
            if (ispin.eq.2) key = rep(isym)(1:ls)//'%eps_B'
            call kfrdnr(iu,key,rwk2,nsos,1)
            do k=1,nsos
               ndxorb=ndxorb+1
               froc(ndxorb,ispin)=rwk1(k)
               eigval(ndxorb,ispin)=rwk2(k)*hartreev
               symorb(ndxorb,ispin)=isym
            end do
            if (ndxorb.gt.norbmx) then
               write(6,*)' ndxorb=',ndxorb,' gt norbmx. Stop'
               stop
            end if
c
            if (ispin.eq.1) key = rep(isym)(1:ls)//'%Eigen-Bas_A'
            if (ispin.eq.2) key = rep(isym)(1:ls)//'%Eigen-Bas_B'
            call kfrdnr(iu,key,rwk1,nsos*nbas,1)
            ind=0
            do isos = 1, nsos
               ndxvec=ndxvec+1
               do k=1,nbas
                  ind = ind+1
                  eigvec(k,ndxvec,ispin)=rwk1(ind)
               enddo
            enddo
            if (ndxvec.ne.ndxorb) then
               write(*,*) ' No. of orbitals ',ndxorb,
     &              ' and no. of vectors ',
     &              ndxvec,' do not coincide !!!!!'
               stop
            end if
            norbtot=ndxorb
c     
         enddo
      enddo
c
c     ********************************************************
c     Creating a string with the orbitals labelled by symmetry
c     ********************************************************
c
      do ispin=1,nspin
         is1=symorb(1,ispin)
         ind=0
         do no=1,norbtot
c *** numbering the orbitals beloging to the same irrep
            is2=symorb(no,ispin)
            if (is2.eq.is1) then
               ind=ind+1
            else
               is1=is2
               ind=1
            end if
            write(namorb(no,ispin),'(I3,A10)') ind,rep(is2)
         end do
      end do
c
c     Sorting the eigenvalues in ascending energy ordering.
c
      do ispin=1,nspin
         call indexx (norbtot,eigval(1,ispin),indx(1,ispin))
      end do
c
c
c     ******************
c     Write ATOM Section
c     ******************
c
      call secwtit(jout,'MO',2,' ',0)
c
      if (nspin.eq.1) then
         call cifwrite('  No. Symm.      Energy  Occup')
         do io=1,norbtot
            k=indx(io,1)
            write(cdummy,'(1x,I3,A10,F10.4,F5.2)') io,namorb(k,1),
     +           eigval(k,1),froc(k,1)
            call cifwrite(cdummy)
         end do
      else
         write(cdummy,'((''     No.  Symm.       Energy  Occup'',
     +        ''   No.  Symm.       Energy  Occup                ''))')
         call cifwrite(cdummy)
         do io=1,norbtot
            k1=indx(io,1)
            k2=indx(io,2)
            write(cdummy,'(2(3x,I3,2x,A10,F10.4,F5.2))') io,
     +           namorb(k1,1),
     +           eigval(k1,1),froc(k1,1),io,namorb(k2,2),eigval(k2,2),
     +           froc(k2,2)
            call cifwrite(cdummy)
         end do
      end if
      write(cdummy,'('' Writing MO ....'',$)')
      call cifwrite(cdummy)
      do ispin=1,nspin
         do io=1,norbtot
            k=indx(io,ispin)
            isym=symorb(k,ispin)
            nbas=nbs(isym)
c     
            write(jout,'(A)') ' Sym= '//namorb(k,ispin)
            cdummy = ' Ene= '
            write(jout,'(A6,F10.4)') cdummy,eigval(k,ispin)/hartreev
            write(jout,'(A)') ' Spin= '//spin(ispin)
            cdummy = ' Occup= '
            write(jout,'(A8,F10.2)') cdummy,froc(k,ispin)
            write(jout,'(I4,1X,F10.6)') (npart(i,isym),
     +           eigvec(i,k,ispin),i=1,nbas)
         end do
      end do
c


      end
