//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module simpledict

import StdClass, StdList, StdMisc
import basic

:: SimpleDict key value :== [(key, value)]
emptySimpleDict :== []

findDefault :: (SimpleDict k v) k v -> v | Ord k
findDefault dict k v = return (find dict k) v
where
	return (PRESENT v) _	= v
	return ABSENT v			= v 

get :: (SimpleDict k v) k -> v | Ord, toString k
get [(k1, v) : dict] k2
| k1 < k2	= get dict k2
| k1 > k2	= abort ("get: value with key " +++ toString k2 +++ " not present")
			= v
get [] k	= abort ("get: value with key " +++ toString k +++ " not present")

find :: (SimpleDict k v) k -> Optional v | Ord k
find [(k1, v) : dict] k2
| k1 < k2	= find dict k2
| k1 > k2	= ABSENT
			= PRESENT v
find [] k	= ABSENT

findList :: (SimpleDict k v) [k]	-> [(k,v)] | Ord k
findList dict list = findList dict list []
where
	findList dict [k : ks] acc	= findList dict ks (include k (find dict k) acc)
	findList dict [] acc		= acc
	
	include k (PRESENT v) acc	= [(k,v) : acc]
	include k ABSENT acc		= acc

toList :: (SimpleDict k v) -> [(k,v)]
toList dict = dict

insertReplace :: (SimpleDict key v) (key,v) -> SimpleDict key v	| Ord key
insertReplace [(k1, v1) : dict] (k2, v2)
| k1 < k2	= [(k1, v1) : insertReplace dict (k2, v2)]
| k1 > k2	= [(k2, v2), (k1, v1) : dict]
			= [(k2, v2) : dict]
insertReplace [] (k, v) = [(k,v)]

insertKeep :: (SimpleDict key v) (key,v) -> SimpleDict key v	| Ord key
insertKeep [(k1, v1) : dict] (k2, v2)
| k1 < k2	= [(k1, v1) : insertKeep dict (k2, v2)]
| k1 > k2	= [(k2, v2), (k1, v1) : dict]
			= [(k1, v1) : dict]
insertKeep [] (k, v) = [(k,v)]

//insertReplaceList :: (SimpleDict key v) [(key,v)] -> dict key v
insertReplaceList dict list :== foldl insertReplace dict list

//insertKeepList :: (SimpleDict key v) [(key,v)] -> dict key v
insertKeepList dict list :== foldl insertKeep dict list
