//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module scanbin

import StdString

//
// Scan Functions
//

takeString :: !Int [Char] -> ([Char], !String)

takeInt32	:: [Char] -> ([Char], !Int)
takeInt16	:: [Char] -> ([Char], !Int)
takeInt8	:: [Char] -> ([Char], !Int)
take2Int4	:: [Char] -> ([Char], !(!Int, !Int))

takeListElement :: [a] -> ([a], a)

takeN_ :: !Int (.s -> (.s, a)) [a] .s -> (.s, [a])

//takeN :: !Int (.s -> (.s, a)) .s -> (.s, [a])
takeN n f s :== takeN_ n f [] s

//takeNxN :: !Int !Int (.s -> (.s, a)) .s -> (.s, [[a]])
takeNxN x y f s :== takeN y (takeN x f) s

takeNfromSegments:: !Int !Int (.s -> (.s, a)) [.s] -> [a]
takeSeq :: [((gs,s) -> ((gs,s), a))] (gs,[s]) -> ((gs,[s]), [a])
