//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module imagePlanes

import matrix, colourTransform

:: GreyImage :== Matrix Int
:: PlanarColourImage :== [GreyImage]
:: ChunkyColourImage :== Matrix [Int]

:: Image
	= Chunky Int ChunkyColourImage
	| Planar Int PlanarColourImage
	| Grey Int GreyImage
	
	// Special chunky cases
	
	| Chunky3xN Int (Matrix (Int, Int, Int))
	| Chunky4xN Int (Matrix (Int, Int, Int, Int))
	
	| Chunky3x8 GreyImage
	| Chunky4x8 GreyImage
		
imageToCharList :: Image Int Int [Char] -> [Char]

