//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module basic

import StdString, StdChar, StdBool, StdList, StdMisc, StdReal

class merge a :: a a -> a

:: Optional a	= PRESENT a
				| ABSENT

instance merge Optional a | merge a
where
	merge (PRESENT x) (PRESENT y) = PRESENT (merge x y)
	merge ABSENT x = x
	merge x ABSENT = x

//pi :: Real
pi :== 3.14159265358979323846

//ceiling :: Real -> Int
ceiling a :== ~(entier(~a))

//toInt does not round correctly!
//round :: Real -> Int
round r :== entier (r + 0.5)
	
instance toBool Int
where
	toBool i = i <> 0

intToDigit n :== '0' + (toChar n)

map2 :: (.a .b -> .c) [.a] [.b] -> [.c]
map2 f [a : as] [b : bs] = [f a b : map2 f as bs]
map2 f _ _ = []

map3 :: (.a .b .c -> .d) [.a] [.b] [.c] -> [.d]
map3 f [a : as] [b : bs] [c : cs] = [f a b c : map3 f as bs cs]
map3 f _ _ _ = []

map4 :: (.a .b .c .d -> .e) [.a] [.b] [.c] [.d] -> [.e]
map4 f [a : as] [b : bs] [c : cs] [d : ds] = [f a b c d : map4 f as bs cs ds]
map4 f _ _ _ _ = []

zip3::[.a] [.b] [.c] -> [(.a,.b,.c)]
zip3 [a:as] [b:bs] [c:cs] = [(a,b,c):zip3 as bs cs]
zip3 _ _ _ = []

zip4::[.a] [.b] [.c] [.d] -> [(.a,.b,.c,.d)]
zip4 [a:as] [b:bs] [c:cs] [d:ds] = [(a,b,c,d):zip4 as bs cs ds]
zip4 _ _ _ _ = []

hexDigitToInt c
| isDigit c				= digitToInt c
| c >= 'a' && c <= 'f'	= (toInt c) - (toInt 'a') + 10
| c >= 'A' && c <= 'F'	= (toInt c) - (toInt 'A') + 10
						= abort "not a hexadecimal digit"

intToHexDigit n
| n >= 0
	| n < 10	= toChar (n + (toInt '0'))
	| n < 16	= toChar (n - 10 + (toInt 'a'))
				= abort "not a hexadecimal value"
= abort "not a hexadecimal value"

hexToChar :: !Char !Char -> Char	
hexToChar h1 h2 = toChar ((hexDigitToInt h1) << 4 bitor (hexDigitToInt h2))

charToHex :: !Char -> (!Char,!Char)
charToHex c = ((intToHexDigit ((toInt c) >> 4)), (intToHexDigit ((toInt c) bitand 15)))

char1 i :== toChar i
char2 i :== toChar (i >> 8)
char3 i :== toChar (i >> 16)
char4 i :== toChar (i >> 24)

mergeSort :: [a] -> [a] | < a
mergeSort list = hd (reduce (pair list))
where

	// create a list of ordered pairs, and remove duplicates
	
	pair [x1, x2 : xs]
	| x1 < x2	= [[x1, x2] : pair xs]
	| x2 < x1	= [[x2, x1] : pair xs]
				= pair [x1 : xs]
	pair x = [x]
	
	// repeatedly combine two merged (and ordered) lists into one
	
	reduce [x1, x2 : xs] = reduce [combine x1 x2 : reducePairs xs]
	reduce x = x
	
	reducePairs [x1, x2 : xs] = [combine x1 x2 : reducePairs xs]
	reducePairs x = x
	
	// combine two merged (and ordered) lists into a new one
	
	combine [a : as] [b : bs]
	| a < b		= [a : combine as [b : bs]]
	| b < a		= [b : combine [a : as] bs]
				= combine [a : as] bs
	combine a [] = a
	combine [] b = b
