//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module imagePlanes

import StdClass, StdChar, StdMisc, StdList
import basic, matrix, colourTransform

:: Rect :== (!Int, !Int, !Int, !Int)

:: GreyImage :== Matrix Int
:: PlanarColourImage :== [GreyImage]
:: ChunkyColourImage :== Matrix [Int]

:: Image
	= Chunky Int Rect ChunkyColourImage
	| Planar Int Rect PlanarColourImage
	| Grey Int Rect GreyImage
	
	// Special chunky cases
	
	| Chunky3xN Int Rect (Matrix (Int, Int, Int))
	| Chunky4xN Int Rect (Matrix (Int, Int, Int, Int))
	
	| Chunky3x8 Rect GreyImage
	| Chunky4x8 Rect GreyImage
	
//
// At the moment we only support conversion of 8-bit images to character
// lists.
//

imageToCharList :: Image [Char] -> [Char]
imageToCharList image rest
	= case image of
		(Grey 8 clip image)
			-> clipImage pixel1x8 clip image rest
		(Chunky3xN 8 clip image)
			-> clipImage pixel3x8 clip image rest
		(Chunky4xN 8 clip image)
			-> clipImage pixel4x8 clip image rest
		(Chunky 8 clip image)
			-> clipImage pixelNx8 clip image rest

pixel1x8 a rest = [toChar a : rest]
pixel3x8 (a,b,c) rest = [toChar a, toChar b, toChar c : rest]
pixel4x8 (a,b,c,d) rest = [toChar a, toChar b, toChar c, toChar d : rest]

pixelNx8 [c : cs] rest 
	= [toChar c : pixelNx8 cs rest]
pixelNx8 [] rest
	= rest

clipImage :: (a [Char] -> [Char]) Rect (Matrix a) [Char] -> [Char]
clipImage pixel (left,top,right,bottom) image rest
	= cutOff pixel (right - left) (bottom - top) (origin left top image) rest
where

	origin x y image = map (drop x) (drop y image)

	cutOff :: (a [Char] -> [Char]) Int Int (Matrix a) [Char] -> [Char]
	cutOff f width height [row : rows] rest
	| height > 0
		= clipRow f width row (cutOff f width (height - 1) rows rest)
		= rest
	where
		clipRow f width [pixel : pixels] rest
		| width > 0
			= f pixel (clipRow f (width - 1) pixels rest)
			= rest
		clipRow _ width [] rest
		| width == 0
			= rest
			= abort "cutOff: image width too small"
	
	cutOff _ _ height [] rest
	| height == 0
		= rest
		= abort "cutOff: image height too small"

