//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module colourTransform

:: Colour1Transformer :== !Int -> Int
:: Colour2Transformer :== (!Int, !Int) -> (!Int, !Int)
:: Colour3Transformer :== (!Int, !Int, !Int) -> (!Int, !Int, !Int)
:: Colour4Transformer :== (!Int, !Int, !Int, !Int) -> (!Int, !Int, !Int, Int)
:: ColourNTransformer :== [Int] -> [Int]

:: ColourTransformRecord =
	{
		signedRangeLimit	:: Colour1Transformer,
		unsignedRangeLimit	:: Colour1Transformer,
		ycc2RGB 			:: Colour3Transformer,
		yccK2CMYK			:: Colour4Transformer
	}

//
// Actually, only precision 8 and 12 will be used for JPEG decoding. We don't
// care. The other entries will never be evaluated.

ColourTransformFunctions :: {ColourTransformRecord}

SignedRangeLimitFunction	:: !Int -> Colour1Transformer
Ycc2RGBFunction				:: !Int -> Colour3Transformer
YccK2CMYKFunction			:: !Int -> Colour4Transformer
