module client

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program implements a minimal TCP session (client).
//  ********************************************************************************

import StdEnv, StdIO, StdTCP

clientConnect :: !*World -> (!TCP_DuplexChannel,!*World)
clientConnect world
	# (mbIPAddr,world)			= lookupIPAddress "martinpc.cs.kun.nl" world
	| isNothing mbIPAddr
		= abort "DNS lookup failed"
    # ipAddr					= fromJust mbIPAddr
	# (tReport,mbDuplex,world)	= connectTCP_MT Nothing (ipAddr,2000) world
    | tReport<>TR_Success
		= abort "can't connect to port 2000"
	| otherwise
		# duplexChannel			= fromJust mbDuplex
		= (duplexChannel,world)

clientSend :: TCP_SChannel *World -> (TCP_SChannel,*World)
clientSend sChannel world = send (toByteSeq "hello server") sChannel world

Start world
    # ({sChannel,rChannel},world)	= clientConnect world
	# (sChannel,world)				= clientSend    sChannel world
	# world							= closeChannel  sChannel world
	# world							= closeRChannel rChannel world
    = world
