implementation module stopwatch

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a stopwatch process component. 
//  It uses three timers to track the seconds, minutes, and hours separately.
//  Message passing is used to reset, pause, and continue timing. 
//  The current time is displayed using a dialogue.
//  ********************************************************************************

import StdEnv,StdIO

::	DialogIds
	=	{	secondsId		:: Id
		,	minutesId		:: Id
		,	hoursId			:: Id
		}
::	TimerInfo
	=	{	timerId			:: Id
		,	timerRId		:: RId StopwatchCommands
		,	timerInterval	:: TimerInterval
		}
::	StopwatchCommands
	=	Reset
	|	Pause
	|	Continue
	|	Close

second	:== ticksPerSecond
minute	:== 60*second
hour	:== 60*minute

openDialogIds :: *env -> (DialogIds,*env) | Ids env
openDialogIds env
	# ([secondsid,minutesid,hoursid:_],env) = openIds 3 env
	= ({ secondsId=secondsid,minutesId=minutesid,hoursId=hoursid }, env)

openTimerInfos :: *env -> ([TimerInfo],*env) | Ids env
openTimerInfos env
	# (tids,env)  = openIds  3 env
	# (rids,env)  = openRIds 3 env
	# intervals   = [second,minute,hour]
	= ( [  {timerId=tid,timerRId=rid,timerInterval=i}
		\\ tid<-tids & rid<-rids & i<-intervals
		]
	  , env
	  )

stopwatch :: (RId StopwatchCommands) -> Process
stopwatch rid
	= Process NDI Void initialise` []
where
	initialise` pst
		# (dialogIds, pst) = accPIO openDialogIds  pst
		# (timerInfos,pst) = accPIO openTimerInfos pst
		= initialise rid dialogIds timerInfos pst

initialise :: (RId StopwatchCommands) DialogIds [TimerInfo] (PSt .l) -> PSt .l
initialise rid {secondsId,minutesId,hoursId} timerinfos pst
	# (errors,pst)	= seqList [  openTimer 0 (tdef timerinfo)
							  \\ timerinfo<-timerinfos
							  ]  pst
	| any ((<>) NoError) errors
		= closeProcess pst
	# (error,pst)	= openDialog Void ddef pst
	| error<>NoError
		= closeProcess pst
	# (error,pst)	= openReceiver Void rdef pst
	| error<>NoError
		= closeProcess pst
	| otherwise
		= pst
where
	tdef {timerId,timerRId,timerInterval}
		= Timer timerInterval (Receiver timerRId receive [])
			[	TimerId			timerId
			,	TimerFunction	tick
			]
	where
		tick nrElapsed (time,pst=:{io})
			# time	= (time+nrElapsed) mod maxunit
			# io	= setControlText textid (toString time) io
			= (time,{pst & io=io})
        
		receive Reset (time,pst=:{io})
			# io	= disableTimer timerId io
			# io	= enableTimer  timerId io
			# io	= setControlText textid "00" io
			= (0,{pst & io=io})
		receive Pause (time,pst=:{io})
			= (time,{pst & io=disableTimer timerId io})
		receive Continue (time,pst=:{io})
			= (time,{pst & io=enableTimer timerId io})
            
        (textid,maxunit)	= if (timerInterval==second) (secondsId,60)
        					 (if (timerInterval==minute) (minutesId,60)
        					 							 (hoursId,  24))
    
	ddef	= Dialog "Stopwatch"
				(	LayoutControl
				(	ListLS	[  TextControl text [ControlPos (Left,zero)]
							\\ text<-["Hours:","Minutes:","Seconds:"]
							]
				)	[]
				:+:	LayoutControl
				(	ListLS	[  TextControl "0"  [ControlPos (Left,zero)
												,ControlId  id
												,ControlWidth (ContentWidth "00")
												]
							\\ id<-[hoursId,minutesId,secondsId]
							]
				)	[]
				)	[ WindowClose (noLS closeProcess) ]
	rdef	= Receiver rid (noLS1 receive) []
    where
		receive Close pst
			= closeProcess pst
		receive msg pst
			= snd (seqList [syncSend timerRId msg \\ {timerRId}<-timerinfos] pst)
