module resize

// example program to resizing controls

import StdEnv, StdIO

Start :: *World -> *World
Start world
	=	startSDI 0 0 0 wdef id [ProcessClose closeProcess] world
where
	wdef	= Window "Window" compound
				[	WindowClose	(noLS closeProcess)
				,	WindowResize
				,	WindowHMargin 0 0
				,	WindowVMargin 0 0
				,	WindowItemSpace 0 0
				]
	compound= CompoundControl
				(ListLS [custom,custom,custom])
				[	ControlResize compoundresize
				,	ControlSize	csize
				,	ControlHMargin 0 0
				,	ControlVMargin 0 0
				,	ControlItemSpace 0 0
				,	ControlLook look
				]
	compoundresize _ _ newwsize
			= {newwsize & w=newwsize.w/3*3}
	csize	= {w=210,h=210}
	custom	= CustomControl {w=csize.w/3,h=20} look [ControlResize resize]
	resize curcsize oldwsize {w}
			//= {curcsize & w=w}
			= {curcsize & w=w/3}
	look _ {newFrame=frame=:{corner1,corner2}} picture
		# picture	= draw frame picture
		# picture	= drawLine corner1 corner2 picture
		# picture	= drawLine {corner1 & y=corner2.y} {corner2 & y=corner1.y} picture
		= picture
