module openclose

// example program to illustrate dynamic closing and opening of controls

import StdEnv, StdIO

Start :: *World -> *World
Start world
	=	startSDI 0 0 0 wdef id [ProcessClose closeProcess] world
where
	wdef	= Window "Window"
				(ListLS [control,control,control])
				//[	WindowId	wid
				[	WindowClose	(noLS closeProcess)
				,	WindowResize
				,	WindowSize	wsize
				,	WindowHMargin 0 0
				,	WindowVMargin 0 0
				,	WindowItemSpace 0 0
				]
	wsize	= {w=200,h=210}
	control	= CustomControl {w=wsize.w/3,h=20} look [ControlResize resize]
	resize curcsize oldwsize {w}
			//= {curcsize & w=w}
			= {curcsize & w=w/3}
	look _ {newFrame=frame=:{corner1,corner2}} picture
		# picture	= draw frame picture
		# picture	= drawLine corner1 corner2 picture
		# picture	= drawLine {corner1 & y=corner2.y} {corner2 & y=corner1.y} picture
		= picture

