module showbitmap

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a window that displays a user selected bitmap.
//  Make sure that this application has sufficient heap or extra memory.
//  ********************************************************************************

import StdIO, StdEnv

Start :: *World -> *World
Start world
	# (maybeFile,world)		= selectInputFile world
	| isNothing maybeFile
		= world
	# bitmapfile			= fromJust maybeFile
	# (maybeBitmap,world)	= openBitmap bitmapfile world
	| isNothing maybeBitmap
		= world
	| otherwise
		# bitmap			= fromJust maybeBitmap
		  bitmapsize		= getBitmapSize bitmap
		  window			= Window "Bitmap" NilLS
								[	WindowViewSize	bitmapsize
								,	WindowLook		True (\_ _->drawAt zero bitmap)
								,	WindowClose		(noLS closeProcess)
								]
		= startIO SDI
				  Void
				  (snd o openWindow Void window)
	              [ProcessClose closeProcess]
	              world
