module mousespotting

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program monitors mouse input that is sent to a Window.
//  ********************************************************************************

import StdEnv,StdIO

Start :: *World -> *World
Start world
    # (wid,world)	= openId world
    # window		= Window "mousespotting" NilLS
						[   WindowMouse		(const True) Able (noLS1 (spotting wid))
						,   WindowId        wid
						,   WindowClose     (noLS closeProcess)
						]
    = startIO SDI
    		  Void
    		  (snd o openWindow Void window)
    		  [ProcessClose closeProcess]
    		  world
where
	spotting :: Id x (PSt .l) -> PSt .l | toString x
	spotting wid x pst
	    = appPIO (setWindowLook wid True (False,look (toString x))) pst
		
	look :: String SelectState UpdateState *Picture -> *Picture
	look text _ {newFrame} picture
	    # picture			= unfill newFrame picture
	    # (width,picture)	= getPenFontStringWidth text picture
	    = drawAt {x=(w-width)/2,y=h/2} text picture
	where
		{w,h}				= rectangleSize newFrame
