module clipboardview

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a dialogue to display and change the current content
//	of the clipboard. 
//  ********************************************************************************

import StdEnv, StdIO

Start :: *World -> *World
Start world
	# (showid,world) = openId world
	# (setid, world) = openId world
	= startProcesses (Process NDI Void (initialise showid setid) []) world

initialise showid setid pst
	# (error,pst)	= openDialog Void clipview pst
	| error<>NoError= closeProcess pst
	| otherwise		= pst
where
	clipview= Dialog "Clipboard Viewer" ( showclip :+: setclip :+: quit ) []
	showclip= EditControl "" width nrlines [ ControlSelectState Unable
										   , ControlId          showid
										   , ControlPos         (Left,zero)
										   ]
			  :+:
			  ButtonControl "Show"		   [ ControlFunction    (noLS show) ]
	setclip	= EditControl "" width nrlines [ ControlId          setid
										   , ControlPos         (Left,zero)
										   ]
			  :+:
			  ButtonControl "Set"		   [ ControlFunction    (noLS set) ]
	quit	= ButtonControl "Quit"		   [ ControlFunction    (noLS closeProcess)
										   , ControlPos         (Center,zero)
										   ]
	width	= PixelWidth (hmm 50.0)
	nrlines	= 4
	
	show pst
		# (content,pst)	= getClipboard pst
		# text			= getString content
		= appPIO (setControlText showid text) pst
	
	set pst
		# (wst,pst)	    = accPIO (getParentWindow showid) pst
		# text			= fromJust (snd (getControlText setid (fromJust wst)))
		= setClipboard [toClipboard text] pst
	
	getString [clip:clips]
		| isNothing item= getString clips
		| otherwise		= fromJust item
	where
		item			= fromClipboard clip
	getString []
		= ""
