module counterreset

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a Controls component that implements a manually settable 
//	counter. A receiver is used to add a reset option.
//  ********************************************************************************

import StdEnv, StdIO

Start :: *World -> *World
Start world
    = startIO NDI Void initialise [] world
where
    initialise pst
        # (displayid,pst)	= accPIO openId  pst
        # (resetid,  pst)	= accPIO openRId pst
        # (error,    pst)	= openDialog Void (dialog displayid resetid) pst
        | error<>NoError
            = abort "counter could not open Dialog."
        | otherwise
            = pst

dialog displayid resetid
    = Dialog "Counter" (counter :+: resetbutton) [WindowClose (noLS closeProcess)]
where
    counter
		= { newLS  = initcount
		  , newDef = LayoutControl
					 (   EditControl (toString initcount) (PixelWidth (hmm 50.0)) 1
                                           [ControlSelectState Unable
                                           ,ControlId          displayid
                                           ]
					 :+: ButtonControl "-" [ControlFunction  (count (-1))
                                           ,ControlWidth     (PixelWidth (hmm 25.0))
                                           ,ControlPos       (BelowPrev,zero)
                                           ]
					 :+: ButtonControl "+" [ControlFunction  (count   1 )
                                           ,ControlWidth     (PixelWidth (hmm 25.0))
					 					   ]
					 :+: Receiver resetid reset []
					 )   [ControlPos       (Center,zero)
					 	 ,ControlHMargin   0 0
					 	 ,ControlVMargin   0 0
					 	 ,ControlItemSpace 0 0
					 	 ]
		  }
    where
        initcount  = 0
        
        count :: Int (Int,PSt .l) -> (Int,PSt .l)
        count dx (count,pst)
            = (count+dx,appPIO (setControlText displayid (toString (count+dx))) pst)
        
        reset :: m (Int,PSt .l) -> (Int,PSt .l)
        reset _ (_,pst)
            = (initcount,appPIO (setControlText displayid (toString initcount)) pst)
    
    resetbutton
        = ButtonControl "Reset"
			[ControlFunction (noLS (snd o syncSend resetid undef))
			,ControlPos      (Center,zero)
			]
