module drawingframe

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a framework in which one can test drawing functions. 
//	The program relies on a function, example, of type *Picture -> *Picture.
//  ********************************************************************************

import StdEnv,StdIO

Start :: *World -> *World
Start world
	= startIO SDI
			  Void
			  (snd o openWindow Void testwindow)
			  [ProcessClose closeProcess]
			  world

testwindow
	= Window "Test Drawing" NilLS
		[	WindowViewSize	 size
		,	WindowClose		 (noLS closeProcess)
		,	WindowLook		 True (\_ _->example)
		,	WindowViewDomain {corner1=origin,corner2=maxdomain}
		]
where
	size		= {w=200,h=50}
	origin		= {x=(-20),y=(-20)}
	maxdomain	= {x=origin.x+size.w,y=origin.y+size.h}

// Here, example draws the string "Pop" at zero
example = drawAt zero "Pop"
