module mousespotting

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program monitors mouse input that is sent to a Window which consists 
//  of a CompoundControl which consists of CustomControl.
//  ********************************************************************************

import StdEnv,StdIO

Start :: *World -> *World
Start world
    # (cid,world)	= openId world
	# custom		= CustomControl customsize (look "")
						[	ControlMouse	(const True) Able
											(noLS1 (spotting cid "Control"))
						,	ControlId		cid
						,	ControlResize	resize
						]
	# compound		= CompoundControl custom
						[	ControlMouse	(const True) Able
											(noLS1 (spotting cid "Compound"))
						,   ControlViewSize {w=customsize.w+2*margin
											,h=customsize.h+2*margin
											}
						,	ControlResize	resize
						,	ControlLook		True (look "")
						]
	# window		= Window "mousespotting" compound
						[	WindowMouse		(const True) Able
											(noLS1 (spotting cid "Window"))
						,	WindowViewSize  {w=customsize.w+4*margin
											,h=customsize.h+4*margin
											}
						,	WindowHMargin	margin margin
						,   WindowVMargin	margin margin
						,	WindowClose		(noLS closeProcess)
						]
	= startIO SDI Void (snd o openWindow Void window)
						[ProcessClose closeProcess] world
where
	customsize	= {w=550,h=100}
    margin		= 10
    resize oldCSize oldParentSize newParentSize
    	= {	w = oldCSize.w+newParentSize.w-oldParentSize.w
    	  ,	h = oldCSize.h+newParentSize.h-oldParentSize.h
    	  }
    spotting cid who x pst
        = appPIO (setControlLook cid True (True,look text)) pst
    where
    	text	= who+++":"+++toString x
    look text _ {newFrame} picture
        # picture			= unfill newFrame picture
        # picture			= draw   newFrame picture
        # (width,picture)	= getPenFontStringWidth text picture
        = drawAt {x=(w-width)/2,y=h/2} text picture
    where
        {w,h}               = rectangleSize newFrame
