implementation module notice

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a new instance of the Dialogs class to create notices.
//  ********************************************************************************

import StdTuple, StdMisc, StdFunc
import StdId, StdPSt, StdWindow

::	Notice ls pst
 =	Notice [String] (NoticeButton *(ls,pst)) [NoticeButton *(ls,pst)]
::	NoticeButton st
 =	NoticeButton String (IdFun st)

instance Dialogs Notice where
	openDialog ls notice pst
		# (okId,pst) = openId pst
		= openDialog ls (noticeToDialog okId notice) pst
	openModalDialog ls notice pst
		# (okId,pst) = openId pst
		= openModalDialog ls (noticeToDialog okId notice) pst
	getDialogType _
		= "Notice"

openNotice :: (Notice .ls (PSt .l)) (PSt .l) -> PSt .l
openNotice notice pst
	= snd (openModalDialog undef notice pst)

noticeToDialog :: Id !(Notice .ls (PSt .l))
	->	Dialog	(:+: (LayoutControl (ListLS TextControl))
				(:+: ButtonControl  (ListLS ButtonControl)
				)) .ls (PSt .l)
noticeToDialog okid (Notice texts ok buttons)
    = Dialog "" (texts`:+:ok`:+:buttons`) [WindowOk okid]
where
    texts`   = LayoutControl
                (  ListLS [  TextControl text [ControlPos (Left,zero)]
						  \\ text<-texts
						  ]
                ) [ControlHMargin 0 0,ControlVMargin 0 0,ControlItemSpace 3 3]

    ok`      = noticebutton ok [ControlPos (Right,zero),ControlId okid]

    buttons` = ListLS
                [  noticebutton button [ControlPos (LeftOfPrev,zero)]
                \\ button<-buttons
                ]

    noticebutton (NoticeButton text f) atts
        = ButtonControl text [ControlFunction f`:atts]
    where
        f` (lst,pst) = f (lst,closeActiveWindow pst)
