module server

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program implements a minimal TCP session (server).
//  ********************************************************************************

import StdEnv, StdIO, StdTCP

serverConnect :: !*World -> (!TCP_DuplexChannel,!*World)
serverConnect world
	# (ok,mbListener,world)					= openTCP_Listener 2000 world
	| not ok
		= abort "can't open Listener on port 2000"
	| otherwise
		# listener							= fromJust mbListener
		# ((_,duplexChannel),listener,world)= receive listener world
		# world								= closeRChannel listener world
		= (duplexChannel,world)

serverReceive :: String TCP_RChannel *World -> (TCP_RChannel,*World)
serverReceive expectedMessage rChannel world
	# (message,rChannel,world)				= receive rChannel world
	| toString message<>expectedMessage		= abort "received wrong message"
	| otherwise								= (rChannel, world)

Start world
	# ({sChannel,rChannel},world)	= serverConnect world
	# (rChannel,world)				= serverReceive "hello server" rChannel world
	# world							= closeChannel  sChannel world
	# world							= closeRChannel rChannel world
    = world
