module echoServer

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program demonstrates the usage of functions for event driven TCP.
//	It listens on port 7, accepts a connection, and echoes the input.
//  ********************************************************************************

import StdEnv, StdTCP, StdIO

echoPort :== 7

::	*State
	=	{ duplex:: TCP_DuplexChannel	// The channel
		, eom	:: Bool					// EOM occurred on receive channel
		}

Start :: *World -> *World
Start world
	# (_,mbListener,world)			= openTCP_Listener echoPort world
	# ((_,duplex),listener,world)	= receive (fromJust mbListener) world
	# world							= closeRChannel listener world
	= startIO NDI {duplex=duplex,eom=False} initialise [] world

/*	initialise - the function to initialise the PSt.
*/
initialise :: (PSt State) -> PSt State
initialise pst=:{ls=ls=:{duplex={rChannel,sChannel}},io}
	# (tcpRcvId,io)        = openId io
	# pst                  = {pst & ls={ls & duplex={rChannel=undef,sChannel=undef}}
                                  , io=io
                             }
//	Open a receiver for the receive channel
	# (error1,pst)		   = openReceiver tcpRcvId 
								(TCP_Receiver tcpRcvId rChannel rcvFun []) pst
//	Open a receiver for the send channel
	# (error2,sChannel,pst)= openSendNotifier tcpRcvId 
								(SendNotifier sChannel sndFun []) pst
	| error1<>NoError || error2<>NoError
		= abort "error: can't open receiver"
	| otherwise
		= {pst & ls={ls & duplex={rChannel=undef,sChannel=sChannel}}}

/*	rcvFun - the callback function for the receive channels receiver.
*/
rcvFun :: (ReceiveMsg ByteSeq) (Id,PSt State) -> (Id,PSt State)
rcvFun (Received byteSeq) (tcpRcvId,pst=:{ls=ls=:{duplex=dc=:{sChannel}},io})
	# (sChannel,io)			= send_NB byteSeq sChannel io
	# (buffSize,sChannel)	= bufferSize sChannel
	# ls					= {ls & duplex={dc & sChannel=sChannel}}
	| buffSize==0
		= (tcpRcvId,{pst & ls=ls,io=io})
	| otherwise				// Disable this receiver if the send channel is full
		# io				= disableReceivers [tcpRcvId] io
		= (tcpRcvId,{pst & ls=ls,io=io})
rcvFun EOM (tcpRcvId,pst=:{ls=ls=:{duplex=dc=:{sChannel}},io})
	# (buffSize,sChannel)	= bufferSize sChannel
	# pst					= {pst & ls={ls & duplex = {dc & sChannel=sChannel}
											, eom    = True
										}
								   , io=io
							  }
	| buffSize==0			// All data has been sent, so close program
		= (tcpRcvId,closeProcess (close pst))
	| otherwise
		= (tcpRcvId,pst)

/*	sndFun - the callback function for the send channels receiver.
*/
sndFun :: SendEvent (Id,PSt State) -> (Id,PSt State)
sndFun Sendable (tcpRcvId,pst=:{ls=ls=:{duplex=dc=:{sChannel},eom},io})
	# (sChannel,io)			= flushBuffer_NB sChannel io
	# (buffSize,sChannel)	= bufferSize sChannel
	# pst					= {pst & ls={ls & duplex={dc & sChannel=sChannel}}
								   , io=io
							  }
//	Reenable the receive channel's receiver if the send channel is still sendable.
	# pst					= case (buffSize,eom) of
								(0,False) -> appPIO (enableReceivers [tcpRcvId]) pst
								(0,True ) -> close pst
								_         -> pst
	= (tcpRcvId,pst)
sndFun Disconnected (ls,pst)
	= (ls,closeProcess pst)

close :: (PSt State) -> PSt State
close pst=:{ls=ls=:{duplex},io}
	# io	= closeChannel duplex.sChannel io
	= {pst & ls={ls & duplex={duplex & sChannel=undef}},io=io}
