module counterread

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a Controls component that implements a manually settable 
//	counter.
//  A bi-directional receiver is added to give external access to the counter value. 
//  ********************************************************************************

import StdEnv, StdIO

Start :: *World -> *World
Start world
	= startIO NDI Void initialise [] world
where
	initialise pst
		# (displayid,pst) = accPIO openId   pst
		# (resetid,  pst) = accPIO openRId  pst
		# (readid,   pst) = accPIO openR2Id pst
		# (error,    pst) = openDialog Void (dialog displayid resetid readid) pst
		| error<>NoError
			= abort "counter could not open counter dialog."
		# (displayid,pst) = accPIO openId   pst
		# (error,    pst) = openDialog Void (display displayid readid) pst
		| error<>NoError
			= abort "counter could not open display dialog."
		| otherwise
			= pst

dialog displayid resetid readid
	= Dialog "Counter" (counter:+:resetbutton) [WindowClose (noLS closeProcess)]
where
	counter
		= {	newLS  = initcount
		  ,	newDef = LayoutControl
					 (   EditControl (toString initcount) (PixelWidth (hmm 50.0)) 1
             							   [ControlSelectState Unable
             							   ,ControlId       displayid
             							   ]
					 :+: ButtonControl "-" [ControlFunction (count (-1))
					 					   ,ControlWidth    (PixelWidth (hmm 25.0))
										   ,ControlPos      (BelowPrev,zero)
										   ]
					 :+: ButtonControl "+" [ControlFunction (count   1 )
					 					   ,ControlWidth    (PixelWidth (hmm 25.0))
					 					   ]
					 :+: Receiver  resetid reset []
					 :+: Receiver2 readid  read  []
					 )   [ControlPos       (Center,zero)
					 	 ,ControlHMargin   0 0
					 	 ,ControlVMargin   0 0
					 	 ,ControlItemSpace 0 0
					 	 ]
		  }
	where
		initcount = 0
        
        count :: Int (Int,PSt .l) -> (Int,PSt .l)
        count dx (count,pst)
            = (count+dx,appPIO (setControlText displayid (toString (count+dx))) pst)
        
        reset :: m (Int,PSt .l) -> (Int,PSt .l)
        reset _ (_,pst)
            = (initcount,appPIO (setControlText displayid (toString initcount)) pst)
        
		read :: m (Int,PSt .l) -> (Int,(Int,PSt .l))
		read _ (count,pst) = (count,(count,pst))
    
    resetbutton
        = ButtonControl "Reset"
			[ControlFunction (noLS (snd o syncSend resetid undef))
			,ControlPos      (Center,zero)
			]
    
display displayid readid
	= Dialog "Read"
		(	EditControl   "" (PixelWidth (hmm 50.0)) 1
								 [ControlSelectState Unable
								 ,ControlId          displayid
								 ]
		:+:	ButtonControl "Read" [ControlFunction    (noLS read)
								 ,ControlPos         (Center,zero)
								 ]
		)	[ WindowClose (noLS closeProcess) ]
where
	read pst
		# ((error,value),pst)	= syncSend2 readid undef pst
		| error<>SendOk
			= abort "could not read counter value"
        | otherwise
			= appPIO (setControlText displayid (toString (fromJust value))) pst
