module counter

import StdEnv, StdIO

Start :: *World -> *World
Start world
	# (cid,world) = openId world
	= startIO NDI
			  Void
			  (snd o openDialog Void (ddef cid))
			  [ProcessClose closeProcess]
			  world

ddef cid
	= Dialog "Counter" (counter cid)
		[	WindowClose		(noLS closeProcess)
		,	WindowViewSize	{w=150,h=100}
		]

counter displayid
  = {newLS =count0
    ,newDef=LayoutControl 
            (   EditControl (toString count0) (ContentWidth "000") 1
                                  [ControlSelectState Unable
                                  ,ControlPos         (Left,zero)
                                  ,ControlId          displayid
                                  ]
            :+: ButtonControl "-" [ControlFunction (count (-1))]
            :+: ButtonControl "+" [ControlFunction (count 1)]
            )   [ControlHMargin   0 0
                ,ControlVMargin   0 0
                ,ControlItemSpace 0 0
                ]
    }
where
  count0 = 0
  
  count :: Int (Int,PSt .l) -> (Int,PSt .l)
  count dx (count,pst=:{io})
    = ( count+dx
      , appPIO (setControlText displayid (toString (count+dx))) pst
      )
