// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.7 - June 23, 1999 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module SampleMat

import SampleVec

:: Matrix :== {# .Vector}

uniMat :: !.Matrix -> *Matrix
uniMat a = { { aaa \\ aaa <-: aa} \\ aa <-: a}

zeroMatrix :: !Int !Int -> .Matrix
zeroMatrix n m = { zeros m \\ i <- [1 .. n]}

In :: !Int -> .Matrix
In n = { ek k n \\ k <- [0 .. dec n]}

hilbert :: !Int -> .Matrix
hilbert n = { { 1.0 / toReal (i+j-1) \\ i <- [1 .. n]} \\ j <- [1 .. n]}

prettyMatrix :: !Matrix -> String
prettyMatrix a = "\n" +++ (prettyMatrix_i 0)
where
	n = size a
	prettyMatrix_i :: Int -> String
	prettyMatrix_i i 
		| (i==n) = "\n"
		= (prettyRowVector a.[i]) +++ (prettyMatrix_i (inc i))
