// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.7 - June 23, 1999 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

definition module SampleMat

import SampleVec

:: Matrix :== {# .Vector}

uniMat		:: !.Matrix -> *Matrix	// returns a unique matrix

zeroMatrix	:: !Int !Int -> .Matrix	// returns the zero matrix of given size
In			:: !Int -> .Matrix		// returns the unit matrix of given size
hilbert		:: !Int -> .Matrix		// returns the Hilbert matrix of given size
// Elements of a Hilbert matrix are defined as 
// h_ij = 1 / (i+j+1), i,j = 0,...,n-1
// Remark: This matrix reveals particularly bad properties for direct methods
// like LU factorization.

prettyMatrix :: !Matrix -> String

