// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.5 - October 6, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

definition module Clas3

import Clas2

class MatrixMatrixProduct a
where
	(***) infix 7 :: a a -> a

instance MatrixMatrixProduct {#{# Real}}

solve 	:: *Matrix Vector -> Vector

lu 		:: *Matrix -> *Matrix		// LU factorization A=LU
// overwrites the input matrix A with both factors L and U:
//		l_11  u_12   ..      ..       u_1n
//		 ..   l_22  u_23     ..        ..
//       ..    ..    ..      ..        ..
//       ..    ..    ..      ..     u_(n-1)n 
//      l_n1  l_n2   ..   l_n(n-1)    l_nn
// The diagonal u_ii, i=1,...,n of U is constant 1 by construction.

invert 	:: *Matrix -> .Matrix		// invert matrix by means of
									// the Gauss-Jordan algorithm
									
