// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.5 - October 6, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module Clas1

import SampleVec, StdBool

dot :: .Vector .Vector -> Real
dot x y = dot_i 0
where
	n = size x
	m = size y
	dot_i :: Int -> Real
	dot_i i | (i==n) || (i==m) = 0.0
	dot_i i = (x.[i] * y.[i]) + dot_i (inc i)   
	
nrm1 :: Vector -> Real
nrm1 x = nrm1_i 0
where
	n = size x
	nrm1_i :: Int -> Real
	nrm1_i i | (i==n) = 0.0
	nrm1_i i = (abs x.[i]) + nrm1_i (inc i)
	
nrm2 :: Vector -> Real
nrm2 x = sqrt (dot x x)

nrmInf :: Vector -> Real
nrmInf x = nrmInf_i 0 0.0
where
	n = size x
    nrmInf_i :: Int Real -> Real
    nrmInf_i i max 
        | (i==n) = max
        | (abs x.[i]) > max = nrmInf_i (inc i) (abs x.[i]) 
        = nrmInf_i (inc i) max

amax :: Vector -> Int
amax x = amax_ 1 0
where
	amax_ :: Int Int -> Int
	amax_ ind max | (ind==(size x)) = inc max
	amax_ ind max | ((abs x.[ind])>(abs x.[max])) = amax_ (inc ind) ind
	amax_ ind max = amax_ (inc ind) max

rotg :: Real Real -> (Real, Real)    // (a,b) -> (c,s)
rotg a 0.0 = (0.0, 1.0) 
rotg a b | ((abs b)>(abs a)) = (s * tau, s) 
where 
	tau=(~a)/b 
	s=1.0 / (sqrt (1.0 + (tau * tau)))
rotg a b = (c, c * tau) 
where 
	tau=(~b)/a
	c=1.0 / (sqrt (1.0 + (tau * tau)))
  
rot :: Real Real -> (Real, Real)    // (a,b) -> (r,0)
rot a b = ( (c*a)-(s*b), (s*a)+(c*b))
where
	(c,s) = rotg a b


instance + {# a} | + , ArrayElem a
where 
	(+) a b = { aa + bb \\ aa <-: a & bb <-: b}

instance - {# a} | - , ArrayElem a
where 
	(-) a b = { aa - bb \\ aa <-: a & bb <-: b}

instance * {# a} | *, ArrayElem a		// Hadamard product
where
	(*) a b = { aa * bb \\ aa <-: a & bb <-: b}
	
instance / {# a} | /, ArrayElem a		// Hadamard division
where
	(/) a b = { aa / bb \\ aa <-: a & bb <-: b}
	
class ScalarProduct a
where
	(.*) infix 7 :: Real a -> a

instance ScalarProduct Real
where	
	(.*) a x = a * x

instance ScalarProduct {# a} | ScalarProduct , ArrayElem a
where	
	(.*) a x = { a .* xx \\ xx <-: x}
	
class ScalarDivision a
where
	(/.) infix 7 :: a Real -> a

instance ScalarDivision Real
where	
	(/.) x a = x / a

instance ScalarDivision {# a} | ScalarDivision , ArrayElem a
where	
	(/.) x a = { xx /. a \\ xx <-: x}
