// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.5 - October 6, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

definition module Clas1

import SampleVec, StdBool

dot  :: .Vector .Vector -> Real				//	x^T y

nrm1   :: Vector -> Real					//	||x||_1
nrm2   :: Vector -> Real					//	||x||_2
nrmInf :: Vector -> Real					//	||x||_inf

amax :: Vector -> Int						//  {k : max_j |x_j|}
											//	||x||_inf=|x_k|

											//  Givens rotation:
											//  [ c -s ] [ a ] = [ r ]
											//  [ s  c ] [ b ]   [ 0 ]
rotg :: Real Real -> (Real, Real)    		//  a b -> (c, s)
											//  applied Givens rotation
rot :: Real Real -> (Real, Real)    		//  a b -> (r, 0)
  

instance + {# a} | + , ArrayElem a
instance - {# a} | - , ArrayElem a
instance * {# a} | * , ArrayElem a			// Hadamard product
instance / {# a} | / , ArrayElem a			// Hadamard division

class ScalarProduct a
where
	(.*) infix 7 :: Real a -> a

instance ScalarProduct Real
instance ScalarProduct {# a} | ScalarProduct , ArrayElem a


class ScalarDivision a
where
	(/.) infix 7 :: a Real -> a

instance ScalarDivision Real
instance ScalarDivision {# a} | ScalarDivision , ArrayElem a
