implementation module wormshow

import	StdInt, StdBool, StdList, StdFunc
import	deltaPicture
import	wormstate

//	The drawing constants.
WormBackGroundColour	:==	RGB 1.0 1.0 0.75
WormFontSize			:==	12
PointsPos				:== (72, 15)
LifesPos				:== (255, 5)
LevelPos				:== (465,15)
CornerX					:== 15
CornerY					:== 23
SegSize					:== 4
CellSize				:== 10


//	Draw the game.
DrawGame :: !Level !Food !Points !Worm !Lives -> [DrawFunction]
DrawGame {level,obstacles} food points worm lives
=	[	EraseRectangle	((CornerX-8,0),(CornerX+SizeX*CellSize+16,CornerY+SizeY*CellSize+16))
	,	DrawBorders
	,	DrawObstacles	obstacles
	,	DrawPoints		points
	,	DrawWorm		worm
	,	DrawFood		food
	,	DrawLevel		level
	,	DrawLives		lives
	]
where
	DrawObstacles :: ![Obstacle] !Picture -> Picture
	DrawObstacles [] pict
	=	pict
	DrawObstacles obstacles pict
	#	pict	= SetPenColour (RGB 0.5 0.5 0.0)	pict
		pict	= seq (map DrawObstacle obstacles)	pict
		pict	= SetPenColour	BlackColour			pict
	=	pict
	where
		DrawObstacle :: !Obstacle !Picture -> Picture
		DrawObstacle ((ltx,lty),(rbx,rby)) pict
		=	FillRectangle ((lx,ty),(rx,by)) pict
		where
			lx	= CornerX+CellSize*ltx-2
			ty	= CornerY+CellSize*lty-2
			rx	= CornerX+CellSize*rbx+2
			by	= CornerY+CellSize*rby+2
	
	DrawPoints :: !Points !Picture -> Picture
	DrawPoints points pict
	#	pict	= SetPenColour	MagentaColour	pict
		pict	= MovePenTo		(x-57,y)		pict
		pict	= DrawString	"Points: "		pict
		pict	= SetPenColour	BlackColour		pict
		pict	= DrawNewPoints	points			pict
	=	pict
	where
		(x,y)	= PointsPos
	
	DrawWorm :: !Worm !Picture -> Picture
	DrawWorm [head:rest] pict
	#	pict	= seq (map (DrawSegment RedColour) rest)	pict
		pict	= DrawSegment	GreenColour head			pict
		pict	= SetPenColour	BlackColour					pict
	=	pict
	
	DrawLevel :: !Int !Picture -> Picture
	DrawLevel level pict
	#	pict	= SetPenColour		MagentaColour				pict
		pict	= MovePenTo			(x-50,y)					pict
		pict	= DrawString		"Level: "					pict
		pict	= SetPenColour		BlackColour					pict
		pict	= EraseRectangle	((x-1,y-12),(x+100,y+4))	pict
		pict	= MovePenTo			LevelPos					pict
		pict	= DrawString		(toString level)			pict
	=	pict
	where
		(x,y)	= LevelPos
	
	DrawLives :: !Lives !Picture -> Picture
	DrawLives lives pict
	|	lives<>0	= DrawLittleWorms lives				pict
	#	pict		= SetPenColour	MagentaColour		pict
		pict		= MovePenTo		(lx-63,ly+10)		pict
		pict		= DrawString	"No more worms!"	pict
		pict		= SetPenColour	BlackColour			pict
	|	otherwise	= pict
	where
		(lx,ly)		= LifesPos
		
		DrawLittleWorms :: !Lives !Picture -> Picture
		DrawLittleWorms lives pict
		|	lives>0		= DrawLittleWorms (lives-1) (DrawLittleWorm lives pict)
		#	pict		= SetPenColour	MagentaColour	pict
			pict		= MovePenTo		(lx-63,ly+10)	pict
			pict		= DrawString	"Worms:"		pict
			pict		= SetPenColour	BlackColour		pict
		|	otherwise	= pict
		where
			(lx,ly)		= LifesPos
			
			DrawLittleWorm :: !Int !Picture -> Picture
			DrawLittleWorm n pict
			#	pict	= SetPenSize	(4,5)		pict
				pict	= SetPenColour	RedColour	pict
				pict	= MovePenTo		(x,y)		pict
				pict	= LinePenTo		(x+9, y)	pict
				pict	= SetPenColour	GreenColour	pict
				pict	= LinePenTo		(x+10,y)	pict
				pict	= SetPenNormal				pict
			=	pict
			where
				x      = lx+20*(dec n / 2) 
				y      = ly+ 7*(dec n mod 2) 
				(lx,ly)= LifesPos

DrawBorders :: !Picture -> Picture
DrawBorders pict
#	pict	= SetPenColour	BlackColour	pict
	pict	= SetPenSize	(3,3)		pict
	pict	= DrawRectangle	((CornerX-3,CornerY-3),(CornerX+SizeX*CellSize+11,CornerY+SizeY*CellSize+11))
										pict
	pict	= SetPenNormal				pict
=	pict

DrawSegment :: !Colour !Segment !Picture -> Picture
DrawSegment color (x,y) pict
#	pict	= SetPenColour color pict
	pict	= FillCircle ((CornerX+CellSize*x,CornerY+CellSize*y),SegSize) pict
=	pict

EraseSegment :: !Segment !Picture -> Picture
EraseSegment segment pict = DrawSegment WormBackGroundColour segment pict

DrawFood :: !Food !Picture -> Picture
DrawFood {pos=(fx,fy)} pict
#	pict	= SetPenColour	MagentaColour		pict
	pict	= FillRectangle	((x,y),(x+6,y+6))	pict
	pict	= SetPenColour	BlackColour			pict
=	pict
where
	x		= CornerX+CellSize*fx-3
	y		= CornerY+CellSize*fy-3
	
EraseFood :: !Food !Picture -> Picture
EraseFood {pos=(fx,fy)} pict
=	EraseRectangle ((x,y),(x+6,y+6)) pict
where
	x		= CornerX+CellSize*fx-3
	y		= CornerY+CellSize*fy-3

DrawNewPoints :: !Points !Picture -> Picture
DrawNewPoints points pict
#	pict	= EraseRectangle ((x-1,y-12),(x+100,y+4))	pict
	pict	= MovePenTo		 PointsPos					pict
	pict	= DrawString	(toString points)			pict
=	pict
where
	(x,y)	= PointsPos


//	Show a step of the worm.
DrawStep :: !Bool !Food !Food !Points !Segment !Segment !Segment !Picture -> Picture
DrawStep scored oldfood newfood points oldh head tail pict
|	not scored	= DrawMove		oldh head tail	pict
#	pict		= EraseFood		oldfood			pict
	pict		= DrawFood		newfood			pict
	pict		= DrawNewPoints	points			pict
	pict		= DrawMove		oldh head tail	pict
|	otherwise	= pict
where
	DrawMove :: !Segment !Segment !Segment !Picture -> Picture
	DrawMove oldh head (0,0) pict
	#	pict	= DrawSegment	RedColour			 oldh pict
		pict	= DrawSegment	GreenColour			 head pict
		pict	= SetPenColour	BlackColour				  pict
	=	pict
	DrawMove oldh head tail pict
	#	pict	= DrawSegment	RedColour			 oldh pict
		pict	= DrawSegment	GreenColour			 head pict
		pict	= DrawSegment	WormBackGroundColour tail pict
		pict	= SetPenColour	BlackColour				  pict
	=	pict


//	Close the Playfield between two levels.
DrawAnimation :: !Int !Int !Picture -> Picture
DrawAnimation 40 1 pict
#	pict		= SetPenColour	WhiteColour	pict
	pict		= DrawBorders				pict
	pict		= SetPenColour	BlackColour	pict
=	pict
DrawAnimation n step pict
|	step<0		= DrawRectangle	 ((l,t),(r,b)) (
				  EraseRectangle ((r,t),(x,y)) (
				  EraseRectangle ((l,b),(x,y)) (
				  SetPenSize	 (3,3) pict)))
|	otherwise	= DrawRectangle	 ((l,t),(r,b)) (
				  EraseRectangle ((r,t),(x-3,y)) (
				  EraseRectangle ((l,b),(x,y-3)) (
				  SetPenSize	 (3,3) pict)))
where
	l			= CornerX-3
	t			= CornerY-3
	r			= l+w*n
	b			= t+h*n 
	x			= r-step*w
	y			= b-step*h 
	w			= (48+SizeX*CellSize)/40
	h			= (48+SizeY*CellSize)/40
