implementation module clCrossCall

import intrface, StdEnv


Void :== 0

  //----------------------------------------------//
 //    Cursor related crosscalls                 //
//----------------------------------------------//


WinSetWindowCursor :: !HWND !Int !OS -> OS
WinSetWindowCursor hwnd cursorcode os = finalos
where
	setcursorCci       =  ( CcRqCHANGEWINDOWCURSOR, hwnd, cursorcode, 0, 0, 0, 0 )
	( _, _, finalos )  =  IssueCleanRequest (ErrorCallback "WinSetWindowCursor") setcursorCci Void os

WinObscureCursor :: !OS -> OS
WinObscureCursor os = newos
where
	obscureCci      =  ( CcRqOBSCURECURSOR, 0,0,0,0,0,0 )
	( _, _, newos ) =  IssueCleanRequest (ErrorCallback "WinObscureCursor") obscureCci Void os



  //----------------------------------------------//
 //    Dialog related crosscalls                 //
//----------------------------------------------//

WinBeep :: !OS -> OS
WinBeep os = newos
where
  beepcci = (CcRqBEEP, 0,0,0,0,0,0)
  (_,_,newos) = IssueCleanRequest (ErrorCallback "WinBeep") beepcci Void os

WinEnableControl :: !HWND !Bool !OS -> OS
WinEnableControl hwnd bool os = newos
where
  createcci = (CcRqENABLECONTROL, hwnd, toInt bool, 0,0,0,0 )
  (_,_, newos)  = Iprint "<<IssueCleanRequest from WinEnableControl>>" IssueCleanRequest (ErrorCallback "WinEnableControl") createcci Void os


WinEnablePopupItem :: !HWND !Int !Bool !OS -> OS
WinEnablePopupItem hwnd pos bool os = newos
where
  createcci = (CcRqENABLEPOPUPITEM, hwnd, pos, toInt bool, 0,0,0 )
  (_,_, newos)  = IssueCleanRequest (ErrorCallback "WinEnablePopupItem") createcci Void os

WinCheckControl :: !HWND !Bool !OS -> OS
WinCheckControl hwnd bool os = newos
where
  createcci = (CcRqSETITEMCHECK, hwnd, toInt bool, 0,0,0,0 )
  (_,_, newos)  = IssueCleanRequest (ErrorCallback "WinCheckControl") createcci Void os

WinSelectPopupItem :: !HWND !Int !OS -> OS
WinSelectPopupItem hwnd pos os = newos
where
  selectcci   = (CcRqSELECTPOPUPITEM, hwnd, pos, 0,0,0,0 )
  (_,_,newos) = IssueCleanRequest (ErrorCallback "WinSelectPopupItem") selectcci Void os


  //----------------------------------------------//
 //    Timer related crosscalls                  //
//----------------------------------------------//


WinCreateTimer :: !Int !OS -> (!HITEM, !OS)
WinCreateTimer interval os = (hitem, newos)
where
  createcci = (CcRqCREATETIMER, interval, 0,0,0,0,0 )
  (rcci,_, newos)  = IssueCleanRequest (ErrorCallback "WinCreateTimer") createcci Void os
  hitem     = case rcci of
                 (CcRETURN1, hi, _,_,_,_,_ )  -> hi
                 (CcWASQUIT, _,_,_,_,_,_ )    -> 0
				 other                        -> abort "[WinCreateTimer] expected CcRETURN1 value." 

WinKillTimer :: !Int !OS -> OS
WinKillTimer id os = newos
where
  killcci = (CcRqKILLTIMER, id, 0,0,0,0,0 )
  (_,_, newos)  = IssueCleanRequest (ErrorCallback "WinKillTimer") killcci Void os


WinSetIdleTimer :: !Bool !OS -> OS
WinSetIdleTimer bool os = newos
where
  idlecci = (CcRqIDLETIMER, toInt bool, 0,0,0,0,0 )
  (_,_, newos)  = IssueCleanRequest (ErrorCallback "WinSetIdleTimer") idlecci Void os



WinGetTime :: !OS -> (!(!Int,!Int,!Int),!OS)
WinGetTime os = (time, os`)
where
  timecci         =  (CcRqGETCURTIME, 0,0,0,0,0,0)
  (rcci, _, os`)  =  IssueCleanRequest (ErrorCallback "WinGetTime") timecci Void os
  time            =  case rcci of
                       ( CcRETURN3, h,m,s,_,_,_) -> (h,m,s)
                       ( CcWASQUIT, _,_,_,_,_,_) -> (0,0,0) 
                       other                     -> abort "[WinGetTime] expected CcRETURN3 value." 

WinGetDate :: !OS -> (!(!Int,!Int,!Int,!Int),!OS)
WinGetDate os = (date, os`)
where
  datecci         =  (CcRqGETCURDATE, 0,0,0,0,0,0)
  (rcci, _, os`)  =  IssueCleanRequest (ErrorCallback "WinGetDate") datecci Void os
  date            =  case rcci of
                       ( CcRETURN4, y,m,d,wd,_,_) -> (y,m,d,wd)
                       ( CcWASQUIT, _,_,_,_,_,_ ) -> (0,0,0,1) 
					   other                      -> abort "[WinGetDate] expected CcRETURN4 value."

WinWait :: !Int !OS -> OS
WinWait i os = newos
where
  waitcci       = (CcRqWAIT, i,0,0,0,0,0)
  (_,_,newos)   = IssueCleanRequest (ErrorCallback "WinWait") waitcci Void os


WinGetBlinkTime :: !OS -> (!Int,!OS)
WinGetBlinkTime os = (time, newos)
where
  blinkcci       = (CcRqGETBLINKTIME, 0,0,0,0,0,0)
  (rcci,_,newos) = IssueCleanRequest (ErrorCallback "WinGetBlinkTime") blinkcci Void os
  time           = case rcci of
                     ( CcRETURN1, t, _,_,_,_,_ ) -> t
                     ( CcWASQUIT, _,_,_,_,_,_)   -> 1 
					 other                       -> abort "[WinGetBlinkTime] expected CcRETURN1 value."

  //----------------------------------------------//
 //    Window related crosscalls                 //
//----------------------------------------------//



WinGetScrollWinFrameSize :: !HWND !OS -> ( !(!Int,!Int), !OS)
WinGetScrollWinFrameSize hwnd os = ( size, os`)
where
  getcci          =  (CcRqGETSCROLLFRAME, hwnd,0,0,0,0,0 )
  (rcci ,_, os`)  =  IssueCleanRequest (ErrorCallback "WinGetScrollWinFrameSize") getcci Void os
  size            =  case rcci of
                        ( CcRETURN2, w, h, _,_,_,_ ) -> (w,h)
                        ( CcWASQUIT, _,_,_,_,_,_)    -> (0,0) 
						other						 -> abort "[WinGetScrollWinFrameSize] expected CcRETURN2 value."


WinGetClientSize :: !HWND !OS -> (!(!Int,!Int), !OS)
WinGetClientSize hwnd os = ( size, os`)
where
  getcci          =  (CcRqGETCLIENTSIZE, hwnd,0,0,0,0,0 )
  (rcci ,_, os`)  =  IssueCleanRequest (ErrorCallback "WinGetClientSize") getcci Void os
  size            =  case rcci of
                        ( CcRETURN2, w, h, _,_,_,_ ) -> (w,h)
                        ( CcWASQUIT, _,_,_,_,_,_)     -> (0,0) 
  					    other						 -> abort "[WinGetClientSize] expected CcRETURN2 value."

WinGetWindowPos :: !HWND !OS -> (!(!Int,!Int), !OS)
WinGetWindowPos hwnd os = ( pos, os`)
where
  getcci          =  (CcRqGETWINDOWPOS, hwnd,0,0,0,0,0 )
  (rcci ,_, os`)  =  IssueCleanRequest (ErrorCallback "WinGetWindowPos") getcci Void os
  pos             =  case rcci of
                        ( CcRETURN2, x, y, _,_,_,_ ) -> (x,y)
                        ( CcWASQUIT, _,_,_,_,_,_)    -> (0,0) 
						other						 -> abort "[WinGetWindowPos] expected CcRETURN2 value."


WinGetClipboardText :: !OS -> (!String, !OS)
WinGetClipboardText os = (text, newos)
where
  getcci          =  (CcRqGETCLIPBOARDTEXT, 0,0,0,0,0,0)
  (rcci, _, os`)  =  IssueCleanRequest (ErrorCallback "WinGetClipboardText") getcci Void os
  (text, newos)   =  case rcci of
                        (CcRETURN1, ptr, _,_,_,_,_) -> WinGetCStringAndFree ptr os`
                        ( CcWASQUIT, _,_,_,_,_,_)   -> ("", os`) 
                        other                       -> abort "[WinGetClipboardText] expected CcRETURN1 value.\n"

WinGetWindowText :: !HWND !OS -> (!String, !OS)
WinGetWindowText hwnd os = (text, newos)
where
  getcci          =  (CcRqGETWINDOWTEXT, hwnd, 0,0,0,0,0)
  (rcci, _, os`)  =  IssueCleanRequest (ErrorCallback "WinGetWindowText") getcci Void os
  (text,newos)    =  case rcci of
                       ( CcRETURN1, ptr, _,_,_,_,_) -> WinGetCStringAndFree ptr os`
                       ( CcWASQUIT, _,_,_,_,_,_)    -> ("",os`) 
                       other                        -> abort "[WinGetWindowText] expected CcRETURN1 value."
           
WinSetClipboardText :: !String !OS -> OS
WinSetClipboardText text os = finalos
where
  (textptr, os2)    =  WinMakeCString text os
  setcci            =  (CcRqSETCLIPBOARDTEXT, textptr, 0,0,0,0,0)
  (_,_, os3)        =  IssueCleanRequest (ErrorCallback "SetClipboardText") setcci Void os2  
  finalos           =  WinReleaseCString textptr os3

WinSetWindowTitle :: !HWND !String !OS -> OS
WinSetWindowTitle hwnd title os = finalos
where
	( textptr,os2 )  =  WinMakeCString title os  
	setTitleCci      =  ( CcRqSETWINDOWTITLE, hwnd, textptr, 0, 0, 0, 0 )
	( _, _, os3 )    =  IssueCleanRequest (ErrorCallback "SetWindowTitle") setTitleCci Void os2
	finalos			 =  Iprint "<<WSWT: WinReleaseCString>>" WinReleaseCString textptr (Iprint "<<WSWT: os3>>" os3)


WinInvalidateWindow :: !HWND !OS -> OS
WinInvalidateWindow hwnd os = newos
where
  invalidateCci = (CcRqINVALIDATEWINDOW, hwnd, 0,0,0,0,0 )
  (_,_, newos)  = IssueCleanRequest (ErrorCallback "WinInvalidateWindow") invalidateCci Void os



WinBeginPaint :: !HWND !OS -> (!HDC, !OS) 
WinBeginPaint hwnd os = (hdc, newos)
where
  beginCci		  = (CcRqBEGINPAINT, hwnd, 0,0,0,0,0 )
  (cci, _, newos) =  IssueCleanRequest (ErrorCallback "WinBeginPaint") beginCci Void os
  hdc             =  case cci of
		   		        (CcRETURN1, v, _,_,_,_,_)  -> v
                        ( CcWASQUIT, _,_,_,_,_,_)   -> 0 
					    other                      -> abort "[WinBeginPaint] expected CcRETURN1 value."


WinEndPaint :: !HWND !(!HDC, !OS) -> OS
WinEndPaint hwnd (hdc, os) = newos
where
  endCci		=  (CcRqENDPAINT, hwnd, hdc, 0,0,0,0 )
  (_,_, newos)	=  IssueCleanRequest (ErrorCallback "WinEndPaint") endCci Void os



WinGetDC :: !HWND !OS -> (!HDC, !OS) 
WinGetDC hwnd os = (hdc, newos)
where
  beginCci		  = (CcRqGETDC, hwnd, 0,0,0,0,0 )
  (cci, _, newos) =  IssueCleanRequest (ErrorCallback "WinGetDC") beginCci Void os
  hdc             =  case cci of
		   		        (CcRETURN1, v, _,_,_,_,_)  -> v
                        ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
					    other                      -> abort "[WinGetDC] expected CcRETURN1 value."


WinReleaseDC :: !HWND !(!HDC, !OS) -> OS
WinReleaseDC hwnd (hdc, os) = newos
where
  endCci		=  (CcRqRELEASEDC, hwnd, hdc, 0,0,0,0 )
  (_,_, newos)	=  IssueCleanRequest (ErrorCallback "WinReleaseDC") endCci Void os


WinGetActiveDialog :: !OS -> (!HWND, !OS)
WinGetActiveDialog os = (hwnd, newos)
where
  getcci         =  ( CcRqGETACTIVEDIALOG, 0,0,0,0,0,0 )
  (cci,_,newos)  =  IssueCleanRequest (ErrorCallback "WinGetActiveDialog") getcci Void os
  hwnd           =  case cci of
                       (CcRETURN1, v, _,_,_,_,_) -> v
                       ( CcWASQUIT, _,_,_,_,_,_) -> 0 
					   other                     -> abort "[WinGetActiveDialog] expected CcRETURN1 value."

WinGetForegroundWindow :: !OS -> (!HWND, !OS)
WinGetForegroundWindow os = (hwnd, newos)
where
  getcci         =  ( CcRqGETFOREGROUNDWINDOW, 0,0,0,0,0,0 )
  (cci,_,newos)  =  IssueCleanRequest (ErrorCallback "WinGetForegroundWindow") getcci Void os
  hwnd           =  case cci of
                       (CcRETURN1, v, _,_,_,_,_) -> v
                       ( CcWASQUIT, _,_,_,_,_,_) -> 0 
					   other                     -> abort "[WinGetForegroundWindow] expected CcRETURN1 value."



WinSetScrollInfos :: !HWND !(!(!Int,!Int),!(!Int,!Int)) !(!Int,!Int,!Int,!Int) !OS -> OS
WinSetScrollInfos hwnd ((pl,pt),(pr,pb)) (width,height,hthumb,vthumb) os = os``
where
  setHcci     =  ( CcRqSETHSCROLLINFO, hwnd, pl, pr, hthumb, width, 0 )
  (_,_,os`)   =  IssueCleanRequest (ErrorCallback "WinSetScrollInfos") setHcci Void os
  setVcci     =  ( CcRqSETVSCROLLINFO, hwnd, pt, pb, vthumb, height, 0 )
  (_,_,os``)  =  IssueCleanRequest (ErrorCallback "WinSetScrollInfos") setVcci Void os`




  //----------------------------------------------//
 //    Menu related crosscalls                   //
//----------------------------------------------//





WinCreateMenuBarHandle :: !OS -> (!HMENU, !OS)
WinCreateMenuBarHandle os = (hmenu, os2)
where
	createMbarCci  =  (CcRqCREATEMBAR, 0,0,0,0,0,0 ) 
	(cci, _, os2)  =  IssueCleanRequest (ErrorCallback "CreateMenuBarHandle") createMbarCci Void os
	hmenu          =  case cci of
						(CcRETURN1, v, _,_,_,_,_)  -> v
                        ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
						other                      -> abort "[CreateMenuBarHandle] expected CcRETURN1 value."


WinCreateMenuWindow :: !HMENU !String !OS -> (!HWND, !OS)
WinCreateMenuWindow mbar wintitle os = (hwnd, finalos)
where
	( textptr, os2 )  =  WinMakeCString wintitle os
	createMenuWinCci  =  ( CcRqCREATEMENUWINDOW, mbar, textptr, 0,0,0,0 )
	( cci, _, os3 )   =  IssueCleanRequest (ErrorCallback "CreateMenuWindow") createMenuWinCci Void os2
	hwnd              =  case cci of
				  		    (CcRETURN1, v, _,_,_,_,_)  -> v
                            ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
						    other                      -> abort "[CreateMenuWindow] expected CcRETURN1 value."
	finalos			  =  WinReleaseCString textptr os3	 


WinCreatePopupMenuHandle :: !OS -> (!HMENU, !OS)
WinCreatePopupMenuHandle os = (hmenu, os2)
where
	createPopupCci =  (CcRqCREATEPOPMENU, 0,0,0,0,0,0 ) 
	(cci, _, os2)  =  IssueCleanRequest (ErrorCallback "CreatePopupMenuHandle ") createPopupCci Void os
	hmenu          =  case cci of
						(CcRETURN1, v, _,_,_,_,_)  -> v
                        ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
						other                      -> abort "[CreatePopupMenuHandle] expected CcRETURN1 value."


WinAppendMenu :: !String !Bool !HMENU !HMENU !OS -> OS
WinAppendMenu text state submenu menu os = finalos
where
	( textptr,os2 )  =  WinMakeCString text os  
	appendMenuCci    =  ( CcRqAPPENDMENU, toInt state, menu, textptr, submenu, 0,0 )
	( _, _, os3 )    =  IssueCleanRequest (ErrorCallback "AppendMenu") appendMenuCci Void os2
	finalos			 =  WinReleaseCString textptr os3


WinAppendMenuItem :: !String !Bool !Bool !HMENU !OS -> (!HITEM, !OS)
WinAppendMenuItem text ablestate markstate menu os = (hitem, finalos)
where
	( textptr,os2 )  =  WinMakeCString text os  
	appendMenuCci    =  ( CcRqAPPENDMENUITEM, toInt ablestate, menu, textptr, toInt markstate, 0,0 )
	( rcci, _, os3 ) =  IssueCleanRequest (ErrorCallback "AppendMenuItem") appendMenuCci Void os2
    hitem            =  case rcci of
	                     (CcRETURN1, hi, _,_,_,_,_) -> hi
                         ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
						 other                      -> abort "[WinAppendMenuItem] expected CcRETURN1 value."
	finalos			 =  WinReleaseCString textptr os3


WinAppendSeparator :: !HMENU !OS -> OS
WinAppendSeparator menu os = finalos
where
	(_,_, finalos)   =  IssueCleanRequest (ErrorCallback "AppendSeparator") (CcRqAPPENDSEPARATOR, menu,0,0,0,0,0) Void os

WinInsertMenuItem :: !String !Bool !Bool !HMENU !Int !OS -> (!HITEM, !OS)
WinInsertMenuItem text ablestate markstate menu pos os = (hitem, finalos)
where
	( textptr,os2 )  =  WinMakeCString text os  
	insertMenuCci    =  ( CcRqINSERTMENUITEM, toInt ablestate, menu, textptr, toInt markstate, pos, 0 )
	( rcci, _, os3 ) =  IssueCleanRequest (ErrorCallback "InsertMenuItem") insertMenuCci Void os2
    hitem            =  case rcci of
	                     (CcRETURN1, hi, _,_,_,_,_) -> hi
                         ( CcWASQUIT, _,_,_,_,_,_)  -> 0 
						 other                      -> abort "[WinInsertMenuItem] expected CcRETURN1 value."
	finalos			 =  WinReleaseCString textptr os3


WinInsertSeparator :: !HMENU !Int !OS -> OS
WinInsertSeparator menu pos os = finalos
where
	(_,_, finalos)   =  IssueCleanRequest (ErrorCallback "InsertSeparator") (CcRqINSERTSEPARATOR, menu, pos, 0,0,0,0) Void os




WinChangeMenuItemCheck :: !HMENU !HITEM !Bool !OS -> OS
WinChangeMenuItemCheck menu hitem state os = finalos
where
	checkCci       =  (CcRqCHECKMENUITEM, menu, hitem, toInt state, 0,0,0 )
	(_,_, finalos) =  IssueCleanRequest (ErrorCallback "CheckMenuItem") checkCci Void os



WinModifyMenu :: !String !Bool !HMENU !HMENU !Int !OS -> OS
WinModifyMenu text state submenu menu pos os = finalos
where
	( textptr,os2 )  =  WinMakeCString text os  
	modifyMenuCci    =  ( CcRqMODIFYMENU, toInt state, menu, textptr, submenu, pos, 0 )
	( _, _, os3 )    =  IssueCleanRequest (ErrorCallback "ModifyMenu") modifyMenuCci Void os2
	finalos			 =  WinReleaseCString textptr os3


WinModifyMenuItem :: !HITEM !String !Bool !Bool !HMENU !OS -> OS
WinModifyMenuItem hitem text ablestate markstate menu os = finalos
where
	( textptr,os2 )  =  WinMakeCString text os  
	modifyMenuCci    =  ( CcRqMODIFYMENUITEM, hitem, toInt ablestate, menu, textptr, toInt markstate, 0 )
	( _, _, os3 )    =  IssueCleanRequest (ErrorCallback "ModifyMenuItem") modifyMenuCci Void os2
	finalos			 =  WinReleaseCString textptr os3



WinRemoveMenuItem :: !HMENU !HITEM !OS -> OS
WinRemoveMenuItem menu hitem os = newos
where
	removeCci     =  (CcRqREMOVEMENUITEM, menu, hitem, 0,0,0,0 )
	(_,_, newos)  =  IssueCleanRequest (ErrorCallback "RemoveMenuItem") removeCci Void os



WinChangeItemAbility :: !HMENU !HITEM !Bool !OS -> OS
WinChangeItemAbility parent hitem onoff os = newos
where
	changeCci		=  ( CcRqITEMENABLE, parent, hitem, toInt onoff, 0,0,0 )
	( _,_, newos )  =  IssueCleanRequest (ErrorCallback "ChangeItemAbility") changeCci Void os


WinChangeMenuAbility :: !HMENU !Int !Bool !OS -> OS
WinChangeMenuAbility parent pos onoff os = newos
where
	changeCci		=  ( CcRqMENUENABLE, parent, pos, toInt onoff, 0,0,0 )
	( _,_, newos )  =  IssueCleanRequest (ErrorCallback "ChangeMenuAbility") changeCci Void os


WinDrawMenuBar :: !OS -> OS
WinDrawMenuBar os = newos
where
	drawmbarCci     =  ( CcRqDRAWMBAR, 0,0,0,0,0,0 )
	( _,_, newos )  =  IssueCleanRequest (ErrorCallback "DrawMenuBar") drawmbarCci Void os




  //----------------------------------------------//
 //    Crosscall infrastructure                  //
//----------------------------------------------//


:: Callback s :== !CrossCallInfo !s -> *(OS -> (Bool, CrossCallInfo, s, OS))


IssueCleanRequest :: !(CrossCallInfo -> .(.s -> .(*OS -> *(.Bool,.CrossCallInfo,.s,*OS))))
                     !.CrossCallInfo !.s !*OS -> *(!CrossCallInfo,!.s,!*OS)
IssueCleanRequest callback cci s os = result
where
	(cci2, os2)	=  Iprint "<<ICR:WinKickOsThread>>" WinKickOsThread cci os
	result		=  Iprint "<<ICR:HandleCallbacks>>" HandleCallBacks cci2 s (Iprint "<<ICR:os2>>" os2)

	HandleCallBacks cci=:(message_kind,_,_,_,_,_,_) s os
	
	| message_kind > 2000
		= abort ("HandleCallBacks "+++toString message_kind);
	
	| IsReturnOrQuitCci cci  =   ( cci, s, os)
	| otherwise		         =   Iprint "<<HCB:HandleCallbacks>>" HandleCallBacks newcci news (Iprint "<<HCB:newos>>" newos)
	where
		(_, returncci, news, os2) = callback cci s os
		(newcci, newos)	  = Iprint "<<HCB:WinKickOsThread>>" WinKickOsThread (Iprint "<<HCB: returnCci>>" returncci) ( Iprint "<<HCB: os2>>" os2)



Return0Cci :: CrossCallInfo
Return0Cci = ( CcRETURN0, 0,0,0,0,0,0 )

Return1Cci :: !Int -> CrossCallInfo
Return1Cci v = ( CcRETURN1, v, 0,0,0,0,0 )

Return2Cci :: !Int !Int -> CrossCallInfo
Return2Cci v1 v2 = ( CcRETURN2, v1, v2, 0,0,0,0 )

Return3Cci :: !Int !Int !Int -> CrossCallInfo
Return3Cci v1 v2 v3 = ( CcRETURN3, v1, v2, v3, 0,0,0 )

Return4Cci :: !Int !Int !Int !Int -> CrossCallInfo
Return4Cci v1 v2 v3 v4 = ( CcRETURN4, v1, v2, v3, v4,0,0 )

Return5Cci :: !Int !Int !Int !Int !Int -> CrossCallInfo
Return5Cci v1 v2 v3 v4 v5 = ( CcRETURN5, v1, v2, v3, v4, v5,0 )

Return6Cci :: !Int !Int !Int !Int !Int !Int -> CrossCallInfo
Return6Cci v1 v2 v3 v4 v5 v6 = ( CcRETURN6, v1, v2, v3, v4, v5, v6 )

IsReturnOrQuitCci :: !CrossCallInfo -> Bool
IsReturnOrQuitCci (CcWASQUIT,_,_,_,_,_,_) = True
IsReturnOrQuitCci (mess, _,_,_,_,_,_)     =  mess >= CcRETURNmin && mess <= CcRETURNmax

instance toInt Bool
where
 toInt :: !Bool -> Int
 toInt True  = -1
 toInt _	 = 0


ErrorCallback :: !String !CrossCallInfo !u:s !OS -> (!Bool, !CrossCallInfo, !u:s, !OS)
ErrorCallback source cci s os = ( True, Return0Cci, s, Iprint msgtext os)
where
	msgtext           = " *** [" +++ source +++ "] did not expect a callback: " +++ toString msg 
	(msg,_,_,_,_,_,_) = cci






  //----------------------------------------------//
 //     Beeping and printing to out.txt          //
//----------------------------------------------//




Ibeep :: .a -> .a
Ibeep a 
  |  i == o = a
            = a
where
  i = 99
  o = WinBeep 99


Iprint string a :== a
Iprint` string a :== a
/*
Iprint :: !String !.a -> .a
Iprint s a 
	| not (printresult == 0)  = a
							  = abort ("Print failed: " +++ s)
where
	printresult   = ConsolePrint ("## " +++ s +++ "\n") 999

Iprint` :: !String !.a -> .a
Iprint` s a 
	| not (printresult == 0)  = a
							  = abort ("Print failed: " +++ s)
where
	printresult   = ConsolePrint s 999
*/
