implementation module deltaFileSelect


import Events, intrface, clCrossCall


:: SwapFunction s :== (Files -> *(s -> (Files, s)))


SelectInputFile :: !*s !(IOState *s) -> (!Bool, !String, !*s, !IOState *s)
SelectInputFile s iostate = ( success, path, news, PackIOState newadm newos )
where
  (adm, os)  =  UnpackIOStateWithCheck iostate
  filecci    =  ( CcRqFILEOPENDIALOG, 0,0,0,0,0,0 )
  (rcci, (news,newadm), os2) 
             =  IssueCleanRequest StdCallback filecci (s, adm) os
  (success, path, newos) 
             =  case rcci of
			     ( CcRETURN2, 0, _,_,_,_,_)    -> ( False, "", os2 )
				 ( CcRETURN2, _, ptr, _,_,_,_) -> ( True, path, os3 )
				                                  where (path, os3) = WinGetCStringAndFree ptr os2
                 ( CcWASQUIT, _,_,_,_,_,_)     -> ( False, "", os2 ) 
				 other                         -> abort "[SelectInputFile`] expected CcRETURN2 value."



SelectOutputFile :: !String !String !*s !(IOState *s) -> (!Bool, !String, !*s, !IOState *s)
SelectOutputFile prompt filename s iostate = ( success, path, news, PackIOState newadm newos )
where
  (adm, os)         =  UnpackIOStateWithCheck iostate
  (promptptr, os2)  =  WinMakeCString prompt os
  (nameptr, os3)    =  WinMakeCString filename os2
  savecci           =  ( CcRqFILESAVEDIALOG, promptptr, nameptr, 0,0,0,0 )
  (rcci, (news,newadm), os4) 
                    =  IssueCleanRequest StdCallback savecci (s, adm) os3
  os5               =  WinReleaseCString nameptr (WinReleaseCString promptptr os4)
  (success, path, newos) 
             =  case rcci of
			     ( CcRETURN2, 0, _,_,_,_,_)    -> ( False, "", os5 )
				 ( CcRETURN2, _, ptr, _,_,_,_) -> ( True, path, os6 )
				                                  where (path, os6) = WinGetCStringAndFree ptr os5
                 ( CcWASQUIT, _,_,_,_,_,_)     -> ( False, "", os5 ) 
				 other                         -> abort "[SelectOutputFile`] expected CcRETURN2 value."
 


