definition module deltaEventIO


from ioTypes import EVENTS, IOState, OpenEvents, CloseEvents
import deltaIOSystem


//  	Definition of IOState: the environment parameter on which all
//  									I/O functions operate.
//  	Definition of EVENTS : the environment parameter to start I/O.
//  
//  	The operations on the IOState to create interactions.
//  
//  
//  ::	*EVENTS;
//  ::	*IOState *s;
//  
//  
//  OpenEvents :: *World -> (!EVENTS, !*World);
//  //	OpenEvents retrieves the event stream from the world.
//  
//  CloseEvents :: !EVENTS !*World -> *World;
//  
//  /*	CloseEvents replaces the event stream in the world. Event streams that
//  	have been retrieved from the world, must be closed before they can be
//  	opened again, otherwise a run-time error will occur. */
//  
from ioTypes import EVENTS, IOState, OpenEvents, CloseEvents



:: InitialIO *s :== [s ->  *((IOState s) -> (s, IOState s)) ]


/*	StartIO starts a new interaction specified by the IOSystem argument.
	Of each device only the first occurrence is taken into account. The
	program state argument serves as initial program state. The first
	functions to be evaluated are given in InitialIO from left-to-right.
	StartIO returns the final program state and the resulting events.
	In this version the program state must be unique. */

StartIO :: !(IOSystem *s (IOState *s)) !*s !(InitialIO *s) !EVENTS -> (!*s, !EVENTS)


/*  NestIO is not implemented in the Windows95 version of the IO library! */


/*	QuitIO closes all devices that are held in the IOState argument.
	The resulting (empty) IOState will cause StartIO to terminate. QuitIO
	is the only function which terminates StartIO. */

QuitIO :: !(IOState s) -> IOState s


/*	ChangeIOState applies the functions in its first argument in
	consecutive order to the second (IOState) argument. */

ChangeIOState :: ![(IOState s) -> (IOState s)] !(IOState s) -> IOState s
