implementation module Events


import ioTypes, clCrossCall, Window0

from Menu0   import HandleMenuEvent
from Timer0  import HandleTimerEvent
from Dialog0 import HandleDialogEvent

Void :== 0


DoMessageLoop :: !*s !(IOadmin *s) !OS -> (!*s, !IOadmin *s, !OS)
DoMessageLoop s admin os
	|	admin.io_quit    =  (s, admin, os)
	|	otherwise		 =  DoMessageLoop nexts nextadmin nextos
where
	doMessageCci  = (CcRqDOMESSAGE, 0,0,0,0,0,0 )
	(_, (s2,admin2), os2) 
				  =  IssueCleanRequest StdCallback doMessageCci (s, admin) os
	delayedmess   =  admin2.io_delayedmessages
	admin3        =  { admin2 & io_delayedmessages = [] }
    (nexts, nextadmin, nextos) 
				  =  DoDelayedMessages (reverse delayedmess) s2 admin3 os2

DoDelayedMessages :: ![ CrossCallInfo ] !*s !(IOadmin *s) !OS -> (!*s, !IOadmin *s, !OS)
DoDelayedMessages [] s admin os = (s, admin, os)
DoDelayedMessages [ cci : rest ] s admin os = DoDelayedMessages rest news newadmin newos
where
  (_, _, (news, newadmin), newos) = Iprint ("Doing delayed message: " +++ toString mess) StdCallback cci (s, admin) os
  (mess, _,_,_,_,_,_) = cci



StdCallback :: !CrossCallInfo !(!*s, !IOadmin *s) !OS -> (!Bool, !CrossCallInfo, !(!*s, !IOadmin *s), !OS)
StdCallback cci (s, adm) os
  |  dialogeventdone  =  (True, dcci, (ds,da), do)
  |  menueventdone    =  (True, mcci, (ms,ma), mo)
  |  windoweventdone  =  (True, wcci, (ws,wa), wo)
  |  timereventdone   =  (True, tcci, (ts,ta), to)
  |  ddeeventdone     =  (True, ecci, (es,ea), eo)
                      =  (False, Return0Cci, (es,ea), eo)
where
  (dialogeventdone, dcci,ds,da,do)  =  HandleDialogEvent cci s adm os
  (menueventdone,   mcci,ms,ma,mo)  =  HandleMenuEvent   cci ds da do
  (windoweventdone, wcci,ws,wa,wo)  =  HandleWindowEvent   cci ms ma mo
  (timereventdone,  tcci,ts,ta,to)  =  HandleTimerEvent   cci ws wa wo
  (ddeeventdone,    ecci,es,ea,eo)  =  HandleDDEEvent   cci ts ta to


IgnoreCallback :: !CrossCallInfo !*s !OS -> (!Bool, !CrossCallInfo, !*s, !OS)
IgnoreCallback (CcWmPAINT,hwnd,_,_,_,_,_) s os
	=  (True, Return0Cci, s, Iprint text newos)
where
	text  = "IgnoreCallback ignored message : WmPAINT"
	pic   = WinBeginPaint hwnd os
	newos = WinEndPaint   hwnd pic 
IgnoreCallback (mess,_,_,_,_,_,_) s os 
	=  (True, Return0Cci, s, Iprint text os)
where
	text = "IgnoreCallback ignored message : " +++ toString mess

DelayMessage :: !CrossCallInfo !(IOadmin s) -> (IOadmin s)
DelayMessage cci adm = { adm & io_delayedmessages = [cci : adm.io_delayedmessages] }


DelayCallback :: !CrossCallInfo !(IOadmin s) !OS -> (!Bool, !CrossCallInfo, !IOadmin s, !OS)
DelayCallback (CcWmPAINT, hwnd, _,_,_,_,_) adm os = (True, Return0Cci, finaladm, finalos)
where
      (hdc, os2)  =  Iprint "delaying WM_PAINT" WinBeginPaint hwnd os
      os3         =  WinEndPaint   hwnd (hdc, os2)
      finalos     =  WinInvalidateWindow hwnd os3
	  finaladm    =  adm
DelayCallback cci=:(CcWmDRAWCONTROL, _,_,_,_,_,_) adm os = (True, Return0Cci, adm, os)
DelayCallback cci=:(CcWmACTIVATE, _,_,_,_,_,_)    adm os = (True, Return0Cci, DelayMessage cci adm, os)
DelayCallback cci=:(CcWmDEACTIVATE, _,_,_,_,_,_)  adm os = (True, Return0Cci, DelayMessage cci adm, os)
DelayCallback cci=:(CcWmGETMINMAXINFO,hwnd,_,_,_,_,_) adm os 
  = case FindWindowWithHandle hwnd adm.io_windowState of
		Nope      -> ( False, Return0Cci, adm, os)
		OK window -> ( True,  returncci, adm, os)
			where
			  returncci   = case window.wkind of
							  FixedK  -> Return0Cci
							  ScrollK -> Return4Cci maxw maxh window.wminwidth window.wminheight
							  where 
								  (maxw,maxh) = GetWindowDimensions window.wdomain

DelayCallback (mess,_,_,_,_,_,_) s os =  abort ("could not delay message" +++ toString mess +++ "\n")

DelayUpdate :: !HWND !OS -> OS
DelayUpdate hwnd os = newos
where
  (hdc, os2) = WinBeginPaint hwnd os
  os3        = WinEndPaint hwnd (hdc, os2)
  newos      = WinInvalidateWindow hwnd os3

HandleDDEEvent :: !CrossCallInfo !*s !(IOadmin *s) !OS -> (!Bool,!CrossCallInfo, !*s, !(IOadmin *s), !OS) 
HandleDDEEvent (CcWmDDEEXECUTE, txtptr, _,_,_,_,_) s adm os 
   =  (True, Return0Cci, s`, adm`, os`)
where
   (text,os2)     =  WinGetCStringAndFree txtptr os
   iostate        =  PackIOState adm os2
   (s`,iostate`)  =  Iprint ("DDE execute handler called with \"" +++ text +++ "\".") adm.io_ddehandler text s iostate
   (adm`, os`)    =  UnpackIOState iostate`
HandleDDEEvent _ s adm os = (False, Return0Cci, s, adm, os)
