implementation module tmdialog


import	StdClass
from	StdFile			import Files
from	StdInt			import ==
import	StdBool, StdString, StdChar, StdTuple
import	deltaDialog
import	deltaEventIO
from	deltaMenu		import EnableMenuItems, DisableMenuItems
from	deltaWindow		import DrawInWindow
import	showtm, tmfile


::	*Tm
	=	{	tmstate	:: !TmState
		,	name	:: !String
		,	delay	:: !Int
		,	disk	:: !Disk
		,	saved	:: !Bool
		}


HelpFile		:== "TuringHelp"
FileMenuId		:== 2
NewItemId			:== 21
OpenItemId			:== 22
SaveItemId			:== 23
SvAsItemId			:== 24
HelpItemId			:== 25
QuitItemId			:== 26
MachineMenuId	:== 3
StepItemId			:== 31
RunItemId			:== 32
HaltItemId			:== 34
DelayItemId			:== 35
VerSId					:== 351
SlowId					:== 352
NormId					:== 353
FastId					:== 354
VerFId					:== 355
WindowID		:== 1
TapeWdID		:== 3

ACId			:== 2
ACCancelId			:== 21
ACOKId				:== 22
ACCellId			:== 23
ASId			:== 3
ASCancelId			:== 31
ASOKId				:== 32
ASEditId			:== 33
ATId			:== 4
ATCancelId			:== 41
ATOKId				:== 42
ATRemoveId			:== 43
ATFromId			:== 44
ATHeadId			:== 45
ATToId				:== 46
ATMoveId			:== 47

SBCSaveId			:== 51
SBCDontId			:== 52
SBCCnclId			:== 53

TimerID			:== 1


//	The dialog to alter the contents of a tape cell.
AlterCell :: Int Tm (IOState Tm) -> (Tm,IOState Tm)
AlterCell pos tm=:{tmstate={turing={tape}}} io
#	(tm,io)		= DoHiliteCell pos cell  tm io
	(tm,io)		= OpenModalDialog dialog tm io
=	(tm,io)
where
	cell		= CellContents pos tape
	dialog		= CommandDialog ACId "Change Tape Cell" [] ACOKId
					[	StaticText		1			Center				 "Write:"
					,	EditText		ACCellId	(RightTo 1) (MM 15.0) 1 ""
					,	DialogButton	ACCancelId	Center				 "Cancel" Able (Cancel pos cell)
					,	DialogButton	ACOKId		(RightTo ACCancelId) "OK" Able (Ok pos)
					]
	
	Ok :: Int DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Ok pos dialog tm=:{tmstate} io
				= (	{tm & tmstate={tmstate & turing={tmstate.turing & tape=newtape}}}
				  ,	DrawInWindow TapeWdID [DrawTapeCell pos cell] (CloseActiveDialog io)
				  )
	where
		cell	= FirstChar (GetEditText ACCellId dialog)
		newtape	= ChangeCellContents pos cell tmstate.turing.tape
	
	Cancel :: Int Char DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Cancel pos cell dialog tm io
				= (	tm
				  ,	DrawInWindow TapeWdID [DrawTapeCell pos cell] (CloseActiveDialog io)
				  )
	
	DoHiliteCell :: Int Char Tm (IOState Tm) -> (Tm,IOState Tm)
	DoHiliteCell pos cell tm io
				= (	tm
				  ,	DrawInWindow TapeWdID [HiliteCell pos cell] io
				  )


//	The dialog to alter a transition.
AlterTransition :: Int Tm (IOState Tm) -> (Tm,IOState Tm)
AlterTransition tnr tm=:{tmstate={turing={transitions}}} io
#	(tm,io)		= DoHiliteTransition tnr transition tm io
	(tm,io)		= OpenModalDialog dialog       tm io
=	(tm,io)
where
	dialog		= CommandDialog ATId "Change Transition" [] ATOKId
					[	DynamicText	 1			Left (MM 20.0)		 "From:"
					,	EditText	 ATFromId	(RightTo 1) (MM 25.0) 1 transition.start
					,	DynamicText	 3			Left (MM 20.0)		 "With:"
					,	EditText	 ATHeadId	(RightTo 3) (MM 20.0) 1 (ctos transition.sigma)
					,	DynamicText	 5			(XOffset ATFromId (MM 10.0)) (MM 20.0) "To:"
					,	EditText	 ATToId		(RightTo 5) (MM 25.0) 1 transition.end
					,	DynamicText	 7			(Below 5) (MM 20.0)  "Action:"
					,	EditText	 ATMoveId	(RightTo 7) (MM 20.0) 1 (ctos transition.move)
					,	DialogButton ATCancelId	Center				 "Cancel" Able (Cancel tnr transition)
					,	DialogButton ATRemoveId	(RightTo ATCancelId) "Remove" Able (Remove tnr)
					,	DialogButton ATOKId		(RightTo ATRemoveId) "OK"	  Able (Ok tnr)
					]
	transition	= GetTransition tnr transitions
	
	ctos :: Char -> String
	ctos c		= if (c==' ') "" (toString c)
	
	Ok :: Int DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Ok tnr dialog tm=:{tmstate} io
	#	io				= CloseActiveDialog io
		io				= DrawInWindow WindowID [ShowTrans tnr transition] io
		io				= EnableMenuItems [SaveItemId] io
	=	({tm & tmstate={tmstate & turing={turing & transitions=newtransitions}},saved=False},io)
	where
		transition		= {	start	= FourCharString	(GetEditText ATFromId dialog)
						  ,	sigma	= FirstChar			(GetEditText ATHeadId dialog)
						  ,	end		= FourCharString	(GetEditText ATToId   dialog)
						  ,	move	= FirstChar			(GetEditText ATMoveId dialog)
						  }
		turing			= tmstate.turing
		newtransitions	= ChangeTransition tnr transition turing.transitions
	
	Cancel :: Int Transition DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Cancel tnr transition=:{start} dialog tm io
	#	io				= CloseActiveDialog io
	|	start==""		= (tm, DrawInWindow WindowID [EraseTrans tnr] io)
	|	otherwise		= (tm, DrawInWindow WindowID [ShowTrans  tnr transition] io)
	
	Remove :: Int DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Remove tnr dialog tm=:{tmstate} io
	#	io				= CloseActiveDialog io
		io				= EnableMenuItems [SaveItemId] io
	=	ReDraw	{tm	& tmstate = {tmstate & turing={turing & transitions=newtransitions},transition=0}
					, saved   = False
				} io
	where
		turing			= tmstate.turing
		newtransitions	= RemoveTransition tnr turing.transitions
	
	DoHiliteTransition :: Int Transition Tm (IOState Tm) -> (Tm,IOState Tm)
	DoHiliteTransition tnr trans tm io
	#	io	= DrawInWindow WindowID [HiliteTransition tnr trans] io
		io	= DrawInWindow TapeWdID [EraseError] io
	=	(tm,io)


//	The dialog to alter the state of the T.M.
AlterState :: Tm (IOState Tm) -> (Tm,IOState Tm)
AlterState tm=:{tmstate={turing={state}}} io
#	(tm,io)	= DoHiliteState state    tm io
	(tm,io)	= OpenModalDialog dialog tm io
=	(tm,io)
where
	dialog	= CommandDialog ASId "Change State" [] ASOKId
				[	StaticText		1			Left					"State:"
				,	EditText		ASEditId	(RightTo 1) (MM 25.0) 1	""
				,	DialogButton	ASCancelId	Center					"Cancel" Able (Cancel state)
				,	DialogButton	ASOKId		(RightTo ASCancelId)	"OK"	 Able Ok
				]
	
	Ok :: DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Ok dialog tm=:{tmstate} io
	#	io		= DrawInWindow WindowID [ShowNextState state] io
		io		= changeMenus state	io
		io		= CloseActiveDialog		io
	=	({tm & tmstate={tmstate & turing={tmstate.turing & state=state}}},io)
	where
		state	= FourCharString (GetEditText ASEditId dialog)
		
		changeMenus :: String (IOState Tm) -> IOState Tm
		changeMenus state io
		|	state=="halt"	= DisableMenuItems [StepItemId, HaltItemId] io
		|	otherwise		= EnableMenuItems  [StepItemId, HaltItemId] io
	
	Cancel :: String DialogInfo Tm (IOState Tm) -> (Tm,IOState Tm)
	Cancel state dialog tm io
	#	io	= CloseActiveDialog io
		io	= DrawInWindow WindowID [ShowNextState state] io
	=	(tm,io)
	
	DoHiliteState :: String Tm (IOState Tm) -> (Tm,IOState Tm)
	DoHiliteState state tm io
	#	io	= DrawInWindow TapeWdID [EraseError] io
		io	= DrawInWindow WindowID [HiliteState state] io
	=	(tm,io)


//	The function to redraw the entire machine when an update event takes place.
ReDraw :: Tm (IOState Tm) -> (Tm,IOState Tm)
ReDraw tm=:{tmstate={turing={transitions,tape,state}}} io
#	io	= DrawInWindow TapeWdID [ShowTape tape]						io
	io	= DrawInWindow WindowID [ShowTransitions transitions state]	io
=	(tm,io)


//	General alert dialog.
Alert :: String String Tm (IOState Tm) -> (Tm, IOState Tm)
Alert mes1 mes2 tm io
#	(_,tm,io)	= OpenNotice (Notice [mes1,mes2] (NoticeButton 1 "OK") []) tm io
=	(tm,io)


//	Save before close dialog.
SaveBeforeClose :: String Tm (IOState Tm) -> (Bool,Tm,IOState Tm)
SaveBeforeClose mes tm=:{name} io
#	(butid,tm,io)		= OpenNotice notice tm io
|	butid==SBCSaveId	= SvBfClSave tm io
|	butid==SBCDontId	= (True ,tm,io)
|	otherwise			= (False,tm,io)
where
	notice				= Notice
							[	"Save changes to \""+++RemovePath name+++"\""
							,	"before "+++mes+++"?"
							]	(NoticeButton SBCSaveId "Yes")
							[	NoticeButton SBCDontId "No"
							,	NoticeButton SBCCnclId "Cancel"
							]
	
	SvBfClSave :: Tm (IOState Tm) -> (Bool,Tm,IOState Tm)
	SvBfClSave tm=:{tmstate={turing},name,disk,saved} io
	=	(	True
		,	{tm & disk=snd (WriteTuringToFile turing name disk),saved=True}
		,	DisableMenuItems [SaveItemId] io
		)
