implementation module Complex

import StdReal
    
::	ComplexNum :== (!Real,!Real)
    
AddC :: !ComplexNum !ComplexNum -> ComplexNum
AddC (re_a,im_a) (re_b,im_b) = (re_a+re_b,im_a+im_b)

SubC :: !ComplexNum !ComplexNum -> ComplexNum
SubC (re_a,im_a) (re_b,im_b) = (re_a-re_b,im_a-im_b)

MulC :: !ComplexNum !ComplexNum -> ComplexNum
MulC (re_a,im_a) (re_b,im_b) = (re_a*re_b - im_a*im_b,re_a*im_b + im_a*re_b)

FakeAbsC :: !ComplexNum -> Real
FakeAbsC (re,im) = re*re + im*im

//	More complex functions
SinC :: !ComplexNum -> ComplexNum
SinC (re,im)
=	let!
		a	 = cos re * (emim-eim)
		b	 = sin re * (emim+eim)
		emim = 1.0 / eim
		eim	 = exp im
	in
		(0.5*b, (-0.5)*a)

CosC :: !ComplexNum -> ComplexNum
CosC (re,im)
=	let!
		a	 = cos re * (emim+eim)
		b	 = sin re * (emim-eim)
		emim = 1.0 / eim
		eim	 = exp im
	in
		(0.5*a,0.5*b)

ExpC :: !ComplexNum -> ComplexNum
ExpC (re,im)
=	(a*cos im,a*sin im)
where
	a	= exp re
