system module _SystemEnum

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.1
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

/*
	This module must be imported if dotdot expressions are used

		[from .. ]			-> _from from
		[from .. to]		-> _from_to from to
		[from, then .. ]	-> _from_then from then
		[from, then .. ]	-> _from_then_to from then to
*/
	
from StdClass import Enum, IncDec
from StdBool import not 

_from			::  a		-> [a] | IncDec , Ord a
_from_to		:: !a !a	-> [a] | Enum a
_from_then		::  a  a	-> [a] | Enum a
_from_then_to	:: !a !a !a	-> [a] | Enum a

_lteq a b	:== not (b < a)
_minus a b	:== a - b
