implementation module EdSupport;

import	StdClass;
from StdChar import toString;
import StdInt, StdString, StdBool, StdArray;
import deltaEventIO, deltaMenu, deltaWindow, deltaTimer, deltaDialog;

import EdProgramState, EdDraw;


    

//
//	Alert flashes the window as a kind of alert
//

Alert	:: IO -> IO;
Alert io =  Beep io;

//
//	Calculate the x-pos of the cursor, given an x-offset and a part before the cursor >>	
//

CalcCursorX	:: Int Int TLine Font -> Int;
CalcCursorX cx tabw [] font =  cx;
CalcCursorX cx tabw [str] font
	| str == TabStr =  tabw *  inc (cx / tabw) ;
	|  str.[last]  <> NewlChar =  cx +  FontStringWidth str font ;
	| last == 0 =  cx;
	=  cx +  FontStringWidth (str % (0, dec last)) font ;
	where {
	last=: dec (size str);
	};
CalcCursorX cx tabw [str:rest] font
	| str == TabStr =  CalcCursorX (tabw *  inc (cx / tabw) ) tabw rest font;
	=  CalcCursorX (cx + strw) tabw rest font;
	where {
	strw=: FontStringWidth str font;
	};

//
//	Calculate the window-coordinates of a text-selection.
//

CalcPixelSelection	:: PartSel Int Int Text Font -> PartSel;
CalcPixelSelection (ln1,cn1,ln2,cn2) tabw hght text font =  (bx,by,ex,ey);
	where {
	by	=: PictureTop +  ln1 * hght ;
	ey	=: PictureTop +  ln2 * hght ;
	bx	=: CalcPixelX LinesLeft cn1 tabw (Text_GetLine ln1 text) font;
	ex	=: CalcPixelX LinesLeft cn2 tabw (Text_GetLine ln2 text) font;
	};

CalcPixelX	:: !Int !Int !Int !TLine !Font -> Int;
CalcPixelX cx 0 tabw line font =  cx;
CalcPixelX cx cn tabw [str:rest] font
	| str == TabStr =  CalcPixelX (tabw *  inc (cx / tabw) ) (dec cn) tabw rest font;
	| cn >= len =  CalcPixelX (cx + strw) (cn - len) tabw rest font;
	=  CalcPixelXInString 0 cn cx str font;
	where {
	strw=: FontStringWidth str font;
	len =: size str;
	};

CalcPixelXInString	:: !Int !Int !Int !String !Font -> !Int;
CalcPixelXInString id 0 cx str font =  cx;
CalcPixelXInString id cn cx str font
	=  CalcPixelXInString (inc id) (dec cn) (cx + charw) str font;
	where {
	charw=: FontCharWidth (str.[id]) font;
	};

//
//	NotSavedAnymore enables the menu items Save and Revert when the file changes >>
//

NotSavedAnymore	:: Bool IO -> IO;
NotSavedAnymore False io =  io;
NotSavedAnymore true io =  EnableMenuItems [ISaveID, IReverID] io;

//
//	Adjust the size of the PictureDomain when the number of lines changes
//

AdjustWindowSize	:: Int EditWindow Editor IO -> EdIO;
AdjustWindowSize nrlines editwd editor io
	=  ChangeActivePictureDomain picdom editor io;
	where {
	picdom	=: ((PictureLeft,PictureTop),(PictureRight,bottom));
	bottom   =: PictureBottom nrlines hght;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics editwd;
	};

//
//	Determine the bottom of the picture domain
//

PictureBottom	:: Int Int -> Int;
PictureBottom nrlines hght | MinBottom > bot =  MinBottom;
	                           =  bot;
	where {
	bot =: PictureTop +  nrlines * hght ;
	};

//
//	Calculate cursorpos and charnr in a line nearest to 1st arg.
//

CalcCharNumber	:: Int Int TLine Font -> (Int,Int);
CalcCharNumber mx tabw line font
	=  CalcCharNr 0 LinesLeft mx tabw line font;

CalcCharNr	:: Int Int Int Int TLine Font -> (!Int,!Int);
CalcCharNr charnr cx mx tabw [] font =  (cx,charnr);
CalcCharNr charnr cx mx tabw [str] font
	=  CharNrInString 0 charnr cx mx (dec (size str)) str font;
CalcCharNr charnr cx mx tabw [str:rest] font
	| toofar && itsatab =  (cx,charnr);
	| toofar =  CharNrInString 0 charnr cx mx len str font;
	| itsatab =  CalcCharNr (inc charnr) newcx mx tabw rest font;
	=  CalcCharNr (charnr + len) newcx mx tabw rest font;
	where {
	toofar=: newcx > mx;
	len=: size str;
	(newcx,itsatab)=: SkipNextString str cx tabw font;
	};

SkipNextString	:: String Int Int Font -> (!Int,!Bool);
SkipNextString str cx tabw font
	| str == TabStr =  (tabw *  inc (cx / tabw) , True);
	=  (cx + strw, False);
	where {
	strw=: FontStringWidth str font;
	};

CharNrInString	:: Int Int Int Int Int String Font -> (!Int,!Int);
CharNrInString id charnr cx mx len str font
	| id >= len =  (cx,charnr);
	| newcx > mx =  (cx,charnr);
	=  CharNrInString (inc id) (inc charnr) newcx mx len str font;
	where {
	newcx=: cx + charw;
	charw=: FontCharWidth (str.[id]) font;
	};


//
//	CalcSelection takes care that the begin of the Selection is always to
//	the upper-left of the end of the Selection

CalcSelection	:: Int Int Int Int Int Int Int Int -> Selection;
CalcSelection lnr cnr cx cy linenr charnr sx sy
	| linenr > lnr || (linenr == lnr && charnr > cnr) =  ((lnr,cnr,linenr,charnr),(cx,cy,sx,sy));
	=  ((linenr,charnr,lnr,cnr),(sx,sy,cx,cy));

//
//	Un-selects possibly hilited part or removes the cursor
//

EvtUnSelect	:: EditWindow IO -> IO;
EvtUnSelect front io
	| IsEmptySelection selection =  remove_cursor;
	=  DrawInActiveWindow [DrawReHilite selection hght] io;
	where {
	selection		=: EW_GetSelection front;
	remove_cursor	=: DrawInActiveWindow [RemoveCursor curpos (at_new + dt) ld] io;
	curpos			=: EW_GetCursorPos front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	};

//
//	RemoveSelection removes the selected part of the text
//

RemoveSelection	:: Editor IO -> (Clipboard,Editor,IO);
RemoveSelection editor io
	| ldiff == 0 =  (clipa,editora,ioa);
	| by >= top && cbot <= bot =  (clipb,editorc,ioc);
	=  (clipb,editord,iod);
	where {
	(editord,iod)	=: ChangeActiveScrollBar (ChangeVThumb verttmb) editorc ioc;
	(editorc,ioc)	=: AdjustWindowSize nrlines front editorb iob;
	editora			=: ChangeFrontWindow [ EW_SetCurLine (bf1,af1,l1,c1) ] editor2;
	editorb			=: ChangeFrontWindow [ EW_SetCurLine (before,after,l1,c1),
						                      EW_SetText text,
						                      EW_SetNrLines nrlines ] editor2;
	editor2			=: ChangeFrontWindow [ EW_SetSelection ((l1,c1,l1,c1),(bx,by,bx,by)),
						                      EW_SetCursorPos curpos ] editor1;
	(editor1,front)=: GetFrontWindow editor;
	ioa				=: DrawInActiveWindow [
						    DrawReHilite selection hght,
						    Erase_and_DrawLine (by + ofs) hght ofs tabw rgt line,
//						    DrawBackspCurLine bx (- ex bx) by hght tabw rgt af1,
						    DrawCursor curpos cht ld ] io2;
	iob				=: DrawInActiveWindow [
						    EraseRectangle ((lft,boty),(rgt,bot)),
						    Erase_and_DrawLines (by + ofs) hght ofs tabw rgt lines,
						    DrawCursor curpos cht ld ] io2;
	(visrect,io2)	=: ActiveWindowGetFrame io1;
	io1				=: ChangeIOState [ DisableMenuItems [ICutID, IClearID, ICopyID,
						                                    IFindSID, IReplaID],
						                  EnableTimer TimerID ] io;
	(clipb,text)	=: Text_CutSelection selection (EW_GetText front);
	(before,after)	=: Line_SplitLine c1 (Text_GetLine l1 text);
	line				=: Line_GlueLine bf1 af1;
	(clipa,bf1,af1)=: CutFromCurLine selection (EW_GetCurLine front);
	lines				=: Text_GetLines l1 number text;
	ofs				=: at_new + ld;
	number			=: Between 0 (nrlines - l1) nr;
	nr					=: inc ( (bot - PictureTop) / hght  - l1);
	(l1,c1,l2,c2)	=: tsel;
	(bx,by,ex,ey)	=: psel;
	(tsel,psel)		=: selection;
	selection		=: EW_GetSelection front;
	curpos			=: (True,bx,by,bx);
	nrlines			=:  EW_GetNrLines front  - ldiff;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	verttmb			=: PictureTop +  hght * (l1 -  (bot - top) / (hght + hght) ) ;
	cht				=: at_new + dt;
	cbot				=: by + cht;
	boty				=: by +  number * hght ;
	(lft,top)		=: topl;
	(rgt,bot)		=: botr;
	(topl,botr)		=: visrect;
	ldiff=:(l2 - l1);
		};

//
//	UnHiliteSelection unhilites the selected part of the text
//

UnHiliteSelection	:: Bool Editor IO -> EdIO;
UnHiliteSelection side editor io
	| cy >= top && cbot <= bot =  (editor`,io`);
	=  ChangeActiveScrollBar (ChangeVThumb verttmb) editor` io`;
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (before,after,ln,cn),
						                      EW_SetSelection EmptySelection,
						                      EW_SetCursorPos curpos ] editor1;
	(editor1,front)=: GetFrontWindow editor;
	io`				=: ChangeIOState [
						    DisableMenuItems [ICutID,IClearID,ICopyID,IFindSID,IReplaID],
						    EnableTimer TimerID,
						    DrawInActiveWindow [DrawReHilite selection hght,
						                        DrawCursor curpos cht ld] ] io1;
	(visrect,io1)	=: ActiveWindowGetFrame io;
	(before,after)	=: Line_SplitLine cn (Text_GetLine ln (EW_GetText front));
	(ln,cn)			=: If side (l1,c1) (l2,c2);
	(cx,cy)			=: If side (bx,by) (ex,ey);
	(l1,c1,l2,c2)	=: tsel;
	(bx,by,ex,ey)	=: psel;
	(tsel,psel)		=: selection;
	selection		=: EW_GetSelection front;
	curpos			=: (True,cx,cy,cx);
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	verttmb			=: PictureTop +  hght * (ln -  (bot - top) / (hght + hght) ) ;
	cbot				=: cy + cht;
	cht				=: at_new + dt;
	(lft,top)		=: topl;
	(rgt,bot)		=: botr;
	(topl,botr)		=: visrect;
	};

//
//	Sort a list of strings
//

SortStrings	:: [String] -> [String];
SortStrings [hd : tl] =  [first : SortStrings rest];
	where {
	(first,rest)=: RemoveFirstString hd tl;
	};
SortStrings [] =  [];

RemoveFirstString	:: String [String] -> (String, [String]);
RemoveFirstString first [str : rest]
	| first < str =  (first1, [str   : rest1]);
	=  (first2, [first : rest2]);
	where {
	(first1,rest1)=: RemoveFirstString first rest;
	(first2,rest2)=: RemoveFirstString str   rest;
	};
RemoveFirstString first [] =  (first, []);

//
//	Conversion from booleans to markstate and back
//

BoolToMark	:: Bool      -> MarkState;
BoolToMark True      =  Mark;
BoolToMark false     =  NoMark;

MarkToBool	:: MarkState -> Bool;
MarkToBool Mark      =  True;
MarkToBool nomark    =  False;
