implementation module EdMouse;

/*	Mouse handling routines for the editor */

import	StdClass;
import StdInt, StdString, StdBool;
from StdChar import toString;
import deltaEventIO, deltaWindow, deltaTimer, deltaMenu;

import EdProgramState, EdDraw, EdSupport, EdKeyboard, EdSpecialKeys;

     
	ShiftDown	:== True;

    

//
//	The mouse functions for the edit windows
//

/*	Track is the mouse-function for the editor */

Track	:: MouseState Editor IO -> EdIO;

Track (pos,ButtonUp,mod_new) editor io =  (editor,io);

Track (pos,buttondown,mod_new=:(ShiftDown,option,command,control)) editor io
	| IsEmptySelection selection =  Drag (pos,ButtonStillDown,mod_new) editora ioa;
	=  Drag (pos,ButtonStillDown,mod_new) editorb iob;
	where {
	ioa				=: DrawInActiveWindow [RemoveCursor curpos csht ld,
						                      DrawCursor curpos csht ld] (DisableTimer TimerID iob);
	iob				=: ChangeActiveMouseFunction Drag io;
	editora			=: SetFrontWindow (EW_SetCursorVisibility True front) editor1;
	editorb			=: ChangeFrontWindow [EW_SetCursorPos (True,cx,cy,cx),
						                     EW_SetCurLine ([],[],ln,cn)] editor1;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	csht				=: at_new + dt;
	(ln,cn,cx,cy)	=: ShiftTrackCursorPos pos selection;
	selection		=: EW_GetSelection front;
	curpos			=: EW_GetCursorPos front;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	};

Track mstate editor io
	| IsEmptySelection selection =  TrackW mstate editor1 io1;
	=  TrackW mstate editor` io`;
	where {
	editor`			=: ChangeFrontWindow [ EW_SetSelection EmptySelection,
						                      EW_SetCursorVisibility False ] editor1;
	(editor1,front)=: GetFrontWindow editor;
	io`				=: DrawInActiveWindow [ DrawReHilite selection hght ] io2;
	io2				=: DisableMenuItems [ICutID, ICopyID, IClearID, IFindSID, IReplaID] io1;
	io1				=: EnableTimer TimerID io;
	selection		=: EW_GetSelection front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	};

ShiftTrackCursorPos	:: (Int,Int) Selection -> (Int,Int,Int,Int);
ShiftTrackCursorPos (mx,my) ((l1,c1,l2,c2),(bx,by,ex,ey))
	| bydif < eydif || (bydif == eydif && bxdif < exdif) =  (l2,c2,ex,ey);
	=  (l1,c1,bx,by);
	where {
	bydif=: ABS (my - by); eydif=: ABS (my - ey);
	bxdif=: ABS (mx - bx); exdif=: ABS (mx - ex);
	};


/*	TrackW is called when there is no selection (anymore) */

TrackW	:: MouseState Editor IO -> EdIO;

TrackW (mpos,ButtonDoubleDown,mod_new) editor io
	=  TypeShiftArrowKey Optn RightKey (EW_GetCurLine front`) front` editor` io`;
	where {
	(editor`,front`)=: GetFrontWindow editor3;
	(editor3,io`)	 =: TypeArrowKey Optn LeftKey (EW_GetCurLine front) front editor2 io2;
	(editor2,front) =: GetFrontWindow editor1;
	io2				 =: ChangeActiveMouseFunction TrackD io1;
	(editor1,io1)	 =: TrackW (mpos,ButtonDown,mod_new) editor io;
	};

TrackW (mpos,ButtonTripleDown,mod_new) editor io
	=  TypeShiftArrowKey Comd RightKey (EW_GetCurLine front`) front` editor` io`;
	where {
	(editor`,front`)=: GetFrontWindow editor3;
	(editor3,io`)	 =: TypeArrowKey Comd LeftKey (EW_GetCurLine front) front editor2 io2;
	(editor2,front) =: GetFrontWindow editor1;
	io2				 =: ChangeActiveMouseFunction TrackD io1;
	(editor1,io1)	 =: TrackW (mpos,ButtonDown,mod_new) editor io;
	};

TrackW mstate=:(pos,ButtonStillDown,mod_new) editor io
	=  Drag mstate editor` io`;
	where {
	io`				=: ChangeIOState [ DisableTimer TimerID,
						                  DrawInActiveWindow [ RemoveCursor curpos csht ld,
												                     DrawCursor curpos csht ld],
						                  ChangeActiveMouseFunction Drag ] io;
	editor`			=: SetFrontWindow (EW_SetCursorVisibility True front) editor1;
	(editor1,front)=: GetFrontWindow editor;
	curpos			=: EW_GetCursorPos front;
	csht				=: at_new + dt;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	};

TrackW ((mx,my),buttondown,mod_new) editor io =  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine curline,
			                       EW_SetCursorPos newpos ] editor1;
	io`=: ChangeIOState [ DrawInActiveWindow [RemoveCursor oldpos csht ld],
		                  DrawInActiveWindow [DrawCursor newpos csht ld] ] io;
	curline			=: (before,after,linenr,charnr);
	(before,after)	=: Line_SplitLine charnr line;
	(cx,charnr)		=: CalcCharNumber mx tabwidth line rfont;
	(rtw,tabwidth)	=: EW_GetTabWidth front;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	line				=: Text_GetLine linenr (EW_GetText front);
	linenr			=: Between 0 (dec nrlines) ((my - PictureTop) / hght);
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	nrlines			=: EW_GetNrLines front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	newpos			=: (True,cx,cy,cx);
	cy					=: PictureTop +  hght * linenr ;
	oldpos			=: EW_GetCursorPos front;
	csht				=: at_new + dt;
	};
	
TrackW (pos,but,mod_new) editor io =  (editor, io);

/*	TrackD is the mouse-function after a double-click or a triple-click
	It filters out the ButtonStillDown events between clicks */

TrackD	:: MouseState Editor IO -> EdIO;
TrackD (pos,ButtonStillDown,mod_new) editor io =  (editor,io);
TrackD mstate editor io =  (editor, ChangeActiveMouseFunction Track io);

/* Drag is the mouse-function that is used while the user is dragging the
	mouse to select a piece of text */

Drag	:: MouseState Editor IO -> EdIO;
Drag mstate=:(pos, ButtonStillDown, mod_new) editor io
	| isoldsel && isnewsel =  (editor`, ioa);
	| isoldsel =  (editor`, iob);
	| isnewsel =  (editor`, ioc);
	=  (editor2, io2);
	where {
	isnewsel				=: not (IsEmptySelection selection);
	isoldsel				=: not (IsEmptySelection oldsel);
	(bef,aft,lnr,cnr)	=: EW_GetCurLine front;
	(editor2,front)	=: GetFrontWindow editor1;
	(sx,charnr)			=: CalcCharNumber mx tabwidth line rfont;
	(rtw,tabwidth)		=: EW_GetTabWidth front;
	line					=: Text_GetLine linenr (EW_GetText front);
	linenr				=: Between 0 (dec nrlines) ((my - PictureTop) / hght);
	nrlines				=: EW_GetNrLines front;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	oldsel				=: EW_GetSelection front;
	curpos				=: EW_GetCursorPos front;
	(v,cx,cy,ux)		=: curpos;
	editor`				=: ChangeFrontWindow [ EW_SetSelection selection ] editor2;
	selection 			=: CalcSelection lnr cnr cx cy linenr charnr sx sy;
	sy						=: PictureTop +  hght * linenr ;
	ioa=: DrawInActiveWindow [ DrawHilite oldsel selection hght ] io2;
	iob=: DrawInActiveWindow [ DrawReHilite oldsel hght,				// Un-hilite old
	                          DrawCursor curpos (at_new + dt) ld] io2;
	ioc=: DrawInActiveWindow [ RemoveCursor curpos (at_new + dt) ld,
		                       DrawReHilite selection hght ] io2;	// Hilite new
	(editor1,io2,mx,my)=: DragOutsideFrame mstate editor io;
	};

Drag (mpos, ButtonUp, mod_new) editor io
	| IsEmptySelection selection =  (editor2, iob);
	| l1 <> l2 =  (editor`, ioa);
	=  (editor`, EnableMenuItems [IReplaID,IFindSID] ioa);
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,ln,cn),
						                      EW_SetCursorPos (v,cx,cy,x) ] editor2;
	(editor2,front)=: GetFrontWindow editor1;
	(editor1,io1)	=: Drag (mpos, ButtonStillDown, mod_new) editor io;
	ioa				=: ChangeIOState [ EnableMenuItems [ICutID,ICopyID,IClearID],
	   				                  ChangeActiveKeyboardFunction TypeSelect,
	   				                  ChangeActiveMouseFunction Track ] io1;
	iob				=: EnableTimer TimerID (ChangeActiveMouseFunction Track io1);
	(bef,aft)		=: Line_SplitLine cn (Text_GetLine ln (EW_GetText front));
	(ln,cn,x,y)		=: EW_GetActivePos front;
	(v,cx,cy,ux)	=: EW_GetCursorPos front;
	selection		=: EW_GetSelection front;
	(tsel,psel)		=: selection;
	(l1,c1,l2,c2)	=: tsel;
	};

Drag mstate editor io =  (editor,io);

/*	DragOutsideFrame is called when the mouse is StillDown outside the windowframe
*/

DragOutsideFrame	:: MouseState Editor IO -> (Editor,IO,Int,Int);
DragOutsideFrame ((mx,my),mode,mod_new) editor io
	| out_right || out_bottom || out_top || out_left =  (editor`,io`,mx`,my`);
	=  (editor,io1,mx,my);
	where {
	(editor`,io`)	=: ChangeActiveScrollBar scrollv editor2 io2;
	(editor2,io2)	=: ChangeActiveScrollBar scrollh editor1 io1;
	(editor1,front)=: GetFrontWindow editor;
	(visrect,io1)	=: ActiveWindowGetFrame io;
	(lft,top)		=: topl;
	(rgt,bot)		=: botr;
	(topl,botr)		=: visrect;
	mx`				=: If out_right  (rgt + HorScroll)
					      (If out_left (lft - HorScroll) mx);
	my`				=: If out_bottom (bot + hght)
					      (If out_top (top - hght) my);
	scrollv			=: If out_bottom (ChangeVThumb (top + hght))
					      (If out_top (ChangeVThumb (top - hght)) (ChangeVThumb top));
	scrollh		 	=: If out_right (ChangeHThumb (lft + HorScroll))
					      (If out_left (ChangeHThumb (lft - HorScroll)) (ChangeHThumb lft));
	out_left			=: mx < lft;
	out_top			=: my < top;
	out_right		=: mx > rgt;
	out_bottom		=: my > bot;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	};


/*	Misc. functions */

ABS	:: Int -> Int;
ABS i | i >= 0 =  i;
	      =  0 - i;