definition module StdFunc

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

// Some Classical Functions:

I					:: !.a -> .a								// Identity function
K					:: !.a .b -> .a								// Konstant function
S					:: !.(a -> .(.b -> .(a -> .c))) .b a -> .c	// Distribution function
flip				:: !.(.a -> .(.b -> .c)) .b .a -> .c			// Flip arguments

(o)		infixr  9	::  u:(.a -> .b) u:(.c -> .a) -> u:(.c -> .b)// Function composition

twice				:: 				!(.a -> .a) .a	-> .a		// f (f x)
while				:: !(a -> .Bool) (a -> a) 	 a 	->  a		// while (p x) f (f x) 
until				:: !(a -> .Bool) (a -> a) 	 a 	->  a		// f (f x) until (p x)
iter				:: !Int 		 (.a -> .a) .a	-> .a		// f (f..(f x)..) 

//	Some handy functions for transforming unique states:

::St s a :== s -> (a,s)

seq 				:: ![.(.s -> .s)] .s -> .s					// fn-1 (..(f1 (f0 x))..)
seqList				:: ![St .s .a] .s -> ([.a],.s)				// fn-1 (..(f1 (f0 x))..)
																// monadic style:
(`bind`) infix 0	:: u:(St .s .a) u:(.a -> .(St .s .b)) -> u:(St .s .b);
return				:: u:a -> u:(St .s u:a)
